<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:php="http://php.net/xsl"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:nt="http://www.arielworks.net/works/codeyard/himmel/xnm"
                              xmlns:nts="http://www.arielworks.net/works/codeyard/himmel/xnm/settings"
                              xmlns:nidx="http://www.arielworks.net/works/codeyard/himmel/xnm/index"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns:hml="http://www.arielworks.net/works/codeyard/himmel"
                              xmlns:s3="http://www.arielworks.net/works/codeyard/sdf/s3"
                              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/">

<xsl:include href="IndexToSdfUtil.xsl"/>


<xsl:template match="/nidx:index">
    <xsl:apply-templates select="./nidx:note[@year = $nidx:year and @month = $nidx:month and @day = $nidx:day and @hour = $nidx:hour and @minute = $nidx:minute and @second = $nidx:second]"/>
</xsl:template>

<xsl:template match="nidx:note">
    <xsl:variable name="nidx:current_note" select="php:function('Xnm_DataManager::loadNote', string(./@timestamp))"/>
    <sdf:document xml:lang="ja">
        <sdf:meta>
            <dc:title>
                <xsl:value-of select="$nts:settings/nts:value[@name = 'siteName']"/>
                <xsl:text>::</xsl:text>
                <xsl:value-of select="$nidx:year"/>
                <xsl:text>-</xsl:text>
                <xsl:value-of select="$nidx:month"/>
                <xsl:text>-</xsl:text>
                <xsl:value-of select="$nidx:day"/>
                <xsl:text>::</xsl:text>
                <xsl:copy-of select="./dc:title/node()"/>
            </dc:title>
            <xsl:call-template name="nidx:copy_latest_modified">
                <xsl:with-param name="nidx:targets_dom" select="."/>
            </xsl:call-template>
            <xsl:call-template name="nidx:copy_oldest_created">
                <xsl:with-param name="nidx:targets_dom" select="."/>
            </xsl:call-template>

            <link rel="up" href="../{@day}" title="{$nts:settings/nts:value[@name = 'siteName']}::{@year}-{@month}-{@day}"/>

            <xsl:variable name="next_page" select="following-sibling::nidx:note[1]"/>
            <xsl:if test="$next_page">
                <link rel="next" href="../../../{$next_page/@year}/{$next_page/@month}/{$next_page/@day}/{$next_page/@hour}{$next_page/@minute}{$next_page/@second}" title="{$next_page/dc:title}"/>
            </xsl:if>
            <xsl:variable name="prev_page" select="preceding-sibling::nidx:note[1]"/>
            <xsl:if test="$prev_page">
                <link rel="prev" href="../../../{$prev_page/@year}/{$prev_page/@month}/{$prev_page/@day}/{$prev_page/@hour}{$prev_page/@minute}{$prev_page/@second}" title="{$prev_page/dc:title}"/>
            </xsl:if>
        </sdf:meta>
        <sdf:body>
            <xsl:copy-of select="$nidx:current_note/nt:note/nt:body/node()"/>
            <sdf:section id="comments">
                <sdf:meta>
                    <dc:title>Comments</dc:title>
                </sdf:meta>
                <sdf:body>
                    <xsl:choose>
                        <xsl:when test="./nt:comments">
                            <xsl:for-each select="./nt:comments/nt:comment">
                                <dl>
                                    <dt>Name</dt>
                                    <dd>
                                        <xsl:choose>
                                            <xsl:when test="./nt:identifier">
                                                <a href="{./nt:identifier}">
                                                    <xsl:value-of select="./nt:name"/>
                                                </a>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of select="./nt:name"/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </dd>
                                    <dt>Datetime</dt>
                                    <dd>
                                        <xsl:value-of select="./nt:datetime"/>
                                    </dd>
                                    <dt>Message</dt>
                                    <dd>
                                        <xsl:value-of select="./nt:message"/>
                                    </dd>
                                </dl>
                            </xsl:for-each>
                        </xsl:when>
                        <xsl:otherwise>
                            <ul>
                                <li>None</li>
                            </ul>
                        </xsl:otherwise>
                    </xsl:choose>
                </sdf:body>
            </sdf:section>
            <sdf:section id="trackback">
                <sdf:meta>
                    <dc:title>Trackbacks</dc:title>
                </sdf:meta>
                <sdf:body>
                    <dl>
                        <dt>Trackback URI</dt>
                        <dd>
                            <xsl:value-of select="$nts:settings/nts:value[@name = 'webRoot']"/>
                            <xsl:value-of select="concat('/archive/', ./@year, '/', ./@month, '/', ./@day, '/', ./@hour, ./@minute, ./@second, '.trackback')"/>
                        </dd>
                    </dl>
                    <xsl:choose>
                        <xsl:when test="./nt:referredBy">
                            <xsl:for-each select="./nt:referredBy/nt:Trackback">
                                <dl>
                                    <dt>Title</dt>
                                    <dd>
                                        <a href="{./@uri}">
                                            <xsl:choose>
                                                <xsl:when test="./nt:title">
                                                    <xsl:value-of select="./nt:title"/>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="./@uri"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </dd>
                                    <dt>Datetime</dt>
                                    <dd>
                                        <xsl:value-of select="./nt:datetime"/>
                                    </dd>
                                    <xsl:if test="./nt:excerpt">
                                        <dt>Excerpt</dt>
                                        <dd>
                                            <xsl:value-of select="./nt:excerpt"/>
                                        </dd>
                                    </xsl:if>
                                    <xsl:if test="./nt:blogName">
                                        <dt>From</dt>
                                        <dd>
                                            <xsl:value-of select="./nt:blogName"/>
                                        </dd>
                                    </xsl:if>
                                </dl>
                            </xsl:for-each>
                        </xsl:when>
                        <xsl:otherwise>
                            <ul>
                                <li>None</li>
                            </ul>
                        </xsl:otherwise>
                    </xsl:choose>
                </sdf:body>
            </sdf:section>
            <sdf:section>
                <sdf:meta>
                    <dc:title>Post a comment</dc:title>
                </sdf:meta>
                <sdf:body>
                    <form action="../../../../archive" method="POST">
                        <dl>
                            <dt>Name</dt>
                            <dd>
                                <input type="text" size="35" name="name"/>
                            </dd>
                            <dt>Mail address or URI</dt>
                            <dd>
                                <input type="text" size="35" name="identifier"/>
                            </dd>
                            <dt>Message</dt>
                            <dd>
                                <textarea rows="10" cols="50" name="message"/>
                            </dd>
                            <dt>Submit</dt>
                            <dd>
                                <input type="hidden" name="action" value="comment"/>
                                <input type="hidden" name="target" value="{./@timestamp}"/>
                                <input type="submit" value="Post"/>
                            </dd>
                        </dl>
                    </form>
                </sdf:body>
            </sdf:section>
        </sdf:body>
    </sdf:document>
</xsl:template>

</xsl:stylesheet>