<?php
$incPath = array("/_himmel", "/_himmel/OutputDefinitions", "/_himmel/Modules");
foreach ($incPath as $anIncPath) ini_set("include_path", ini_get("include_path") . PATH_SEPARATOR . dirname(__FILE__) . $anIncPath);
function __autoload($className) {
    require_once $className . ".php";
}
/**
 * Main class of HIMMEL Core
 * 
 * @author Arielworks
 * @license Public Domain
 */
class Hml_Himmel {
    private static $backEndMap = array(
        "/memo" => "Xnm_XmlNoteManager",
        ""      => "Xsm_XmlSiteManager"
    );

    public function main() {
        $fullQuery = $_SERVER["PATH_INFO"];
        krsort(self::$backEndMap);
        foreach (self::$backEndMap as $backEndPath => $backEndClass) {
            $benLen = strlen($backEndPath);
            if ($backEndPath !== "" && strpos($fullQuery, $backEndPath) === 0
                && (strlen($fullQuery) == $benLen || $fullQuery[$benLen] === "/" )) {
                $backEnd = new $backEndClass();
                preg_match("!^(/(?:.*?/)*[^.]+)!", $_SERVER["SCRIPT_NAME"], $scriptName); // cut extension
                preg_match("!^(" .  $scriptName[1] . ".*?)($|/)!", $_SERVER["REQUEST_URI"], $scriptName);
                $backEndRoot = $scriptName[1] . $backEndPath;
                $backEndQuery = substr($fullQuery, $benLen);
                break;
            } elseif($backEndPath === "") {
                $backEnd = new $backEndClass();
                $backEndRoot = "/";
                preg_match("!^(/(?:.*?/)*[^.]+)!", $_SERVER["SCRIPT_NAME"], $scriptName); // cut extension
                preg_match("!^(" .  $scriptName[1] . ".*?)($|/)!", $_SERVER["REQUEST_URI"], $scriptName);
                $backEndRoot = $scriptName[1];
                $backEndQuery = substr($fullQuery, $benLen);
                break;
            }
        }
        $ioManager = new Hml_IoManager($backEndQuery);

        if (NULL !== $outputDef = $ioManager->getOutputDefinition()) {
            $formatType = $outputDef->getFormatType();
            $dc = new Hml_DataContainer;
            try {
                $backEnd->setDataToContainer($ioManager->getRequestedId(), $formatType, $dc, $backEndRoot);
                $dc->setId($backEndPath . $ioManager->getRequestedId());
                $ioManager->output($dc);
            } catch(Hml_InvalidIdException $e) {
                if (! $sdf = $e->getSdfData()) {
                    $sdf = new DomDocument();
                    $sdf->load(dirname(__FILE__) . "/_himmel/404.xml");
                }
                $dc->setData($sdf);
                $ioManager->output($dc, 404);
            }

        } else {
            $backEnd->excuteAlone($ioManager->getRequestedId(), $ioManager->getFileExtension(), $ioManager->getAcceptList(), "ja", $backEndRoot);
        }

    }
}

Hml_Himmel::main();
?>