/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.calendar;

import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.calendar.ejb.session.CalendarController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.export.util.Config;
import jp.co.intellilink.hinemos.export.util.DateListComparator;
import jp.co.intellilink.hinemos.export.util.DayOfWeekListComparator;
import jp.co.intellilink.hinemos.export.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.export.util.Messages;
import jp.co.intellilink.hinemos.export.util.StringListComparator;
import jp.co.intellilink.hinemos.export.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportCalendar {
    private static Log log = LogFactory.getLog(ExportCalendar.class);

    public void exportCalendar() {
        log.info((Object)Messages.getMsg("ExportTool.Calendar.Start"));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        ArrayList<ArrayList<String>> arrayList3 = new ArrayList<ArrayList<String>>();
        ArrayList arrayList4 = this.getCalendarList();
        if (arrayList4 instanceof ArrayList) {
            for (ArrayList arrayList5 : arrayList4) {
                ArrayList arrayList62;
                String string = (String)arrayList5.get(0);
                Object[] objectArray = new Object[]{string};
                log.info((Object)Messages.getMsg("ExportTool.CalendarID", objectArray));
                arrayList.add(this.createCalendarCsvFormat(arrayList5));
                ArrayList arrayList7 = this.getRuleList(string);
                for (ArrayList arrayList62 : arrayList7) {
                    ArrayList<String> arrayList8 = this.createRuleCsvFormat(arrayList62);
                    arrayList8.add(0, string);
                    arrayList2.add(arrayList8);
                }
                arrayList62 = this.getExceptionList(string);
                for (ArrayList arrayList9 : arrayList62) {
                    ArrayList<String> arrayList10 = this.createExceptionCsvFormat(arrayList9);
                    arrayList10.add(0, string);
                    arrayList3.add(arrayList10);
                }
            }
            Collections.sort(arrayList, new StringListComparator(0));
            Collections.sort(arrayList2, new DayOfWeekListComparator(1));
            Collections.sort(arrayList2, new StringListComparator(0));
            Collections.sort(arrayList3, new DateListComparator(1));
            Collections.sort(arrayList3, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Output.Dir.Conf") + "/CALENDAR_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        WriteCsvFile.writeCsvFile(Config.getConfig("Output.Dir.Conf") + "/CALENDAR_RULE_" + simpleDateFormat.format(new Date()) + ".csv", arrayList2);
        WriteCsvFile.writeCsvFile(Config.getConfig("Output.Dir.Conf") + "/CALENDAR_EXCEPTION_" + simpleDateFormat.format(new Date()) + ".csv", arrayList3);
        log.info((Object)Messages.getMsg("ExportTool.Calendar.End"));
    }

    protected ArrayList<String> createCalendarCsvFormat(ArrayList arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (arrayList.get(0) instanceof String) {
            arrayList2.add((String)arrayList.get(0));
        } else {
            arrayList2.add("");
        }
        if (arrayList.get(1) instanceof String) {
            arrayList2.add((String)arrayList.get(1));
        } else {
            arrayList2.add("");
        }
        if (arrayList.get(2) instanceof Date) {
            arrayList2.add(DateFormat.getDateTimeInstance().format((Date)arrayList.get(2)));
        } else {
            arrayList2.add("");
        }
        if (arrayList.get(3) instanceof Date) {
            arrayList2.add(DateFormat.getDateTimeInstance().format((Date)arrayList.get(3)));
        } else {
            arrayList2.add("");
        }
        if (arrayList.get(4) instanceof String) {
            arrayList2.add((String)arrayList.get(4));
        } else {
            arrayList2.add("");
        }
        return arrayList2;
    }

    protected ArrayList<String> createRuleCsvFormat(ArrayList arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        if (arrayList.get(0) instanceof Integer) {
            arrayList2.add(DayOfWeekConstant.typeToString((int)((Integer)arrayList.get(0))));
        } else {
            arrayList2.add("");
        }
        if (arrayList.get(1) instanceof Date) {
            arrayList2.add(simpleDateFormat.format((Date)arrayList.get(1)));
        } else {
            arrayList2.add("");
        }
        if (arrayList.get(2) instanceof Date) {
            arrayList2.add(simpleDateFormat.format((Date)arrayList.get(2)));
        } else {
            arrayList2.add("");
        }
        if (arrayList.get(3) instanceof String) {
            arrayList2.add((String)arrayList.get(3));
        } else {
            arrayList2.add("");
        }
        return arrayList2;
    }

    protected ArrayList<String> createExceptionCsvFormat(ArrayList arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (arrayList.get(0) instanceof Boolean) {
            Boolean bl = (Boolean)arrayList.get(0);
            if (bl.booleanValue()) {
                arrayList2.add(YesNoConstant.STRING_YES);
            } else {
                arrayList2.add(YesNoConstant.STRING_NO);
            }
        } else {
            arrayList2.add("");
        }
        if (arrayList.get(1) instanceof Date) {
            arrayList2.add(DateFormat.getDateTimeInstance().format((Date)arrayList.get(1)));
        } else {
            arrayList2.add("");
        }
        if (arrayList.get(2) instanceof Date) {
            arrayList2.add(DateFormat.getDateTimeInstance().format((Date)arrayList.get(2)));
        } else {
            arrayList2.add("");
        }
        if (arrayList.get(3) instanceof String) {
            arrayList2.add((String)arrayList.get(3));
        } else {
            arrayList2.add("");
        }
        return arrayList2;
    }

    protected ArrayList getExceptionList(String string) {
        CalendarController calendarController = EjbConnectionManager.getConnectionManager().getCalendarController();
        ArrayList arrayList = null;
        try {
            arrayList = calendarController.getAddList(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    protected ArrayList getRuleList(String string) {
        CalendarController calendarController = EjbConnectionManager.getConnectionManager().getCalendarController();
        ArrayList arrayList = null;
        try {
            arrayList = calendarController.getWeekdayList(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    protected ArrayList getCalendarList() {
        CalendarController calendarController = EjbConnectionManager.getConnectionManager().getCalendarController();
        ArrayList arrayList = null;
        try {
            arrayList = calendarController.getCalendarList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

