/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.monitor;

import com.clustercontrol.bean.PingRunCountConstant;
import com.clustercontrol.bean.PingRunIntervalConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.ping.bean.MonitorPingInfo;
import com.clustercontrol.ping.ejb.session.MonitorPingController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorNumeric;
import jp.co.intellilink.hinemos.export.util.Config;
import jp.co.intellilink.hinemos.export.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.export.util.Messages;
import jp.co.intellilink.hinemos.export.util.StringListComparator;
import jp.co.intellilink.hinemos.export.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorPing
extends ExportMonitorNumeric {
    private static Log log = LogFactory.getLog(ExportMonitorPing.class);

    public ExportMonitorPing() {
        super(3, 2);
    }

    public void exportPing() {
        log.info((Object)Messages.getMsg("ExportTool.Ping.Start"));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getPingList();
        if (arrayList2 instanceof ArrayList) {
            for (ArrayList arrayList3 : arrayList2) {
                Object[] objectArray = new Object[]{(String)arrayList3.get(0)};
                log.info((Object)Messages.getMsg("ExportTool.MonitorID", objectArray));
                MonitorInfo monitorInfo = this.getPing((String)arrayList3.get(0));
                arrayList.add(this.createCsvFormat(monitorInfo));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Output.Dir.Conf") + "/PING_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)Messages.getMsg("ExportTool.Ping.End"));
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        MonitorPingInfo monitorPingInfo = (MonitorPingInfo)monitorInfo.getCheckInfo();
        if (monitorPingInfo == null) {
            monitorPingInfo = new MonitorPingInfo();
        }
        if (monitorPingInfo.getRunCount() != null) {
            arrayList.add(PingRunCountConstant.typeToString((int)monitorPingInfo.getRunCount()));
        } else {
            arrayList.add("");
        }
        if (monitorPingInfo.getRunInterval() != null) {
            arrayList.add(PingRunIntervalConstant.typeToString((int)monitorPingInfo.getRunInterval()));
        } else {
            arrayList.add("");
        }
        if (monitorPingInfo.getTimeout() != null) {
            arrayList.add(monitorPingInfo.getTimeout().toString());
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    protected MonitorInfo getPing(String string) {
        MonitorPingController monitorPingController = EjbConnectionManager.getConnectionManager().getMonitorPingController();
        MonitorInfo monitorInfo = null;
        try {
            monitorInfo = monitorPingController.getPing(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return monitorInfo;
    }

    protected ArrayList getPingList() {
        MonitorPingController monitorPingController = EjbConnectionManager.getConnectionManager().getMonitorPingController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorPingController.getPingList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

