/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.monitor;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitor;
import jp.co.intellilink.hinemos.export.util.CheckString;
import jp.co.intellilink.hinemos.export.util.Config;
import jp.co.intellilink.hinemos.export.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.export.util.Messages;
import jp.co.intellilink.hinemos.export.util.StringListComparator;
import jp.co.intellilink.hinemos.export.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorSnmpTrap
extends ExportMonitor {
    private static Log log = LogFactory.getLog(ExportMonitorSnmpTrap.class);

    public void exportSnmpTrap() {
        log.info((Object)Messages.getMsg("ExportTool.SnmpTrap.Start"));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getSnmpTrapList();
        if (arrayList2 instanceof ArrayList) {
            for (ArrayList arrayList3 : arrayList2) {
                Object[] objectArray = new Object[]{(String)arrayList3.get(0)};
                log.info((Object)Messages.getMsg("ExportTool.MonitorID", objectArray));
                MonitorInfo monitorInfo = this.getSnmpTrap((String)arrayList3.get(0));
                arrayList.add(this.createCsvFormat(monitorInfo));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Output.Dir.Conf") + "/TRAP_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)Messages.getMsg("ExportTool.SnmpTrap.End"));
    }

    @Override
    public ArrayList<String> createCsvFormat(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.createMonitorBase(monitorInfo));
        arrayList.addAll(this.createMonitorInfo(monitorInfo));
        arrayList.addAll(this.createMonitorNotify(monitorInfo));
        if (monitorInfo.getApplication() != null) {
            arrayList.add(monitorInfo.getApplication());
        } else {
            arrayList.add("");
        }
        arrayList.add(ValidConstant.typeToString((int)monitorInfo.getValid()));
        return arrayList;
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        MonitorSnmpTrapInfo monitorSnmpTrapInfo = (MonitorSnmpTrapInfo)monitorInfo;
        if (monitorSnmpTrapInfo.getCommunityName() != null) {
            arrayList.add(monitorSnmpTrapInfo.getCommunityName());
        } else {
            arrayList.add("");
        }
        switch (monitorSnmpTrapInfo.getCheckMode()) {
            case 1: {
                arrayList.add(com.clustercontrol.util.Messages.getString((String)"OidListComposite.AllMaterOid"));
                break;
            }
            case 2: {
                arrayList.add(com.clustercontrol.util.Messages.getString((String)"OidListComposite.NoMasterOid"));
                break;
            }
            default: {
                arrayList.add(com.clustercontrol.util.Messages.getString((String)"OidListComposite.SpecificOid"));
            }
        }
        if (monitorSnmpTrapInfo.getOidInfos() != null) {
            ArrayList arrayList2 = monitorSnmpTrapInfo.getOidInfos();
            Iterator iterator = arrayList2.iterator();
            if (iterator.hasNext()) {
                MonitorSnmpTrapOidInfo monitorSnmpTrapOidInfo = (MonitorSnmpTrapOidInfo)iterator.next();
                if (monitorSnmpTrapOidInfo.getTrapName() != null) {
                    arrayList.add(monitorSnmpTrapOidInfo.getTrapName());
                } else {
                    arrayList.add("");
                }
                if (monitorSnmpTrapOidInfo.getTrapOid() != null) {
                    arrayList.add(monitorSnmpTrapOidInfo.getTrapOid());
                } else {
                    arrayList.add("");
                }
                arrayList.add(String.valueOf(monitorSnmpTrapOidInfo.getGenericId()));
                arrayList.add(String.valueOf(monitorSnmpTrapOidInfo.getSpecificId()));
                arrayList.add(ValidConstant.typeToString((int)monitorSnmpTrapOidInfo.getValidFlg()));
                arrayList.add(PriorityConstant.typeToString((int)monitorSnmpTrapOidInfo.getPriority()));
                if (monitorSnmpTrapOidInfo.getLogmsg() != null) {
                    arrayList.add(CheckString.checkReturn(monitorSnmpTrapOidInfo.getLogmsg()));
                } else {
                    arrayList.add("");
                }
                if (monitorSnmpTrapOidInfo.getDescr() != null) {
                    arrayList.add(CheckString.checkReturn(monitorSnmpTrapOidInfo.getDescr()));
                } else {
                    arrayList.add("");
                }
            }
        } else {
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
        }
        return arrayList;
    }

    protected MonitorInfo getSnmpTrap(String string) {
        MonitorSnmpTrapController monitorSnmpTrapController = EjbConnectionManager.getConnectionManager().getMonitorSnmpTrapController();
        MonitorSnmpTrapInfo monitorSnmpTrapInfo = null;
        try {
            monitorSnmpTrapInfo = monitorSnmpTrapController.getMonitorInfo(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return monitorSnmpTrapInfo;
    }

    protected ArrayList getSnmpTrapList() {
        MonitorSnmpTrapController monitorSnmpTrapController = EjbConnectionManager.getConnectionManager().getMonitorSnmpTrapController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSnmpTrapController.getMonitorList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

