/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.history;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.bean.ReportEventInfo;
import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.util.PropertyUtil;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import jp.co.intellilink.hinemos.export.util.CheckString;
import jp.co.intellilink.hinemos.export.util.Config;
import jp.co.intellilink.hinemos.export.util.DateListComparator;
import jp.co.intellilink.hinemos.export.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.export.util.Messages;
import jp.co.intellilink.hinemos.export.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportEvent {
    private static Log log = LogFactory.getLog(ExportEvent.class);

    public void export(Date date) {
        log.info((Object)Messages.getMsg("ExportTool.Event.Start"));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date2 = calendar.getTime();
        calendar.add(5, 1);
        calendar.add(14, -1);
        Date date3 = calendar.getTime();
        ArrayList<ReportEventInfo> arrayList2 = this.getEvent(date2, date3);
        for (ReportEventInfo reportEventInfo : arrayList2) {
            arrayList.addAll(this.createEvent(reportEventInfo));
        }
        Collections.sort(arrayList, new DateListComparator(1));
        arrayList.add(0, this.createHeader());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        WriteCsvFile.writeCsvFile(Config.getConfig("Output.Dir.History") + "/EVENT_" + simpleDateFormat.format(date2) + ".csv", arrayList);
        log.info((Object)Messages.getMsg("ExportTool.Event.End"));
    }

    public ArrayList<String> createHeader() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"priority"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"receive.time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"output.time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"plugin.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"monitor.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"facility.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"scope"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"application"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"message.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"message"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"message.org"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"confirmed"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"confirm.user"));
        return arrayList;
    }

    public ArrayList<ArrayList<String>> createEvent(ReportEventInfo reportEventInfo) {
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        arrayList2.add(reportEventInfo.getPriority());
        arrayList2.add(dateFormat.format(reportEventInfo.getGenerationDate()));
        arrayList2.add(dateFormat.format(reportEventInfo.getOutputDate()));
        arrayList2.add(reportEventInfo.getPluginId());
        arrayList2.add(reportEventInfo.getMonitorId());
        arrayList2.add(reportEventInfo.getFacilityId());
        arrayList2.add(reportEventInfo.getScopeText());
        arrayList2.add(reportEventInfo.getApplication());
        arrayList2.add(reportEventInfo.getMessageId());
        arrayList2.add(reportEventInfo.getMessage());
        arrayList2.add(CheckString.checkReturn(reportEventInfo.getMessageOrg()));
        arrayList2.add(reportEventInfo.getConfirmFlg());
        arrayList2.add(reportEventInfo.getConfirmUser());
        arrayList.add(arrayList2);
        return arrayList;
    }

    public ArrayList<ReportEventInfo> getEvent(Date date, Date date2) {
        MonitorController monitorController = EjbConnectionManager.getConnectionManager().getMonitorController();
        ArrayList arrayList = null;
        try {
            Property property = monitorController.getEventFilterProperty(Locale.getDefault());
            ArrayList arrayList2 = PropertyUtil.getProperty((Property)property, (String)"priority");
            ((Property)arrayList2.get(0)).setValue((Object)"");
            if (date instanceof Date) {
                arrayList2 = PropertyUtil.getProperty((Property)property, (String)"outputFromDate");
                ((Property)arrayList2.get(0)).setValue((Object)date);
            }
            if (date2 instanceof Date) {
                arrayList2 = PropertyUtil.getProperty((Property)property, (String)"outputToDate");
                ((Property)arrayList2.get(0)).setValue((Object)date2);
            }
            arrayList2 = PropertyUtil.getProperty((Property)property, (String)"confirmed");
            ((Property)arrayList2.get(0)).setValue((Object)"-1");
            arrayList = monitorController.getEventListForReport(null, property);
        }
        catch (RemoteException remoteException) {
        }
        catch (CreateException createException) {
        }
        catch (FinderException finderException) {
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return arrayList;
    }
}

