/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.session;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;
import org.jboss.util.NestedRuntimeException;
import org.jboss.web.tomcat.tc5.session.AbstractJBossManager;
import org.jboss.web.tomcat.tc5.session.ClusteredSession;

public class JvmRouteValve
extends ValveBase
implements Lifecycle {
    private static final String info = "JvmRouteValve/1.0";
    protected static Logger log_ = Logger.getLogger((Class)(class$org$jboss$web$tomcat$tc5$session$JvmRouteValve == null ? (class$org$jboss$web$tomcat$tc5$session$JvmRouteValve = JvmRouteValve.class$("org.jboss.web.tomcat.tc5.session.JvmRouteValve")) : class$org$jboss$web$tomcat$tc5$session$JvmRouteValve));
    protected LifecycleSupport support = new LifecycleSupport((Lifecycle)this);
    protected AbstractJBossManager manager_;
    static /* synthetic */ Class class$org$jboss$web$tomcat$tc5$session$JvmRouteValve;

    public JvmRouteValve(AbstractJBossManager manager) {
        this.manager_ = manager;
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.checkJvmRoute(request, response);
        this.getNext().invoke(request, response);
    }

    public void checkJvmRoute(Request req, Response res) throws IOException, ServletException {
        HttpSession session = req.getSession(false);
        if (session != null) {
            String sessionId = session.getId();
            String jvmRoute = this.manager_.getJvmRoute();
            if (log_.isDebugEnabled()) {
                log_.debug((Object)("checkJvmRoute(): check if need to re-route based on JvmRoute. Session id: " + sessionId + " jvmRoute: " + jvmRoute));
            }
            if (jvmRoute == null) {
                throw new RuntimeException("JvmRouteValve.checkJvmRoute(): Tomcat JvmRoute is null. Need to assign a value in Tomcat server.xml for load balancing.");
            }
            if (req.isRequestedSessionIdFromURL()) {
                log_.error((Object)"JvmRoutValve.checkJvmRoute(): Can't handle clustering where session id is from URL. Will skip.");
            } else {
                this.handleJvmRoute(sessionId, jvmRoute, (HttpServletResponse)res);
            }
        }
    }

    protected void handleJvmRoute(String sessionId, String jvmRoute, HttpServletResponse response) {
        String requestedJvmRoute = null;
        int ind = sessionId.indexOf(".");
        if (ind > 0) {
            requestedJvmRoute = sessionId.substring(sessionId.indexOf(".") + 1, sessionId.length());
        }
        String sid = sessionId;
        if (requestedJvmRoute == null) {
            sid = sessionId + "." + jvmRoute;
            this.manager_.setNewSessionCookie(sid, response);
        } else {
            int index;
            if (requestedJvmRoute.equals(jvmRoute)) {
                return;
            }
            if (log_.isDebugEnabled()) {
                log_.debug((Object)("handleJvmRoute(): We have detected a failover with differen jvmRoute. old one: " + requestedJvmRoute + " new one: " + jvmRoute + ". Will reset the session id."));
            }
            if ((index = sessionId.indexOf(".")) <= 0) {
                throw new RuntimeException("JvmRouteVavle.handleJvmRoute(): session id doesn't JvmRoute.");
            }
            String base = sessionId.substring(0, sessionId.indexOf("."));
            sid = base + "." + jvmRoute;
            this.manager_.setNewSessionCookie(sid, response);
            ClusteredSession session = null;
            try {
                session = (ClusteredSession)this.manager_.findSession(sessionId);
                if (session != null) {
                    session.resetIdWithRouteInfo(sid);
                    if (log_.isDebugEnabled()) {
                        log_.debug((Object)("handleJvmRoute(): changed catalina session to= [" + sid + "] old one= [" + sessionId + "]"));
                    }
                }
            }
            catch (IOException e) {
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)("handleJvmRoute(): manager_.findSession() unable to find session= [" + sessionId + "]"), (Throwable)e);
                }
                throw new NestedRuntimeException("JvmRouteValve.handleJvmRoute(): cannot find session [" + sessionId + "]", (Throwable)e);
            }
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.support.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.support.removeLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.support.findLifecycleListeners();
    }

    public void start() throws LifecycleException {
        this.support.fireLifecycleEvent("start", (Object)this);
    }

    public void stop() throws LifecycleException {
        this.support.fireLifecycleEvent("stop", (Object)this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

