/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.iiop;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.iiop.CorbaNamingService;
import org.jboss.iiop.CorbaORBService;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.iiop.CorbaTransactionServiceMBean;
import org.jboss.tm.iiop.TransactionFactoryExtHelper;
import org.jboss.tm.iiop.TransactionServiceImpl;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public class CorbaTransactionService
extends ServiceMBeanSupport
implements CorbaTransactionServiceMBean {
    public static String COSNAMING_NAME = "TransactionService";
    public static String COSNAMING_USERTX_NAME = "UserTransaction";
    private POA poa;

    protected void startService() throws Exception {
        POA rootPOA;
        ORB orb;
        InitialContext jndiContext;
        try {
            jndiContext = new InitialContext();
        }
        catch (NamingException e) {
            throw new RuntimeException("Cannot get intial JNDI context: " + e);
        }
        try {
            orb = (ORB)jndiContext.lookup("java:/" + CorbaORBService.ORB_NAME);
        }
        catch (NamingException e) {
            throw new RuntimeException("Cannot lookup java:/" + CorbaORBService.ORB_NAME + ": " + e);
        }
        try {
            rootPOA = (POA)jndiContext.lookup("java:/" + CorbaORBService.POA_NAME);
        }
        catch (NamingException e) {
            throw new RuntimeException("Cannot lookup java:/" + CorbaORBService.POA_NAME + ": " + e);
        }
        Policy[] policies = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT), rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID)};
        this.poa = rootPOA.create_POA("Transactions", null, policies);
        this.poa.the_POAManager().activate();
        TransactionServiceImpl theDefaultServant = new TransactionServiceImpl(orb, this.poa);
        this.poa.set_servant((Servant)theDefaultServant);
        Object theTransactionFactory = this.poa.create_reference_with_id(TransactionServiceImpl.theFactoryId(), TransactionFactoryExtHelper.id());
        NamingContextExt rootContext = null;
        try {
            rootContext = NamingContextExtHelper.narrow((Object)((Object)jndiContext.lookup("java:/" + CorbaNamingService.NAMING_NAME)));
        }
        catch (NamingException e) {
            throw new Exception("Cannot lookup java:/" + CorbaNamingService.NAMING_NAME + ":\n" + e);
        }
        try {
            rootContext.rebind(rootContext.to_name(COSNAMING_NAME), theTransactionFactory);
            this.getLog().info((java.lang.Object)("TransactionFactory: [" + orb.object_to_string(theTransactionFactory) + "]"));
            rootContext.rebind(rootContext.to_name(COSNAMING_USERTX_NAME), theTransactionFactory);
        }
        catch (Exception e) {
            this.getLog().error((java.lang.Object)"Cannot bind transaction factory in CORBA naming service:", (Throwable)e);
            throw new Exception("Cannot bind transaction factory in CORBA naming service:\n" + e);
        }
    }

    protected void stopService() {
        try {
            InitialContext jndiContext = new InitialContext();
            NamingContextExt rootContext = NamingContextExtHelper.narrow((Object)((Object)jndiContext.lookup("java:/" + CorbaNamingService.NAMING_NAME)));
            try {
                NameComponent[] name = rootContext.to_name(COSNAMING_NAME);
                rootContext.unbind(name);
            }
            catch (InvalidName invalidName) {
                this.getLog().error((java.lang.Object)"Cannot unregister transaction factory from CORBA naming service", (Throwable)invalidName);
            }
            catch (NotFound notFound) {
                this.getLog().error((java.lang.Object)"Cannot unregister transaction factory from CORBA naming service", (Throwable)notFound);
            }
            catch (CannotProceed cannotProceed) {
                this.getLog().error((java.lang.Object)"Cannot unregister transaction factory from CORBA naming service", (Throwable)cannotProceed);
            }
        }
        catch (NamingException namingException) {
            this.getLog().error((java.lang.Object)"Unexpected error in JNDI lookup", (Throwable)namingException);
        }
        try {
            this.poa.destroy(false, false);
        }
        catch (Exception e) {
            this.getLog().error((java.lang.Object)"Exception while stopping CORBA transaction service", (Throwable)e);
        }
    }
}

