/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmppoller;

import com.clustercontrol.bean.SnmpVersionConstant;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.sharedtable.bean.DataTable;
import com.clustercontrol.sharedtable.bean.ValueObject;
import com.clustercontrol.snmppoller.FacilityNotFoundExciption;
import com.clustercontrol.snmppoller.SnmpConfig;
import com.clustercontrol.snmppoller.bean.PollingConfig;
import com.clustercontrol.snmppoller.job.CheckJob;
import com.clustercontrol.snmppoller.job.PollingThread;
import com.clustercontrol.snmppoller.job.SnmpPollingJob;
import com.clustercontrol.snmppoller.util.JNDIConnectionManager;
import com.clustercontrol.snmppoller.util.ReceiveRepositoryTopic;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdScheduler;

public class SnmpSharedTable {
    protected static Log m_log = LogFactory.getLog(SnmpSharedTable.class);
    private final String m_checkJobGroup = "SNMP_CHECK_JOB";
    private String m_quartzJndiName = null;
    private int m_defaultPort = -1;
    private int m_defaultVersion = 1;
    private String m_defaultCommunity = "public";
    private int m_defaultRetries = -1;
    private int m_defaultTimeout = 1000;
    private boolean m_indexCheckFlg = false;
    private String m_jndiName;
    private String m_groupName;
    private String m_checkJobName;
    private String m_checkInterval = "34 */10 * * * ? *";
    private List m_oidList;
    private int m_gracePeriod = 5;
    private boolean m_scheduleFlag = false;
    private int m_minInterval = Integer.MAX_VALUE;
    private HashMap<String, DataTable> m_dataTable;
    private HashMap<String, PollingConfig> m_pollerConf;
    private HashMap<String, LockObject> m_lockMap = new HashMap();
    private ReceiveRepositoryTopic m_receiveRepositoryTopic;

    public SnmpSharedTable(String jndiName, String groupName) {
        this.m_jndiName = jndiName;
        this.m_groupName = groupName;
        this.m_dataTable = new HashMap();
        this.m_pollerConf = new HashMap();
        this.m_checkJobName = groupName;
        this.m_receiveRepositoryTopic = new ReceiveRepositoryTopic(this);
    }

    public void scheduleCheckJob() {
        JobDetail job = new JobDetail(this.m_checkJobName, "SNMP_CHECK_JOB", CheckJob.class);
        job.setDurability(true);
        job.getJobDataMap().put("jndiName", this.m_jndiName);
        this.scheduleJob(this.m_checkJobName, "SNMP_CHECK_JOB", job, this.m_checkInterval);
    }

    public void deleteCheckJob() {
        m_log.debug((Object)("deleteCheckJob()  JobName : " + this.m_checkJobName + "  JobGroup : " + "SNMP_CHECK_JOB"));
        Scheduler scheduler = this.getScheduler();
        try {
            scheduler.deleteJob(this.m_checkJobName, "SNMP_CHECK_JOB");
        }
        catch (SchedulerException e) {
            m_log.error((Object)e);
        }
    }

    public void checkAll() {
        m_log.debug((Object)("checkAll()  Group : " + this.m_groupName + "  \u53c2\u7167\u3055\u308c\u3066\u3044\u306a\u3044\u30c6\u30fc\u30d6\u30eb\u3092\u63a2\u3057\u307e\u3059"));
        Set<String> facilityIdSet = this.m_dataTable.keySet();
        String[] facilityIds = facilityIdSet.toArray(new String[facilityIdSet.size()]);
        for (int i = 0; i < facilityIds.length; ++i) {
            this.check(facilityIds[i]);
        }
        if (this.m_scheduleFlag) {
            this.schedule();
        }
        m_log.debug((Object)("Group : " + this.m_groupName + "  \u53c2\u7167\u3055\u308c\u3066\u3044\u306a\u3044\u30c6\u30fc\u30d6\u30eb\u306e\u30c1\u30a7\u30c3\u30af\u5b8c\u4e86"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(String facilityId) {
        m_log.debug((Object)("check()  Group : " + this.m_groupName + "  " + facilityId + "  \u53c2\u7167\u3055\u308c\u3066\u3044\u306a\u3044\u30c6\u30fc\u30d6\u30eb\u3092\u63a2\u3057\u307e\u3059"));
        HashMap<String, PollingConfig> hashMap = this.m_pollerConf;
        synchronized (hashMap) {
            boolean changeFlag = false;
            long now = System.currentTimeMillis();
            try {
                int elapsedTime = (int)((now - this.getLastReferenceTime(facilityId)) / 1000L);
                int interval = this.getInterval(facilityId);
                m_log.debug((Object)("\u7d4c\u904e\u6642\u9593 " + elapsedTime + "s   \u53ce\u96c6\u9593\u9694 " + interval + "s"));
                while (interval != 0 && interval + this.m_gracePeriod < elapsedTime) {
                    m_log.debug((Object)("Group : " + this.m_groupName + "  " + facilityId + "  \u524a\u9664 " + interval));
                    this.removePollingInterval(facilityId, interval);
                    changeFlag = true;
                    interval = this.getInterval(facilityId);
                }
                if (interval == 0) {
                    this.deleteTable(facilityId);
                } else if (changeFlag) {
                    m_log.debug((Object)("Quartz\u306e\u53ce\u96c6\u8a2d\u5b9a\u3092\u5909\u66f4  " + facilityId));
                    this.m_scheduleFlag = true;
                }
            }
            catch (FacilityNotFoundExciption e) {
                m_log.error((Object)e);
            }
        }
        m_log.debug((Object)("Group : " + this.m_groupName + "  " + facilityId + "  \u53c2\u7167\u3055\u308c\u3066\u3044\u306a\u3044\u30c6\u30fc\u30d6\u30eb\u306e\u30c1\u30a7\u30c3\u30af\u5b8c\u4e86"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread createTable(String facilityId) {
        m_log.debug((Object)("createTable()  Group : " + this.m_groupName + "  " + facilityId));
        PollingConfig pConfig = this.createPollingConfig(facilityId);
        HashMap<String, PollingConfig> hashMap = this.m_pollerConf;
        synchronized (hashMap) {
            this.m_pollerConf.put(facilityId, pConfig);
            this.m_dataTable.put(facilityId, new DataTable());
        }
        PollingThread pt = new PollingThread(pConfig.getSnmpConfig(), this.m_oidList, this.m_jndiName, facilityId, this.m_indexCheckFlg);
        Thread th = new Thread(pt);
        th.start();
        return th;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTable(String facilityId) {
        m_log.debug((Object)("deleteTable()  Group : " + facilityId));
        HashMap<String, PollingConfig> hashMap = this.m_pollerConf;
        synchronized (hashMap) {
            this.m_dataTable.remove(facilityId);
            this.m_pollerConf.remove(facilityId);
            this.m_scheduleFlag = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTableAll() {
        m_log.debug((Object)("deleteTableAll()  Group : " + this.m_groupName));
        TreeSet<String> set = new TreeSet<String>(this.m_dataTable.keySet());
        Iterator<String> itr = set.iterator();
        HashMap<String, PollingConfig> hashMap = this.m_pollerConf;
        synchronized (hashMap) {
            while (itr.hasNext()) {
                String facilityId = itr.next();
                this.m_dataTable.remove(facilityId);
                this.m_pollerConf.remove(facilityId);
            }
        }
        try {
            Scheduler scheduler = this.getScheduler();
            String[] jobNames = scheduler.getJobNames(this.m_groupName);
            for (int i = 0; i < jobNames.length; ++i) {
                m_log.debug((Object)("deleteJob  JobName : " + jobNames[i] + "  JobGroup : " + this.m_groupName));
                scheduler.deleteJob(jobNames[i], this.m_groupName);
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTable() {
        m_log.debug((Object)("refreshTable()  Group : " + this.m_groupName + " searching tables different from Repository"));
        Set<String> facilityIdSet = this.m_dataTable.keySet();
        String[] facilityIds = facilityIdSet.toArray(new String[facilityIdSet.size()]);
        for (int i = 0; i < facilityIds.length; ++i) {
            String facilityId = facilityIds[i];
            if (!this.isNodeModify(facilityId)) continue;
            HashMap<String, PollingConfig> hashMap = this.m_pollerConf;
            synchronized (hashMap) {
                m_log.debug((Object)("Change Config : " + facilityId));
                try {
                    this.getTable(facilityId).setValueAll(new DataTable());
                }
                catch (FacilityNotFoundExciption e) {
                    m_log.debug((Object)e);
                }
                this.m_pollerConf.put(facilityId, this.createPollingConfig(facilityId));
                m_log.debug((Object)("Reset polling config " + facilityId));
                this.m_scheduleFlag = true;
                m_log.debug((Object)("Set Quartz schedule flag " + facilityId));
                continue;
            }
        }
        if (this.m_scheduleFlag) {
            this.schedule();
        }
        HashMap<String, LockObject> hashMap = this.m_lockMap;
        synchronized (hashMap) {
            this.m_lockMap.clear();
        }
        m_log.debug((Object)("refreshTable()  Group : " + this.m_groupName + " end."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule() {
        m_log.debug((Object)("schedule()  Group : " + this.m_groupName));
        if (!this.m_scheduleFlag) {
            return;
        }
        HashMap<String, PollingConfig> hashMap = this.m_pollerConf;
        synchronized (hashMap) {
            m_log.debug((Object)("\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb\u5909\u66f4  Group : " + this.m_groupName));
            int[] intervalList = PollingConfig.getAvailableIntervals();
            this.m_minInterval = Integer.MAX_VALUE;
            for (int i = 0; i < intervalList.length; ++i) {
                int interval = intervalList[i];
                String jobName = "Int" + interval + "Sec";
                JobDetail job = new JobDetail(jobName, this.m_groupName, SnmpPollingJob.class);
                job.setDurability(true);
                Iterator<String> itr = this.m_pollerConf.keySet().iterator();
                HashMap<String, SnmpConfig> confMap = new HashMap<String, SnmpConfig>();
                while (itr.hasNext()) {
                    String facilityId = itr.next();
                    PollingConfig conf = this.m_pollerConf.get(facilityId);
                    if (conf.getMinInterval() != interval) continue;
                    confMap.put(facilityId, conf.getSnmpConfig());
                }
                if (confMap.size() == 0) {
                    Scheduler scheduler = this.getScheduler();
                    try {
                        scheduler.deleteJob(jobName, this.m_groupName);
                    }
                    catch (SchedulerException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                this.m_minInterval = Math.min(this.m_minInterval, interval);
                job.getJobDataMap().put("jndiName", this.m_jndiName);
                job.getJobDataMap().put("interval", interval);
                job.getJobDataMap().put((Object)"oidList", (Object)this.m_oidList);
                job.getJobDataMap().put((Object)"snmpConfMap", confMap);
                job.getJobDataMap().put("indexCheckFlg", this.m_indexCheckFlg);
                String cronString = PollingConfig.parseCronExpression(interval);
                this.scheduleJob(jobName, this.m_groupName, job, cronString);
            }
        }
        this.m_scheduleFlag = false;
    }

    private void scheduleJob(String jobName, String groupName, JobDetail job, String cronString) {
        m_log.debug((Object)("scheduleJob()  Group : " + this.m_groupName + " JobName : " + jobName + " " + groupName + " : " + cronString));
        CronTrigger cronTrigger = new CronTrigger(jobName, groupName);
        try {
            cronTrigger.setCronExpression(cronString);
        }
        catch (ParseException e) {
            m_log.error((Object)e);
        }
        try {
            Scheduler scheduler = this.getScheduler();
            scheduler.deleteJob(jobName, groupName);
            scheduler.scheduleJob(job, (Trigger)cronTrigger);
        }
        catch (SchedulerException e) {
            m_log.error((Object)e);
        }
    }

    private Scheduler getScheduler() {
        Scheduler scheduler = null;
        try {
            InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
            Object obj = iniCtx.lookup(this.m_quartzJndiName);
            scheduler = (Scheduler)PortableRemoteObject.narrow((Object)obj, StdScheduler.class);
        }
        catch (NamingException e) {
            m_log.error((Object)e);
        }
        return scheduler;
    }

    private boolean isNodeModify(String facilityId) {
        try {
            RepositoryControllerLocal bean = RepositoryControllerUtil.getLocalHome().create();
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add("ccModifyTimestamp");
            HashMap nodeInfo = bean.getNodeDetail(facilityId, attributes);
            bean.remove();
            Date modifyDate = (Date)nodeInfo.get("ccModifyTimestamp");
            if (modifyDate == null) {
                return false;
            }
            PollingConfig config = this.getConfig(facilityId);
            if (config.getRepositoryModifyTime() < modifyDate.getTime()) {
                m_log.debug((Object)(facilityId + " is modify"));
                return true;
            }
        }
        catch (Exception e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private PollingConfig createPollingConfig(String facilityId) {
        m_log.debug((Object)("createPollingConfig() start " + facilityId));
        try {
            RepositoryControllerLocal bean = RepositoryControllerUtil.getLocalHome().create();
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add("ipProtocolNumber");
            attributes.add("ipNetworkNumber");
            attributes.add("ccIpNetworkNumberV6");
            attributes.add("ccSnmpCommunity");
            attributes.add("ccSnmpPort");
            attributes.add("ccSnmpVersion");
            attributes.add("ccModifyTimestamp");
            HashMap nodeInfo = bean.getNodeDetail(facilityId, attributes);
            bean.remove();
            Integer ipProtNum = (Integer)nodeInfo.get("ipProtocolNumber");
            String ipAddress = null;
            ipAddress = ipProtNum != null && ipProtNum == 6 ? (String)nodeInfo.get("ccIpNetworkNumberV6") : (String)nodeInfo.get("ipNetworkNumber");
            String community = this.m_defaultCommunity;
            String communityStr = (String)nodeInfo.get("ccSnmpCommunity");
            m_log.debug((Object)("community : " + communityStr));
            if (communityStr != null && communityStr != "") {
                community = communityStr;
            }
            int port = this.m_defaultPort;
            Integer portInteger = (Integer)nodeInfo.get("ccSnmpPort");
            m_log.debug((Object)("port      : " + portInteger));
            if (portInteger != null) {
                port = portInteger;
            }
            int version = this.m_defaultVersion;
            String versionStr = (String)nodeInfo.get("ccSnmpVersion");
            m_log.debug((Object)("version   : " + versionStr));
            if (versionStr != null && versionStr != "" && (version = SnmpVersionConstant.stringToType((String)versionStr).intValue()) == -1) {
                version = this.m_defaultVersion;
            }
            Date modifyDate = (Date)nodeInfo.get("ccModifyTimestamp");
            long modifyTime = 0L;
            modifyTime = modifyDate != null ? modifyDate.getTime() : new Date().getTime();
            PollingConfig pConfig = new PollingConfig(InetAddress.getByName(ipAddress), port, version, community, this.m_defaultRetries, this.m_defaultTimeout, modifyTime);
            m_log.debug((Object)("createPollingConfig() end " + facilityId));
            return pConfig;
        }
        catch (Exception e) {
            String message = "Couldn't get Snmp Config : " + facilityId;
            throw new EJBException(message, e);
        }
    }

    public PollingConfig getConfig(String facilityId) {
        PollingConfig conf = this.m_pollerConf.get(facilityId);
        if (conf == null) {
            m_log.error((Object)("Facility not found. : " + facilityId));
        }
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPollingInterval(String facilityId, int interval) {
        HashMap<String, PollingConfig> hashMap = this.m_pollerConf;
        synchronized (hashMap) {
            PollingConfig conf;
            if (!this.m_dataTable.containsKey(facilityId)) {
                this.createTable(facilityId);
            }
            if ((conf = this.getConfig(facilityId)).addInterval(interval)) {
                this.m_scheduleFlag = true;
                if (interval < this.m_minInterval) {
                    this.schedule();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePollingInterval(String facilityId, int interval) throws FacilityNotFoundExciption {
        HashMap<String, PollingConfig> hashMap = this.m_pollerConf;
        synchronized (hashMap) {
            PollingConfig conf = this.getConfig(facilityId);
            conf.removeInterval(interval);
            this.m_scheduleFlag = true;
        }
    }

    public int getInterval(String facilityId) throws FacilityNotFoundExciption {
        return this.getConfig(facilityId).getMinInterval();
    }

    public long getLastReferenceTime(String facilityId) throws FacilityNotFoundExciption {
        return this.getTable(facilityId).getLastReference();
    }

    private DataTable getTable(String facilityId) throws FacilityNotFoundExciption {
        DataTable table = this.m_dataTable.get(facilityId);
        if (table == null) {
            m_log.debug((Object)("\u767b\u9332\u3055\u308c\u3066\u3044\u306a\u3044\u30d5\u30a1\u30b7\u30ea\u30c6\u30a3ID\u3067\u30c6\u30fc\u30d6\u30eb\u304c\u53c2\u7167\u3055\u308c\u307e\u3057\u305f : " + facilityId));
            throw new FacilityNotFoundExciption();
        }
        return table;
    }

    public void putValue(String facilityId, String oid, long date, Object value) throws FacilityNotFoundExciption {
        m_log.debug((Object)("putValue()   Group : " + this.m_groupName + "  " + facilityId + " : " + value));
        if (!this.m_dataTable.containsKey(facilityId)) {
            this.createTable(facilityId);
        }
        this.getTable(facilityId).putValue(oid, date, value);
    }

    public void putValueAll(String facilityId, DataTable table) throws FacilityNotFoundExciption {
        m_log.debug((Object)("putValueAll()   Group : " + this.m_groupName + "  " + facilityId));
        if (!this.m_dataTable.containsKey(facilityId)) {
            this.createTable(facilityId);
        }
        this.getTable(facilityId).putValueAll(table);
    }

    public void setValueAll(String facilityId, DataTable table) throws FacilityNotFoundExciption {
        m_log.debug((Object)("setValueAll()   Group : " + this.m_groupName + "  " + facilityId));
        if (!this.m_dataTable.containsKey(facilityId)) {
            this.createTable(facilityId);
        }
        this.getTable(facilityId).setValueAll(table);
    }

    public ValueObject getValue(String facilityId, int interval, String oid) {
        if (!this.m_dataTable.containsKey(facilityId)) {
            this.createTable(facilityId);
        }
        this.setPollingInterval(facilityId, interval);
        try {
            return this.getTable(facilityId).getValue(oid);
        }
        catch (FacilityNotFoundExciption e) {
            m_log.debug((Object)e);
            return null;
        }
    }

    public Set getValueSet(String facilityId, int interval, String oid) {
        if (!this.m_dataTable.containsKey(facilityId)) {
            this.createTable(facilityId);
        }
        this.setPollingInterval(facilityId, interval);
        HashSet<ValueObject> set = new HashSet<ValueObject>();
        try {
            DataTable dt = this.getTable(facilityId).getValueAll();
            for (String fullOid : dt.keySet()) {
                if (!fullOid.startsWith(oid)) continue;
                set.add(this.getTable(facilityId).getValue(fullOid));
            }
        }
        catch (FacilityNotFoundExciption e) {
            m_log.debug((Object)e);
        }
        if (set.size() == 0) {
            return null;
        }
        return set;
    }

    public void setPollingSchedule(String facilityId, int interval) {
        if (!this.m_dataTable.containsKey(facilityId)) {
            this.createTable(facilityId);
        }
        this.setPollingInterval(facilityId, interval);
    }

    public void setPollingSchedule(String[] facilityIds, int interval, long waitTime) {
        for (int i = 0; i < facilityIds.length; ++i) {
            String facilityId = facilityIds[i];
            if (!this.m_dataTable.containsKey(facilityId)) {
                this.createTable(facilityId);
            }
            this.setPollingInterval(facilityId, interval);
        }
        this.m_scheduleFlag = true;
        this.schedule();
        try {
            Thread.sleep(waitTime);
        }
        catch (InterruptedException e) {
            m_log.error((Object)e);
        }
    }

    public String getCheckInterval() {
        return this.m_checkInterval;
    }

    public void setCheckInterval(String interval) {
        this.m_checkInterval = interval;
    }

    public List getOidList() {
        return this.m_oidList;
    }

    public void setOidList(List oidList) {
        this.m_oidList = oidList;
    }

    public int getDefaultPort() {
        return this.m_defaultPort;
    }

    public void setDefaultPort(int port) {
        this.m_defaultPort = port;
    }

    public String getDefaultCommunity() {
        return this.m_defaultCommunity;
    }

    public void setDefaultCommunity(String community) {
        this.m_defaultCommunity = community;
    }

    public int getDefaultVersion() {
        return this.m_defaultVersion;
    }

    public void setDefaultVersion(int version) {
        this.m_defaultVersion = version;
    }

    public int getDefaultRetries() {
        return this.m_defaultRetries;
    }

    public void setDefaultRetries(int retries) {
        this.m_defaultRetries = retries;
    }

    public int getDefaultTimeout() {
        return this.m_defaultTimeout;
    }

    public void setDdefaultTimeout(int timeout) {
        this.m_defaultTimeout = timeout;
    }

    public String getQuartzJndiName() {
        return this.m_quartzJndiName;
    }

    public void setQuartzJndiName(String jndiName) {
        this.m_quartzJndiName = jndiName;
    }

    public boolean isIndexCheckFlg() {
        return this.m_indexCheckFlg;
    }

    public void setIndexCheckFlg(boolean checkFlg) {
        this.m_indexCheckFlg = checkFlg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void polling(String facilityId, long waitTime) {
        m_log.debug((Object)(facilityId + " polling() start"));
        LockObject lo = null;
        Object object = this.m_lockMap;
        synchronized (object) {
            if (this.m_lockMap == null) {
                this.m_lockMap = new HashMap();
            }
            if (!this.m_lockMap.containsKey(facilityId)) {
                this.m_lockMap.put(facilityId, new LockObject(0L));
            }
            lo = this.m_lockMap.get(facilityId);
        }
        object = lo;
        synchronized (object) {
            Thread th = null;
            if (!this.m_dataTable.containsKey(facilityId)) {
                m_log.debug((Object)(facilityId + " create table start"));
                th = this.createTable(facilityId);
                if (th != null) {
                    try {
                        th.join(waitTime);
                        m_log.debug((Object)(facilityId + " create table end"));
                    }
                    catch (InterruptedException e) {
                        m_log.error((Object)e.getMessage(), (Throwable)e);
                        return;
                    }
                }
            } else {
                long time = System.currentTimeMillis() - lo.getTime();
                m_log.debug((Object)(facilityId + " " + time + "ms"));
                if (time < 20000L) {
                    return;
                }
                PollingThread pt = new PollingThread(this.getConfig(facilityId).getSnmpConfig(), this.m_oidList, this.m_jndiName, facilityId, this.m_indexCheckFlg);
                th = new Thread(pt);
                m_log.debug((Object)(facilityId + " polling thread start"));
                th.start();
                if (th != null) {
                    try {
                        th.join(waitTime);
                        m_log.debug((Object)(facilityId + " polling thread end"));
                    }
                    catch (InterruptedException e) {
                        m_log.error((Object)e.getMessage(), (Throwable)e);
                        return;
                    }
                }
            }
            lo.setTime(System.currentTimeMillis());
        }
        m_log.debug((Object)(facilityId + " polling() end"));
    }

    private class LockObject {
        long time;

        LockObject(long time) {
            this.time = time;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }
    }
}

