/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.jboss.reflect.plugins.AnnotationHolder;
import org.jboss.reflect.plugins.ParameterInfoImpl;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class MethodInfoImpl
extends AnnotationHolder
implements MethodInfo {
    private static final long serialVersionUID = 3257007670035756341L;
    protected String name;
    protected Method method;
    protected ClassInfo declaringClass;
    protected TypeInfo[] parameterTypes;
    protected ParameterInfo[] parameters;
    protected ClassInfo[] exceptionTypes;
    protected int modifiers;
    protected TypeInfo returnType;
    protected int hash;

    public MethodInfoImpl() {
    }

    public MethodInfoImpl(AnnotationValue[] annotations, String name, TypeInfo returnType, TypeInfo[] parameterTypes, ClassInfo[] exceptionTypes, int modifiers, ClassInfo declaring) {
        super(annotations);
        this.name = name;
        if (parameterTypes == null) {
            this.parameterTypes = MethodInfo.NO_PARAMS_TYPES;
            this.parameters = MethodInfo.NO_PARAMS;
        } else {
            this.parameterTypes = parameterTypes;
            this.parameters = new ParameterInfoImpl[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                this.parameters[i] = new ParameterInfoImpl(null, null, parameterTypes[i]);
            }
        }
        this.exceptionTypes = exceptionTypes == null ? MethodInfo.NO_EXCEPTIONS : exceptionTypes;
        this.modifiers = modifiers;
        this.declaringClass = declaring;
        this.returnType = returnType;
        this.calculateHash();
    }

    public MethodInfoImpl(AnnotationValue[] annotations, String name, TypeInfo returnType, ParameterInfo[] parameters, ClassInfo[] exceptionTypes, int modifiers, ClassInfo declaring) {
        super(annotations);
        this.name = name;
        if (parameters == null || parameters.length == 0) {
            this.parameterTypes = MethodInfo.NO_PARAMS_TYPES;
            this.parameters = MethodInfo.NO_PARAMS;
        } else {
            this.parameters = parameters;
            this.parameterTypes = new TypeInfo[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                this.parameterTypes[i] = parameters[i].getParameterType();
            }
        }
        this.exceptionTypes = exceptionTypes == null || exceptionTypes.length == 0 ? MethodInfo.NO_EXCEPTIONS : exceptionTypes;
        this.modifiers = modifiers;
        this.declaringClass = declaring;
        this.returnType = returnType;
        this.calculateHash();
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public String getName() {
        return this.name;
    }

    public Method getMethod() {
        return this.method;
    }

    public ClassInfo getDeclaringClass() {
        return this.declaringClass;
    }

    public TypeInfo[] getParameterTypes() {
        return this.parameterTypes;
    }

    public ParameterInfo[] getParameters() {
        return this.parameters;
    }

    public ClassInfo[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public TypeInfo getReturnType() {
        return this.returnType;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        buffer.append(Arrays.asList(this.parameterTypes));
        buffer.append(" return=").append((Object)this.returnType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof MethodInfoImpl)) {
            return false;
        }
        MethodInfoImpl other = (MethodInfoImpl)obj;
        if (!this.declaringClass.equals(other.declaringClass)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!Arrays.equals(this.parameterTypes, other.parameterTypes)) {
            return false;
        }
        return this.returnType.equals(other.returnType);
    }

    public int hashCode() {
        return this.hash;
    }

    protected void calculateHash() {
        int result = this.name.hashCode();
        result = 29 * result + this.declaringClass.hashCode();
        if (this.parameterTypes != null) {
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                result = 29 * result + this.parameterTypes[i].hashCode();
            }
        }
        this.hash = result;
    }
}

