/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.jobmanagement.dao.JobFileInfoDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileInfoBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileInfoPK;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobFileInfoDAOImpl
implements JobFileInfoDAO {
    protected static Log m_log = LogFactory.getLog(JobFileInfoDAOImpl.class);

    public void init() {
    }

    public void load(JobFileInfoPK pk, JobFileInfoBean ejb) throws EJBException {
        block13: {
            m_log.debug((Object)("load() start : " + pk.toString()));
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_file_info WHERE session_id = ? AND job_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getSession_id());
                stmt.setString(2, pk.getJob_id());
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setCheck_flg(res.getInt("check_flg"));
                    ejb.setCompression_flg(res.getInt("compression_flg"));
                    ejb.setDest_directory(res.getString("dest_directory"));
                    ejb.setDest_facility_id(res.getString("dest_facility_id"));
                    ejb.setDest_work_dir(res.getString("dest_work_dir"));
                    ejb.setEffective_user(res.getString("effective_user"));
                    ejb.setJob_id(res.getString("job_id"));
                    ejb.setProcess_mode(res.getInt("process_mode"));
                    ejb.setSession_id(res.getString("session_id"));
                    ejb.setSrc_facility_id(res.getString("src_facility_id"));
                    ejb.setSrc_file(res.getString("src_file"));
                    ejb.setSrc_work_dir(res.getString("src_work_dir"));
                    break block13;
                }
                String msg = "JobFileInfo data is not found.";
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    public void store(JobFileInfoBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE cc_job_file_info SET ");
            sql.append("process_mode = ?, ");
            sql.append("src_facility_id = ?, ");
            sql.append("dest_facility_id = ?, ");
            sql.append("src_file = ?, ");
            sql.append("src_work_dir = ?, ");
            sql.append("dest_directory = ?, ");
            sql.append("dest_work_dir = ?, ");
            sql.append("compression_flg = ?, ");
            sql.append("check_flg = ?, ");
            sql.append("effective_user = ? ");
            sql.append("WHERE session_id = ? AND ");
            sql.append("job_id = ?");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setInt(1, ejb.getProcess_mode());
            stmt.setString(2, ejb.getSrc_facility_id());
            stmt.setString(3, ejb.getDest_facility_id());
            stmt.setString(4, ejb.getSrc_file());
            stmt.setString(5, ejb.getSrc_work_dir());
            stmt.setString(6, ejb.getDest_directory());
            stmt.setString(7, ejb.getDest_work_dir());
            stmt.setInt(8, ejb.getCompression_flg());
            stmt.setInt(9, ejb.getCheck_flg());
            stmt.setString(10, ejb.getEffective_user());
            stmt.setString(11, ejb.getSession_id());
            stmt.setString(12, ejb.getJob_id());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("store() end : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
    }

    public void remove(JobFileInfoPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM cc_job_file_info WHERE session_id = ? AND job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    public JobFileInfoPK create(JobFileInfoBean ejb) throws CreateException, EJBException {
        JobFileInfoPK pk;
        m_log.debug((Object)("create() start : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO cc_job_file_info (");
            sql.append("session_id, ");
            sql.append("job_id, ");
            sql.append("process_mode, ");
            sql.append("src_facility_id, ");
            sql.append("dest_facility_id, ");
            sql.append("src_file, ");
            sql.append("src_work_dir, ");
            sql.append("dest_directory, ");
            sql.append("dest_work_dir, ");
            sql.append("compression_flg, ");
            sql.append("check_flg, ");
            sql.append("effective_user) ");
            sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getSession_id());
            stmt.setString(2, ejb.getJob_id());
            stmt.setInt(3, ejb.getProcess_mode());
            stmt.setString(4, ejb.getSrc_facility_id());
            stmt.setString(5, ejb.getDest_facility_id());
            stmt.setString(6, ejb.getSrc_file());
            stmt.setString(7, ejb.getSrc_work_dir());
            stmt.setString(8, ejb.getDest_directory());
            stmt.setString(9, ejb.getDest_work_dir());
            stmt.setInt(10, ejb.getCompression_flg());
            stmt.setInt(11, ejb.getCheck_flg());
            stmt.setString(12, ejb.getEffective_user());
            int row = stmt.executeUpdate();
            pk = new JobFileInfoPK(ejb.getSession_id(), ejb.getJob_id());
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("23505")) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
            throw new CreateException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("create() end : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
        return pk;
    }

    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<JobFileInfoPK> ret = new ArrayList<JobFileInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_file_info";
            stmt = conn.prepareStatement(sql);
            res = stmt.executeQuery();
            while (res.next()) {
                JobFileInfoPK pk = new JobFileInfoPK(res.getString("session_id"), res.getString("job_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public JobFileInfoPK findByPrimaryKey(JobFileInfoPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_file_info WHERE session_id = ? AND job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobFileInfoPK jobFileInfoPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobFileInfoPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection makeSession(String sessionId, Collection jobs) throws CreateException {
        m_log.debug((Object)("makeSession() start : " + sessionId));
        ArrayList<Hashtable> fileJobs = new ArrayList<Hashtable>();
        Connection conn = null;
        Connection connMaster = null;
        Statement stmt = null;
        Statement stmtMaster = null;
        String jobId = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                connMaster = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_job_file_info (");
                sql.append("session_id, ");
                sql.append("job_id, ");
                sql.append("process_mode, ");
                sql.append("src_facility_id, ");
                sql.append("dest_facility_id, ");
                sql.append("src_file, ");
                sql.append("src_work_dir, ");
                sql.append("dest_directory, ");
                sql.append("dest_work_dir, ");
                sql.append("compression_flg, ");
                sql.append("check_flg, ");
                sql.append("effective_user) ");
                sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, sessionId);
                StringBuilder sqlMaster = new StringBuilder();
                sqlMaster.append("SELECT ");
                sqlMaster.append("cc_job_mst.job_type, ");
                sqlMaster.append("cc_job_file_mst.job_id, ");
                sqlMaster.append("cc_job_file_mst.process_mode, ");
                sqlMaster.append("cc_job_file_mst.src_facility_id, ");
                sqlMaster.append("cc_job_file_mst.dest_facility_id, ");
                sqlMaster.append("cc_job_file_mst.src_file, ");
                sqlMaster.append("cc_job_file_mst.src_work_dir, ");
                sqlMaster.append("cc_job_file_mst.dest_directory, ");
                sqlMaster.append("cc_job_file_mst.dest_work_dir, ");
                sqlMaster.append("cc_job_file_mst.compression_flg, ");
                sqlMaster.append("cc_job_file_mst.check_flg, ");
                sqlMaster.append("cc_job_file_mst.effective_user ");
                sqlMaster.append("FROM cc_job_mst, cc_job_file_mst ");
                sqlMaster.append("WHERE ");
                sqlMaster.append("(cc_job_mst.job_id=cc_job_file_mst.job_id ");
                sqlMaster.append("AND cc_job_mst.job_id=");
                sqlMaster.append(" ? )");
                stmtMaster = connMaster.prepareStatement(sqlMaster.toString());
                for (Hashtable ht : jobs) {
                    jobId = (String)ht.get("jobId");
                    stmtMaster.setString(1, jobId);
                    ResultSet resMaster = stmtMaster.executeQuery();
                    if (resMaster.next() && resMaster.getInt("job_type") == 3) {
                        stmt.setString(2, resMaster.getString("job_id"));
                        stmt.setInt(3, resMaster.getInt("process_mode"));
                        stmt.setString(4, resMaster.getString("src_facility_id"));
                        stmt.setString(5, resMaster.getString("dest_facility_id"));
                        stmt.setString(6, resMaster.getString("src_file"));
                        stmt.setString(7, resMaster.getString("src_work_dir"));
                        stmt.setString(8, resMaster.getString("dest_directory"));
                        stmt.setString(9, resMaster.getString("dest_work_dir"));
                        stmt.setInt(10, resMaster.getInt("compression_flg"));
                        stmt.setInt(11, resMaster.getInt("check_flg"));
                        stmt.setString(12, resMaster.getString("effective_user"));
                        int row = stmt.executeUpdate();
                        if (row != 1) {
                            String msg = "result row is not 1";
                            m_log.error((Object)("makeSession() error : " + sessionId + ", " + resMaster.getString("job_id") + " SQLException"));
                            throw new EJBException(msg);
                        }
                        fileJobs.add(ht);
                    }
                    resMaster.close();
                }
                Object var17_17 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (stmtMaster != null) {
                    stmtMaster.close();
                }
                if (conn != null) {
                    conn.close();
                }
                if (connMaster == null) throw throwable;
                connMaster.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (stmtMaster != null) {
            stmtMaster.close();
        }
        if (conn != null) {
            conn.close();
        }
        if (connMaster != null) {
            connMaster.close();
        }
        m_log.debug((Object)("makeSession() end : " + sessionId));
        return fileJobs;
    }
}

