/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib;

import java.io.StringWriter;
import org.apache.util.DOMUtils;
import org.apache.util.PropertyWriter;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.ResponseEntity;
import org.w3c.dom.Element;

public class BaseProperty
implements Property {
    protected ResponseEntity response;
    protected Element element;

    public BaseProperty(ResponseEntity response, Element element) {
        this.element = element;
        this.response = response;
    }

    public String getName() {
        return this.element.getTagName();
    }

    public String getLocalName() {
        return DOMUtils.getElementLocalName(this.element);
    }

    public String getNamespaceURI() {
        return DOMUtils.getElementNamespaceURI(this.element);
    }

    public Element getElement() {
        return this.element;
    }

    public String getPropertyAsString() {
        return DOMUtils.getTextValue(this.element);
    }

    public int getStatusCode() {
        Element status = DOMUtils.getFirstElement(this.element.getParentNode().getParentNode(), "DAV:", "status");
        if (status != null) {
            return DOMUtils.parseStatus(DOMUtils.getTextValue(status));
        }
        return this.response.getStatusCode();
    }

    public String getOwningURL() {
        return this.response.getHref();
    }

    public String toString() {
        StringWriter tmp = new StringWriter();
        PropertyWriter propertyWriter = new PropertyWriter(tmp, true);
        propertyWriter.print(this.element);
        return tmp.getBuffer().toString();
    }
}

