/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.ejb.mdb;

import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.monitor.message.LogOutputJobRunInfo;
import com.clustercontrol.monitor.message.LogOutputNotifyInfo;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK;
import com.clustercontrol.snmptrap.factory.SelectMonitorInfo;
import com.clustercontrol.snmptrap.message.SnmpTrapMessageInfo;
import com.clustercontrol.util.Messages;
import java.io.Serializable;
import java.util.ArrayList;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotifySnmpTrapBean
implements MessageDrivenBean,
MessageListener {
    protected static Log m_log = LogFactory.getLog(NotifySnmpTrapBean.class);
    private MessageDrivenContext messageContext = null;

    public void setMessageDrivenContext(MessageDrivenContext messageContext) throws EJBException {
        this.messageContext = messageContext;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
        this.messageContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessage(Message message) {
        m_log.debug((Object)"onMessage() : strat");
        if (!(message instanceof ObjectMessage)) return;
        ObjectMessage objectMessage = (ObjectMessage)message;
        Serializable obj = null;
        try {
            obj = objectMessage.getObject();
        }
        catch (JMSException e) {
            return;
        }
        if (obj instanceof SnmpTrapMessageInfo) {
            RepositoryControllerLocal repository = null;
            try {
                repository = RepositoryControllerUtil.getLocalHome().create();
                SnmpTrapMessageInfo info = (SnmpTrapMessageInfo)obj;
                String monitorId = info.getMonitorId();
                String facilityId = info.getFacilityId();
                String facilityPath = info.getFacilityId().equals("UNREGISTERED") ? info.getAgentAdder() : repository.getFacilityPath(facilityId, null);
                String trapOid = info.getTrapOid();
                int genericId = info.getGenericId();
                int specificId = info.getSpecificId();
                SelectMonitorInfo select = new SelectMonitorInfo();
                MonitorSnmpTrapInfo snmpTrapInfo = select.getMonitorInfo(monitorId);
                if (snmpTrapInfo.getCheckMode() == 1) {
                    SnmpTrapMasterInfo master = select.findMasterInfo(trapOid, genericId, specificId);
                    if (master == null || master.getMib() == null) return;
                    String msg = master.getLogmsg();
                    String msgOrg = master.getDescr();
                    int priority = master.getPriority();
                    this.sendMassage(msg, msgOrg, info, master, priority, snmpTrapInfo, facilityPath);
                    return;
                }
                if (snmpTrapInfo.getCheckMode() == 2) {
                    SnmpTrapMasterInfo master = select.findMasterInfo(trapOid, genericId, specificId);
                    if (master == null || master.getMib() != null) return;
                    String msg = "oid  : " + trapOid + " specificId : " + specificId + " generic_id : " + genericId;
                    String msgOrg = "";
                    int priority = 1;
                    this.sendMassage(msg, msgOrg, info, master, priority, snmpTrapInfo, facilityPath);
                    return;
                }
                ArrayList<MonitorSnmpTrapOidInfo> oidList = snmpTrapInfo.getOidInfos();
                for (int i = 0; i < oidList.size(); ++i) {
                    MonitorSnmpTrapOidInfo oidInfo = oidList.get(i);
                    m_log.debug((Object)("oidInfo : " + oidInfo.getGenericId() + " " + oidInfo.getTrapOid() + " " + oidInfo.getSpecificId()));
                    if (!trapOid.equals(oidInfo.getTrapOid()) || genericId != oidInfo.getGenericId() || specificId != oidInfo.getSpecificId()) continue;
                    String mib = oidInfo.getMib();
                    int priority = oidInfo.getPriority();
                    String msg = oidInfo.getLogmsg();
                    String msgOrg = oidInfo.getDescr();
                    SnmpTrapMasterPK pk = new SnmpTrapMasterPK(mib, trapOid, genericId, specificId);
                    SnmpTrapMasterInfo master = select.getMasterInfo(pk);
                    this.sendMassage(msg, msgOrg, info, master, priority, snmpTrapInfo, facilityPath);
                }
                return;
            }
            catch (EJBException e) {
                return;
            }
            catch (Exception e) {
                return;
            }
            finally {
                if (repository != null) {
                    try {
                        repository.remove();
                    }
                    catch (Exception e) {}
                }
                repository = null;
            }
        }
        m_log.debug((Object)("onMessage(): ObjectMessage is not an expected instance. " + obj.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMassage(String msg, String msgOrg, SnmpTrapMessageInfo info, SnmpTrapMasterInfo master, int priority, MonitorSnmpTrapInfo snmpTrapInfo, String facilityPath) {
        String regex;
        int j;
        String[] values;
        m_log.debug((Object)("sendMassage() start:" + info.getMonitorId() + " " + info.getFacilityId() + " " + info.getTrapOid()));
        SendQueue sendQueue = null;
        try {
            sendQueue = new SendQueue("queue/clustercontrol/Monitor/EventLog");
        }
        catch (NamingException e1) {
            m_log.error((Object)("sendMassage()" + e1.getMessage()));
        }
        catch (JMSException e1) {
            m_log.error((Object)("sendMassage()" + e1.getMessage()));
        }
        if (msg != null && !"".equals(msg)) {
            values = info.getVarBindValue();
            for (j = 0; j < values.length; ++j) {
                regex = "%parm\\[#" + Integer.toString(j + 1) + "\\]%";
                msg = msg.replaceAll(regex, values[j]);
            }
        } else {
            msg = "";
        }
        if (msgOrg == null || "".equals(msgOrg)) {
            msgOrg = master.getDescr();
        }
        if (msgOrg != null && !"".equals(msgOrg)) {
            values = info.getVarBindValue();
            for (j = 0; j < values.length; ++j) {
                regex = "%parm\\[#" + Integer.toString(j + 1) + "\\]%";
                msgOrg = msgOrg.replaceAll(regex, values[j]);
            }
        } else {
            msgOrg = "";
        }
        LogOutputNotifyInfo notifyInfo = new LogOutputNotifyInfo();
        notifyInfo.setMonitorId(info.getMonitorId());
        notifyInfo.setPluginId("SNMPTRAP");
        notifyInfo.setPriority(priority);
        notifyInfo.setNotifyId(snmpTrapInfo.getNotifyId());
        notifyInfo.setApplication(snmpTrapInfo.getApplication());
        notifyInfo.setFacilityId(info.getFacilityId());
        notifyInfo.setScopeText(facilityPath);
        notifyInfo.setGenerationDate(info.getTrapDate());
        String messageId = null;
        messageId = priority == 3 ? "001" : (priority == 2 ? "002" : (priority == 0 ? "003" : "004"));
        notifyInfo.setMessageId(messageId);
        notifyInfo.setMessage(msg);
        Object[] args = new String[]{info.getTrapOid(), master.getUei()};
        notifyInfo.setMessageOrg(Messages.getString((String)"message.snmptrap.3", (Object[])args) + "\n" + msgOrg);
        if (snmpTrapInfo.getJobRun() == 1 && !info.getFacilityId().equals("UNREGISTERED")) {
            for (MonitorNumericValueInfo mnvi : snmpTrapInfo.getJudgementInfo()) {
                if (mnvi.getPriority() != notifyInfo.getPriority() || mnvi.getJobRun() != 1) continue;
                LogOutputJobRunInfo jobRunInfo = new LogOutputJobRunInfo();
                jobRunInfo.setJobRun(mnvi.getJobRun());
                jobRunInfo.setJobId(mnvi.getJobId());
                jobRunInfo.setJobInhibitionFlg(mnvi.getJobInhibitionFlg());
                jobRunInfo.setJobFailurePriority(mnvi.getJobFailurePriority());
                notifyInfo.setJobRun(jobRunInfo);
            }
        }
        try {
            sendQueue.put((Serializable)notifyInfo);
        }
        catch (Exception e) {
            m_log.error((Object)("onMessage() : \u76e3\u8996\u7ba1\u7406\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
        }
        finally {
            if (sendQueue != null) {
                try {
                    sendQueue.terminate();
                }
                catch (JMSException e) {
                    m_log.error((Object)("Terminate SendQueue Failed : " + e.getMessage()));
                }
            }
        }
    }
}

