/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoaderUtils;

public class ClassPreloadService {
    static /* synthetic */ Class class$org$jboss$mx$loading$ClassPreloadService;

    public void start() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL[] cp = ClassLoaderUtils.getClassLoaderURLs(loader);
        Logger log = Logger.getLogger(class$org$jboss$mx$loading$ClassPreloadService == null ? (class$org$jboss$mx$loading$ClassPreloadService = ClassPreloadService.class$("org.jboss.mx.loading.ClassPreloadService")) : class$org$jboss$mx$loading$ClassPreloadService);
        boolean trace = log.isTraceEnabled();
        int loadedClasses = 0;
        int loadErrors = 0;
        for (int n = 0; n < cp.length; ++n) {
            URL u = cp[n];
            try {
                InputStream is = u.openStream();
                ZipInputStream zis = new ZipInputStream(is);
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    block8: {
                        String name = ze.getName();
                        if (name.endsWith(".class")) {
                            int length = name.length();
                            String cname = name.replace('/', '.').substring(0, length - 6);
                            try {
                                Class<?> c = loader.loadClass(cname);
                                ++loadedClasses;
                                if (trace) {
                                    log.trace("loaded class: " + cname);
                                }
                            }
                            catch (Throwable e) {
                                ++loadErrors;
                                if (!trace) break block8;
                                log.trace("Failed to load class, " + e.getMessage());
                            }
                        }
                    }
                    ze = zis.getNextEntry();
                }
                zis.close();
                continue;
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        log.info("Loaded " + loadedClasses + " classes, " + loadErrors + " CNFEs");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

