/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddableSuperclass;
import javax.persistence.Entity;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceInfo;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.ejb.EntityManagerFactoryImpl;
import org.hibernate.ejb.EventListenerConfigurator;
import org.hibernate.ejb.HibernatePersistence;
import org.hibernate.ejb.InjectedDataSourceConnectionProvider;
import org.hibernate.ejb.InjectionSettingsFactory;
import org.hibernate.ejb.packaging.JarVisitor;
import org.hibernate.ejb.packaging.PersistenceMetadata;
import org.hibernate.ejb.packaging.PersistenceXmlLoader;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.event.EventListeners;
import org.hibernate.mapping.AuxiliaryDatabaseObject;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.secure.JACCConfiguration;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.jboss.util.file.ArchiveBrowser;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3Configuration
implements Serializable {
    private static final String IMPLEMENTATION_NAME = HibernatePersistence.class.getName();
    private static Log log = LogFactory.getLog(Ejb3Configuration.class);
    private AnnotationConfiguration cfg;
    private SettingsFactory settingsFactory = new InjectionSettingsFactory();

    public Ejb3Configuration() {
        this.cfg = new AnnotationConfiguration(this.settingsFactory);
    }

    public void setDataSource(DataSource ds) {
        HashMap<String, DataSource> cpInjection = new HashMap<String, DataSource>();
        cpInjection.put("dataSource", ds);
        ((InjectionSettingsFactory)this.settingsFactory).setConnectionProviderInjectionData(cpInjection);
    }

    private EntityManagerFactory createFactory(PersistenceMetadata metadata, Map overrides) {
        log.debug((Object)("Creating Factory: " + metadata.getName()));
        if (metadata.getMappingFiles().size() > 0) {
            throw new RuntimeException("<mapping-file not supported yet");
        }
        if (StringHelper.isNotEmpty((String)metadata.getJtaDatasource())) {
            this.setProperty("hibernate.connection.datasource", metadata.getJtaDatasource());
        }
        HashMap<String, List<Object>> workingVars = new HashMap<String, List<Object>>();
        if (metadata.getClasses().size() > 0) {
            workingVars.put("hibernate.ejb.classes", metadata.getClasses());
        }
        if (metadata.getPackages().size() > 0) {
            workingVars.put("hibernate.ejb.packages", metadata.getPackages());
        }
        if (metadata.getHbmfiles().size() > 0) {
            workingVars.put("hibernate.hbmxml.files", metadata.getHbmfiles());
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)metadata.getProps());
        if (overrides != null) {
            props.putAll((Map<?, ?>)overrides);
        }
        return this.createEntityManagerFactory(props, workingVars);
    }

    public EntityManagerFactory createEntityManagerFactory(String emName, Map map) {
        try {
            log.debug((Object)("Trying to find persistence unit: " + emName));
            Enumeration<URL> xmls = Thread.currentThread().getContextClassLoader().getResources("META-INF/persistence.xml");
            while (xmls.hasMoreElements()) {
                URL url = xmls.nextElement();
                log.trace((Object)("Analyse of persistence.xml: " + url));
                PersistenceMetadata metadata = PersistenceXmlLoader.deploy(url);
                JarVisitor.Filter[] filters = this.getFilters(metadata.getProps(), map);
                if (metadata.getProvider() != null && !IMPLEMENTATION_NAME.equalsIgnoreCase(metadata.getProvider())) continue;
                log.trace((Object)"Archive to be processed by hibernate Entity Manager implementation found");
                URL jarURL = JarVisitor.getJarURLFromURLEntry(url, "/META-INF/persistence.xml");
                JarVisitor visitor = JarVisitor.getVisitor(jarURL, filters);
                if (metadata.getName() == null) {
                    metadata.setName(visitor.getUnqualifiedJarName());
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Persistence unit name: " + metadata.getName()));
                }
                log.trace((Object)("emname:" + emName + " metadata: " + metadata.getName()));
                if (emName == null && xmls.hasMoreElements()) {
                    throw new PersistenceException("No name provided and several persistence units found");
                }
                if (emName != null && !metadata.getName().equals(emName)) continue;
                Ejb3Configuration.addMetadataFromVisitor(visitor, metadata);
                for (String jarFile : metadata.getJarFiles()) {
                    visitor = JarVisitor.getVisitor(jarFile, filters);
                    Ejb3Configuration.addMetadataFromVisitor(visitor, metadata);
                }
                return this.createFactory(metadata, map);
            }
            return null;
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private static void addMetadataFromVisitor(JarVisitor visitor, PersistenceMetadata metadata) throws IOException {
        Set[] entries = visitor.getMatchingEntries();
        JarVisitor.Filter[] filters = visitor.getFilters();
        int size = filters.length;
        List<String> classes = metadata.getClasses();
        List<String> packages = metadata.getPackages();
        List<InputStream> hbmFiles = metadata.getHbmfiles();
        for (int index = 0; index < size; ++index) {
            for (JarVisitor.Entry entry : entries[index]) {
                if (filters[index] instanceof JarVisitor.ClassFilter) {
                    classes.add(entry.getName());
                    continue;
                }
                if (filters[index] instanceof JarVisitor.PackageFilter) {
                    packages.add(entry.getName());
                    continue;
                }
                if (!(filters[index] instanceof JarVisitor.FileFilter)) continue;
                hbmFiles.add(entry.getInputStream());
            }
        }
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceInfo info) {
        ArrayList<String> entities = info.getEntityclassNames();
        if (entities == null) {
            entities = new ArrayList<String>();
        }
        ArrayList<InputStream> hbmFiles = new ArrayList<InputStream>();
        ArrayList<String> packages = new ArrayList<String>();
        HashMap<String, ArrayList<Object>> workingVars = new HashMap<String, ArrayList<Object>>();
        boolean[] detectArtifact = this.getDetectedArtifacts(info.getProperties(), null);
        for (URL jar : info.getJarFiles()) {
            if (detectArtifact[0]) {
                this.scanForClasses(jar, packages, entities);
            }
            if (!detectArtifact[1]) continue;
            this.scanForHbmXmlFiles(jar, hbmFiles);
        }
        Properties props = info.getProperties();
        if (props == null) {
            props = new Properties();
        }
        workingVars.put("hibernate.ejb.classes", entities);
        workingVars.put("hibernate.ejb.packages", packages);
        if (hbmFiles.size() > 0) {
            workingVars.put("hibernate.hbmxml.files", hbmFiles);
        }
        if (info.getJtaDataSource() != null || info.getNonJtaDataSource() != null) {
            this.setDataSource(info.getJtaDataSource() != null ? info.getJtaDataSource() : info.getNonJtaDataSource());
            this.setProperty("hibernate.connection.provider_class", InjectedDataSourceConnectionProvider.class.getName());
        }
        return this.createEntityManagerFactory(props, workingVars);
    }

    public Ejb3Configuration setProperty(String key, String value) {
        this.cfg.setProperty(key, value);
        return this;
    }

    private boolean[] getDetectedArtifacts(Properties properties, Map overridenProperties) {
        boolean[] result = new boolean[]{false, false};
        String detect = overridenProperties != null ? (String)overridenProperties.get("hibernate.archive.autodetection") : null;
        detect = detect == null ? properties.getProperty("hibernate.archive.autodetection", "class,hbm") : detect;
        StringTokenizer st = new StringTokenizer(detect, ",", false);
        while (st.hasMoreElements()) {
            String element = (String)st.nextElement();
            if ("class".equalsIgnoreCase(element)) {
                result[0] = true;
            }
            if (!"hbm".equalsIgnoreCase(element)) continue;
            result[1] = true;
        }
        log.debug((Object)("Detect class: " + result[0] + "; detect hbm: " + result[1]));
        return result;
    }

    private JarVisitor.Filter[] getFilters(Properties properties, Map overridenProperties) {
        boolean[] result = this.getDetectedArtifacts(properties, overridenProperties);
        int size = (result[0] ? 2 : 0) + (result[1] ? 1 : 0);
        JarVisitor.Filter[] filters = new JarVisitor.Filter[size];
        if (result[0]) {
            filters[0] = new JarVisitor.PackageFilter(false, null){

                public boolean accept(String javaElementName) {
                    return true;
                }
            };
            filters[1] = new JarVisitor.ClassFilter(false, new Class[]{Entity.class, EmbeddableSuperclass.class, Embeddable.class}){

                public boolean accept(String javaElementName) {
                    return true;
                }
            };
        }
        if (result[1]) {
            filters[size - 1] = new JarVisitor.FileFilter(true){

                public boolean accept(String javaElementName) {
                    return javaElementName.endsWith("hbm.xml");
                }
            };
        }
        return filters;
    }

    private void scanForHbmXmlFiles(URL jar, List<InputStream> hbmxmls) {
        Iterator it = ArchiveBrowser.getBrowser((URL)jar, (ArchiveBrowser.Filter)new ArchiveBrowser.Filter(){

            public boolean accept(String filename) {
                return filename.endsWith(".hbm.xml");
            }
        });
        while (it.hasNext()) {
            InputStream stream = (InputStream)it.next();
            hbmxmls.add(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanForClasses(URL jar, List<String> packages, List<String> entities) {
        Iterator it = ArchiveBrowser.getBrowser((URL)jar, (ArchiveBrowser.Filter)new ArchiveBrowser.Filter(){

            public boolean accept(String filename) {
                return filename.endsWith(".class");
            }
        });
        while (it.hasNext()) {
            boolean isEmbeddableSuperclass;
            boolean isEmbeddable;
            boolean isEntity;
            InputStream stream = (InputStream)it.next();
            DataInputStream dstream = new DataInputStream(stream);
            ClassFile cf = null;
            try {
                try {
                    cf = new ClassFile(dstream);
                }
                finally {
                    dstream.close();
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (cf.getName().endsWith(".package-info")) {
                int idx = cf.getName().indexOf(".package-info");
                String pkgName = cf.getName().substring(0, idx);
                log.info((Object)("found package: " + pkgName));
                packages.add(pkgName);
                continue;
            }
            AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
            if (visible == null) continue;
            boolean bl = isEntity = visible.getAnnotation(Entity.class.getName()) != null;
            if (isEntity) {
                log.info((Object)("found EJB3 Entity bean: " + cf.getName()));
                entities.add(cf.getName());
            }
            boolean bl2 = isEmbeddable = visible.getAnnotation(Embeddable.class.getName()) != null;
            if (isEmbeddable) {
                log.info((Object)("found EJB3 @Embeddable: " + cf.getName()));
                entities.add(cf.getName());
            }
            if (!(isEmbeddableSuperclass = visible.getAnnotation(EmbeddableSuperclass.class.getName()) != null)) continue;
            log.info((Object)("found EJB3 @EmbeddableSuperclass: " + cf.getName()));
            entities.add(cf.getName());
        }
    }

    public EntityManagerFactory createEntityManagerFactory(Map workingVars) {
        Properties props = new Properties();
        if (workingVars != null) {
            props.putAll((Map<?, ?>)workingVars);
            props.remove("hibernate.ejb.classes");
            props.remove("hibernate.ejb.packages");
            props.remove("hibernate.hbmxml.files");
            props.remove("hibernate.ejb.loaded.classes");
        }
        return this.createEntityManagerFactory(props, workingVars);
    }

    public EntityManagerFactory createEntityManagerFactory() {
        return new EntityManagerFactoryImpl(this.cfg.buildSessionFactory());
    }

    private EntityManagerFactory createEntityManagerFactory(Properties properties, Map workingVars) {
        Properties preparedProperties = new Properties();
        preparedProperties.setProperty("hibernate.connection.release_mode", "auto");
        preparedProperties.setProperty("hibernate.connection.autocommit", "true");
        preparedProperties.setProperty("hibernate.use_identifier_rollback", "true");
        if (properties != null) {
            preparedProperties.putAll((Map<?, ?>)properties);
        }
        if (properties != null && properties.containsKey("hibernate.ejb.cfgfile")) {
            String cfgFileName = properties.getProperty("hibernate.ejb.cfgfile");
            this.cfg.configure(cfgFileName);
        }
        this.cfg.addProperties(preparedProperties);
        if (workingVars == null) {
            workingVars = CollectionHelper.EMPTY_MAP;
        }
        if (workingVars.containsKey("hibernate.ejb.classes")) {
            Collection classNames = (Collection)workingVars.get("hibernate.ejb.classes");
            this.addNamedAnnotatedClasses(this, classNames);
        }
        if (workingVars.containsKey("hibernate.ejb.loaded.classes")) {
            Collection classes = (Collection)workingVars.get("hibernate.ejb.loaded.classes");
            for (Class clazz : classes) {
                this.cfg.addAnnotatedClass(clazz);
            }
        }
        if (workingVars.containsKey("hibernate.ejb.packages")) {
            Collection packages = (Collection)workingVars.get("hibernate.ejb.packages");
            for (String pkg : packages) {
                this.cfg.addPackage(pkg);
            }
        }
        if (workingVars.containsKey("hibernate.hbmxml.files")) {
            Collection hbmXmlFiles = (Collection)workingVars.get("hibernate.hbmxml.files");
            for (InputStream is : hbmXmlFiles) {
                this.cfg.addInputStream(is);
            }
        }
        ArrayList<String> jaccKeys = new ArrayList<String>();
        if (properties != null) {
            for (Object uncastObject : properties.keySet()) {
                if (uncastObject == null || !(uncastObject instanceof String)) continue;
                String propertyKey = (String)uncastObject;
                if (propertyKey.startsWith("hibernate.ejb.classcache")) {
                    this.setCacheStrategy(propertyKey, properties, true);
                    continue;
                }
                if (propertyKey.startsWith("hibernate.ejb.collectioncache")) {
                    this.setCacheStrategy(propertyKey, properties, false);
                    continue;
                }
                if (propertyKey.startsWith("hibernate.jacc") && !propertyKey.equals("hibernate.jacc.ctx.id") && !propertyKey.equals("hibernate.jacc.enabled")) {
                    jaccKeys.add(propertyKey);
                    continue;
                }
                if (!propertyKey.equals("hibernate.ejb.interceptor") || this.cfg.getInterceptor() != null) continue;
                String interceptorName = properties.getProperty("hibernate.ejb.interceptor");
                try {
                    Class interceptor = ReflectHelper.classForName((String)interceptorName, this.getClass());
                    this.cfg.setInterceptor((Interceptor)interceptor.newInstance());
                }
                catch (ClassNotFoundException e) {
                    throw new PersistenceException("Unable to find interceptor class: " + interceptorName, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new PersistenceException("Unable to access interceptor class: " + interceptorName, (Throwable)e);
                }
                catch (InstantiationException e) {
                    throw new PersistenceException("Unable to instanciate interceptor class: " + interceptorName, (Throwable)e);
                }
                catch (ClassCastException e) {
                    throw new PersistenceException("Interceptor class does not implement Interceptor interface: " + interceptorName, (Throwable)e);
                }
            }
        }
        if (jaccKeys.size() > 0) {
            Ejb3Configuration.addSecurity(jaccKeys, properties);
        }
        EventListenerConfigurator listenerConfigurator = new EventListenerConfigurator();
        listenerConfigurator.setConfiguration(this);
        listenerConfigurator.setProperties(preparedProperties);
        listenerConfigurator.setValidator(true);
        listenerConfigurator.configure();
        if (!"true".equalsIgnoreCase(this.cfg.getProperty("hibernate.connection.autocommit"))) {
            log.warn((Object)"hibernate.connection.autocommit = false break the EJB3 specification");
        }
        if (!"true".equalsIgnoreCase(this.cfg.getProperty("hibernate.use_identifier_rollback"))) {
            log.warn((Object)"hibernate.use_identifier_rollback = false break the EJB3 specification");
        }
        return this.createEntityManagerFactory();
    }

    private void setCacheStrategy(String propertyKey, Map properties, boolean isClass) {
        String role = propertyKey.substring((isClass ? "hibernate.ejb.classcache".length() : "hibernate.ejb.collectioncache".length()) + 1);
        String value = (String)properties.get(propertyKey);
        StringTokenizer params = new StringTokenizer(value, ";, ");
        if (!params.hasMoreTokens()) {
            StringBuilder error = new StringBuilder("Illegal usage of ");
            error.append(isClass ? "hibernate.ejb.classcache" : "hibernate.ejb.collectioncache");
            error.append(": ").append(propertyKey).append(" ").append(value);
            throw new MappingException(error.toString());
        }
        String usage = params.nextToken();
        String region = null;
        if (params.hasMoreTokens()) {
            region = params.nextToken();
        }
        if (isClass) {
            boolean lazyProperty = true;
            if (params.hasMoreTokens()) {
                lazyProperty = "all".equalsIgnoreCase(params.nextToken());
            }
            this.cfg.setCacheConcurrencyStrategy(role, usage, region, lazyProperty);
        } else {
            this.cfg.setCollectionCacheConcurrencyStrategy(role, usage, region);
        }
    }

    private static void addSecurity(List<String> keys, Map properties) {
        log.debug((Object)"Adding security");
        if (!properties.containsKey("hibernate.jacc.ctx.id")) {
            throw new MappingException("Entities have been configured for JACC, but hibernate.jacc.ctx.id has not been set");
        }
        String contextId = (String)properties.get("hibernate.jacc.ctx.id");
        int roleStart = "hibernate.jacc".length() + 1;
        for (String key : keys) {
            JACCConfiguration jaccCfg = new JACCConfiguration(contextId);
            try {
                String role = key.substring(roleStart, key.indexOf(46, roleStart));
                int classStart = roleStart + role.length() + 1;
                String clazz = key.substring(classStart, key.length());
                String actions = (String)properties.get(key);
                jaccCfg.addPermission(role, clazz, actions);
            }
            catch (IndexOutOfBoundsException e) {
                throw new MappingException("Illegal usage of hibernate.jacc: " + key);
            }
        }
    }

    private void addNamedAnnotatedClasses(Ejb3Configuration cfg, Collection<String> classNames) {
        for (String name : classNames) {
            try {
                Class clazz = ReflectHelper.classForName((String)name);
                cfg.addAnnotatedClass(clazz);
            }
            catch (ClassNotFoundException cnfe) {
                Package pkg = Package.getPackage(name);
                if (pkg == null) {
                    throw new IllegalArgumentException("class or package not found", cnfe);
                }
                cfg.addPackage(name);
            }
        }
    }

    public Settings buildSettings() throws HibernateException {
        return this.settingsFactory.buildSettings(this.cfg.getProperties());
    }

    public void addProperties(Properties props) {
        this.cfg.addProperties(props);
    }

    public Ejb3Configuration addAnnotatedClass(Class persistentClass) throws MappingException {
        this.cfg.addAnnotatedClass(persistentClass);
        return this;
    }

    public Ejb3Configuration configure(String resource) throws HibernateException {
        this.cfg.configure(resource);
        return this;
    }

    public Ejb3Configuration addPackage(String packageName) throws MappingException {
        this.cfg.addPackage(packageName);
        return this;
    }

    public Ejb3Configuration addFile(String xmlFile) throws MappingException {
        this.cfg.addFile(xmlFile);
        return this;
    }

    public Ejb3Configuration addClass(Class persistentClass) throws MappingException {
        this.cfg.addClass(persistentClass);
        return this;
    }

    public Ejb3Configuration addFile(File xmlFile) throws MappingException {
        this.cfg.addFile(xmlFile);
        return this;
    }

    public void buildMappings() {
        this.cfg.buildMappings();
    }

    public Iterator getClassMappings() {
        return this.cfg.getClassMappings();
    }

    public EventListeners getEventListeners() {
        return this.cfg.getEventListeners();
    }

    SessionFactory buildSessionFactory() throws HibernateException {
        return this.cfg.buildSessionFactory();
    }

    public Iterator getTableMappings() {
        return this.cfg.getTableMappings();
    }

    public PersistentClass getClassMapping(String persistentClass) {
        return this.cfg.getClassMapping(persistentClass);
    }

    public org.hibernate.mapping.Collection getCollectionMapping(String role) {
        return this.cfg.getCollectionMapping(role);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.cfg.setEntityResolver(entityResolver);
    }

    public Map getNamedQueries() {
        return this.cfg.getNamedQueries();
    }

    public Interceptor getInterceptor() {
        return this.cfg.getInterceptor();
    }

    public Properties getProperties() {
        return this.cfg.getProperties();
    }

    public Ejb3Configuration setInterceptor(Interceptor interceptor) {
        this.cfg.setInterceptor(interceptor);
        return this;
    }

    public Ejb3Configuration setProperties(Properties properties) {
        this.cfg.setProperties(properties);
        return this;
    }

    public Map getFilterDefinitions() {
        return this.cfg.getFilterDefinitions();
    }

    public void addFilterDefinition(FilterDefinition definition) {
        this.cfg.addFilterDefinition(definition);
    }

    public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject object) {
        this.cfg.addAuxiliaryDatabaseObject(object);
    }
}

