/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import org.jfree.data.XYDataset;
import org.jfree.util.ObjectUtils;

public class AbstractXYItemLabelGenerator
implements Cloneable,
Serializable {
    private String formatString;
    private NumberFormat xFormat;
    private DateFormat xDateFormat;
    private NumberFormat yFormat;
    private DateFormat yDateFormat;

    protected AbstractXYItemLabelGenerator() {
        this("{2}", NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance());
    }

    protected AbstractXYItemLabelGenerator(String formatString, NumberFormat xFormat, NumberFormat yFormat) {
        if (formatString == null) {
            throw new IllegalArgumentException("Null 'formatString' argument.");
        }
        if (xFormat == null) {
            throw new IllegalArgumentException("Null 'xFormat' argument.");
        }
        if (yFormat == null) {
            throw new IllegalArgumentException("Null 'yFormat' argument.");
        }
        this.formatString = formatString;
        this.xFormat = xFormat;
        this.yFormat = yFormat;
    }

    protected AbstractXYItemLabelGenerator(String formatString, DateFormat xFormat, NumberFormat yFormat) {
        this(formatString, NumberFormat.getInstance(), yFormat);
        this.xDateFormat = xFormat;
    }

    protected AbstractXYItemLabelGenerator(String formatString, DateFormat xFormat, DateFormat yFormat) {
        this(formatString, NumberFormat.getInstance(), NumberFormat.getInstance());
        this.xDateFormat = xFormat;
        this.yDateFormat = yFormat;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public NumberFormat getXFormat() {
        return this.xFormat;
    }

    public DateFormat getXDateFormat() {
        return this.xDateFormat;
    }

    public NumberFormat getYFormat() {
        return this.yFormat;
    }

    public DateFormat getYDateFormat() {
        return this.yDateFormat;
    }

    public String generateLabelString(XYDataset dataset, int series, int item) {
        String result = null;
        Object[] items = this.createItemArray(dataset, series, item);
        result = MessageFormat.format(this.formatString, items);
        return result;
    }

    protected Object[] createItemArray(XYDataset dataset, int series, int item) {
        Object[] result = new Object[3];
        result[0] = dataset.getSeriesName(series);
        Number x = dataset.getXValue(series, item);
        result[1] = this.xDateFormat != null ? this.xDateFormat.format(x) : this.xFormat.format(x);
        Number y = dataset.getYValue(series, item);
        result[2] = this.yDateFormat != null ? this.yDateFormat.format(y) : this.yFormat.format(y);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractXYItemLabelGenerator) {
            AbstractXYItemLabelGenerator generator = (AbstractXYItemLabelGenerator)obj;
            if (!this.formatString.equals(generator.formatString)) {
                return false;
            }
            if (!ObjectUtils.equal(this.xFormat, generator.xFormat)) {
                return false;
            }
            if (!ObjectUtils.equal(this.xDateFormat, generator.xDateFormat)) {
                return false;
            }
            if (!ObjectUtils.equal(this.yFormat, generator.yFormat)) {
                return false;
            }
            return ObjectUtils.equal(this.yDateFormat, generator.yDateFormat);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractXYItemLabelGenerator clone = (AbstractXYItemLabelGenerator)super.clone();
        if (this.xFormat != null) {
            clone.xFormat = (NumberFormat)this.xFormat.clone();
        }
        if (this.yFormat != null) {
            clone.yFormat = (NumberFormat)this.yFormat.clone();
        }
        return clone;
    }
}

