/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.EJBModuleMBean;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEApplication;
import org.jboss.management.j2ee.J2EEDeployedObject;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEModule;

public class EJBModule
extends J2EEModule
implements EJBModuleMBean {
    private static final String[] eventTypes = new String[]{"j2ee.object.created", "j2ee.object.deleted"};
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$management$j2ee$EJBModule == null ? (class$org$jboss$management$j2ee$EJBModule = EJBModule.class$("org.jboss.management.j2ee.EJBModule")) : class$org$jboss$management$j2ee$EJBModule));
    private List mEJBs = new ArrayList();
    private ObjectName moduleServiceName;
    private String mJBossDD;
    private String mJAWSDD;
    private String mCMPDD;
    private static final Map fakeJ2EEApps = new HashMap();
    static /* synthetic */ Class class$org$jboss$management$j2ee$EJBModule;

    public static ObjectName create(MBeanServer mbeanServer, String earName, String jarName, URL pURL, ObjectName moduleServiceName) {
        String lDD = null;
        String lJBossDD = null;
        String lJAWSDD = null;
        String lCMPDD = null;
        ObjectName lParent = null;
        ObjectName lCreated = null;
        ObjectName jsr77Name = null;
        ObjectName j2eeServerName = J2EEDomain.getDomainServerName(mbeanServer);
        try {
            Hashtable<String, String> props = j2eeServerName.getKeyPropertyList();
            String j2eeServer = props.get("j2eeType") + "=" + props.get("name");
            if (earName == null) {
                lParent = j2eeServerName;
            } else {
                ObjectName lApplicationQuery = new ObjectName(J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "J2EEApplication" + "," + "name=" + earName + "," + j2eeServer + "," + "*");
                Set<ObjectName> parentApps = mbeanServer.queryNames(lApplicationQuery, null);
                if (parentApps.isEmpty()) {
                    lParent = lCreated = J2EEApplication.create(mbeanServer, earName, null);
                } else if (parentApps.size() == 1) {
                    lParent = parentApps.iterator().next();
                }
            }
            lDD = J2EEDeployedObject.getDeploymentDescriptor(pURL, 2);
            lJBossDD = J2EEDeployedObject.getDeploymentDescriptor(pURL, 5);
            lJAWSDD = J2EEDeployedObject.getDeploymentDescriptor(pURL, 6);
            lCMPDD = J2EEDeployedObject.getDeploymentDescriptor(pURL, 7);
        }
        catch (Exception e) {
            log.debug((Object)("Could not create JSR-77 EJBModule: " + jarName), (Throwable)e);
            return null;
        }
        try {
            String[] jvms = (String[])mbeanServer.getAttribute(j2eeServerName, "javaVMs");
            EJBModule ejbModule = new EJBModule(jarName, lParent, jvms, lDD, moduleServiceName, lJBossDD, lJAWSDD, lCMPDD);
            jsr77Name = ejbModule.getObjectName();
            mbeanServer.registerMBean(ejbModule, jsr77Name);
            if (lCreated != null) {
                fakeJ2EEApps.put(jsr77Name, lCreated);
            }
            log.debug((Object)("Created JSR-77 EJBModule: " + jsr77Name));
        }
        catch (Exception e) {
            log.error((Object)("Could not create JSR-77 EJBModule: " + jarName), (Throwable)e);
        }
        return jsr77Name;
    }

    public static void destroy(MBeanServer mbeanServer, ObjectName jsr77Name) {
        try {
            log.debug((Object)("destroy(), remove EJB-Module: " + jsr77Name));
            mbeanServer.unregisterMBean(jsr77Name);
            ObjectName jsr77ParentName = (ObjectName)fakeJ2EEApps.get(jsr77Name);
            if (jsr77ParentName != null) {
                log.debug((Object)("Remove fake JSR-77 parent Application: " + jsr77ParentName));
                J2EEApplication.destroy(mbeanServer, jsr77ParentName);
            }
        }
        catch (Exception e) {
            log.debug((Object)("Could not destroy JSR-77 EJBModule: " + jsr77Name), (Throwable)e);
        }
    }

    public EJBModule(String jarName, ObjectName jsr77ParentName, String[] pJVMs, String pDeploymentDescriptor, ObjectName moduleServiceName, String pJBossDD, String pJAWSDD, String pCMPDD) throws MalformedObjectNameException, InvalidParentException {
        super("EJBModule", jarName, jsr77ParentName, pJVMs, pDeploymentDescriptor);
        this.moduleServiceName = moduleServiceName;
        this.mJBossDD = pJBossDD == null ? "" : pJBossDD;
        this.mJAWSDD = pJAWSDD == null ? "" : pJAWSDD;
        this.mCMPDD = pCMPDD == null ? "" : pCMPDD;
    }

    public String[] getejbs() {
        return this.mEJBs.toArray(new String[this.mEJBs.size()]);
    }

    public String getejb(int pIndex) {
        if (pIndex >= 0 && pIndex < this.mEJBs.size()) {
            return (String)this.mEJBs.get(pIndex);
        }
        return null;
    }

    public String getjbossDeploymentDescriptor() {
        return this.mJBossDD;
    }

    public String getjawsDeploymentDescriptor() {
        return this.mJAWSDD;
    }

    public String getcmpDeploymentDescriptor() {
        return this.mCMPDD;
    }

    public void addChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("EntityBean".equals(lType) || "StatelessSessionBean".equals(lType) || "StatefulSessionBean".equals(lType) || "MessageDrivenBean".equals(lType)) {
            this.mEJBs.add(pChild.getCanonicalName());
        }
    }

    public void removeChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("EntityBean".equals(lType) || "StatelessSessionBean".equals(lType) || "StatefulSessionBean".equals(lType) || "MessageDrivenBean".equals(lType)) {
            this.mEJBs.remove(pChild.getCanonicalName());
        }
    }

    public void postCreation() {
        this.sendNotification("j2ee.object.created", "EJB Module created");
    }

    public void preDestruction() {
        this.sendNotification("j2ee.object.deleted", "EJB Module destroyed");
    }

    public String[] getEventTypes() {
        return eventTypes;
    }

    public String getEventType(int index) {
        String type = null;
        if (index >= 0 && index < eventTypes.length) {
            type = eventTypes[index];
        }
        return type;
    }

    public String toString() {
        return "EJBModule[ " + super.toString() + ", EJBs: " + this.mEJBs + ", JBoss-DD: " + this.mJBossDD + ", JAWS-DD: " + this.mJAWSDD + ", CMP-2.0-DD: " + this.mCMPDD + " ]";
    }

    protected Hashtable getParentKeys(ObjectName jsr77ParentName) {
        Hashtable<String, String> parentKeys = new Hashtable<String, String>();
        Hashtable<String, String> parentProps = jsr77ParentName.getKeyPropertyList();
        String parentName = parentProps.get("name");
        String j2eeType = parentProps.get("j2eeType");
        if (!j2eeType.equals("J2EEApplication")) {
            parentKeys.put("J2EEServer", parentName);
            parentKeys.put("J2EEApplication", "null");
        } else {
            parentKeys.put("J2EEApplication", parentName);
            String j2eeServerName = parentProps.get("J2EEServer");
            parentKeys.put("J2EEServer", j2eeServerName);
        }
        return parentKeys;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

