/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.jboss.axis.wsdl.gen.Generator;
import org.jboss.axis.wsdl.symbolTable.SchemaUtils;
import org.jboss.axis.wsdl.symbolTable.SymTabEntry;
import org.jboss.axis.wsdl.symbolTable.SymbolTable;
import org.jboss.axis.wsdl.symbolTable.TypeEntry;
import org.jboss.axis.wsdl.toJava.Emitter;
import org.jboss.axis.wsdl.toJava.JavaBeanFaultWriter;
import org.jboss.axis.wsdl.toJava.JavaBeanHelperWriter;
import org.jboss.axis.wsdl.toJava.JavaBeanWriter;
import org.jboss.axis.wsdl.toJava.JavaEnumTypeWriter;
import org.jboss.axis.wsdl.toJava.JavaGeneratorFactory;
import org.jboss.axis.wsdl.toJava.JavaHolderWriter;
import org.jboss.axis.wsdl.toJava.JavaWriter;
import org.jboss.axis.wsdl.toJava.Utils;
import org.w3c.dom.Node;

public class JavaTypeWriter
implements Generator {
    public static final String HOLDER_IS_NEEDED = "Holder is needed";
    private Generator typeWriter = null;
    private Generator holderWriter = null;

    public JavaTypeWriter(Emitter emitter, TypeEntry type, SymbolTable symbolTable) {
        if (type.isReferenced() && !type.isOnlyLiteralReferenced()) {
            Node node = type.getNode();
            if (!type.getName().endsWith("[]")) {
                Vector v = Utils.getEnumerationBaseAndValues(node, symbolTable);
                if (v != null) {
                    this.typeWriter = this.getEnumTypeWriter(emitter, type, v);
                } else {
                    QName baseQName;
                    TypeEntry base = SchemaUtils.getComplexElementExtensionBase(node, symbolTable);
                    if (base == null && (baseQName = SchemaUtils.getSimpleTypeBase(node)) != null) {
                        base = symbolTable.getType(baseQName);
                    }
                    this.typeWriter = this.getBeanWriter(emitter, type, SchemaUtils.getContainedElementDeclarations(node, symbolTable), base, SchemaUtils.getContainedAttributeTypes(node, symbolTable));
                }
            }
            if (this.holderIsNeeded(type)) {
                this.holderWriter = this.getHolderWriter(emitter, type);
            }
        }
    }

    public void generate() throws IOException {
        if (this.typeWriter != null) {
            this.typeWriter.generate();
        }
        if (this.holderWriter != null) {
            this.holderWriter.generate();
        }
    }

    private boolean holderIsNeeded(SymTabEntry entry) {
        Boolean holderIsNeeded = (Boolean)entry.getDynamicVar(HOLDER_IS_NEEDED);
        return holderIsNeeded != null && holderIsNeeded != false;
    }

    protected JavaWriter getEnumTypeWriter(Emitter emitter, TypeEntry type, Vector v) {
        return new JavaEnumTypeWriter(emitter, type, v);
    }

    protected JavaWriter getBeanWriter(Emitter emitter, TypeEntry type, Vector elements, TypeEntry base, Vector attributes) {
        JavaWriter helperWriter = this.getBeanHelperWriter(emitter, type, elements, base, attributes);
        Boolean isComplexFault = (Boolean)type.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT);
        if (isComplexFault != null && isComplexFault.booleanValue()) {
            return new JavaBeanFaultWriter(emitter, type, elements, base, attributes, helperWriter);
        }
        return new JavaBeanWriter(emitter, type, elements, base, attributes, helperWriter);
    }

    protected JavaWriter getBeanHelperWriter(Emitter emitter, TypeEntry type, Vector elements, TypeEntry base, Vector attributes) {
        return new JavaBeanHelperWriter(emitter, type, elements, base, attributes);
    }

    protected Generator getHolderWriter(Emitter emitter, TypeEntry type) {
        return new JavaHolderWriter(emitter, type);
    }
}

