/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.deployment;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.system.ServiceDynamicMBeanSupport;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.varia.deployment.ScriptService;

public class BeanShellScript
extends ServiceDynamicMBeanSupport {
    protected DeploymentInfo deploymentInfo = null;
    protected String name = null;
    protected Interpreter interpreter = null;
    protected ScriptService scriptService = null;
    protected ObjectName preferedObjectName = null;
    protected ObjectName[] dependsServices = null;
    protected HashMap supportedInterfaces = new HashMap();
    protected MBeanInfo mbeanInfo = null;
    protected static HashMap basicTypes = new HashMap();

    public BeanShellScript(DeploymentInfo di) throws DeploymentException {
        try {
            this.deploymentInfo = di;
            String name = this.deploymentInfo.url.toString();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            this.name = name;
            this.loadScript(di.url);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    protected Object getInternalAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            String action = "get" + attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
            InvocationCouple invoc = this.retrieveCompatibleInvocation(action, new Class[0]);
            if (invoc == null) {
                throw new AttributeNotFoundException(attribute + " getter not implemented on target script");
            }
            return invoc.method.invoke(invoc.proxy, null);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ReflectionException(cnfe, "A signature class couldn't be loaded");
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionException(iae, "Problem while invoking gettter for field " + attribute);
        }
        catch (InvocationTargetException ite) {
            throw new MBeanException(ite, "Problem while invoking gettter for field " + attribute);
        }
    }

    protected void setInternalAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String field = attribute.getName();
        try {
            InvocationCouple invoc;
            String action = "set" + field.substring(0, 1).toUpperCase() + field.substring(1);
            Object value = attribute.getValue();
            Class clazz = value.getClass();
            Class tmp = (Class)basicTypes.get(clazz);
            if (tmp != null) {
                clazz = tmp;
            }
            if ((invoc = this.retrieveCompatibleInvocation(action, new Class[]{clazz})) == null) {
                throw new AttributeNotFoundException(field + " setter not implemented on target script");
            }
            invoc.method.invoke(invoc.proxy, value);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ReflectionException(cnfe, "A signature class couldn't be loaded");
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionException(iae, "Problem while invoking setter for field " + field);
        }
        catch (InvocationTargetException ite) {
            throw new MBeanException(ite, "Problem while invoking setter for field " + field);
        }
    }

    protected Object internalInvoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            InvocationCouple invoc = this.retrieveCompatibleInvocation(actionName, signature);
            if (invoc == null) {
                throw new ReflectionException(new Exception(), actionName + " not implemented on target script");
            }
            Object value = invoc.method.invoke(invoc.proxy, params);
            return value;
        }
        catch (ClassNotFoundException cnfe) {
            throw new ReflectionException(cnfe, "A signature class couldn't be loaded");
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionException(iae, "Problem while invoking " + actionName);
        }
        catch (InvocationTargetException ite) {
            throw new MBeanException(ite, "Problem while invoking " + actionName);
        }
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    protected void createService() throws Exception {
        try {
            this.scriptService.setCtx((ServiceMBeanSupport)this);
        }
        catch (UndeclaredThrowableException e) {
            this.log.trace((Object)"UndeclaredThrowableException during setCtx", (Throwable)e);
        }
        catch (Throwable t) {
            this.log.warn((Object)"Error during setCtx", t);
        }
        try {
            this.scriptService.create();
        }
        catch (UndeclaredThrowableException e) {
            this.log.trace((Object)"UndeclaredThrowableException during create", (Throwable)e);
        }
        catch (EvalError e) {
            this.log.debug((Object)"EvalError during create", (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)"Error during create", (Throwable)e);
            throw e;
        }
    }

    protected void startService() throws Exception {
        try {
            this.scriptService.start();
        }
        catch (UndeclaredThrowableException e) {
            this.log.trace((Object)"UndeclaredThrowableException during start", (Throwable)e);
        }
        catch (EvalError e) {
            this.log.debug((Object)"EvalError during start", (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)"Error during start", (Throwable)e);
            throw e;
        }
    }

    protected void stopService() throws Exception {
        try {
            this.scriptService.stop();
        }
        catch (UndeclaredThrowableException e) {
            this.log.trace((Object)"UndeclaredThrowableException during stop", (Throwable)e);
        }
        catch (Exception e) {
            this.log.debug((Object)"Error during stop", (Throwable)e);
            throw e;
        }
    }

    protected void destroyService() throws Exception {
        try {
            this.scriptService.destroy();
        }
        catch (UndeclaredThrowableException e) {
            this.log.trace((Object)"UndeclaredThrowableException during destroy", (Throwable)e);
        }
        catch (Exception e) {
            this.log.debug((Object)"Error during destroy", (Throwable)e);
            throw e;
        }
    }

    protected InvocationCouple retrieveCompatibleInvocation(String name, String[] signature) throws ClassNotFoundException {
        ClassLoader ucl = Thread.currentThread().getContextClassLoader();
        Class[] realSignature = null;
        if (signature != null) {
            realSignature = new Class[signature.length];
            for (int i = 0; i < signature.length; ++i) {
                realSignature[i] = ucl.loadClass(signature[i]);
            }
        }
        return this.retrieveCompatibleInvocation(name, realSignature);
    }

    protected InvocationCouple retrieveCompatibleInvocation(String name, Class[] signature) throws ClassNotFoundException {
        for (Class key : this.supportedInterfaces.keySet()) {
            try {
                Method method = key.getMethod(name, signature);
                Object targetProxy = this.supportedInterfaces.get(key);
                return new InvocationCouple(targetProxy, method);
            }
            catch (NoSuchMethodException ok) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadScript(URL url) throws Exception {
        int i;
        InputStream stream = null;
        try {
            this.interpreter = new Interpreter();
            this.interpreter.setClassLoader(Thread.currentThread().getContextClassLoader());
            stream = url.openStream();
            this.interpreter.eval((Reader)new InputStreamReader(stream));
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception strange) {
                    this.log.info((Object)strange);
                }
            }
        }
        this.scriptService = (ScriptService)this.interpreter.getInterface(ScriptService.class);
        try {
            String[] depends = this.scriptService.dependsOn();
            if (depends != null && depends.length > 0) {
                this.dependsServices = new ObjectName[depends.length];
                for (i = 0; i < depends.length; ++i) {
                    this.dependsServices[i] = new ObjectName(depends[i]);
                }
            }
        }
        catch (UndeclaredThrowableException ignored) {
            // empty catch block
        }
        try {
            String myName = this.scriptService.objectName();
            if (myName != null) {
                this.preferedObjectName = new ObjectName(myName);
            }
        }
        catch (UndeclaredThrowableException ignored) {
            // empty catch block
        }
        try {
            Class[] intfs = this.scriptService.getInterfaces();
            if (intfs != null && intfs.length > 0) {
                for (i = 0; i < intfs.length; ++i) {
                    Object iface = this.interpreter.getInterface(intfs[i]);
                    this.supportedInterfaces.put(intfs[i], iface);
                }
            }
            this.mbeanInfo = this.generateMBeanInfo(intfs);
        }
        catch (UndeclaredThrowableException ignored) {
            this.log.debug((Object)"Failed to obtain interfaces", (Throwable)ignored);
            this.mbeanInfo = this.generateMBeanInfo(null);
        }
    }

    protected MBeanInfo generateMBeanInfo(Class[] intfs) throws IntrospectionException {
        MBeanInfo result = super.getMBeanInfo();
        if (intfs != null && intfs.length > 0) {
            ArrayList<MBeanAttributeInfo> attrs = new ArrayList<MBeanAttributeInfo>(Arrays.asList(result.getAttributes()));
            ArrayList<MBeanOperationInfo> ops = new ArrayList<MBeanOperationInfo>(Arrays.asList(result.getOperations()));
            HashMap<String, Method> readAttr = new HashMap<String, Method>();
            HashMap<String, Method> writeAttr = new HashMap<String, Method>();
            for (int i = 0; i < intfs.length; ++i) {
                Class clazz = intfs[i];
                Method[] methods = clazz.getMethods();
                for (int m = 0; m < methods.length; ++m) {
                    Method meth = methods[m];
                    String name = meth.getName();
                    Class<?>[] params = meth.getParameterTypes();
                    if (name.startsWith("get") && params.length == 0) {
                        readAttr.put(name, meth);
                        continue;
                    }
                    if (name.startsWith("set") && params.length == 1) {
                        writeAttr.put(name, meth);
                        continue;
                    }
                    ops.add(new MBeanOperationInfo("Method " + name + " from class/interface " + clazz.getName(), meth));
                }
            }
            for (String getter : readAttr.keySet()) {
                Method getterMethod = (Method)readAttr.get(getter);
                String attribute = getter.substring(3);
                String setter = "set" + attribute;
                Method setterMethod = (Method)writeAttr.remove(setter);
                attrs.add(new MBeanAttributeInfo(attribute, "", getterMethod, setterMethod));
            }
            for (String setter : writeAttr.keySet()) {
                Method setterMethod = (Method)writeAttr.get(setter);
                String attribute = setter.substring(3);
                attrs.add(new MBeanAttributeInfo(attribute, "", null, setterMethod));
            }
            result = new MBeanInfo(this.name, "Dynamic MBean Service around BSH script " + this.name, attrs.toArray(new MBeanAttributeInfo[attrs.size()]), result.getConstructors(), ops.toArray(new MBeanOperationInfo[ops.size()]), result.getNotifications());
        }
        return result;
    }

    public ObjectName getPreferedObjectName() {
        return this.preferedObjectName;
    }

    public ObjectName[] getDependsServices() {
        return this.dependsServices;
    }

    static {
        basicTypes.put(Boolean.class, Boolean.TYPE);
        basicTypes.put(Byte.class, Byte.TYPE);
        basicTypes.put(Character.class, Character.TYPE);
        basicTypes.put(Integer.class, Integer.TYPE);
        basicTypes.put(Short.class, Short.TYPE);
        basicTypes.put(Float.class, Float.TYPE);
        basicTypes.put(Double.class, Double.TYPE);
        basicTypes.put(Long.class, Long.TYPE);
    }

    public class InvocationCouple {
        public Object proxy = null;
        public Method method = null;

        public InvocationCouple(Object proxy, Method m) {
            this.proxy = proxy;
            this.method = m;
        }
    }
}

