/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import org.jboss.logging.Logger;

public class TmpFilePassword {
    private static Logger log = Logger.getLogger(TmpFilePassword.class);
    private File passwordFile;
    private long timeoutSystemTime;

    public TmpFilePassword(String file) {
        this(file, null);
    }

    public TmpFilePassword(String file, String timeout) {
        this.passwordFile = new File(file);
        if (timeout != null) {
            long ms = Long.parseLong(timeout);
            this.timeoutSystemTime = System.currentTimeMillis() + ms;
        }
    }

    public char[] toCharArray() throws IOException {
        int b;
        while (!this.passwordFile.exists()) {
            log.info((Object)("Waiting for password file: " + this.passwordFile.getAbsolutePath()));
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                log.info((Object)"Exiting wait on InterruptedException");
                break;
            }
            long now = System.currentTimeMillis();
            if (now <= this.timeoutSystemTime) continue;
            throw new InterruptedIOException("Timed out waiting for: " + this.passwordFile.getAbsolutePath());
        }
        FileInputStream fis = new FileInputStream(this.passwordFile);
        CharArrayWriter writer = new CharArrayWriter();
        while ((b = fis.read()) >= 0) {
            if (b == 13 || b == 10) continue;
            writer.write(b);
        }
        fis.close();
        char[] password = writer.toCharArray();
        writer.reset();
        for (int n = 0; n < password.length; ++n) {
            writer.write(0);
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(this.passwordFile, "rws");
            for (int i = 0; i < 10; ++i) {
                raf.seek(0L);
                for (int j = 0; j < password.length; ++j) {
                    raf.write(j);
                }
            }
            raf.close();
            if (!this.passwordFile.delete()) {
                log.warn((Object)"Was not able to delete the password file");
            }
        }
        catch (Exception e) {
            log.warn((Object)"Failed to zero the password file", (Throwable)e);
        }
        return password;
    }
}

