/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.poller;

import com.clustercontrol.poller.CollectorAlreadyExistException;
import com.clustercontrol.poller.NotInitializedException;
import com.clustercontrol.poller.PollingControllerConfig;
import com.clustercontrol.poller.PollingInterval;
import com.clustercontrol.poller.cfg.PollerConfig;
import com.clustercontrol.poller.cfg.SnmpPollerConfig;
import com.clustercontrol.poller.cfg.VmPollerConfig;
import com.clustercontrol.poller.cfg.WbemPollerConfig;
import com.clustercontrol.poller.impl.SnmpPollerImpl;
import com.clustercontrol.poller.impl.WbemPollerImpl;
import com.clustercontrol.poller.job.PollingJob;
import com.clustercontrol.sharedtable.DataTable;
import com.clustercontrol.sharedtable.DataTableNotFoundException;
import com.clustercontrol.sharedtable.SharedTable;
import com.clustercontrol.vm.VmPollerImplInterface;
import com.clustercontrol.vm.bean.VmMethodTypeConstant;
import com.clustercontrol.vm.ejb.entity.VmMethodMstLocal;
import com.clustercontrol.vm.ejb.entity.VmMethodMstPK;
import com.clustercontrol.vm.ejb.entity.VmMethodMstUtil;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollingController {
    private static Log m_log = LogFactory.getLog(PollingController.class);
    private Object modifyLock = new Object();
    private static final String SHARED_TABLE_JNDI_NAME = "SharedTable";
    private static final String POLLER_MANAGER_JNDI_NAME = "PollerManager";
    private static final int RUNNING = 1;
    private static final int STOPPED = 2;
    private String m_quartzJndiName = "QuartzRAM";
    private String m_quartzJobName;
    private String m_quartzGroupName;
    private String m_pollerGroup;
    private String m_pollerName;
    private PollingControllerConfig m_pollingConfig;
    private String m_tableGroup;
    private String m_tableName;
    private volatile int m_status;

    public PollingController(String pollerGroup, String pollerName, PollerConfig pollerConfig, boolean indexCheckFlg, String tableGroup, String tableName) throws NotInitializedException, DataTableNotFoundException {
        PollingControllerConfig pollingConfig;
        this.m_pollerGroup = pollerGroup;
        this.m_pollerName = pollerName;
        this.m_pollingConfig = pollingConfig = new PollingControllerConfig(pollerConfig, indexCheckFlg);
        this.m_tableGroup = tableGroup;
        this.m_tableName = tableName;
        this.m_quartzJobName = this.m_pollerName;
        this.m_quartzGroupName = this.m_pollerGroup;
        this.m_status = 2;
        try {
            SharedTable sharedTable = this.lookupSharedTable();
            if (!sharedTable.containsDataTable(tableGroup, tableName)) {
                throw new DataTableNotFoundException(tableGroup, tableName);
            }
        }
        catch (NamingException e) {
            m_log.error((Object)("get SharedTable:" + e.getMessage()));
            throw new NotInitializedException("Table is not initialized. (" + tableName + " in " + tableGroup + " )");
        }
    }

    protected void scheduleJob() {
        int interval = this.m_pollingConfig.getMinPollingInterval();
        m_log.debug((Object)("scheduleJob : " + interval));
        Scheduler scheduler = null;
        try {
            InitialContext ctx = new InitialContext();
            Object obj = ctx.lookup(this.m_quartzJndiName);
            scheduler = (Scheduler)PortableRemoteObject.narrow((Object)obj, StdScheduler.class);
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (scheduler == null) {
            return;
        }
        if (interval == -1) {
            try {
                scheduler.deleteJob(this.m_quartzJobName, this.m_quartzGroupName);
                this.m_status = 2;
            }
            catch (SchedulerException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
            }
            return;
        }
        JobDetail job = new JobDetail(this.m_quartzJobName, this.m_quartzGroupName, PollingJob.class);
        job.setDurability(true);
        job.getJobDataMap().put("jndiName", POLLER_MANAGER_JNDI_NAME);
        job.getJobDataMap().put("pollerGroup", this.m_pollerGroup);
        job.getJobDataMap().put("pollerName", this.m_pollerName);
        CronTrigger cronTrigger = new CronTrigger(this.m_quartzJobName, this.m_quartzGroupName);
        cronTrigger.setMisfireInstruction(2);
        try {
            String cronString = PollingInterval.parseCronExpression(interval);
            cronTrigger.setCronExpression(cronString);
        }
        catch (ParseException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            scheduler.deleteJob(this.m_quartzJobName, this.m_quartzGroupName);
            scheduler.scheduleJob(job, (Trigger)cronTrigger);
            scheduler.triggerJob(this.m_quartzJobName, this.m_quartzGroupName);
            this.m_status = 1;
        }
        catch (SchedulerException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void polling() {
        try {
            InitialContext ctx = new InitialContext();
            Object obj = ctx.lookup(this.m_quartzJndiName);
            Scheduler scheduler = (Scheduler)PortableRemoteObject.narrow((Object)obj, StdScheduler.class);
            scheduler.triggerJob(this.m_quartzJobName, this.m_quartzGroupName);
            this.m_status = 1;
        }
        catch (SchedulerException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPolling(String collectorName, int interval, HashMap<String, List<String>> maps) throws CollectorAlreadyExistException {
        Object object = this.modifyLock;
        synchronized (object) {
            if (this.m_pollingConfig.containsCollectorName(collectorName)) {
                throw new CollectorAlreadyExistException(collectorName);
            }
            try {
                SharedTable stable = this.lookupSharedTable();
                if (!stable.containsCollectorName(this.m_tableGroup, this.m_tableName, collectorName)) {
                    stable.registerCollector(this.m_tableGroup, this.m_tableName, collectorName, interval);
                }
            }
            catch (DataTableNotFoundException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
            catch (NamingException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
            this.m_pollingConfig.addPollingTargets(collectorName, interval, maps);
            this.scheduleJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPolling(String collectorName) {
        Object object = this.modifyLock;
        synchronized (object) {
            m_log.debug((Object)("stop polling : " + this.m_pollerGroup + ", " + this.m_pollerName + ", " + collectorName));
            boolean modifyFlg = this.m_pollingConfig.removePollingTargets(collectorName);
            if (modifyFlg) {
                this.scheduleJob();
            }
            try {
                SharedTable stable = this.lookupSharedTable();
                stable.unregisterCollector(this.m_tableGroup, this.m_tableName, collectorName);
            }
            catch (DataTableNotFoundException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
            catch (NamingException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPollingAll() {
        Object object = this.modifyLock;
        synchronized (object) {
            m_log.debug((Object)("stop polling : " + this.m_pollerGroup + ", " + this.m_pollerName));
            boolean modifyFlg = this.m_pollingConfig.removePollingAllTargets();
            if (modifyFlg) {
                this.scheduleJob();
            }
            try {
                SharedTable sharedtable = this.lookupSharedTable();
                if (sharedtable != null) {
                    sharedtable.removeDataTable(this.m_tableGroup, this.m_tableName);
                }
            }
            catch (NamingException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object poller;
        Set<Integer> holderIntervals;
        m_log.debug((Object)("run start : " + this.m_pollerGroup + "  " + this.m_pollerName));
        SharedTable sharedTable = null;
        try {
            sharedTable = this.lookupSharedTable();
            if (sharedTable == null) {
                return;
            }
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            HashSet<String> retainCollectorNames = new HashSet<String>(sharedTable.getCollectorNames(this.m_tableGroup, this.m_tableName));
            Set<String> pollerCollectorNames = this.m_pollingConfig.getCollectorNames();
            retainCollectorNames.retainAll(pollerCollectorNames);
            HashSet<String> removeCollectoName = new HashSet<String>(this.m_pollingConfig.getCollectorNames());
            removeCollectoName.removeAll(retainCollectorNames);
            Object object = this.modifyLock;
            synchronized (object) {
                Iterator itr = removeCollectoName.iterator();
                boolean modifyFlg = false;
                while (itr.hasNext()) {
                    String collectorName = (String)itr.next();
                    modifyFlg = this.m_pollingConfig.removePollingTargets(collectorName);
                }
                if (modifyFlg) {
                    this.scheduleJob();
                }
            }
        }
        catch (DataTableNotFoundException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        try {
            holderIntervals = sharedTable.getIntervals(this.m_tableGroup, this.m_tableName);
        }
        catch (DataTableNotFoundException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        if (holderIntervals.size() <= 0) {
            return;
        }
        long now = System.currentTimeMillis();
        List<Integer> intervals = this.m_pollingConfig.getCurrentRefreshIntervals(now);
        ArrayList<Integer> tmpList = new ArrayList<Integer>(intervals);
        for (int interval : tmpList) {
            if (holderIntervals.contains(interval)) continue;
            m_log.debug((Object)("Remove : " + interval));
            intervals.remove(new Integer(interval));
        }
        if (intervals.size() <= 0) {
            return;
        }
        HashMap<String, List<String>> pollingTargetMap = this.m_pollingConfig.getCurrentTargetMap(now);
        m_log.debug((Object)("run() pollingTargetMap : " + pollingTargetMap));
        if (pollingTargetMap.size() <= 0) {
            m_log.debug((Object)"polling targets are nothing.");
            return;
        }
        PollerConfig pollerConfig = this.m_pollingConfig.getPollerConfig();
        DataTable dataTable = new DataTable();
        if (pollingTargetMap.get("SNMP") != null) {
            SnmpPollerConfig snmpConfig = pollerConfig.getSnmpConfig();
            poller = new SnmpPollerImpl();
            ((SnmpPollerImpl)poller).polling(pollerConfig.getAddress(), snmpConfig.getPort(), snmpConfig.getVersion(), snmpConfig.getComunity(), snmpConfig.getRetries(), snmpConfig.getTimeout(), pollingTargetMap.get("SNMP"), this.m_pollingConfig.isIndexCheckFlg(), dataTable);
        }
        if (pollingTargetMap.get("WBEM") != null) {
            WbemPollerConfig wbemConfig = pollerConfig.getWbemConfig();
            poller = new WbemPollerImpl();
            ((WbemPollerImpl)poller).polling(pollerConfig.getAddress(), wbemConfig.getPort(), wbemConfig.getProtocol(), wbemConfig.getUserName(), wbemConfig.getPassword(), wbemConfig.getNameSpace(), wbemConfig.getRetries(), wbemConfig.getTimeout(), pollingTargetMap.get("WBEM"), dataTable);
        }
        for (String pollerProtocol : pollingTargetMap.keySet()) {
            m_log.debug((Object)("pollerProtocol : " + pollerProtocol));
            if (pollerProtocol.equals("SNMP") || pollerProtocol.equals("WBEM")) continue;
            VmPollerConfig vmConfig = pollerConfig.getVmConfig();
            VmMethodMstLocal local = null;
            try {
                local = VmMethodMstUtil.getLocalHome().findByPrimaryKey(new VmMethodMstPK(pollerProtocol, VmMethodTypeConstant.POLLERIMPL));
            }
            catch (FinderException e) {
                e.printStackTrace();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            if (local == null) {
                m_log.warn((Object)(pollerProtocol + "\u306e\u5b9f\u884c\u30af\u30e9\u30b9\u304c\u5185\u90e8DB\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002(" + VmMethodTypeConstant.POLLERIMPL + ")"));
                continue;
            }
            String className = local.getClassName();
            m_log.debug((Object)("action() : className = " + className));
            if (className == null) {
                m_log.warn((Object)(pollerProtocol + "\u306e\u5b9f\u884c\u30af\u30e9\u30b9\u304c\u5185\u90e8DB\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u3002"));
                continue;
            }
            Constructor<?> pollerConstructor = null;
            try {
                pollerConstructor = Class.forName(className).getConstructor(new Class[0]);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                m_log.warn((Object)(className + " is not poller class"));
                continue;
            }
            if (pollerConstructor == null) {
                m_log.warn((Object)"action() : pollerConstructor is null");
                continue;
            }
            VmPollerImplInterface poller2 = null;
            try {
                poller2 = (VmPollerImplInterface)pollerConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (poller2 == null) {
                m_log.warn((Object)"action() : poller is null");
                continue;
            }
            poller2.init(pollerProtocol);
            poller2.polling(pollerConfig.getAddress(), vmConfig.getVmNodeType(), vmConfig.getVmManagementNodeIp(), vmConfig.getVmName(), vmConfig.getVmUser(), vmConfig.getVmUserPassword(), vmConfig.getVmProtocol(), pollingTargetMap.get(pollerProtocol), (Object)dataTable);
        }
        m_log.debug((Object)("dataTable" + dataTable));
        for (int interval : intervals) {
            m_log.debug((Object)("insert " + this.m_tableGroup + ", " + this.m_tableName + ", " + interval));
            try {
                sharedTable.insertDataTable(this.m_tableGroup, this.m_tableName, interval, dataTable, pollerConfig.getAddress().toString());
            }
            catch (DataTableNotFoundException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        m_log.debug((Object)("run end   : " + this.m_pollerGroup + "  " + this.m_pollerName));
    }

    public DataTable polling(int timeout, int retries, HashMap<String, List<String>> targetMaps) {
        Set<String> setKeys = targetMaps.keySet();
        Iterator<String> itrKeys = setKeys.iterator();
        DataTable dataTable = new DataTable();
        while (itrKeys.hasNext()) {
            Object poller;
            List<String> pollingTargets;
            String collectMethod = itrKeys.next();
            PollerConfig pollerConfig = this.m_pollingConfig.getPollerConfig();
            if (collectMethod.equals("SNMP")) {
                SnmpPollerConfig snmpConfig = pollerConfig.getSnmpConfig();
                pollingTargets = targetMaps.get("SNMP");
                poller = new SnmpPollerImpl();
                ((SnmpPollerImpl)poller).polling(pollerConfig.getAddress(), snmpConfig.getPort(), snmpConfig.getVersion(), snmpConfig.getComunity(), retries, timeout, pollingTargets, this.m_pollingConfig.isIndexCheckFlg(), dataTable);
                continue;
            }
            if (!collectMethod.equals("WBEM")) continue;
            WbemPollerConfig wbemConfig = pollerConfig.getWbemConfig();
            pollingTargets = targetMaps.get("WBEM");
            poller = new WbemPollerImpl();
            ((WbemPollerImpl)poller).polling(pollerConfig.getAddress(), wbemConfig.getPort(), wbemConfig.getProtocol(), wbemConfig.getUserName(), wbemConfig.getPassword(), wbemConfig.getNameSpace(), retries, timeout, pollingTargets, dataTable);
        }
        return dataTable;
    }

    protected SharedTable lookupSharedTable() throws NamingException {
        try {
            InitialContext ctx = new InitialContext();
            Object obj = ctx.lookup(SHARED_TABLE_JNDI_NAME);
            SharedTable table = (SharedTable)PortableRemoteObject.narrow((Object)obj, SharedTable.class);
            return table;
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public String getPollerGroup() {
        return this.m_pollerGroup;
    }

    public String getPollerName() {
        return this.m_pollerName;
    }

    public PollingControllerConfig getPollingConfig() {
        return this.m_pollingConfig;
    }

    public String getQuartzJndiName() {
        return this.m_quartzJndiName;
    }

    public void setQuartzJndiName(String jndiName) {
        this.m_quartzJndiName = jndiName;
    }

    public int getStatus() {
        return this.m_status;
    }
}

