/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.vm.factory;

import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.bean.VmNodeInfo;
import com.clustercontrol.repository.ejb.entity.FacilityData;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.vm.VmException;
import com.clustercontrol.vm.factory.VmNodeController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchVmNode {
    protected static Log m_log = LogFactory.getLog(SearchVmNode.class);

    public ArrayList<VmNodeInfo> searchNode(Property host, Locale locale) throws NamingException, FinderException, CreateException, VmException {
        FacilityData facilityData;
        boolean exists;
        String facilityId;
        m_log.debug((Object)"searchNode() : start");
        ArrayList<VmNodeInfo> ret = new ArrayList<VmNodeInfo>();
        m_log.debug((Object)"searchNode() : init");
        Iterator strItr = null;
        Iterator<Object> fdItr = null;
        ArrayList<String> attribute = new ArrayList<String>();
        ArrayList propertyList = null;
        HashMap<String, String> condition = new HashMap<String, String>();
        VmNodeInfo info = null;
        String targetFalicityId = null;
        String vmManagementIp = null;
        String user = null;
        String password = null;
        String protocol = null;
        String virtSolution = null;
        ArrayList hostNodeList = null;
        ArrayList settingNodeList = null;
        ArrayList<String> settingUnknownNodeList = null;
        ArrayList<FacilityData> currentList = null;
        ArrayList<FacilityData> unregistNodeList = null;
        VmNodeController vmNodeController = new VmNodeController();
        RepositoryControllerLocal repository = null;
        try {
            repository = RepositoryControllerUtil.getLocalHome().create();
        }
        catch (CreateException e) {
            m_log.error((Object)"searchNode() : ", (Throwable)e);
            throw e;
        }
        catch (NamingException e) {
            m_log.error((Object)"searchNode() : ", (Throwable)e);
            throw e;
        }
        m_log.debug((Object)"searchNode() : init info");
        propertyList = PropertyUtil.getProperty((Property)host, (String)"facilityId");
        targetFalicityId = ((Property)propertyList.get(0)).getValue().toString();
        m_log.debug((Object)("searchNode() : targetFalicityId = " + targetFalicityId));
        FacilityData hostData = repository.getNodeFacilityData(targetFalicityId);
        virtSolution = hostData.getVirtSolution();
        user = hostData.getVmUser();
        password = hostData.getVmUserpassword();
        protocol = hostData.getVmProtocol();
        vmManagementIp = hostData.getIpProtocolNumber() == null ? hostData.getIpNetworkNumber() : (hostData.getIpProtocolNumber() == 4 ? hostData.getIpNetworkNumber() : hostData.getIpNetworkNumberV6());
        m_log.debug((Object)("searchNode() : virtSolution = " + virtSolution));
        m_log.debug((Object)("searchNode() : user = " + user));
        m_log.debug((Object)("searchNode() : password = " + password));
        m_log.debug((Object)("searchNode() : protocol = " + protocol));
        m_log.debug((Object)("searchNode() : vmManagementIp = " + vmManagementIp));
        try {
            condition.clear();
            condition.put("ccVirtualizationNodeType", "guest");
            condition.put("ccVMManagementNode", targetFalicityId);
            settingNodeList = repository.findByCondition(condition);
            for (String string : settingNodeList) {
                m_log.debug((Object)("searchNode() : settingNodeList -> " + string));
            }
            condition.clear();
            condition.put("ccVirtualizationNodeType", "host");
            condition.put("ccValid", "TRUE");
            hostNodeList = repository.findByCondition(condition);
            for (String string : hostNodeList) {
                m_log.debug((Object)("searchNode() : hostNodeList -> " + string));
            }
        }
        catch (NamingException e) {
            m_log.error((Object)"searchNode() : NamingException ", (Throwable)e);
            throw e;
        }
        catch (FinderException e) {
            m_log.error((Object)"searchNode() : FinderException ", (Throwable)e);
            throw e;
        }
        currentList = vmNodeController.getCurrentAllocationList(targetFalicityId, vmManagementIp, user, password, protocol, virtSolution, locale);
        m_log.debug((Object)"searchNode() : stage 1 ");
        attribute.clear();
        attribute.add("ccVMName");
        attribute.add("ccVMId");
        settingUnknownNodeList = new ArrayList<String>();
        strItr = settingNodeList.iterator();
        while (strItr.hasNext()) {
            try {
                facilityId = (String)strItr.next();
                m_log.debug((Object)("searchNode() : start facilityId = " + facilityId));
                HashMap map = repository.getNodeDetail(facilityId, attribute);
                exists = false;
                for (FacilityData facilityData2 : currentList) {
                    if (map.get("ccVMName") == null || !map.get("ccVMName").equals(facilityData2.getVmName()) || map.get("ccVMId") == null || !map.get("ccVMId").equals(facilityData2.getVmId())) continue;
                    m_log.debug((Object)("searchNode() : facilityId = " + facilityId + " is in currentList. " + "vmName = " + facilityData2.getVmName() + ", vmId = " + facilityData2.getVmId()));
                    info = new VmNodeInfo();
                    info.setNewManageNode(targetFalicityId);
                    info.setRegistration(1);
                    info.setSelection(true);
                    info.setProperty(repository.getNodeProperty(facilityId, 2, locale));
                    ret.add(info);
                    exists = true;
                    break;
                }
                if (exists) continue;
                m_log.debug((Object)("searchNode() : facilityId = " + facilityId + " is not in currentList."));
                settingUnknownNodeList.add(facilityId);
            }
            catch (FinderException e) {
                m_log.error((Object)"searchNode() : ", (Throwable)e);
                throw e;
            }
            catch (NamingException e) {
                m_log.error((Object)"searchNode() : ", (Throwable)e);
                throw e;
            }
        }
        m_log.debug((Object)"searchNode() : stage 2 ");
        strItr = settingUnknownNodeList.iterator();
        while (strItr.hasNext()) {
            try {
                facilityId = (String)strItr.next();
                m_log.debug((Object)("searchNode() : start facilityId = " + facilityId));
                String newManageNode = null;
                exists = false;
                for (String hostId : hostNodeList) {
                    m_log.debug((Object)("searchNode() : facilityId = " + facilityId + " search in " + hostId));
                    if (vmNodeController.isAllocated(facilityId, hostId, locale)) {
                        m_log.debug((Object)("searchNode() : facilityId = " + facilityId + " is in  currentFacilityId = " + hostId));
                        newManageNode = hostId;
                        exists = true;
                        continue;
                    }
                    m_log.debug((Object)("searchNode() : facilityId = " + facilityId + " is not in  currentFacilityId = " + hostId));
                }
                if (!exists) {
                    newManageNode = "UNALLOCATED";
                }
                info = new VmNodeInfo();
                info.setNewManageNode(newManageNode);
                info.setRegistration(1);
                info.setSelection(true);
                info.setProperty(repository.getNodeProperty(facilityId, 2, locale));
                ret.add(info);
            }
            catch (FinderException e) {
                m_log.error((Object)"searchNode() : ", (Throwable)e);
                throw e;
            }
            catch (NamingException e) {
                m_log.error((Object)"searchNode() : ", (Throwable)e);
                throw e;
            }
            catch (CreateException e) {
                m_log.error((Object)"searchNode() : ", (Throwable)e);
                throw e;
            }
            catch (VmException e) {
                throw e;
            }
        }
        m_log.debug((Object)"searchNode() : stage 3 ");
        attribute.clear();
        attribute.add("ccVMName");
        attribute.add("ccVMId");
        unregistNodeList = new ArrayList<FacilityData>();
        fdItr = currentList.iterator();
        while (fdItr.hasNext()) {
            try {
                facilityData = fdItr.next();
                m_log.debug((Object)("searchNode() : start vmName = " + facilityData.getVmName() + "vmId = " + facilityData.getVmId()));
                boolean exists2 = false;
                for (String facilityId2 : settingNodeList) {
                    HashMap map = repository.getNodeDetail(facilityId2, attribute);
                    if (map.get("ccVMName") == null || !map.get("ccVMName").equals(facilityData.getVmName()) || map.get("ccVMId") == null || !map.get("ccVMId").equals(facilityData.getVmId())) continue;
                    m_log.debug((Object)("searchNode() : vmName = " + facilityData.getVmName() + " is in settingNodeList. " + "facilityId = " + facilityId2));
                    exists2 = true;
                    break;
                }
                if (exists2) continue;
                m_log.debug((Object)("searchNode() : vmName = " + facilityData.getVmName() + " is not in settingNodeList. "));
                condition.clear();
                condition.put("ccVirtualizationNodeType", "guest");
                condition.put("ccVMId", facilityData.getVmId());
                condition.put("ccVMName", facilityData.getVmName());
                ArrayList searchNodeList = repository.findByCondition(condition);
                if (searchNodeList != null && searchNodeList.size() > 0) {
                    String facilityId3 = (String)searchNodeList.get(0);
                    m_log.debug((Object)("searchNode() : vmName = " + facilityData.getVmName() + " is in repository. facilityId = " + facilityId3));
                    Property guest = repository.getNodeProperty(facilityId3, 2, locale);
                    info = new VmNodeInfo();
                    info.setNewManageNode(targetFalicityId);
                    info.setRegistration(1);
                    info.setSelection(true);
                    info.setProperty(guest);
                    ret.add(info);
                    continue;
                }
                m_log.debug((Object)("searchNode() : vmName = " + facilityData.getVmName() + " is not in repository"));
                unregistNodeList.add(facilityData);
            }
            catch (FinderException e) {
                m_log.error((Object)"searchNode() : ", (Throwable)e);
                throw e;
            }
            catch (NamingException e) {
                m_log.error((Object)"searchNode() : ", (Throwable)e);
                throw e;
            }
        }
        m_log.debug((Object)"searchNode() : stage 4 ");
        fdItr = unregistNodeList.iterator();
        while (fdItr.hasNext()) {
            try {
                facilityData = (FacilityData)fdItr.next();
                m_log.debug((Object)("searchNode() : start vmName = " + facilityData.getVmName() + "vmId = " + facilityData.getVmId()));
                info = new VmNodeInfo();
                info.setNewManageNode(targetFalicityId);
                info.setRegistration(0);
                info.setSelection(false);
                info.setProperty(repository.getNodeProperty(facilityData, locale));
                ret.add(info);
            }
            catch (NamingException e) {
                m_log.error((Object)"searchNode() : ", (Throwable)e);
                throw e;
            }
            catch (CreateException e) {
                m_log.error((Object)"searchNode() : ", (Throwable)e);
                throw e;
            }
            catch (FinderException e) {
                m_log.error((Object)"searchNode() : ", (Throwable)e);
                throw e;
            }
        }
        return ret;
    }
}

