/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.vm.factory;

import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.vm.VmException;
import com.clustercontrol.vm.factory.VmNodeController;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateVmNodeAllocation {
    protected static Log m_log = LogFactory.getLog(UpdateVmNodeAllocation.class);
    public static final int VM_SORT_ORDER = 9000;
    public static final int UNALLOCATED_SORT_ORDER = 9000;
    public static final int HOST_NODE_SCOPE_SORT_ORDER = 200;
    RepositoryControllerLocal repository = null;

    public void update(Locale locale) throws VmException, FinderException, CreateException, NamingException {
        this.updateVmNodeAllocation(locale);
    }

    public String getHostNodeScopeFacilityId(String hostId) {
        return hostId + "scope";
    }

    private void setRepositoryController() throws VmException {
        if (this.repository == null) {
            try {
                this.repository = RepositoryControllerUtil.getLocalHome().create();
            }
            catch (Exception e) {
                m_log.error((Object)"setRepositoryController() : ", (Throwable)e);
                VmException ve = new VmException("\u30ea\u30dd\u30b8\u30c8\u30ea\u3078\u306e\u30a2\u30af\u30bb\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                ve.setStackTrace(e.getStackTrace());
                throw ve;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVmNodeAllocation(Locale locale) throws FinderException, NamingException, CreateException, VmException {
        m_log.debug((Object)"updateManagementNode() : start");
        HashMap<String, ArrayList<String>> newMap = new HashMap<String, ArrayList<String>>();
        HashMap<String, ArrayList<String>> releaseMap = new HashMap<String, ArrayList<String>>();
        m_log.debug((Object)"updateManagementNode() : init");
        ArrayList hostNodeList = null;
        ArrayList guestNodeList = null;
        ArrayList unknownNodeList = null;
        HashMap<String, String> condition = new HashMap<String, String>();
        HashMap<String, String> attribute = new HashMap<String, String>();
        this.setRepositoryController();
        VmNodeController vmNodeController = new VmNodeController();
        condition.clear();
        condition.put("ccVirtualizationNodeType", "host");
        condition.put("ccValid", "TRUE");
        try {
            hostNodeList = this.repository.findByCondition(condition);
            for (String string : hostNodeList) {
                m_log.debug((Object)("updateManagementNode() : hostNodeList -> " + string));
            }
        }
        catch (FinderException e) {
            m_log.error((Object)"searchNode() : ", (Throwable)e);
            throw e;
        }
        catch (NamingException e) {
            m_log.error((Object)"searchNode() : ", (Throwable)e);
            throw e;
        }
        condition.clear();
        condition.put("ccVirtualizationNodeType", "guest");
        try {
            unknownNodeList = this.repository.findByCondition(condition);
            for (String string : unknownNodeList) {
                m_log.debug((Object)("updateManagementNode() : unknownNodeList -> " + string));
            }
        }
        catch (FinderException e) {
            m_log.error((Object)"searchNode() : ", (Throwable)e);
            throw e;
        }
        catch (NamingException e) {
            m_log.error((Object)"searchNode() : ", (Throwable)e);
            throw e;
        }
        newMap.put("UNALLOCATED", new ArrayList());
        releaseMap.put("UNALLOCATED", new ArrayList());
        m_log.debug((Object)"updateManagementNode() : search host");
        for (String hostId : hostNodeList) {
            m_log.debug((Object)("updateManagementNode() : search host hostId = " + hostId));
            newMap.put(hostId, new ArrayList());
            releaseMap.put(hostId, new ArrayList());
            try {
                m_log.debug((Object)("updateManagementNode() : get guest list at vmManagementNode = " + hostId));
                condition.clear();
                condition.put("ccVirtualizationNodeType", "guest");
                condition.put("ccVMManagementNode", hostId);
                guestNodeList = this.repository.findByCondition(condition);
            }
            catch (FinderException e) {
                m_log.error((Object)"updateManagementNode() : ", (Throwable)e);
                throw e;
            }
            catch (NamingException e) {
                m_log.error((Object)"updateManagementNode() : ", (Throwable)e);
                throw e;
            }
            try {
                for (String guestId : guestNodeList) {
                    if (vmNodeController.isAllocated(guestId, hostId, Locale.getDefault())) {
                        m_log.debug((Object)("updateManagementNode() : guestId = " + guestId + " is in hostId = " + hostId));
                        newMap.get(hostId).add(guestId);
                        if (unknownNodeList.remove(guestId)) continue;
                        m_log.warn((Object)("updateManagementNode() : guestId = " + guestId + " is not exists?"));
                        continue;
                    }
                    m_log.debug((Object)("updateManagementNode() : guestId = " + guestId + " is not in hostId = " + hostId));
                    releaseMap.get(hostId).add(guestId);
                }
            }
            catch (VmException e) {
                throw e;
            }
            catch (FinderException e) {
                m_log.error((Object)"updateManagementNode() : ", (Throwable)e);
                throw e;
            }
            catch (CreateException e) {
                m_log.error((Object)"updateManagementNode() : ", (Throwable)e);
                throw e;
            }
            catch (NamingException e) {
                m_log.error((Object)"updateManagementNode() : ", (Throwable)e);
                throw e;
            }
        }
        m_log.debug((Object)"updateManagementNode() : search unknown guest");
        Iterator unknownItr = unknownNodeList.iterator();
        while (unknownItr.hasNext()) {
            try {
                String unknownId = (String)unknownItr.next();
                m_log.debug((Object)("updateManagementNode() : search unknown guest guestId = " + unknownId));
                boolean exists = false;
                for (String hostId : hostNodeList) {
                    m_log.debug((Object)("updateManagementNode() : search unknown guest guestId = " + unknownId + " : search hostId " + hostId));
                    if (vmNodeController.isAllocated(unknownId, hostId, Locale.getDefault())) {
                        m_log.debug((Object)("updateManagementNode() : search unknown guest guestId = " + unknownId + " : search hostId " + hostId + " exists!"));
                        attribute.clear();
                        attribute.put("ccVMManagementNode", hostId);
                        this.repository.setNodeDetail(unknownId, attribute);
                        newMap.get(hostId).add(unknownId);
                        releaseMap.get("UNALLOCATED").add(unknownId);
                        exists = true;
                        break;
                    }
                    m_log.debug((Object)("updateManagementNode() : search unknown guest guestId = " + unknownId + " : search hostId " + hostId + " not exists!"));
                }
                if (exists) continue;
                m_log.debug((Object)("updateManagementNode() : search unknown guest guestId = " + unknownId + " : UNALLOCATION"));
                attribute.clear();
                attribute.put("ccVMManagementNode", "UNALLOCATED");
                this.repository.setNodeDetail(unknownId, attribute);
                newMap.get("UNALLOCATED").add(unknownId);
            }
            catch (FinderException e) {
                m_log.error((Object)"updateManagementNode() : ", (Throwable)e);
                throw e;
            }
            catch (NamingException e) {
                m_log.error((Object)"updateManagementNode() : ", (Throwable)e);
                throw e;
            }
            catch (CreateException e) {
                m_log.error((Object)"updateManagementNode() : ", (Throwable)e);
                throw e;
            }
            catch (VmException e) {
                throw e;
            }
        }
        try {
            this.updateScope(newMap, releaseMap, locale);
            Object var16_30 = null;
        }
        catch (Throwable throwable) {
            Object var16_31 = null;
            this.repository.sendRepositoryUpdateTopic();
            throw throwable;
        }
        this.repository.sendRepositoryUpdateTopic();
    }

    public void updateScope(HashMap<String, ArrayList<String>> newMap, HashMap<String, ArrayList<String>> releaseMap, Locale locale) throws VmException {
        m_log.debug((Object)"updateVmNodeAllocation() : init");
        ArrayList<String> guestNodeList = null;
        ArrayList<String> list = new ArrayList<String>();
        this.setRepositoryController();
        m_log.debug((Object)"updateVmNodeAllocation() : init enviroment");
        m_log.debug((Object)"updateVmNodeAllocation() : init VM scope");
        this.makeVmRelatedScope("", "VM", Messages.getString((String)"vm.scope.vm"), "Auto Create", 9000, locale);
        m_log.debug((Object)"updateVmNodeAllocation() : init UNALLOCATED scope");
        this.makeVmRelatedScope("VM", "UNALLOCATED", Messages.getString((String)"vm.scope.unallocated"), "Auto Create", 9000, locale);
        m_log.debug((Object)"updateVmNodeAllocation() : main");
        Iterator<String> hostItr = newMap.keySet().iterator();
        while (hostItr.hasNext()) {
            try {
                String hostId = hostItr.next();
                m_log.debug((Object)("updateVmNodeAllocation() : host node scope check : hostId = " + hostId));
                list.clear();
                list.add("cn");
                HashMap map = this.repository.getNodeDetail(hostId, list);
                String facilityName = null;
                facilityName = map != null && map.size() > 0 ? (String)map.get("cn") : hostId;
                m_log.debug((Object)("updateVmNodeAllocation() : add host node scope facilityName = " + facilityName));
                if (hostId.equals("UNALLOCATED")) {
                    this.makeVmRelatedScope("VM", "UNALLOCATED", facilityName, "Auto Create at " + new Date().toString(), 200, locale);
                } else {
                    this.makeVmRelatedScope("VM", this.getHostNodeScopeFacilityId(hostId), facilityName, "Auto Create at " + new Date().toString(), 200, locale);
                }
                guestNodeList = releaseMap.get(hostId);
                if (guestNodeList != null && guestNodeList.size() > 0) {
                    m_log.debug((Object)("release host node scope " + hostId));
                    if (hostId.equals("UNALLOCATED")) {
                        this.releaseVmNodeAtHostNodeScope("UNALLOCATED", guestNodeList);
                    } else {
                        this.releaseVmNodeAtHostNodeScope(this.getHostNodeScopeFacilityId(hostId), guestNodeList);
                    }
                }
                if ((guestNodeList = newMap.get(hostId)) == null || guestNodeList.size() <= 0) continue;
                m_log.debug((Object)("add host node scope " + hostId));
                if (hostId.equals("UNALLOCATED")) {
                    this.assignVmNodeAtHostNodeScope("UNALLOCATED", guestNodeList);
                    continue;
                }
                this.assignVmNodeAtHostNodeScope(this.getHostNodeScopeFacilityId(hostId), guestNodeList);
            }
            catch (VmException e) {
                m_log.error((Object)"updateVmNodeAllocation() : ", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                m_log.error((Object)"updateVmNodeAllocation() : ", (Throwable)e);
                VmException ve = new VmException("\u30db\u30b9\u30c8\u30ce\u30fc\u30c9\u7528\u30b9\u30b3\u30fc\u30d7\u306e\u66f4\u65b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                ve.setStackTrace(e.getStackTrace());
                throw ve;
            }
        }
    }

    public void makeVmRelatedScope(String parentFacilityId, String targetFacilityId, String targetFacilityName, String targetDescription, int sortOrder, Locale locale) throws VmException {
        m_log.debug((Object)("makeVmRelatedScope() : start targetFacilityId " + targetFacilityId + " on " + parentFacilityId));
        m_log.debug((Object)"makeVmRelatedScope() : init");
        String facilityId = null;
        ArrayList scopeList = null;
        this.setRepositoryController();
        m_log.debug((Object)"makeVmRelatedScope() : main");
        try {
            boolean exists = false;
            scopeList = this.repository.getScopeList(parentFacilityId);
            for (ArrayList arrayList : scopeList) {
                facilityId = (String)arrayList.get(0);
                m_log.debug((Object)("makeVmRelatedScope() : search scope : facilityId = " + facilityId));
                if (facilityId == null || !facilityId.equals(targetFacilityId)) continue;
                m_log.debug((Object)("makeVmRelatedScope() : Scope " + targetFacilityId + " is in " + parentFacilityId));
                exists = true;
            }
            if (!exists) {
                m_log.debug((Object)("makeVmRelatedScope() : Scope " + targetFacilityId + " is not in " + parentFacilityId));
                Property property = this.repository.getScopeProperty(1, locale);
                ArrayList propertyList = PropertyUtil.getProperty((Property)property, (String)"facilityId");
                ((Property)propertyList.get(0)).setValue((Object)targetFacilityId);
                propertyList = PropertyUtil.getProperty((Property)property, (String)"facilityName");
                ((Property)propertyList.get(0)).setValue((Object)targetFacilityName);
                propertyList = PropertyUtil.getProperty((Property)property, (String)"notes");
                ((Property)propertyList.get(0)).setValue((Object)targetDescription);
                this.repository.addScope(parentFacilityId, property, sortOrder, false);
                m_log.debug((Object)("makeVmRelatedScope() : Scope " + targetFacilityId + " make succeeded ! "));
            }
        }
        catch (Exception e) {
            m_log.error((Object)"makeVmRelatedScope() : ", (Throwable)e);
            VmException ve = new VmException(targetFacilityId + "\u30b9\u30b3\u30fc\u30d7\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            ve.setStackTrace(e.getStackTrace());
            throw ve;
        }
    }

    public void assignVmNodeAtHostNodeScope(String hostNodeScopeId, ArrayList<String> guestNodeList) throws VmException {
        m_log.debug((Object)("assignVmNodeAtHostNodeScope() : start hostNodeScopeId = " + hostNodeScopeId));
        m_log.debug((Object)"assignVmNodeAtHostNodeScope() : init");
        ArrayList scopeList = null;
        String facilityId = null;
        m_log.debug((Object)"assignVmNodeAtHostNodeScope() : main");
        try {
            scopeList = this.repository.getScopeList(hostNodeScopeId);
            for (String guestId : guestNodeList) {
                m_log.debug((Object)("assignVmNodeAtHostNodeScope() : loop guestId = " + guestId));
                boolean exists = false;
                for (ArrayList arrayList : scopeList) {
                    facilityId = (String)arrayList.get(0);
                    if (!guestId.equals(facilityId)) continue;
                    exists = true;
                    break;
                }
                if (!exists) {
                    m_log.debug((Object)("assignVmNodeAtHostNodeScope() : add guestId = " + guestId));
                    String[] glist = new String[]{guestId};
                    this.repository.assignNodeScope(hostNodeScopeId, glist, false);
                    m_log.debug((Object)("assignVmNodeAtHostNodeScope() : add guestId = " + guestId + " succeeded!!"));
                    continue;
                }
                m_log.debug((Object)("assignVmNodeAtHostNodeScope() : already exists : guestId = " + guestId));
            }
        }
        catch (Exception e) {
            m_log.error((Object)"assignVmNodeAtHostNodeScope() : ", (Throwable)e);
            VmException ve = new VmException(hostNodeScopeId + "\u30b9\u30b3\u30fc\u30d7\u3078\u306e\u30b2\u30b9\u30c8\u30ce\u30fc\u30c9\u5272\u5f53\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            ve.setStackTrace(e.getStackTrace());
            throw ve;
        }
    }

    public void releaseVmNodeAtHostNodeScope(String hostNodeScopeId, ArrayList<String> guestNodeList) throws VmException {
        m_log.debug((Object)("releaseVmNodeAtHostNodeScope() : start hostNodeScopeId = " + hostNodeScopeId));
        m_log.debug((Object)"releaseVmNodeAtHostNodeScope() : init");
        ArrayList scopeList = null;
        String facilityId = null;
        m_log.debug((Object)"releaseVmNodeAtHostNodeScope() : main");
        try {
            scopeList = this.repository.getScopeList(hostNodeScopeId);
            block2: for (String guestId : guestNodeList) {
                m_log.debug((Object)("releaseVmNodeAtHostNodeScope() : loop guestId = " + guestId));
                for (ArrayList arrayList : scopeList) {
                    facilityId = (String)arrayList.get(0);
                    if (!guestId.equals(facilityId)) continue;
                    m_log.debug((Object)("releaseVmNodeAtHostNodeScope() : release guestId = " + guestId));
                    String[] glist = new String[]{guestId};
                    this.repository.releaseNodeScope(hostNodeScopeId, glist, false);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            m_log.error((Object)"releaseVmNodeAtHostNodeScope() : ", (Throwable)e);
            VmException ve = new VmException(hostNodeScopeId + "\u30b9\u30b3\u30fc\u30d7\u3078\u306e\u30b2\u30b9\u30c8\u30ce\u30fc\u30c9\u5272\u5f53\u89e3\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            ve.setStackTrace(e.getStackTrace());
            throw ve;
        }
    }
}

