/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.auth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AuthPolicy {
    private static final HashMap SCHEMES = new HashMap();
    private static final ArrayList SCHEME_LIST = new ArrayList();
    public static final String AUTH_SCHEME_PRIORITY = "http.auth.scheme-priority";
    public static final String NTLM = "NTLM";
    public static final String DIGEST = "Digest";
    public static final String BASIC = "Basic";
    protected static final Log LOG;
    static /* synthetic */ Class class$org$apache$commons$httpclient$auth$NTLMScheme;
    static /* synthetic */ Class class$org$apache$commons$httpclient$auth$DigestScheme;
    static /* synthetic */ Class class$org$apache$commons$httpclient$auth$BasicScheme;
    static /* synthetic */ Class class$org$apache$commons$httpclient$auth$AuthPolicy;

    public static synchronized void registerAuthScheme(String string, Class clazz) {
        if (string == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Authentication scheme class may not be null");
        }
        SCHEMES.put(string.toLowerCase(), clazz);
        SCHEME_LIST.add(string.toLowerCase());
    }

    public static synchronized void unregisterAuthScheme(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        SCHEMES.remove(string.toLowerCase());
        SCHEME_LIST.remove(string.toLowerCase());
    }

    public static synchronized AuthScheme getAuthScheme(String string) throws IllegalStateException {
        if (string == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        Class clazz = (Class)SCHEMES.get(string.toLowerCase());
        if (clazz != null) {
            try {
                return (AuthScheme)clazz.newInstance();
            }
            catch (Exception exception) {
                LOG.error((Object)("Error initializing authentication scheme: " + string), (Throwable)exception);
                throw new IllegalStateException(string + " authentication scheme implemented by " + clazz.getName() + " could not be initialized");
            }
        }
        throw new IllegalStateException("Unsupported authentication scheme " + string);
    }

    public static synchronized List getDefaultAuthPrefs() {
        return (List)SCHEME_LIST.clone();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        AuthPolicy.registerAuthScheme(NTLM, class$org$apache$commons$httpclient$auth$NTLMScheme == null ? (class$org$apache$commons$httpclient$auth$NTLMScheme = AuthPolicy.class$("org.apache.commons.httpclient.auth.NTLMScheme")) : class$org$apache$commons$httpclient$auth$NTLMScheme);
        AuthPolicy.registerAuthScheme(DIGEST, class$org$apache$commons$httpclient$auth$DigestScheme == null ? (class$org$apache$commons$httpclient$auth$DigestScheme = AuthPolicy.class$("org.apache.commons.httpclient.auth.DigestScheme")) : class$org$apache$commons$httpclient$auth$DigestScheme);
        AuthPolicy.registerAuthScheme(BASIC, class$org$apache$commons$httpclient$auth$BasicScheme == null ? (class$org$apache$commons$httpclient$auth$BasicScheme = AuthPolicy.class$("org.apache.commons.httpclient.auth.BasicScheme")) : class$org$apache$commons$httpclient$auth$BasicScheme);
        LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$auth$AuthPolicy == null ? (class$org$apache$commons$httpclient$auth$AuthPolicy = AuthPolicy.class$("org.apache.commons.httpclient.auth.AuthPolicy")) : class$org$apache$commons$httpclient$auth$AuthPolicy));
    }
}

