/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdleConnectionHandler {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$util$IdleConnectionHandler == null ? (class$org$apache$commons$httpclient$util$IdleConnectionHandler = IdleConnectionHandler.class$("org.apache.commons.httpclient.util.IdleConnectionHandler")) : class$org$apache$commons$httpclient$util$IdleConnectionHandler));
    private Map connectionToAdded = new HashMap();
    static /* synthetic */ Class class$org$apache$commons$httpclient$util$IdleConnectionHandler;

    public void add(HttpConnection httpConnection) {
        Long l = new Long(System.currentTimeMillis());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding connection at: " + l));
        }
        this.connectionToAdded.put(httpConnection, l);
    }

    public void remove(HttpConnection httpConnection) {
        this.connectionToAdded.remove(httpConnection);
    }

    public void removeAll() {
        this.connectionToAdded.clear();
    }

    public void closeIdleConnections(long l) {
        long l2 = System.currentTimeMillis() - l;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking for connections, idleTimeout: " + l2));
        }
        Iterator iterator = this.connectionToAdded.keySet().iterator();
        while (iterator.hasNext()) {
            HttpConnection httpConnection = (HttpConnection)iterator.next();
            Long l3 = (Long)this.connectionToAdded.get(httpConnection);
            if (l3 > l2) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Closing connection, connection time: " + l3));
            }
            iterator.remove();
            httpConnection.close();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

