/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.binding;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.handler.Handler;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonBinding;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.EndpointInvocation;
import org.jboss.ws.core.HeaderSource;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.jaxws.SOAPFaultHelperJAXWS;
import org.jboss.ws.core.jaxws.binding.BindingExt;
import org.jboss.ws.core.jaxws.binding.BindingImpl;
import org.jboss.ws.core.jaxws.handler.SOAPMessageContextJAXWS;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.MessageFactoryImpl;
import org.jboss.ws.core.soap.SOAPBodyElementDoc;
import org.jboss.ws.core.soap.SOAPBodyImpl;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.core.soap.UnboundHeader;
import org.jboss.ws.core.soap.XMLFragment;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PayloadBinding
implements CommonBinding,
BindingExt {
    private static final Logger log = Logger.getLogger(PayloadBinding.class);
    private BindingImpl delegate = new BindingImpl();

    @Override
    public MessageAbstraction bindRequestMessage(OperationMetaData opMetaData, EndpointInvocation epInv, Map<QName, UnboundHeader> unboundHeaders) throws BindingException {
        throw new NotImplementedException();
    }

    @Override
    public EndpointInvocation unbindRequestMessage(OperationMetaData opMetaData, MessageAbstraction payload) throws BindingException {
        log.debug((Object)("unbindRequestMessage: " + opMetaData.getQName()));
        try {
            EndpointInvocation epInv = new EndpointInvocation(opMetaData);
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            if (msgContext == null) {
                throw new WSException("MessageContext not available");
            }
            ParameterMetaData paramMetaData = opMetaData.getParameters().get(0);
            QName xmlName = paramMetaData.getXmlName();
            SOAPMessage reqMessage = (SOAPMessage)payload;
            SOAPBodyImpl body = (SOAPBodyImpl)reqMessage.getSOAPBody();
            SOAPContentElement bodyElement = (SOAPContentElement)body.getBodyElement();
            Source source = bodyElement.getXMLFragment().getSource();
            if (source == null) {
                throw new IllegalStateException("Payload cannot be null");
            }
            epInv.setRequestParamValue(xmlName, source);
            return epInv;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public MessageAbstraction bindResponseMessage(OperationMetaData opMetaData, EndpointInvocation epInv) throws BindingException {
        log.debug((Object)("bindResponseMessage: " + opMetaData.getQName()));
        try {
            SOAPMessageContextJAXWS msgContext = (SOAPMessageContextJAXWS)MessageContextAssociation.peekMessageContext();
            if (msgContext == null) {
                throw new WSException("MessageContext not available");
            }
            MessageFactoryImpl factory = new MessageFactoryImpl();
            factory.setEnvNamespace("http://schemas.xmlsoap.org/soap/envelope/");
            SOAPMessageImpl resMessage = (SOAPMessageImpl)factory.createMessage();
            msgContext.setSOAPMessage(resMessage);
            ParameterMetaData retParameter = opMetaData.getReturnParameter();
            QName xmlName = retParameter.getXmlName();
            SOAPBodyImpl soapBody = (SOAPBodyImpl)resMessage.getSOAPBody();
            SOAPContentElement bodyElement = new SOAPBodyElementDoc(xmlName);
            bodyElement = (SOAPContentElement)soapBody.addChildElement(bodyElement);
            Source payload = (Source)epInv.getReturnValue();
            bodyElement.setXMLFragment(new XMLFragment(payload));
            return resMessage;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public void unbindResponseMessage(OperationMetaData opMetaData, MessageAbstraction resMessage, EndpointInvocation epInv, Map<QName, UnboundHeader> unboundHeaders) throws BindingException {
        throw new NotImplementedException();
    }

    @Override
    public MessageAbstraction bindFaultMessage(Exception ex) {
        SOAPMessageImpl faultMessage = SOAPFaultHelperJAXWS.exceptionToFaultMessage(ex);
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext != null) {
            msgContext.setSOAPMessage(faultMessage);
        } else {
            log.warn((Object)"Cannot set fault message in message context");
        }
        return faultMessage;
    }

    public List<Handler> getHandlerChain() {
        return this.delegate.getHandlerChain();
    }

    @Override
    public List<Handler> getHandlerChain(UnifiedHandlerMetaData.HandlerType handlerType) {
        return this.delegate.getHandlerChain(handlerType);
    }

    public void setHandlerChain(List<Handler> handlerChain) {
        this.delegate.setHandlerChain(handlerChain);
    }

    @Override
    public void setHandlerChain(List<Handler> handlerChain, UnifiedHandlerMetaData.HandlerType handlerType) {
        this.delegate.setHandlerChain(handlerChain, handlerType);
    }

    private void handleException(Exception ex) throws BindingException {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof BindingException) {
            throw (BindingException)ex;
        }
        throw new BindingException(ex);
    }

    public String getBindingID() {
        throw new NotImplementedException();
    }

    @Override
    public void setHeaderSource(HeaderSource source) {
    }
}

