/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsse;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import org.jboss.logging.Logger;
import org.jboss.ws.core.utils.ResourceURL;
import org.jboss.ws.metadata.wsse.Config;
import org.jboss.ws.metadata.wsse.Encrypt;
import org.jboss.ws.metadata.wsse.Operation;
import org.jboss.ws.metadata.wsse.Port;
import org.jboss.ws.metadata.wsse.RequireEncryption;
import org.jboss.ws.metadata.wsse.RequireSignature;
import org.jboss.ws.metadata.wsse.RequireTimestamp;
import org.jboss.ws.metadata.wsse.Requires;
import org.jboss.ws.metadata.wsse.Sign;
import org.jboss.ws.metadata.wsse.Target;
import org.jboss.ws.metadata.wsse.Timestamp;
import org.jboss.ws.metadata.wsse.Username;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class WSSecurityOMFactory
implements ObjectModelFactory {
    public static String SERVER_RESOURCE_NAME = "jboss-wsse-server.xml";
    public static String CLIENT_RESOURCE_NAME = "jboss-wsse-client.xml";
    private static HashMap options = new HashMap(6);
    private static final Logger log;

    private WSSecurityOMFactory() {
    }

    public static WSSecurityOMFactory newInstance() {
        return new WSSecurityOMFactory();
    }

    public WSSecurityConfiguration parse(URL configURL) throws IOException {
        if (configURL == null) {
            throw new IllegalArgumentException("Security config URL cannot be null");
        }
        InputStream is = new ResourceURL(configURL).openStream();
        try {
            WSSecurityConfiguration configuration;
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            WSSecurityConfiguration wSSecurityConfiguration = configuration = (WSSecurityConfiguration)unmarshaller.unmarshal(is, (ObjectModelFactory)this, null);
            return wSSecurityConfiguration;
        }
        catch (JBossXBException e) {
            IOException ioex = new IOException("Cannot parse: " + configURL);
            Throwable cause = e.getCause();
            if (cause != null) {
                ioex.initCause(cause);
            }
            throw ioex;
        }
        finally {
            is.close();
        }
    }

    public WSSecurityConfiguration parse(String xmlString) throws JBossXBException {
        if (xmlString == null) {
            throw new IllegalArgumentException("Security config xml String cannot be null");
        }
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        WSSecurityConfiguration configuration = (WSSecurityConfiguration)unmarshaller.unmarshal(xmlString, (ObjectModelFactory)this, null);
        return configuration;
    }

    public WSSecurityConfiguration parse(StringReader strReader) throws JBossXBException {
        if (strReader == null) {
            throw new IllegalArgumentException("Security InputStream cannot be null");
        }
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        WSSecurityConfiguration configuration = (WSSecurityConfiguration)unmarshaller.unmarshal((Reader)strReader, (ObjectModelFactory)this, null);
        return configuration;
    }

    public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return new WSSecurityConfiguration();
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        return root;
    }

    public void setValue(WSSecurityConfiguration configuration, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        log.trace((Object)("setValue: [obj=" + configuration + ",value=" + value + "]"));
        String method = (String)options.get(localName);
        if (method == null) {
            return;
        }
        try {
            WSSecurityConfiguration.class.getMethod(method, String.class).invoke((Object)configuration, value);
        }
        catch (Exception e) {
            log.error((Object)("Could not set option: " + method + " to: " + value), (Throwable)e);
        }
    }

    public Object newChild(WSSecurityConfiguration configuration, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("config".equals(localName)) {
            return new Config();
        }
        if ("key-passwords".equals(localName)) {
            HashMap<String, String> pwds = new HashMap<String, String>();
            configuration.setKeyPasswords(pwds);
            return pwds;
        }
        if ("port".equals(localName)) {
            return new Port(attrs.getValue("", "name"));
        }
        return null;
    }

    public Object newChild(HashMap passwords, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("key-password".equals(localName)) {
            String alias = attrs.getValue("", "alias");
            String pwd = attrs.getValue("", "password");
            passwords.put(alias, pwd);
        }
        return null;
    }

    public void addChild(WSSecurityConfiguration configuration, Config defaultConfig, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + configuration + ",child=" + defaultConfig + "]"));
        configuration.setDefaultConfig(defaultConfig);
    }

    public void addChild(WSSecurityConfiguration configuration, Port port, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + configuration + ",child=" + port + "]"));
        configuration.addPort(port);
    }

    public Object newChild(Config config, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("sign".equals(localName)) {
            Boolean include = new Boolean(true);
            String timestamp = attrs.getValue("", "includeTimestamp");
            if (timestamp != null) {
                include = (Boolean)SimpleTypeBindings.unmarshal((String)timestamp, (String)"boolean", null);
            }
            return new Sign(attrs.getValue("", "type"), attrs.getValue("", "alias"), include);
        }
        if ("encrypt".equals(localName)) {
            return new Encrypt(attrs.getValue("", "type"), attrs.getValue("", "alias"), attrs.getValue("", "algorithm"));
        }
        if ("timestamp".equals(localName)) {
            return new Timestamp(attrs.getValue("", "ttl"));
        }
        if ("requires".equals(localName)) {
            return new Requires();
        }
        if ("username".equals(localName)) {
            return new Username();
        }
        return null;
    }

    public void addChild(Config config, Encrypt encrypt, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + config + ",child=" + encrypt + "]"));
        config.setEncrypt(encrypt);
    }

    public void addChild(Config config, Sign sign, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + config + ",child=" + sign + "]"));
        config.setSign(sign);
    }

    public void addChild(Config config, Timestamp timestamp, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + config + ",child=" + timestamp + "]"));
        config.setTimestamp(timestamp);
    }

    public void addChild(Config config, Username username, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + config + ",child=" + username + "]"));
        config.setUsername(username);
    }

    public void addChild(Config config, Requires requires, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + config + ",child=" + requires + "]"));
        config.setRequires(requires);
    }

    private Object handleTargets(Object object, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("target".equals(localName)) {
            Target target = new Target(attrs.getValue("", "type"));
            if ("true".equals(attrs.getValue("", "contentOnly"))) {
                target.setContentOnly(true);
            }
            return target;
        }
        return null;
    }

    public Object newChild(Encrypt encrypt, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return this.handleTargets(encrypt, navigator, namespaceURI, localName, attrs);
    }

    public Object newChild(Sign sign, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return this.handleTargets(sign, navigator, namespaceURI, localName, attrs);
    }

    public Object newChild(Requires requires, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("signature".equals(localName)) {
            return new RequireSignature();
        }
        if ("encryption".equals(localName)) {
            return new RequireEncryption();
        }
        if ("timestamp".equals(localName)) {
            return new RequireTimestamp(attrs.getValue("", "maxAge"));
        }
        return null;
    }

    public Object newChild(RequireSignature requireSignature, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return this.handleTargets(requireSignature, navigator, namespaceURI, localName, attrs);
    }

    public Object newChild(RequireEncryption requireEncryption, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return this.handleTargets(requireEncryption, navigator, namespaceURI, localName, attrs);
    }

    public void setValue(Target target, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        log.trace((Object)("setValue: [obj=" + target + ",value=" + value + "]"));
        target.setValue(value);
    }

    public void addChild(Encrypt encrypt, Target target, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + encrypt + ",child=" + target + "]"));
        encrypt.addTarget(target);
    }

    public void addChild(Sign sign, Target target, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + sign + ",child=" + target + "]"));
        sign.addTarget(target);
    }

    public void addChild(Requires requires, RequireEncryption requireEncryption, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + requires + ",child=" + requireEncryption + "]"));
        requires.setRequireEncryption(requireEncryption);
    }

    public void addChild(Requires requires, RequireSignature requireSignature, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + requires + ",child=" + requireSignature + "]"));
        requires.setRequireSignature(requireSignature);
    }

    public void addChild(Requires requires, RequireTimestamp requireTimestamp, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + requires + ",child=" + requireTimestamp + "]"));
        requires.setRequireTimestamp(requireTimestamp);
    }

    public void addChild(RequireEncryption requireEncryption, Target target, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + requireEncryption + ",child=" + target + "]"));
        requireEncryption.addTarget(target);
    }

    public void addChild(RequireSignature requireSignature, Target target, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + requireSignature + ",child=" + target + "]"));
        requireSignature.addTarget(target);
    }

    public Object newChild(Port port, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("operation".equals(localName)) {
            return new Operation(attrs.getValue("", "name"));
        }
        if ("config".equals(localName)) {
            return new Config();
        }
        return null;
    }

    public void addChild(Port port, Operation operation, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + port + ",child=" + operation + "]"));
        port.addOperation(operation);
    }

    public void addChild(Port port, Config config, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + port + ",child=" + config + "]"));
        port.setDefaultConfig(config);
    }

    public Object newChild(Operation operation, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("config".equals(localName)) {
            return new Config();
        }
        return null;
    }

    public void addChild(Operation operation, Config config, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + operation + ",child=" + config + "]"));
        operation.setConfig(config);
    }

    static {
        options.put("key-store-file", "setKeyStoreFile");
        options.put("key-store-type", "setKeyStoreType");
        options.put("key-store-password", "setKeyStorePassword");
        options.put("trust-store-file", "setTrustStoreFile");
        options.put("trust-store-type", "setTrustStoreType");
        options.put("trust-store-password", "setTrustStorePassword");
        log = Logger.getLogger(WSSecurityOMFactory.class);
    }
}

