/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.factory;

import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.calendar.ejb.session.CalendarControllerLocal;
import com.clustercontrol.calendar.ejb.session.CalendarControllerUtil;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.monitor.run.bean.MonitorJudgementInfo;
import com.clustercontrol.monitor.run.bean.MonitorRunResultInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoPK;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.monitor.run.util.CallableTask;
import com.clustercontrol.monitor.run.util.MonitorTransactionManager;
import com.clustercontrol.monitor.run.util.ParallelExecution;
import com.clustercontrol.priority.util.PriorityJudgment;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.util.deadlock.ApplicationDeadlockException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RunMonitor {
    private static final int RETRY_MAX = 1;
    protected static Log m_log = LogFactory.getLog(RunMonitor.class);
    public static final String MESSAGE_INFO = Messages.getString((String)"message.info");
    public static final String MESSAGE_WARNING = Messages.getString((String)"message.warning");
    public static final String MESSAGE_CRITICAL = Messages.getString((String)"message.critical");
    public static final String MESSAGE_UNKNOWN = Messages.getString((String)"message.unknown");
    public static int RETRY_INTERVAL = 1000;
    protected MonitorInfoLocal m_monitor;
    protected String m_monitorTypeId;
    protected String m_monitorId;
    protected String m_notifyGroupId;
    protected String m_facilityId;
    protected int m_failurePriority = -1;
    protected int m_runInterval;
    protected Date m_now;
    protected long m_scopeDate;
    protected long m_nodeDate;
    protected int m_responseTime;
    protected OutputNotifyGroupInfo m_notifyGroupInfo;
    protected RepositoryControllerLocal m_repository;
    private SendQueue m_queue;
    protected int m_monitorBlock;
    protected int m_timeout;
    protected int m_jobRun;
    protected boolean m_isNode;
    protected HashMap<Integer, ArrayList<String>> m_priorityMap;
    protected TreeMap<Integer, MonitorJudgementInfo> m_judgementInfoList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run(String monitorTypeId, String monitorId) throws FinderException, RemoveException, JMSException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException, CreateException {
        this.initialize();
        this.m_monitorTypeId = monitorTypeId;
        this.m_monitorId = monitorId;
        TransactionManager tm = null;
        Transaction oldTx = null;
        boolean result = false;
        int count = 0;
        boolean deadlock = false;
        try {
            block32: {
                tm = MonitorTransactionManager.getInstance().getTransactionManager();
                if (tm.getTransaction() != null) {
                    oldTx = tm.suspend();
                }
                try {
                    do {
                        try {
                            ++count;
                            result = false;
                            deadlock = false;
                            if (tm.getTransaction() == null) {
                                tm.begin();
                            }
                            if (result = this.runMonitorInfo()) {
                                tm.commit();
                            }
                        }
                        catch (TransactionRolledbackLocalException e) {
                            if (e.getCausedByException() instanceof ApplicationDeadlockException) {
                                deadlock = true;
                                if (count <= 1) {
                                    m_log.debug((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
                                } else {
                                    m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
                                }
                                if (tm.getTransaction() != null && !result) {
                                    tm.rollback();
                                }
                            }
                            m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
                            throw e;
                        }
                        if (!deadlock) break;
                    } while (count <= 1);
                    Object var10_14 = null;
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    if (tm.getTransaction() != null && !result) {
                        tm.rollback();
                    }
                    throw throwable;
                }
                if (tm.getTransaction() != null && !result) {
                    tm.rollback();
                }
                break block32;
                {
                    catch (NotSupportedException e) {
                        m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
                        throw e;
                    }
                    catch (RollbackException e) {
                        m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
                        throw e;
                    }
                    catch (HeuristicMixedException e) {
                        m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
                        throw e;
                    }
                    catch (HeuristicRollbackException e) {
                        m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
                        throw e;
                    }
                    catch (SystemException e) {
                        m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
                        throw e;
                    }
                }
            }
            Object var12_17 = null;
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            this.terminate();
            if (oldTx != null) {
                try {
                    tm.resume(oldTx);
                }
                catch (InvalidTransactionException e) {
                    m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
                    throw e;
                }
                catch (IllegalStateException e) {
                    m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
                    throw e;
                }
                catch (SystemException e) {
                    m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
                    throw e;
                }
            }
            throw throwable;
        }
        this.terminate();
        if (oldTx != null) {
            try {
                tm.resume(oldTx);
            }
            catch (InvalidTransactionException e) {
                m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
                throw e;
            }
            catch (IllegalStateException e) {
                m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
                throw e;
            }
            catch (SystemException e) {
                m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
                throw e;
            }
        }
    }

    public boolean runMonitorInfo() throws FinderException, RemoveException, JMSException, NamingException, CreateException {
        this.m_now = new Date();
        this.m_priorityMap = new HashMap();
        this.m_priorityMap.put(3, new ArrayList());
        this.m_priorityMap.put(2, new ArrayList());
        this.m_priorityMap.put(0, new ArrayList());
        this.m_priorityMap.put(1, new ArrayList());
        try {
            Iterator itr;
            boolean run = this.setMonitorInfo(this.m_monitorTypeId, this.m_monitorId);
            if (!run) {
                return true;
            }
            this.setJudgementInfo();
            this.setCheckInfo();
            ArrayList facilityList = this.m_repository.getExecTargetFacilityIdList(this.m_facilityId);
            if (facilityList.size() == 0) {
                return true;
            }
            this.m_isNode = this.m_repository.isNode(this.m_facilityId);
            m_log.debug((Object)("\u76e3\u8996start : monitorTypeId : " + this.m_monitorTypeId + ", monitorId : " + this.m_monitorId));
            String facilityId2 = null;
            HashMap<String, Future<MonitorRunResultInfo>> futuresMap = new HashMap<String, Future<MonitorRunResultInfo>>(facilityList.size());
            for (String facilityId2 : facilityList) {
                if (facilityId2 != null && !"".equals(facilityId2)) {
                    RunMonitor runMonitor = this.createMonitorInstance();
                    runMonitor.m_monitorTypeId = this.m_monitorTypeId;
                    runMonitor.m_monitorId = this.m_monitorId;
                    runMonitor.m_now = this.m_now;
                    runMonitor.setMonitorInfo(this.m_monitorTypeId, this.m_monitorId);
                    runMonitor.m_priorityMap = this.m_priorityMap;
                    runMonitor.setJudgementInfo();
                    runMonitor.m_repository = this.m_repository;
                    runMonitor.setCheckInfo();
                    Future<MonitorRunResultInfo> future = ParallelExecution.m_executorService.submit(new CallableTask(runMonitor, facilityId2));
                    futuresMap.put(facilityId2, future);
                    continue;
                }
                facilityList.remove(facilityId2);
            }
            ArrayList facilityListCopy = null;
            ArrayList<String> facilityListComplete = null;
            boolean isGet = false;
            MonitorRunResultInfo result = new MonitorRunResultInfo();
            m_log.debug((Object)("\u96c6\u8a08start : monitorTypeId : " + this.m_monitorTypeId + ", monitorId : " + this.m_monitorId));
            if (0 == this.m_monitorBlock || 1 == this.m_monitorBlock && this.m_isNode || 2 == this.m_monitorBlock) {
                facilityListCopy = new ArrayList(facilityList);
                facilityListComplete = new ArrayList<String>();
                while (true) {
                    facilityListComplete.clear();
                    for (String facilityId2 : facilityListCopy) {
                        isGet = ((Future)futuresMap.get(facilityId2)).isDone();
                        if (!isGet) continue;
                        m_log.debug((Object)("\u7d50\u679c\u51fa\u529b\u51e6\u7406 : monitorTypeId : " + this.m_monitorTypeId + ", m_monitorId : " + this.m_monitorId + ",\u3000m_facilityId : " + facilityId2));
                        result = (MonitorRunResultInfo)((Future)futuresMap.get(facilityId2)).get();
                        this.m_nodeDate = result.getNodeDate();
                        this.notify(true, facilityId2, result.getCheakResult(), new Date(this.m_nodeDate), result);
                        facilityListComplete.add(facilityId2);
                    }
                    itr = facilityListComplete.iterator();
                    while (itr.hasNext()) {
                        facilityListCopy.remove(itr.next());
                    }
                    if (facilityListCopy.size() == 0) {
                        m_log.debug((Object)("\u53ce\u96c6\u51e6\u7406\u7d42\u4e86(node) : monitorTypeId : " + this.m_monitorTypeId + ", m_monitorId : " + this.m_monitorId));
                        break;
                    }
                    m_log.debug((Object)("\u53ce\u96c6\u51e6\u7406\u4e2d(node) : monitorTypeId : " + this.m_monitorTypeId + ", m_monitorId : " + this.m_monitorId));
                    Thread.sleep(RETRY_INTERVAL);
                }
            }
            if (!(this.m_isNode || 1 != this.m_monitorBlock && 2 != this.m_monitorBlock)) {
                ArrayList<Integer> priorityList = new ArrayList<Integer>();
                facilityListCopy = new ArrayList(facilityList);
                facilityListComplete = new ArrayList();
                while (true) {
                    facilityListComplete.clear();
                    for (String facilityId2 : facilityListCopy) {
                        isGet = ((Future)futuresMap.get(facilityId2)).isDone();
                        if (!isGet) continue;
                        result = (MonitorRunResultInfo)((Future)futuresMap.get(facilityId2)).get();
                        this.m_nodeDate = result.getNodeDate();
                        int priority = result.getPriority();
                        priorityList.add(priority);
                        this.setPriorityMap(priority, facilityId2);
                        if (this.m_nodeDate > this.m_scopeDate) {
                            this.m_scopeDate = this.m_nodeDate;
                        }
                        m_log.debug((Object)("\u7d50\u679c\u51fa\u529b\u51e6\u7406 : monitorTypeId : " + this.m_monitorTypeId + ", m_monitorId : " + this.m_monitorId + ",\u3000m_facilityId : " + facilityId2));
                        facilityListComplete.add(facilityId2);
                    }
                    itr = facilityListComplete.iterator();
                    while (itr.hasNext()) {
                        facilityListCopy.remove(itr.next());
                    }
                    if (facilityListCopy.size() == 0) break;
                    m_log.debug((Object)("\u53ce\u96c6\u51e6\u7406\u4e2d(scope) : monitorTypeId : " + this.m_monitorTypeId + ", m_monitorId : " + this.m_monitorId));
                    Thread.sleep(RETRY_INTERVAL);
                }
                m_log.debug((Object)("\u53ce\u96c6\u51e6\u7406\u7d42\u4e86(scope) : monitorTypeId : " + this.m_monitorTypeId + ", m_monitorId : " + this.m_monitorId));
                Integer priority = PriorityJudgment.judgment(priorityList);
                if (priority == null) {
                    priority = this.m_failurePriority;
                }
                Date generationDate = null;
                generationDate = this.m_scopeDate > 0L ? new Date(this.m_scopeDate) : this.m_now;
                this.notify(false, this.m_facilityId, priority, generationDate);
            }
            m_log.debug((Object)("\u76e3\u8996end : monitorTypeId : " + this.m_monitorTypeId + ", monitorId : " + this.m_monitorId));
            return true;
        }
        catch (FinderException e) {
            m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (CreateException e) {
            m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (JMSException e) {
            m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (NamingException e) {
            m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (InterruptedException e) {
            m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
            return false;
        }
        catch (ExecutionException e) {
            m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public abstract void setJudgementInfo();

    public abstract void setCheckInfo() throws FinderException, NamingException;

    public abstract boolean collect(String var1);

    public abstract RunMonitor createMonitorInstance() throws NamingException, JMSException, CreateException;

    public abstract int getCheckResult(boolean var1);

    public int getPriority(int key) {
        MonitorJudgementInfo info = this.m_judgementInfoList.get(key);
        if (info != null) {
            return info.getPriority();
        }
        return this.m_failurePriority;
    }

    public String getNotifyGroupId() {
        return this.m_notifyGroupId;
    }

    public String getMessageId(int key) {
        MonitorJudgementInfo info = this.m_judgementInfoList.get(key);
        if (info != null && info.getMessageId() != null) {
            return info.getMessageId();
        }
        return "";
    }

    public String getMessage(int key) {
        MonitorJudgementInfo info = this.m_judgementInfoList.get(key);
        if (info != null && info.getMessage() != null) {
            return info.getMessage();
        }
        return "";
    }

    public abstract String getMessageOrg(int var1);

    public String getMessageIdForScope(int priority) {
        Set<Integer> set = this.m_judgementInfoList.keySet();
        for (Integer key : set) {
            MonitorJudgementInfo info = this.m_judgementInfoList.get(key);
            if (priority != info.getPriority() || info.getMessageId() == null) continue;
            return info.getMessageId();
        }
        return "";
    }

    public String getMessageForScope(int priority) {
        if (priority == 3) {
            return MESSAGE_INFO;
        }
        if (priority == 2) {
            return MESSAGE_WARNING;
        }
        if (priority == 0) {
            return MESSAGE_CRITICAL;
        }
        return MESSAGE_UNKNOWN;
    }

    public String getMessageOrgForScope(int priority) {
        ArrayList<String> info = this.m_priorityMap.get(3);
        ArrayList<String> warning = this.m_priorityMap.get(2);
        ArrayList<String> critical = this.m_priorityMap.get(0);
        ArrayList<String> unknown = this.m_priorityMap.get(1);
        StringBuffer summary = new StringBuffer();
        summary.append(Messages.getString((String)"info") + ":" + info.size() + Messages.getString((String)"record") + ", ");
        summary.append(Messages.getString((String)"warning") + ":" + warning.size() + Messages.getString((String)"record") + ", ");
        summary.append(Messages.getString((String)"critical") + ":" + critical.size() + Messages.getString((String)"record") + ", ");
        summary.append(Messages.getString((String)"unknown") + ":" + unknown.size() + Messages.getString((String)"record"));
        StringBuffer detail = new StringBuffer();
        detail.append(this.getItemListString("\n" + Messages.getString((String)"info"), info));
        detail.append(this.getItemListString("\n" + Messages.getString((String)"warning"), warning));
        detail.append(this.getItemListString("\n" + Messages.getString((String)"critical"), critical));
        detail.append(this.getItemListString("\n" + Messages.getString((String)"unknown"), unknown));
        return summary.toString() + detail.toString();
    }

    public long getNodeDate() {
        return this.m_nodeDate;
    }

    protected boolean setMonitorInfo(String monitorTypeId, String monitorId) throws FinderException, NamingException, CreateException {
        MonitorInfoPK pk = new MonitorInfoPK(monitorId, monitorTypeId);
        this.m_monitor = MonitorInfoUtil.getLocalHome().findByPrimaryKey(pk);
        this.m_notifyGroupId = this.m_monitor.getNotifyGroupId();
        if ((this.m_notifyGroupId == null || "".equals(this.m_notifyGroupId)) && this.m_monitor.getMonitorType() != 2) {
            return false;
        }
        String calendarId = this.m_monitor.getCalendarId();
        if (calendarId != null && !"".equals(calendarId)) {
            CalendarControllerLocal calendar = CalendarControllerUtil.getLocalHome().create();
            try {
                if (!calendar.isRun(calendarId, this.m_now).booleanValue()) {
                    m_log.debug((Object)("setMonitorInfo() : \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ",\u30ab\u30ec\u30f3\u30c0ID\uff1a" + calendarId + "\u3002\u975e\u7a3c\u50cd\u65e5\u306e\u70ba\u3001\u76e3\u8996\u306f\u5b9f\u884c\u3055\u308c\u307e\u305b\u3093\u3002"));
                    return false;
                }
            }
            catch (FinderException e) {
                m_log.info((Object)("setMonitorInfo() : \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + "\u3002\u30ab\u30ec\u30f3\u30c0ID\u300c" + calendarId + "\u300d\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002"));
                return false;
            }
        }
        this.m_facilityId = this.m_monitor.getFacilityId();
        this.m_monitorBlock = this.m_monitor.getMonitorBlock();
        this.m_timeout = this.m_monitor.getTimeout();
        this.m_failurePriority = this.m_monitor.getFailurePriority();
        this.m_runInterval = this.m_monitor.getRunInterval();
        return true;
    }

    protected void notify(boolean isNode, String facilityId, int result, Date generationDate) throws FinderException, JMSException, NamingException {
        String notifyGroupId = this.getNotifyGroupId();
        if (notifyGroupId == null || "".equals(notifyGroupId)) {
            return;
        }
        if (this.m_notifyGroupInfo == null) {
            this.m_notifyGroupInfo = new OutputNotifyGroupInfo();
            this.m_notifyGroupInfo.setPluginId(this.m_monitorTypeId);
            this.m_notifyGroupInfo.setMonitorId(this.m_monitorId);
            this.m_notifyGroupInfo.setApplication(this.m_monitor.getApplication());
        }
        this.m_notifyGroupInfo.setNotifyGroupId(notifyGroupId);
        String facilityPath = this.m_repository.getFacilityPath(facilityId, null);
        this.m_notifyGroupInfo.setFacilityId(facilityId);
        this.m_notifyGroupInfo.setScopeText(facilityPath);
        int priority = -1;
        String messageId = "";
        String message = "";
        String messageOrg = "";
        if (isNode) {
            priority = this.getPriority(result);
            messageId = this.getMessageId(result);
            message = this.getMessage(result);
            messageOrg = this.getMessageOrg(result);
        } else {
            priority = result;
            messageId = this.getMessageIdForScope(result);
            message = this.getMessageForScope(result);
            messageOrg = this.getMessageOrgForScope(result);
        }
        this.m_notifyGroupInfo.setPriority(priority);
        this.m_notifyGroupInfo.setMessageId(messageId);
        this.m_notifyGroupInfo.setMessage(message);
        this.m_notifyGroupInfo.setMessageOrg(messageOrg);
        this.m_notifyGroupInfo.setGenerationDate(generationDate);
        this.m_queue.put((Serializable)this.m_notifyGroupInfo);
    }

    protected void notify(boolean isNode, String facilityId, int result, Date generationDate, MonitorRunResultInfo resultInfo) throws FinderException, JMSException, NamingException {
        String notifyGroupId = resultInfo.getNotifyGroupId();
        if (notifyGroupId == null || "".equals(notifyGroupId)) {
            return;
        }
        if (this.m_notifyGroupInfo == null) {
            this.m_notifyGroupInfo = new OutputNotifyGroupInfo();
            this.m_notifyGroupInfo.setPluginId(this.m_monitorTypeId);
            this.m_notifyGroupInfo.setMonitorId(this.m_monitorId);
            this.m_notifyGroupInfo.setApplication(this.m_monitor.getApplication());
        }
        this.m_notifyGroupInfo.setNotifyGroupId(notifyGroupId);
        String facilityPath = this.m_repository.getFacilityPath(facilityId, null);
        this.m_notifyGroupInfo.setFacilityId(facilityId);
        this.m_notifyGroupInfo.setScopeText(facilityPath);
        int priority = -1;
        String messageId = "";
        String message = "";
        String messageOrg = "";
        if (isNode) {
            priority = resultInfo.getPriority();
            messageId = resultInfo.getMessageId();
            message = resultInfo.getMessage();
            messageOrg = resultInfo.getMessageOrg();
        } else {
            priority = result;
            messageId = this.getMessageIdForScope(result);
            message = this.getMessageForScope(result);
            messageOrg = this.getMessageOrgForScope(result);
        }
        this.m_notifyGroupInfo.setPriority(priority);
        this.m_notifyGroupInfo.setMessageId(messageId);
        this.m_notifyGroupInfo.setMessage(message);
        this.m_notifyGroupInfo.setMessageOrg(messageOrg);
        this.m_notifyGroupInfo.setGenerationDate(generationDate);
        this.m_queue.put((Serializable)this.m_notifyGroupInfo);
    }

    protected void setPriorityMap(Integer priority, String facilityId) throws NamingException, FinderException {
        ArrayList<String> list = this.m_priorityMap.get(priority);
        if (list != null) {
            String facilityName = this.m_repository.getFacilityPath(facilityId, null);
            list.add(facilityName);
            this.m_priorityMap.put(priority, list);
        }
    }

    protected String getItemListString(String item, ArrayList<String> list) {
        int length = list.size();
        if (length > 0) {
            StringBuffer result = new StringBuffer();
            result.append(item + ":" + "\n");
            for (int i = 0; i < length; ++i) {
                result.append("\t" + list.get(i));
                if (i >= length - 1) continue;
                result.append("\n");
            }
            return result.toString();
        }
        return "";
    }

    protected void initialize() throws NamingException, JMSException, CreateException {
        this.m_queue = new SendQueue("queue/clustercontrolNotifyControl");
        try {
            this.m_repository = RepositoryControllerUtil.getLocalHome().create();
        }
        catch (CreateException e) {
            m_log.error((Object)("initialize():" + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (NamingException e) {
            m_log.error((Object)("initialize():" + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    protected void terminate() throws JMSException, RemoveException {
        try {
            if (this.m_queue != null) {
                this.m_queue.terminate();
            }
            this.m_queue = null;
            if (this.m_repository != null) {
                this.m_repository.remove();
            }
            this.m_repository = null;
        }
        catch (JMSException e) {
            m_log.error((Object)("terminate():" + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (RemoveException e) {
            m_log.error((Object)("terminate():" + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    static {
        Properties properties = new Properties();
        String etcdir = System.getProperty("hinemos.manager.etc.dir");
        String propertyFile = etcdir + File.separator + "hinemos.properties";
        try {
            properties.load(new FileInputStream(propertyFile));
            String retryInterval = properties.getProperty("monitor.common.retry.interval");
            RETRY_INTERVAL = Integer.parseInt(retryInterval);
            new ParallelExecution(properties);
        }
        catch (Exception e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

