/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.recovery;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class RecoveryDriver {
    private String _hostName = null;
    private int _port = 0;
    private int _timeout = 20000;

    public RecoveryDriver(int port) {
        this(port, null, 20000);
    }

    public RecoveryDriver(int port, String hostName) {
        this(port, hostName, 20000);
    }

    public RecoveryDriver(int port, String hostName, int timeout) {
        this._port = port;
        this._hostName = hostName;
        this._timeout = timeout;
    }

    public final boolean synchronousScan() throws UnknownHostException, SocketException, IOException {
        return this.scan("SCAN");
    }

    public final boolean asynchronousScan() throws UnknownHostException, SocketException, IOException {
        return this.scan("ASYNC_SCAN");
    }

    private final boolean scan(String scanType) throws UnknownHostException, SocketException, IOException {
        if (this._hostName == null) {
            this._hostName = InetAddress.getLocalHost().getHostName();
        }
        Socket connectorSocket = new Socket(this._hostName, this._port);
        connectorSocket.setSoTimeout(this._timeout);
        BufferedReader fromServer = new BufferedReader(new InputStreamReader(connectorSocket.getInputStream()));
        PrintWriter toServer = new PrintWriter(new OutputStreamWriter(connectorSocket.getOutputStream()));
        toServer.println(scanType);
        toServer.flush();
        String response = fromServer.readLine();
        boolean success = false;
        if (response.equals("DONE")) {
            success = true;
        }
        connectorSocket.close();
        return success;
    }
}

