/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.transaction.xa.Xid;
import org.jboss.jms.tx.MessagingXid;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Message;
import org.jboss.messaging.core.contract.MessageReference;
import org.jboss.messaging.core.contract.PersistenceManager;
import org.jboss.messaging.core.impl.JDBCSupport;
import org.jboss.messaging.core.impl.message.MessageFactory;
import org.jboss.messaging.core.impl.message.MessageSupport;
import org.jboss.messaging.core.impl.tx.PreparedTxInfo;
import org.jboss.messaging.core.impl.tx.Transaction;
import org.jboss.messaging.core.impl.tx.TxCallback;
import org.jboss.messaging.util.JDBCUtil;
import org.jboss.messaging.util.StreamUtils;
import org.jboss.messaging.util.Util;

public class JDBCPersistenceManager
extends JDBCSupport
implements PersistenceManager {
    private static final Logger log = Logger.getLogger(JDBCPersistenceManager.class);
    private boolean trace = log.isTraceEnabled();
    private boolean usingBinaryStream = true;
    private boolean usingTrailingByte = false;
    private int maxParams;
    private short orderCount;
    private int nodeID;
    private boolean nodeIDSet;
    private boolean supportsBlobSelect;

    public JDBCPersistenceManager(DataSource ds, TransactionManager tm, Properties sqlProperties, boolean createTablesOnStartup, boolean usingBatchUpdates, boolean usingBinaryStream, boolean usingTrailingByte, int maxParams, boolean supportsBlobSelect) {
        super(ds, tm, sqlProperties, createTablesOnStartup);
        this.usingBinaryStream = usingBinaryStream;
        this.usingTrailingByte = usingTrailingByte;
        this.maxParams = maxParams;
        this.supportsBlobSelect = supportsBlobSelect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        super.start();
        Connection conn = null;
        PreparedStatement ps = null;
        JDBCSupport.TransactionWrapper wrap = new JDBCSupport.TransactionWrapper(this);
        try {
            conn = this.ds.getConnection();
            if (conn.getTransactionIsolation() != 2) {
                int level = conn.getTransactionIsolation();
                String warn = "\n\nJBoss Messaging Warning: DataSource connection transaction isolation should be READ_COMMITTED, but it is currently " + Util.transactionIsolationToString(level) + ".\n" + "                         Using an isolation level less strict than READ_COMMITTED may lead to data consistency problems.\n" + "                         Using an isolation level more strict than READ_COMMITTED may lead to deadlock.\n";
                log.warn((Object)warn);
            }
            log.debug((Object)"Adding record on JBM_DUAL");
            ps = conn.prepareStatement(this.getSQLStatement("INSERT_DUAL"));
            try {
                int rows = ps.executeUpdate();
                if (this.trace) {
                    log.trace((Object)("Inserted " + rows + " rows into dual"));
                }
            }
            catch (SQLException e) {
                wrap.exceptionOccurred();
                wrap.end();
                wrap = new JDBCSupport.TransactionWrapper(this);
                log.debug((Object)"Checking for existance on JBM_DUAL");
                Statement selectCount = conn.createStatement();
                ResultSet rset = selectCount.executeQuery(this.getSQLStatement("CHECK_DUAL"));
                try {
                    if (!rset.next()) {
                        log.debug((Object)"JBM_DUAL didn't have a record.. throwing exception", (Throwable)e);
                        throw e;
                    }
                    if (rset.next()) {
                        log.debug((Object)"duplicated record found on JBM_DUAL... throwing exception");
                        throw new IllegalStateException("JBM_DUAL is missing a primary key as it allowed a duplicate value");
                    }
                }
                finally {
                    try {
                        rset.close();
                        selectCount.close();
                    }
                    catch (Throwable ignored) {}
                }
            }
        }
        catch (Exception e) {
            try {
                wrap.exceptionOccurred();
                throw e;
            }
            catch (Throwable throwable) {
                this.closeStatement(ps);
                this.closeConnection(conn);
                wrap.end();
                throw throwable;
            }
        }
        this.closeStatement(ps);
        this.closeConnection(conn);
        wrap.end();
        log.debug((Object)(this + " started"));
    }

    public void injectNodeID(int nodeID) {
        this.nodeID = nodeID;
        this.nodeIDSet = true;
    }

    public List getMessageChannelPairRefsForTx(long transactionId) throws Exception {
        String sql = this.getSQLStatement("SELECT_MESSAGE_ID_FOR_REF");
        return this.getMessageChannelPair(sql, transactionId);
    }

    public List getMessageChannelPairAcksForTx(long transactionId) throws Exception {
        String sql = this.getSQLStatement("SELECT_MESSAGE_ID_FOR_ACK");
        return this.getMessageChannelPair(sql, transactionId);
    }

    public List retrievePreparedTransactions() throws Exception {
        ArrayList<PreparedTxInfo> arrayList;
        if (!this.nodeIDSet) {
            throw new IllegalStateException("Node id has not been set");
        }
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        PreparedTxInfo txInfo = null;
        JDBCSupport.TransactionWrapper wrap = new JDBCSupport.TransactionWrapper(this);
        try {
            ArrayList<PreparedTxInfo> transactions = new ArrayList<PreparedTxInfo>();
            conn = this.ds.getConnection();
            st = conn.prepareStatement(this.getSQLStatement("SELECT_PREPARED_TRANSACTIONS"));
            st.setInt(1, this.nodeID);
            rs = st.executeQuery();
            while (rs.next()) {
                long txId = rs.getLong(1);
                byte[] branchQual = this.getVarBinaryColumn(rs, 2);
                int formatId = rs.getInt(3);
                byte[] globalTxId = this.getVarBinaryColumn(rs, 4);
                MessagingXid xid = new MessagingXid(branchQual, formatId, globalTxId);
                txInfo = new PreparedTxInfo(txId, xid);
                transactions.add(txInfo);
            }
            arrayList = transactions;
        }
        catch (Exception e) {
            try {
                wrap.exceptionOccurred();
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(st);
                this.closeConnection(conn);
                wrap.end();
                throw throwable;
            }
        }
        this.closeResultSet(rs);
        this.closeStatement(st);
        this.closeConnection(conn);
        wrap.end();
        return arrayList;
    }

    public long reserveIDBlock(final String counterName, final int size) throws Exception {
        if (this.trace) {
            log.trace((Object)("Getting ID block for counter " + counterName + ", size " + size));
        }
        if (size <= 0) {
            throw new IllegalArgumentException("block size must be > 0");
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ReserveIDBlockRunner
        extends JDBCSupport.JDBCTxRunner2<Long> {
            ReserveIDBlockRunner() {
                super(JDBCPersistenceManager.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long doTransaction() throws Exception {
                ResultSet rs;
                PreparedStatement ps;
                block6: {
                    Long l;
                    String selectCounterSQL = JDBCPersistenceManager.this.getSQLStatement("SELECT_COUNTER");
                    ps = null;
                    rs = null;
                    try {
                        ps = this.conn.prepareStatement(selectCounterSQL);
                        ps.setString(1, counterName);
                        rs = ps.executeQuery();
                        if (JDBCPersistenceManager.this.trace) {
                            log.trace((Object)JDBCUtil.statementToString(selectCounterSQL, counterName));
                        }
                        if (rs.next()) break block6;
                        rs.close();
                        ps.close();
                        String insertCounterSQL = JDBCPersistenceManager.this.getSQLStatement("INSERT_COUNTER");
                        ps = this.conn.prepareStatement(insertCounterSQL);
                        ps.setString(1, counterName);
                        ps.setLong(2, size);
                        int rows = ps.executeUpdate();
                        if (JDBCPersistenceManager.this.trace) {
                            log.trace((Object)(JDBCUtil.statementToString(insertCounterSQL, counterName, new Integer(size)) + " inserted " + rows + " rows"));
                        }
                        l = 0L;
                    }
                    catch (Throwable throwable) {
                        JDBCPersistenceManager.this.closeResultSet(rs);
                        JDBCPersistenceManager.this.closeStatement(ps);
                        throw throwable;
                    }
                    JDBCPersistenceManager.this.closeResultSet(rs);
                    JDBCPersistenceManager.this.closeStatement(ps);
                    return l;
                }
                long nextId = rs.getLong(1);
                rs.close();
                ps.close();
                String updateCounterSQL = JDBCPersistenceManager.this.getSQLStatement("UPDATE_COUNTER");
                ps = this.conn.prepareStatement(updateCounterSQL);
                ps.setLong(1, nextId + (long)size);
                ps.setString(2, counterName);
                int rows = ps.executeUpdate();
                if (JDBCPersistenceManager.this.trace) {
                    log.trace((Object)(JDBCUtil.statementToString(updateCounterSQL, new Long(nextId + (long)size), counterName) + " updated " + rows + " rows"));
                }
                Long l = nextId;
                JDBCPersistenceManager.this.closeResultSet(rs);
                JDBCPersistenceManager.this.closeStatement(ps);
                return l;
            }
        }
        return (Long)new ReserveIDBlockRunner().executeWithRetry();
    }

    public List getMessages(final List messageIds) throws Exception {
        if (this.trace) {
            log.trace((Object)("Getting batch of messages for " + messageIds));
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class GetMessageListTX
        extends JDBCSupport.JDBCTxRunner2<List> {
            GetMessageListTX() {
                super(JDBCPersistenceManager.this);
            }

            @Override
            public List<Message> doTransaction() throws Exception {
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    Iterator iter = messageIds.iterator();
                    int size = messageIds.size();
                    int count = 0;
                    ArrayList<Message> msgs = new ArrayList<Message>();
                    while (iter.hasNext()) {
                        if (ps == null) {
                            int numParams = count < size / JDBCPersistenceManager.this.maxParams * JDBCPersistenceManager.this.maxParams ? JDBCPersistenceManager.this.maxParams : size % JDBCPersistenceManager.this.maxParams;
                            StringBuffer buff = new StringBuffer(JDBCPersistenceManager.this.getSQLStatement("LOAD_MESSAGES"));
                            buff.append(" WHERE ").append(JDBCPersistenceManager.this.getSQLStatement("MESSAGE_ID_COLUMN")).append(" IN (");
                            for (int i = 0; i < numParams; ++i) {
                                buff.append("?");
                                if (i >= numParams - 1) continue;
                                buff.append(",");
                            }
                            buff.append(")");
                            ps = this.conn.prepareStatement(buff.toString());
                            if (JDBCPersistenceManager.this.trace) {
                                log.trace((Object)buff.toString());
                            }
                        }
                        long msgId = (Long)iter.next();
                        ps.setLong(count % JDBCPersistenceManager.this.maxParams + 1, msgId);
                        if (iter.hasNext() && ++count % JDBCPersistenceManager.this.maxParams != 0) continue;
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            long messageId = rs.getLong(1);
                            boolean reliable = rs.getString(2).equals("Y");
                            long expiration = rs.getLong(3);
                            long timestamp = rs.getLong(4);
                            byte priority = rs.getByte(5);
                            byte[] bytes = JDBCPersistenceManager.this.getBytes(rs, 6);
                            HashMap headers = JDBCPersistenceManager.this.bytesToMap(bytes);
                            byte[] payload = JDBCPersistenceManager.this.getBytes(rs, 7);
                            byte type = rs.getByte(8);
                            Message m = MessageFactory.createMessage(messageId, reliable, expiration, timestamp, priority, headers, payload, type);
                            msgs.add(m);
                        }
                        rs.close();
                        ps.close();
                        ps = null;
                    }
                    if (JDBCPersistenceManager.this.trace) {
                        log.trace((Object)("Loaded " + msgs.size() + " messages in total"));
                    }
                    ArrayList<Message> arrayList = msgs;
                    return arrayList;
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    JDBCPersistenceManager.this.closeResultSet(rs);
                    JDBCPersistenceManager.this.closeStatement(ps);
                }
            }
        }
        return (List)new GetMessageListTX().executeWithRetry();
    }

    public void pageReferences(final long channelID, final List references, final boolean page) throws Exception {
        if (this.trace) {
            log.trace((Object)("Paging references in channel " + channelID + " refs " + references.size()));
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PageReferencesRunner
        extends JDBCSupport.JDBCTxRunner2 {
            PageReferencesRunner() {
                super(JDBCPersistenceManager.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doTransaction() throws Exception {
                Object var5_5;
                PreparedStatement psInsertReference = null;
                PreparedStatement psInsertMessage = null;
                PreparedStatement psUpdateMessage = null;
                try {
                    Iterator iter = references.iterator();
                    psInsertReference = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("INSERT_MESSAGE_REF"));
                    if (JDBCPersistenceManager.this.supportsBlobSelect) {
                        psInsertMessage = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("INSERT_MESSAGE_CONDITIONAL_FULL"));
                    } else {
                        psInsertMessage = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("INSERT_MESSAGE_CONDITIONAL"));
                        psUpdateMessage = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("UPDATE_MESSAGE_4CONDITIONAL"));
                    }
                    while (iter.hasNext()) {
                        MessageReference ref = (MessageReference)iter.next();
                        log.trace((Object)("Paged ref with page order " + ref.getPagingOrder()));
                        JDBCPersistenceManager.this.addReference(channelID, ref, psInsertReference, page);
                        int rows = psInsertReference.executeUpdate();
                        if (JDBCPersistenceManager.this.trace) {
                            log.trace((Object)("Inserted " + rows + " rows"));
                        }
                        Message m = ref.getMessage();
                        rows = JDBCPersistenceManager.this.storeMessage(m, psInsertMessage, psUpdateMessage);
                        if (!JDBCPersistenceManager.this.trace) continue;
                        log.trace((Object)("Inserted " + rows + " rows"));
                    }
                    var5_5 = null;
                }
                catch (Throwable throwable) {
                    JDBCPersistenceManager.this.closeStatement(psInsertReference);
                    JDBCPersistenceManager.this.closeStatement(psInsertMessage);
                    JDBCPersistenceManager.this.closeStatement(psUpdateMessage);
                    throw throwable;
                }
                JDBCPersistenceManager.this.closeStatement(psInsertReference);
                JDBCPersistenceManager.this.closeStatement(psInsertMessage);
                JDBCPersistenceManager.this.closeStatement(psUpdateMessage);
                return var5_5;
            }
        }
        new PageReferencesRunner().executeWithRetry();
    }

    public void removeDepagedReferences(final long channelID, final List references) throws Exception {
        if (this.trace) {
            log.trace((Object)(this + " Removing depaged " + references.size() + " refs from channel " + channelID));
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class RemoveDepagedReferencesRunner
        extends JDBCSupport.JDBCTxRunner2 {
            RemoveDepagedReferencesRunner() {
                super(JDBCPersistenceManager.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doTransaction() throws Exception {
                Object var3_3;
                PreparedStatement psDeleteReference = null;
                try {
                    psDeleteReference = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("DELETE_MESSAGE_REF"));
                    for (MessageReference ref : references) {
                        JDBCPersistenceManager.this.removeReference(channelID, ref, psDeleteReference);
                        int rows = psDeleteReference.executeUpdate();
                        if (!JDBCPersistenceManager.this.trace) continue;
                        log.trace((Object)("Deleted " + rows + " references"));
                    }
                    var3_3 = null;
                }
                catch (Throwable throwable) {
                    JDBCPersistenceManager.this.closeStatement(psDeleteReference);
                    throw throwable;
                }
                JDBCPersistenceManager.this.closeStatement(psDeleteReference);
                return var3_3;
            }
        }
        new RemoveDepagedReferencesRunner().executeWithRetry();
        this.deleteMessages(references);
    }

    public void updateReferencesNotPagedInRange(final long channelID, final long orderStart, final long orderEnd, final long num) throws Exception {
        if (this.trace) {
            log.trace((Object)("Updating paged references for channel " + channelID + " between " + orderStart + " and " + orderEnd));
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UpdateReferencesNotPagedInRangeRunner
        extends JDBCSupport.JDBCTxRunner2 {
            UpdateReferencesNotPagedInRangeRunner() {
                super(JDBCPersistenceManager.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doTransaction() throws Exception {
                Object var3_3;
                PreparedStatement ps = null;
                try {
                    ps = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("UPDATE_REFS_NOT_PAGED"));
                    ps.setLong(1, orderStart);
                    ps.setLong(2, orderEnd);
                    ps.setLong(3, channelID);
                    int rows = ps.executeUpdate();
                    if (JDBCPersistenceManager.this.trace) {
                        log.trace((Object)(JDBCUtil.statementToString(JDBCPersistenceManager.this.getSQLStatement("UPDATE_REFS_NOT_PAGED"), new Long(channelID), new Long(orderStart), new Long(orderEnd)) + " updated " + rows + " rows"));
                    }
                    if ((long)rows != num) {
                        throw new IllegalStateException("Did not update correct number of rows");
                    }
                    var3_3 = null;
                }
                catch (Throwable throwable) {
                    JDBCPersistenceManager.this.closeStatement(ps);
                    throw throwable;
                }
                JDBCPersistenceManager.this.closeStatement(ps);
                return var3_3;
            }
        }
        new UpdateReferencesNotPagedInRangeRunner().executeWithRetry();
    }

    public void updatePageOrder(final long channelID, final List references) throws Exception {
        if (this.trace) {
            log.trace((Object)("Updating page order for channel:" + channelID));
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UpdatePageOrderRunner
        extends JDBCSupport.JDBCTxRunner2 {
            UpdatePageOrderRunner() {
                super(JDBCPersistenceManager.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doTransaction() throws Exception {
                Object var3_3;
                PreparedStatement psUpdateReference = null;
                try {
                    Iterator iter = references.iterator();
                    psUpdateReference = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("UPDATE_PAGE_ORDER"));
                    while (iter.hasNext()) {
                        MessageReference ref = (MessageReference)iter.next();
                        psUpdateReference.setLong(1, ref.getPagingOrder());
                        psUpdateReference.setLong(2, ref.getMessage().getMessageID());
                        psUpdateReference.setLong(3, channelID);
                        int rows = psUpdateReference.executeUpdate();
                        if (!JDBCPersistenceManager.this.trace) continue;
                        log.trace((Object)("Updated " + rows + " rows"));
                    }
                    var3_3 = null;
                }
                catch (Throwable throwable) {
                    JDBCPersistenceManager.this.closeStatement(psUpdateReference);
                    throw throwable;
                }
                JDBCPersistenceManager.this.closeStatement(psUpdateReference);
                return var3_3;
            }
        }
        new UpdatePageOrderRunner().executeWithRetry();
    }

    public List getPagedReferenceInfos(long channelID, long orderStart, int number) throws Exception {
        ArrayList<PersistenceManager.ReferenceInfo> arrayList;
        if (this.trace) {
            log.trace((Object)("loading message reference info for channel " + channelID + " from " + orderStart + " number " + number));
        }
        ArrayList<PersistenceManager.ReferenceInfo> refs = new ArrayList<PersistenceManager.ReferenceInfo>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        JDBCSupport.TransactionWrapper wrap = new JDBCSupport.TransactionWrapper(this);
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(this.getSQLStatement("LOAD_PAGED_REFS"));
            ps.setLong(1, channelID);
            ps.setLong(2, orderStart);
            ps.setLong(3, orderStart + (long)number - 1L);
            rs = ps.executeQuery();
            long ord = orderStart;
            while (rs.next()) {
                long msgId = rs.getLong(1);
                int deliveryCount = rs.getInt(2);
                int pageOrd = rs.getInt(3);
                long sched = rs.getLong(4);
                if ((long)pageOrd != ord) {
                    throw new IllegalStateException("Unexpected pageOrd: " + pageOrd + " expected: " + ord);
                }
                PersistenceManager.ReferenceInfo ri = new PersistenceManager.ReferenceInfo(msgId, deliveryCount, sched);
                refs.add(ri);
                ++ord;
            }
            if (ord != orderStart + (long)number) {
                throw new IllegalStateException("Didn't load expected number of references, loaded: " + (ord - orderStart) + " expected: " + number);
            }
            arrayList = refs;
        }
        catch (Exception e) {
            try {
                wrap.exceptionOccurred();
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                this.closeConnection(conn);
                wrap.end();
                throw throwable;
            }
        }
        this.closeResultSet(rs);
        this.closeStatement(ps);
        this.closeConnection(conn);
        wrap.end();
        return arrayList;
    }

    public PersistenceManager.InitialLoadInfo loadFromStart(long channelID, int number) throws Exception {
        PersistenceManager.InitialLoadInfo initialLoadInfo;
        if (this.trace) {
            log.trace((Object)("loading initial reference infos for channel " + channelID));
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        JDBCSupport.TransactionWrapper wrap = new JDBCSupport.TransactionWrapper(this);
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(this.getSQLStatement("SELECT_MIN_MAX_PAGE_ORD"));
            ps.setLong(1, channelID);
            rs = ps.executeQuery();
            rs.next();
            Long minOrdering = new Long(rs.getLong(1));
            if (rs.wasNull()) {
                minOrdering = null;
            }
            Long maxOrdering = new Long(rs.getLong(2));
            if (rs.wasNull()) {
                maxOrdering = null;
            }
            ps.close();
            ps = conn.prepareStatement(this.getSQLStatement("LOAD_UNPAGED_REFS"));
            ps.setLong(1, channelID);
            rs = ps.executeQuery();
            ArrayList<PersistenceManager.ReferenceInfo> refs = new ArrayList<PersistenceManager.ReferenceInfo>();
            ArrayList<PersistenceManager.ReferenceInfo> refsToUpdate = new ArrayList<PersistenceManager.ReferenceInfo>();
            int count = 0;
            while (rs.next()) {
                long msgId = rs.getLong(1);
                int deliveryCount = rs.getInt(2);
                long sched = rs.getLong(3);
                PersistenceManager.ReferenceInfo ri = new PersistenceManager.ReferenceInfo(msgId, deliveryCount, sched);
                if (count < number) {
                    refs.add(ri);
                } else {
                    refsToUpdate.add(ri);
                }
                ++count;
            }
            if (!refsToUpdate.isEmpty()) {
                ps.close();
                ps = conn.prepareStatement(this.getSQLStatement("UPDATE_PAGE_ORDER"));
                Iterator iter = refsToUpdate.iterator();
                long ordering = 0L;
                if (maxOrdering != null) {
                    ordering = maxOrdering + 1L;
                }
                while (iter.hasNext()) {
                    PersistenceManager.ReferenceInfo ri = (PersistenceManager.ReferenceInfo)iter.next();
                    ps.setLong(1, ordering);
                    ps.setLong(2, ri.getMessageId());
                    ps.setLong(3, channelID);
                    int rows = ps.executeUpdate();
                    if (this.trace) {
                        log.trace((Object)("Updated " + rows + " rows"));
                    }
                    ++ordering;
                }
                if (minOrdering == null) {
                    minOrdering = new Long(0L);
                }
                maxOrdering = new Long(ordering - 1L);
            }
            initialLoadInfo = new PersistenceManager.InitialLoadInfo(minOrdering, maxOrdering, refs);
        }
        catch (Exception e) {
            try {
                wrap.exceptionOccurred();
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                this.closeConnection(conn);
                wrap.end();
                throw throwable;
            }
        }
        this.closeResultSet(rs);
        this.closeStatement(ps);
        this.closeConnection(conn);
        wrap.end();
        return initialLoadInfo;
    }

    public void mergeTransactions(final long fromChannelID, final long toChannelID) throws Exception {
        if (this.trace) {
            log.trace((Object)("Merging transactions from channel " + fromChannelID + " to " + toChannelID));
        }
        if (fromChannelID == toChannelID) {
            throw new IllegalArgumentException("Cannot merge transactions - they have the same channel id!!");
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MergeTransactionsRunner
        extends JDBCSupport.JDBCTxRunner2 {
            MergeTransactionsRunner() {
                super(JDBCPersistenceManager.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doTransaction() throws Exception {
                Object var3_3;
                PreparedStatement statement = null;
                try {
                    statement = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("UPDATE_TX"));
                    statement.setLong(1, toChannelID);
                    statement.setLong(2, fromChannelID);
                    int affected = statement.executeUpdate();
                    log.debug((Object)("Merged " + affected + " transactions from channel " + fromChannelID + " into node " + toChannelID));
                    var3_3 = null;
                }
                catch (Throwable throwable) {
                    JDBCPersistenceManager.this.closeStatement(statement);
                    throw throwable;
                }
                JDBCPersistenceManager.this.closeStatement(statement);
                return var3_3;
            }
        }
        new MergeTransactionsRunner().executeWithRetry();
    }

    public PersistenceManager.InitialLoadInfo mergeAndLoad(final long fromChannelID, final long toChannelID, final int numberToLoad, final long firstPagingOrder, final long nextPagingOrder) throws Exception {
        if (this.trace) {
            log.trace((Object)("Merging channel from " + fromChannelID + " to " + toChannelID + " numberToLoad:" + numberToLoad + " firstPagingOrder:" + firstPagingOrder + " nextPagingOrder:" + nextPagingOrder));
        }
        if (fromChannelID == toChannelID) {
            throw new IllegalArgumentException("Cannot merge queues - they have the same channel id!!");
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MergeAndLoadRunner
        extends JDBCSupport.JDBCTxRunner2 {
            MergeAndLoadRunner() {
                super(JDBCPersistenceManager.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doTransaction() throws Exception {
                ArrayList<PersistenceManager.ReferenceInfo> refs;
                PreparedStatement ps2;
                ResultSet rs;
                PreparedStatement ps;
                block12: {
                    PersistenceManager.InitialLoadInfo initialLoadInfo;
                    ps = null;
                    rs = null;
                    ps2 = null;
                    try {
                        refs = new ArrayList<PersistenceManager.ReferenceInfo>();
                        ps = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("LOAD_REFS"));
                        ps.setLong(1, fromChannelID);
                        rs = ps.executeQuery();
                        int count = 0;
                        boolean arePaged = false;
                        long pageOrd = nextPagingOrder;
                        while (rs.next()) {
                            long msgId = rs.getLong(1);
                            int deliveryCount = rs.getInt(2);
                            long sched = rs.getLong(3);
                            if (count < numberToLoad) {
                                PersistenceManager.ReferenceInfo ri = new PersistenceManager.ReferenceInfo(msgId, deliveryCount, sched);
                                refs.add(ri);
                            }
                            if (ps2 == null) {
                                ps2 = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("UPDATE_PAGE_ORDER"));
                            }
                            if (count < numberToLoad) {
                                ps2.setNull(1, -5);
                                if (JDBCPersistenceManager.this.trace) {
                                    log.trace((Object)"Set page ord to null");
                                }
                            } else {
                                ps2.setLong(1, pageOrd);
                                if (JDBCPersistenceManager.this.trace) {
                                    log.trace((Object)("Set page ord to " + pageOrd));
                                }
                                arePaged = true;
                                ++pageOrd;
                            }
                            ps2.setLong(2, msgId);
                            ps2.setLong(3, fromChannelID);
                            int rows = ps2.executeUpdate();
                            if (JDBCPersistenceManager.this.trace) {
                                log.trace((Object)("Update page ord updated " + rows + " rows"));
                            }
                            ++count;
                        }
                        ps.close();
                        ps = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("UPDATE_CHANNEL_ID"));
                        ps.setLong(1, toChannelID);
                        ps.setLong(2, fromChannelID);
                        int rows = ps.executeUpdate();
                        if (JDBCPersistenceManager.this.trace) {
                            log.trace((Object)("Update channel id updated " + rows + " rows"));
                        }
                        if (!arePaged) break block12;
                        initialLoadInfo = new PersistenceManager.InitialLoadInfo(new Long(firstPagingOrder), new Long(pageOrd - 1L), refs);
                    }
                    catch (Throwable throwable) {
                        JDBCPersistenceManager.this.closeResultSet(rs);
                        JDBCPersistenceManager.this.closeStatement(ps);
                        JDBCPersistenceManager.this.closeStatement(ps2);
                        throw throwable;
                    }
                    JDBCPersistenceManager.this.closeResultSet(rs);
                    JDBCPersistenceManager.this.closeStatement(ps);
                    JDBCPersistenceManager.this.closeStatement(ps2);
                    return initialLoadInfo;
                }
                PersistenceManager.InitialLoadInfo initialLoadInfo = new PersistenceManager.InitialLoadInfo(null, null, refs);
                JDBCPersistenceManager.this.closeResultSet(rs);
                JDBCPersistenceManager.this.closeStatement(ps);
                JDBCPersistenceManager.this.closeStatement(ps2);
                return initialLoadInfo;
            }
        }
        return (PersistenceManager.InitialLoadInfo)new MergeAndLoadRunner().executeWithRetry();
    }

    public void testSpeed() throws Exception {
    }

    public void addReference(final long channelID, final MessageReference ref, Transaction tx) throws Exception {
        if (this.trace) {
            log.trace((Object)("Adding reference " + ref + " in channel " + channelID + " tx " + tx));
        }
        if (tx != null) {
            TransactionCallback callback = this.getCallback(tx);
            callback.addReferenceToAdd(channelID, ref);
        } else {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class AddReferenceRunner
            extends JDBCSupport.JDBCTxRunner2 {
                AddReferenceRunner() {
                    super(JDBCPersistenceManager.this);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object doTransaction() throws Exception {
                    Object var5_5;
                    PreparedStatement psReference = null;
                    PreparedStatement psInsertMessage = null;
                    Message m = ref.getMessage();
                    try {
                        psReference = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("INSERT_MESSAGE_REF"));
                        JDBCPersistenceManager.this.addReference(channelID, ref, psReference, false);
                        int rows = psReference.executeUpdate();
                        if (JDBCPersistenceManager.this.trace) {
                            log.trace((Object)("Inserted " + rows + " rows"));
                        }
                        if (!m.isPersisted()) {
                            psInsertMessage = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("INSERT_MESSAGE"));
                            JDBCPersistenceManager.this.storeMessage(m, psInsertMessage, true);
                            rows = psInsertMessage.executeUpdate();
                            if (JDBCPersistenceManager.this.trace) {
                                log.trace((Object)("Inserted/updated " + rows + " rows"));
                            }
                            log.trace((Object)("message Inserted/updated " + rows + " rows"));
                            m.setPersisted(true);
                        }
                        var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        JDBCPersistenceManager.this.closeStatement(psReference);
                        JDBCPersistenceManager.this.closeStatement(psInsertMessage);
                        throw throwable;
                    }
                    JDBCPersistenceManager.this.closeStatement(psReference);
                    JDBCPersistenceManager.this.closeStatement(psInsertMessage);
                    return var5_5;
                }
            }
            new AddReferenceRunner().executeWithRetry();
        }
    }

    public void moveReference(final long sourceChannelID, final long destChannelID, final MessageReference ref) throws Exception {
        if (this.trace) {
            log.trace((Object)("Moving reference " + ref + " from " + sourceChannelID + " to " + destChannelID));
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MoveReferenceRunner
        extends JDBCSupport.JDBCTxRunner2 {
            MoveReferenceRunner() {
                super(JDBCPersistenceManager.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doTransaction() throws Exception {
                Object var3_3;
                PreparedStatement psReference = null;
                try {
                    psReference = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("MOVE_REFERENCE"));
                    psReference.setLong(1, destChannelID);
                    psReference.setLong(2, ref.getMessage().getMessageID());
                    psReference.setLong(3, sourceChannelID);
                    int rows = psReference.executeUpdate();
                    if (JDBCPersistenceManager.this.trace) {
                        log.trace((Object)("Updated " + rows + " rows"));
                    }
                    var3_3 = null;
                }
                catch (Throwable throwable) {
                    JDBCPersistenceManager.this.closeStatement(psReference);
                    throw throwable;
                }
                JDBCPersistenceManager.this.closeStatement(psReference);
                return var3_3;
            }
        }
        new MoveReferenceRunner().executeWithRetry();
    }

    public void updateDeliveryCount(final long channelID, final MessageReference ref) throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UpdateDeliveryCountRunner
        extends JDBCSupport.JDBCTxRunner2 {
            UpdateDeliveryCountRunner() {
                super(JDBCPersistenceManager.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doTransaction() throws Exception {
                Object var3_3;
                PreparedStatement psReference = null;
                try {
                    psReference = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("UPDATE_DELIVERY_COUNT"));
                    psReference.setInt(1, ref.getDeliveryCount());
                    psReference.setLong(2, ref.getMessage().getMessageID());
                    psReference.setLong(3, channelID);
                    int rows = psReference.executeUpdate();
                    if (JDBCPersistenceManager.this.trace) {
                        log.trace((Object)("Updated " + rows + " rows"));
                    }
                    var3_3 = null;
                }
                catch (Throwable throwable) {
                    JDBCPersistenceManager.this.closeStatement(psReference);
                    throw throwable;
                }
                JDBCPersistenceManager.this.closeStatement(psReference);
                return var3_3;
            }
        }
        new UpdateDeliveryCountRunner().executeWithRetry();
    }

    public void removeReference(final long channelID, final MessageReference ref, Transaction tx) throws Exception {
        if (this.trace) {
            log.trace((Object)("Removing reference " + ref + " in channel " + channelID + " tx " + tx));
        }
        if (tx != null) {
            TransactionCallback callback = this.getCallback(tx);
            callback.addReferenceToRemove(channelID, ref);
        } else {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class RemoveReferenceRunner
            extends JDBCSupport.JDBCTxRunner2 {
                RemoveReferenceRunner() {
                    super(JDBCPersistenceManager.this);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object doTransaction() throws Exception {
                    int rows;
                    PreparedStatement psReference;
                    block4: {
                        Object var3_3;
                        psReference = null;
                        try {
                            psReference = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("DELETE_MESSAGE_REF"));
                            JDBCPersistenceManager.this.removeReference(channelID, ref, psReference);
                            rows = psReference.executeUpdate();
                            if (rows == 1) break block4;
                            log.warn((Object)("Failed to remove row for: " + ref));
                            var3_3 = null;
                        }
                        catch (Throwable throwable) {
                            JDBCPersistenceManager.this.closeStatement(psReference);
                            throw throwable;
                        }
                        JDBCPersistenceManager.this.closeStatement(psReference);
                        return var3_3;
                    }
                    if (JDBCPersistenceManager.this.trace) {
                        log.trace((Object)("Deleted " + rows + " references"));
                    }
                    Object var3_4 = null;
                    JDBCPersistenceManager.this.closeStatement(psReference);
                    return var3_4;
                }
            }
            new RemoveReferenceRunner().executeWithRetry();
            this.deleteMessage(ref.getMessage().getMessageID());
        }
    }

    public boolean referenceExists(long messageID) throws Exception {
        boolean bl;
        JDBCSupport.TransactionWrapper wrap;
        ResultSet rs;
        PreparedStatement st;
        Connection conn;
        block5: {
            conn = null;
            st = null;
            rs = null;
            wrap = new JDBCSupport.TransactionWrapper(this);
            conn = this.ds.getConnection();
            st = conn.prepareStatement(this.getSQLStatement("SELECT_EXISTS_REF_MESSAGE_ID"));
            st.setLong(1, messageID);
            rs = st.executeQuery();
            if (!rs.next()) break block5;
            boolean bl2 = true;
            this.closeResultSet(rs);
            this.closeStatement(st);
            this.closeConnection(conn);
            wrap.end();
            return bl2;
        }
        try {
            bl = false;
        }
        catch (Exception e) {
            try {
                wrap.exceptionOccurred();
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(st);
                this.closeConnection(conn);
                wrap.end();
                throw throwable;
            }
        }
        this.closeResultSet(rs);
        this.closeStatement(st);
        this.closeConnection(conn);
        wrap.end();
        return bl;
    }

    public String toString() {
        return "JDBCPersistenceManager[" + Integer.toHexString(this.hashCode()) + "]";
    }

    protected TransactionCallback getCallback(Transaction tx) {
        TransactionCallback callback = (TransactionCallback)tx.getCallback(this);
        if (callback == null) {
            callback = new TransactionCallback(tx);
            tx.addCallback(callback, this);
        }
        return callback;
    }

    protected void handleBeforeCommit1PC(final List refsToAdd, final List refsToRemove, Transaction tx) throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class HandleBeforeCommit1PCRunner
        extends JDBCSupport.JDBCTxRunner2 {
            HandleBeforeCommit1PCRunner() {
                super(JDBCPersistenceManager.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doTransaction() throws Exception {
                PreparedStatement psReference = null;
                PreparedStatement psInsertMessage = null;
                PreparedStatement psDeleteReference = null;
                ArrayList<Message> messagesStored = new ArrayList<Message>();
                try {
                    for (ChannelRefPair pair : refsToAdd) {
                        Message m;
                        MessageReference ref = pair.ref;
                        psReference = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("INSERT_MESSAGE_REF"));
                        JDBCPersistenceManager.this.addReference(pair.channelID, ref, psReference, false);
                        int rows = psReference.executeUpdate();
                        if (JDBCPersistenceManager.this.trace) {
                            log.trace((Object)("Inserted " + rows + " rows"));
                        }
                        Message message = m = ref.getMessage();
                        synchronized (message) {
                            if (!m.isPersisted()) {
                                if (psInsertMessage == null) {
                                    psInsertMessage = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("INSERT_MESSAGE"));
                                }
                                if (JDBCPersistenceManager.this.trace) {
                                    log.trace((Object)"Message does not already exist so inserting it");
                                }
                                JDBCPersistenceManager.this.storeMessage(m, psInsertMessage, true);
                                rows = psInsertMessage.executeUpdate();
                                if (JDBCPersistenceManager.this.trace) {
                                    log.trace((Object)("Inserted " + rows + " rows"));
                                }
                                m.setPersisted(true);
                                messagesStored.add(m);
                            }
                        }
                    }
                    for (ChannelRefPair pair : refsToRemove) {
                        if (psDeleteReference == null) {
                            psDeleteReference = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("DELETE_MESSAGE_REF"));
                        }
                        JDBCPersistenceManager.this.removeReference(pair.channelID, pair.ref, psDeleteReference);
                        int rows = psDeleteReference.executeUpdate();
                        if (!JDBCPersistenceManager.this.trace) continue;
                        log.trace((Object)("Deleted " + rows + " references"));
                    }
                    Iterator i = null;
                    return i;
                }
                catch (Exception e) {
                    for (Message msg : messagesStored) {
                        msg.setPersisted(false);
                    }
                    throw e;
                }
                finally {
                    JDBCPersistenceManager.this.closeStatement(psReference);
                    JDBCPersistenceManager.this.closeStatement(psDeleteReference);
                    JDBCPersistenceManager.this.closeStatement(psInsertMessage);
                }
            }
        }
        new HandleBeforeCommit1PCRunner().executeWithRetry();
        this.deleteMessages(refsToRemove);
    }

    protected void handleBeforeCommit2PC(List refsToRemove, final Transaction tx) throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class HandleBeforeCommit2PCRunner
        extends JDBCSupport.JDBCTxRunner2 {
            HandleBeforeCommit2PCRunner() {
                super(JDBCPersistenceManager.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doTransaction() throws Exception {
                Object var3_3;
                PreparedStatement ps = null;
                if (JDBCPersistenceManager.this.trace) {
                    log.trace((Object)(this + " commitPreparedTransaction, tx= " + tx));
                }
                try {
                    ps = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("COMMIT_MESSAGE_REF1"));
                    ps.setLong(1, tx.getId());
                    int rows = ps.executeUpdate();
                    if (JDBCPersistenceManager.this.trace) {
                        log.trace((Object)(JDBCUtil.statementToString(JDBCPersistenceManager.this.getSQLStatement("COMMIT_MESSAGE_REF1"), new Long(tx.getId())) + " removed " + rows + " row(s)"));
                    }
                    ps.close();
                    ps = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("COMMIT_MESSAGE_REF2"));
                    ps.setLong(1, tx.getId());
                    rows = ps.executeUpdate();
                    if (JDBCPersistenceManager.this.trace) {
                        log.trace((Object)(JDBCUtil.statementToString(JDBCPersistenceManager.this.getSQLStatement("COMMIT_MESSAGE_REF2"), new Long(tx.getId())) + " updated " + rows + " row(s)"));
                    }
                    JDBCPersistenceManager.this.removeTXRecord(this.conn, tx);
                    var3_3 = null;
                }
                catch (Throwable throwable) {
                    JDBCPersistenceManager.this.closeStatement(ps);
                    throw throwable;
                }
                JDBCPersistenceManager.this.closeStatement(ps);
                return var3_3;
            }
        }
        new HandleBeforeCommit2PCRunner().executeWithRetry();
        this.deleteMessages(refsToRemove);
    }

    protected void handleBeforePrepare(final List refsToAdd, final List refsToRemove, final Transaction tx) throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class HandleBeforePrepareRunner
        extends JDBCSupport.JDBCTxRunner2 {
            HandleBeforePrepareRunner() {
                super(JDBCPersistenceManager.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doTransaction() throws Exception {
                ChannelRefPair pair2;
                PreparedStatement psReference = null;
                PreparedStatement psInsertMessage = null;
                PreparedStatement psUpdateReference = null;
                ArrayList<Message> messagesStored = new ArrayList<Message>();
                try {
                    int rows;
                    if (!refsToAdd.isEmpty() || !refsToRemove.isEmpty()) {
                        JDBCPersistenceManager.this.addTXRecord(this.conn, tx);
                    }
                    for (ChannelRefPair pair2 : refsToAdd) {
                        Message m;
                        if (psReference == null) {
                            psReference = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("INSERT_MESSAGE_REF"));
                        }
                        JDBCPersistenceManager.this.prepareToAddReference(pair2.channelID, pair2.ref, tx, psReference);
                        rows = psReference.executeUpdate();
                        if (JDBCPersistenceManager.this.trace) {
                            log.trace((Object)("Inserted " + rows + " rows"));
                        }
                        Message message = m = pair2.ref.getMessage();
                        synchronized (message) {
                            if (!m.isPersisted()) {
                                if (psInsertMessage == null) {
                                    psInsertMessage = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("INSERT_MESSAGE"));
                                }
                                JDBCPersistenceManager.this.storeMessage(m, psInsertMessage, true);
                                rows = psInsertMessage.executeUpdate();
                                if (JDBCPersistenceManager.this.trace) {
                                    log.trace((Object)("Inserted " + rows + " rows"));
                                }
                                m.setPersisted(true);
                                messagesStored.add(m);
                            }
                        }
                    }
                    Iterator iter = refsToRemove.iterator();
                    while (iter.hasNext()) {
                        if (psUpdateReference == null) {
                            psUpdateReference = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("UPDATE_MESSAGE_REF"));
                        }
                        pair2 = (ChannelRefPair)iter.next();
                        JDBCPersistenceManager.this.prepareToRemoveReference(pair2.channelID, pair2.ref, tx, psUpdateReference);
                        rows = psUpdateReference.executeUpdate();
                        if (!JDBCPersistenceManager.this.trace) continue;
                        log.trace((Object)("updated " + rows + " rows"));
                    }
                    pair2 = null;
                }
                catch (Exception e) {
                    try {
                        for (Message msg : messagesStored) {
                            msg.setPersisted(false);
                        }
                        throw e;
                    }
                    catch (Throwable throwable) {
                        JDBCPersistenceManager.this.closeStatement(psReference);
                        JDBCPersistenceManager.this.closeStatement(psInsertMessage);
                        JDBCPersistenceManager.this.closeStatement(psUpdateReference);
                        throw throwable;
                    }
                }
                JDBCPersistenceManager.this.closeStatement(psReference);
                JDBCPersistenceManager.this.closeStatement(psInsertMessage);
                JDBCPersistenceManager.this.closeStatement(psUpdateReference);
                return pair2;
            }
        }
        new HandleBeforePrepareRunner().executeWithRetry();
    }

    protected void handleBeforeRollback(List refsToAdd, final Transaction tx) throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class HandleBeforeRollbackRunner
        extends JDBCSupport.JDBCTxRunner2 {
            HandleBeforeRollbackRunner() {
                super(JDBCPersistenceManager.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doTransaction() throws Exception {
                Object var3_3;
                PreparedStatement ps = null;
                try {
                    ps = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("ROLLBACK_MESSAGE_REF1"));
                    ps.setLong(1, tx.getId());
                    int rows = ps.executeUpdate();
                    if (JDBCPersistenceManager.this.trace) {
                        log.trace((Object)(JDBCUtil.statementToString(JDBCPersistenceManager.this.getSQLStatement("ROLLBACK_MESSAGE_REF1"), new Long(tx.getId())) + " removed " + rows + " row(s)"));
                    }
                    ps.close();
                    ps = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("ROLLBACK_MESSAGE_REF2"));
                    ps.setLong(1, tx.getId());
                    rows = ps.executeUpdate();
                    if (JDBCPersistenceManager.this.trace) {
                        log.trace((Object)(JDBCUtil.statementToString(JDBCPersistenceManager.this.getSQLStatement("ROLLBACK_MESSAGE_REF2"), new Long(tx.getId())) + " updated " + rows + " row(s)"));
                    }
                    JDBCPersistenceManager.this.removeTXRecord(this.conn, tx);
                    var3_3 = null;
                }
                catch (Throwable throwable) {
                    JDBCPersistenceManager.this.closeStatement(ps);
                    throw throwable;
                }
                JDBCPersistenceManager.this.closeStatement(ps);
                return var3_3;
            }
        }
        new HandleBeforeRollbackRunner().executeWithRetry();
        this.deleteMessages(refsToAdd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addTXRecord(Connection conn, Transaction tx) throws Exception {
        PreparedStatement ps;
        block5: {
            if (this.trace) {
                log.trace((Object)("Inserting tx record for " + tx));
            }
            if (!this.nodeIDSet) {
                throw new IllegalStateException("Node id has not been set");
            }
            ps = null;
            String statement = "UNDEFINED";
            int rows = -1;
            int formatID = -1;
            try {
                statement = this.getSQLStatement("INSERT_TRANSACTION");
                ps = conn.prepareStatement(statement);
                ps.setInt(1, this.nodeID);
                ps.setLong(2, tx.getId());
                Xid xid = tx.getXid();
                formatID = xid.getFormatId();
                this.setVarBinaryColumn(3, ps, xid.getBranchQualifier());
                ps.setInt(4, formatID);
                this.setVarBinaryColumn(5, ps, xid.getGlobalTransactionId());
                rows = ps.executeUpdate();
                if (!this.trace) break block5;
            }
            catch (Throwable throwable) {
                if (this.trace) {
                    String s = JDBCUtil.statementToString(statement, new Integer(this.nodeID), new Long(tx.getId()), "<byte-array>", new Integer(formatID), "<byte-array>");
                    log.trace((Object)(s + (rows == -1 ? " failed!" : " inserted " + rows + " row(s)")));
                }
                this.closeStatement(ps);
                throw throwable;
            }
            String s = JDBCUtil.statementToString(statement, new Integer(this.nodeID), new Long(tx.getId()), "<byte-array>", new Integer(formatID), "<byte-array>");
            log.trace((Object)(s + (rows == -1 ? " failed!" : " inserted " + rows + " row(s)")));
        }
        this.closeStatement(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTXRecord(Connection conn, Transaction tx) throws Exception {
        if (!this.nodeIDSet) {
            throw new IllegalStateException("Node id has not been set");
        }
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.getSQLStatement("DELETE_TRANSACTION"));
            ps.setInt(1, this.nodeID);
            ps.setLong(2, tx.getId());
            int rows = ps.executeUpdate();
            if (this.trace) {
                log.trace((Object)(JDBCUtil.statementToString(this.getSQLStatement("DELETE_TRANSACTION"), new Integer(this.nodeID), new Long(tx.getId())) + " removed " + rows + " row(s)"));
            }
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeStatement(ps);
    }

    protected void addReference(long channelID, MessageReference ref, PreparedStatement ps, boolean paged) throws Exception {
        if (this.trace) {
            log.trace((Object)("adding " + ref + " to channel " + channelID));
        }
        ps.setLong(1, channelID);
        ps.setLong(2, ref.getMessage().getMessageID());
        ps.setNull(3, -5);
        ps.setString(4, "C");
        ps.setLong(5, this.getOrdering());
        if (paged) {
            ps.setLong(6, ref.getPagingOrder());
        } else {
            ps.setNull(6, -5);
        }
        ps.setInt(7, ref.getDeliveryCount());
        ps.setLong(8, ref.getScheduledDeliveryTime());
    }

    protected void removeReference(long channelID, MessageReference ref, PreparedStatement ps) throws Exception {
        if (this.trace) {
            log.trace((Object)("removing " + ref + " from channel " + channelID));
        }
        ps.setLong(1, ref.getMessage().getMessageID());
        ps.setLong(2, channelID);
    }

    protected void prepareToAddReference(long channelID, MessageReference ref, Transaction tx, PreparedStatement ps) throws Exception {
        if (this.trace) {
            log.trace((Object)("adding " + ref + " to channel " + channelID + (tx == null ? " non-transactionally" : " on transaction: " + tx)));
        }
        ps.setLong(1, channelID);
        ps.setLong(2, ref.getMessage().getMessageID());
        ps.setLong(3, tx.getId());
        ps.setString(4, "+");
        ps.setLong(5, this.getOrdering());
        ps.setNull(6, -5);
        ps.setInt(7, ref.getDeliveryCount());
        ps.setLong(8, ref.getScheduledDeliveryTime());
    }

    protected void prepareToRemoveReference(long channelID, MessageReference ref, Transaction tx, PreparedStatement ps) throws Exception {
        if (this.trace) {
            log.trace((Object)("removing " + ref + " from channel " + channelID + (tx == null ? " non-transactionally" : " on transaction: " + tx)));
        }
        ps.setLong(1, tx.getId());
        ps.setLong(2, ref.getMessage().getMessageID());
        ps.setLong(3, channelID);
    }

    protected byte[] mapToBytes(Map map) throws Exception {
        if (map == null || map.isEmpty()) {
            return null;
        }
        int BUFFER_SIZE = 1024;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        DataOutputStream oos = new DataOutputStream(bos);
        StreamUtils.writeMap(oos, map, true);
        oos.close();
        return bos.toByteArray();
    }

    protected HashMap bytesToMap(byte[] bytes) throws Exception {
        if (bytes == null) {
            return new HashMap();
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream dais = new DataInputStream(bis);
        HashMap map = StreamUtils.readMap(dais, true);
        dais.close();
        return map;
    }

    protected void storeMessage(Message m, PreparedStatement ps, boolean bindBlobs) throws Exception {
        ps.setLong(1, m.getMessageID());
        ps.setString(2, m.isReliable() ? "Y" : "N");
        ps.setLong(3, m.getExpiration());
        ps.setLong(4, m.getTimestamp());
        ps.setByte(5, m.getPriority());
        ps.setByte(6, m.getType());
        if (bindBlobs) {
            this.bindBlobs(m, ps, 7, 8);
        }
    }

    protected int storeMessage(Message message, PreparedStatement psInsertMessage, PreparedStatement psUpdateMessage) throws Exception {
        int rows;
        if (!this.supportsBlobSelect) {
            this.storeMessage(message, psInsertMessage, false);
            psInsertMessage.setLong(7, message.getMessageID());
            rows = psInsertMessage.executeUpdate();
            if (rows == 1) {
                this.bindBlobs(message, psUpdateMessage, 1, 2);
                psUpdateMessage.setLong(3, message.getMessageID());
                rows = psUpdateMessage.executeUpdate();
                if (rows != 1) {
                    throw new IllegalStateException("Couldn't update messageId=" + message.getMessageID() + " on paging");
                }
            }
        } else {
            this.storeMessage(message, psInsertMessage, true);
            psInsertMessage.setLong(9, message.getMessageID());
            rows = psInsertMessage.executeUpdate();
        }
        return rows;
    }

    private void bindBlobs(Message m, PreparedStatement ps, int headerPosition, int payloadPosition) throws Exception {
        byte[] bytes = this.mapToBytes(((MessageSupport)m).getHeaders());
        if (bytes != null) {
            this.setBytes(ps, headerPosition, bytes);
        } else {
            ps.setNull(headerPosition, -4);
        }
        byte[] payload = m.getPayloadAsByteArray();
        if (payload != null) {
            this.setBytes(ps, payloadPosition, payload);
        } else {
            ps.setNull(payloadPosition, -4);
        }
    }

    protected void setVarBinaryColumn(int column, PreparedStatement ps, byte[] bytes) throws Exception {
        if (this.usingTrailingByte) {
            byte[] res = new byte[bytes.length + 1];
            System.arraycopy(bytes, 0, res, 0, bytes.length);
            res[bytes.length] = 127;
            bytes = res;
        }
        ps.setBytes(column, bytes);
        if (this.trace) {
            log.trace((Object)("Setting varbinary column of length: " + bytes.length));
        }
    }

    protected byte[] getVarBinaryColumn(ResultSet rs, int columnIndex) throws Exception {
        byte[] bytes = rs.getBytes(columnIndex);
        if (this.usingTrailingByte) {
            byte[] newBytes = new byte[bytes.length - 1];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length - 1);
            bytes = newBytes;
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBytes(PreparedStatement ps, int columnIndex, byte[] bytes) throws Exception {
        if (this.usingBinaryStream) {
            ByteArrayInputStream is = null;
            try {
                is = new ByteArrayInputStream(bytes);
                ps.setBinaryStream(columnIndex, (InputStream)is, bytes.length);
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        } else {
            this.setVarBinaryColumn(columnIndex, ps, bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getBytes(ResultSet rs, int columnIndex) throws Exception {
        if (this.usingBinaryStream) {
            InputStream is = null;
            ByteArrayOutputStream os = null;
            int BUFFER_SIZE = 4096;
            try {
                int b;
                InputStream i = rs.getBinaryStream(columnIndex);
                if (i == null) {
                    byte[] byArray = null;
                    return byArray;
                }
                is = new BufferedInputStream(rs.getBinaryStream(columnIndex), 4096);
                os = new ByteArrayOutputStream(4096);
                while ((b = is.read()) != -1) {
                    os.write(b);
                }
                byte[] byArray = os.toByteArray();
                return byArray;
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
        }
        return this.getVarBinaryColumn(rs, columnIndex);
    }

    protected void logBatchUpdate(String name, int[] rows, String action) {
        int count = 0;
        for (int i = 0; i < rows.length; ++i) {
            count += rows[i];
        }
        log.trace((Object)("Batch update " + name + ", " + action + " total of " + count + " rows"));
    }

    protected Map getDefaultDDLStatements() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("CREATE_DUAL", "CREATE TABLE JBM_DUAL (DUMMY INTEGER)");
        map.put("CREATE_MESSAGE_REFERENCE", "CREATE TABLE JBM_MSG_REF (MESSAGE_ID BIGINT, CHANNEL_ID BIGINT, TRANSACTION_ID BIGINT, STATE CHAR(1), ORD BIGINT, PAGE_ORD BIGINT, DELIVERY_COUNT INTEGER, SCHED_DELIVERY BIGINT, PRIMARY KEY(MESSAGE_ID, CHANNEL_ID))");
        map.put("CREATE_IDX_MESSAGE_REF_TX", "CREATE INDEX JBM_MSG_REF_TX ON JBM_MSG_REF (TRANSACTION_ID, STATE)");
        map.put("CREATE_IDX_MESSAGE_REF_ORD", "CREATE INDEX JBM_MSG_REF_ORD ON JBM_MSG_REF (ORD)");
        map.put("CREATE_IDX_MESSAGE_REF_PAGE_ORD", "CREATE INDEX JBM_MSG_REF__PAGE_ORD ON JBM_MSG_REF (PAGE_ORD)");
        map.put("CREATE_IDX_MESSAGE_REF_MESSAGE_ID", "CREATE INDEX JBM_MSG_REF_MESSAGE_ID ON JBM_MSG_REF (MESSAGE_ID)");
        map.put("CREATE_IDX_MESSAGE_REF_SCHED_DELIVERY", "CREATE INDEX JBM_MSG_REF_SCHED_DELIVERY ON JBM_MSG_REF (SCHED_DELIVERY)");
        map.put("CREATE_MESSAGE", "CREATE TABLE JBM_MSG (MESSAGE_ID BIGINT, RELIABLE CHAR(1), EXPIRATION BIGINT, TIMESTAMP BIGINT, PRIORITY TINYINT, TYPE TINYINT, HEADERS LONGVARBINARY, PAYLOAD LONGVARBINARY, PRIMARY KEY (MESSAGE_ID))");
        map.put("CREATE_TRANSACTION", "CREATE TABLE JBM_TX (NODE_ID INTEGER, TRANSACTION_ID BIGINT, BRANCH_QUAL VARBINARY(254), FORMAT_ID INTEGER, GLOBAL_TXID VARBINARY(254), PRIMARY KEY (TRANSACTION_ID))");
        map.put("CREATE_COUNTER", "CREATE TABLE JBM_COUNTER (NAME VARCHAR(255), NEXT_ID BIGINT, PRIMARY KEY(NAME))");
        return map;
    }

    protected Map getDefaultDMLStatements() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("INSERT_DUAL", "INSERT INTO JBM_DUAL VALUES (1)");
        map.put("CHECK_DUAL", "SELECT 1 FROM JBM_DUAL");
        map.put("INSERT_MESSAGE_REF", "INSERT INTO JBM_MSG_REF (CHANNEL_ID, MESSAGE_ID, TRANSACTION_ID, STATE, ORD, PAGE_ORD, DELIVERY_COUNT, SCHED_DELIVERY) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        map.put("DELETE_MESSAGE_REF", "DELETE FROM JBM_MSG_REF WHERE MESSAGE_ID=? AND CHANNEL_ID=? AND STATE='C'");
        map.put("UPDATE_MESSAGE_REF", "UPDATE JBM_MSG_REF SET TRANSACTION_ID=?, STATE='-' WHERE MESSAGE_ID=? AND CHANNEL_ID=? AND STATE='C'");
        map.put("UPDATE_PAGE_ORDER", "UPDATE JBM_MSG_REF SET PAGE_ORD = ? WHERE MESSAGE_ID=? AND CHANNEL_ID=?");
        map.put("COMMIT_MESSAGE_REF1", "UPDATE JBM_MSG_REF SET STATE='C', TRANSACTION_ID = NULL WHERE TRANSACTION_ID=? AND STATE='+'");
        map.put("COMMIT_MESSAGE_REF2", "DELETE FROM JBM_MSG_REF WHERE TRANSACTION_ID=? AND STATE='-'");
        map.put("ROLLBACK_MESSAGE_REF1", "DELETE FROM JBM_MSG_REF WHERE TRANSACTION_ID=? AND STATE='+'");
        map.put("ROLLBACK_MESSAGE_REF2", "UPDATE JBM_MSG_REF SET STATE='C', TRANSACTION_ID = NULL WHERE TRANSACTION_ID=? AND STATE='-'");
        map.put("LOAD_PAGED_REFS", "SELECT MESSAGE_ID, DELIVERY_COUNT, PAGE_ORD, SCHED_DELIVERY FROM JBM_MSG_REF WHERE CHANNEL_ID = ? AND PAGE_ORD BETWEEN ? AND ? ORDER BY PAGE_ORD");
        map.put("LOAD_UNPAGED_REFS", "SELECT MESSAGE_ID, DELIVERY_COUNT, SCHED_DELIVERY FROM JBM_MSG_REF WHERE STATE = 'C' AND CHANNEL_ID = ? AND PAGE_ORD IS NULL ORDER BY ORD");
        map.put("LOAD_REFS", "SELECT MESSAGE_ID, DELIVERY_COUNT, SCHED_DELIVERY FROM JBM_MSG_REF WHERE STATE = 'C' AND CHANNEL_ID = ? ORDER BY ORD");
        map.put("UPDATE_REFS_NOT_PAGED", "UPDATE JBM_MSG_REF SET PAGE_ORD = NULL WHERE PAGE_ORD BETWEEN ? AND ? AND CHANNEL_ID=?");
        map.put("SELECT_MIN_MAX_PAGE_ORD", "SELECT MIN(PAGE_ORD), MAX(PAGE_ORD) FROM JBM_MSG_REF WHERE CHANNEL_ID = ?");
        map.put("SELECT_EXISTS_REF_MESSAGE_ID", "SELECT MESSAGE_ID FROM JBM_MSG_REF WHERE MESSAGE_ID = ?");
        map.put("UPDATE_DELIVERY_COUNT", "UPDATE JBM_MSG_REF SET DELIVERY_COUNT = ? WHERE MESSAGE_ID = ? AND CHANNEL_ID = ?");
        map.put("UPDATE_CHANNEL_ID", "UPDATE JBM_MSG_REF SET CHANNEL_ID = ? WHERE CHANNEL_ID = ?");
        map.put("MOVE_REFERENCE", "UPDATE JBM_MSG_REF SET CHANNEL_ID = ? WHERE MESSAGE_ID = ? AND CHANNEL_ID = ?");
        map.put("LOAD_MESSAGES", "SELECT MESSAGE_ID, RELIABLE, EXPIRATION, TIMESTAMP, PRIORITY, HEADERS, PAYLOAD, TYPE FROM JBM_MSG");
        map.put("INSERT_MESSAGE", "INSERT INTO JBM_MSG (MESSAGE_ID, RELIABLE, EXPIRATION, TIMESTAMP, PRIORITY, TYPE, HEADERS, PAYLOAD) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        map.put("INSERT_MESSAGE_CONDITIONAL", "INSERT INTO JBM_MSG (MESSAGE_ID, RELIABLE, EXPIRATION, TIMESTAMP, PRIORITY, TYPE) SELECT ?, ?, ?, ?, ?, ? FROM JBM_DUAL WHERE NOT EXISTS (SELECT MESSAGE_ID FROM JBM_MSG WHERE MESSAGE_ID = ?)");
        map.put("INSERT_MESSAGE_CONDITIONAL_FULL", "INSERT INTO JBM_MSG (MESSAGE_ID, RELIABLE, EXPIRATION, TIMESTAMP, PRIORITY, TYPE, HEADERS, PAYLOAD) SELECT ?, ?, ?, ?, ?, ?, ?, ? FROM JBM_DUAL WHERE NOT EXISTS (SELECT MESSAGE_ID FROM JBM_MSG WHERE MESSAGE_ID = ?)");
        map.put("UPDATE_MESSAGE_4CONDITIONAL", "UPDATE JBM_MSG SET HEADERS=?, PAYLOAD=? WHERE MESSAGE_ID=?");
        map.put("MESSAGE_ID_COLUMN", "MESSAGE_ID");
        map.put("DELETE_MESSAGE", "DELETE FROM JBM_MSG WHERE MESSAGE_ID = ? AND NOT EXISTS (SELECT JBM_MSG_REF.MESSAGE_ID FROM JBM_MSG_REF WHERE JBM_MSG_REF.MESSAGE_ID = ?)");
        map.put("INSERT_TRANSACTION", "INSERT INTO JBM_TX (NODE_ID, TRANSACTION_ID, BRANCH_QUAL, FORMAT_ID, GLOBAL_TXID) VALUES(?, ?, ?, ?, ?)");
        map.put("DELETE_TRANSACTION", "DELETE FROM JBM_TX WHERE NODE_ID = ? AND TRANSACTION_ID = ?");
        map.put("SELECT_PREPARED_TRANSACTIONS", "SELECT TRANSACTION_ID, BRANCH_QUAL, FORMAT_ID, GLOBAL_TXID FROM JBM_TX WHERE NODE_ID = ?");
        map.put("SELECT_MESSAGE_ID_FOR_REF", "SELECT MESSAGE_ID, CHANNEL_ID FROM JBM_MSG_REF WHERE TRANSACTION_ID = ? AND STATE = '+' ORDER BY ORD");
        map.put("SELECT_MESSAGE_ID_FOR_ACK", "SELECT MESSAGE_ID, CHANNEL_ID FROM JBM_MSG_REF WHERE TRANSACTION_ID = ? AND STATE = '-' ORDER BY ORD");
        map.put("UPDATE_TX", "UPDATE JBM_TX SET NODE_ID=? WHERE NODE_ID=?");
        map.put("UPDATE_COUNTER", "UPDATE JBM_COUNTER SET NEXT_ID = ? WHERE NAME=?");
        map.put("SELECT_COUNTER", "SELECT NEXT_ID FROM JBM_COUNTER WHERE NAME=?");
        map.put("INSERT_COUNTER", "INSERT INTO JBM_COUNTER (NAME, NEXT_ID) VALUES (?, ?)");
        map.put("SELECT_ALL_CHANNELS", "SELECT DISTINCT(CHANNEL_ID) FROM JBM_MSG_REF");
        return map;
    }

    private void deleteMessages(final List references) throws Exception {
        this.orderReferences(references);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DeleteMessagesRunner
        extends JDBCSupport.JDBCTxRunner2 {
            DeleteMessagesRunner() {
                super(JDBCPersistenceManager.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doTransaction() throws Exception {
                Object var3_3;
                PreparedStatement psMessage = null;
                try {
                    psMessage = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("DELETE_MESSAGE"));
                    for (Object obj : references) {
                        MessageReference ref = obj instanceof MessageReference ? (MessageReference)obj : ((ChannelRefPair)obj).ref;
                        psMessage.setLong(1, ref.getMessage().getMessageID());
                        psMessage.setLong(2, ref.getMessage().getMessageID());
                        int rows = psMessage.executeUpdate();
                        if (!JDBCPersistenceManager.this.trace) continue;
                        log.trace((Object)("Deleted " + rows + " messages"));
                    }
                    var3_3 = null;
                }
                catch (Throwable throwable) {
                    JDBCPersistenceManager.this.closeStatement(psMessage);
                    throw throwable;
                }
                JDBCPersistenceManager.this.closeStatement(psMessage);
                return var3_3;
            }
        }
        new DeleteMessagesRunner().executeWithRetry();
    }

    private void deleteMessage(final long messageID) throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DeleteMessageRunner
        extends JDBCSupport.JDBCTxRunner2 {
            DeleteMessageRunner() {
                super(JDBCPersistenceManager.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doTransaction() throws Exception {
                Object var3_3;
                PreparedStatement psMessage = null;
                try {
                    psMessage = this.conn.prepareStatement(JDBCPersistenceManager.this.getSQLStatement("DELETE_MESSAGE"));
                    psMessage.setLong(1, messageID);
                    psMessage.setLong(2, messageID);
                    int rows = psMessage.executeUpdate();
                    if (JDBCPersistenceManager.this.trace) {
                        log.trace((Object)("Deleted " + rows + " messages"));
                    }
                    var3_3 = null;
                }
                catch (Throwable throwable) {
                    JDBCPersistenceManager.this.closeStatement(psMessage);
                    throw throwable;
                }
                JDBCPersistenceManager.this.closeStatement(psMessage);
                return var3_3;
            }
        }
        new DeleteMessageRunner().executeWithRetry();
    }

    private List getMessageChannelPair(String sqlQuery, long transactionId) throws Exception {
        ArrayList<PersistenceManager.MessageChannelPair> arrayList;
        if (this.trace) {
            log.trace((Object)("loading message and channel ids for tx [" + transactionId + "]"));
        }
        if (!this.nodeIDSet) {
            throw new IllegalStateException("Node id has not been set");
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        JDBCSupport.TransactionWrapper wrap = new JDBCSupport.TransactionWrapper(this);
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(sqlQuery);
            ps.setLong(1, transactionId);
            rs = ps.executeQuery();
            class Holder {
                long messageId;
                long channelId;

                Holder(long messageId, long channelId) {
                    this.messageId = messageId;
                    this.channelId = channelId;
                }
            }
            ArrayList<Holder> holders = new ArrayList<Holder>();
            HashSet<Long> msgIds = new HashSet<Long>();
            while (rs.next()) {
                long messageId = rs.getLong(1);
                long channelId = rs.getLong(2);
                Holder holder = new Holder(messageId, channelId);
                holders.add(holder);
                msgIds.add(messageId);
                if (!this.trace) continue;
                log.trace((Object)("Loaded MsgID: " + messageId + " and ChannelID: " + channelId));
            }
            HashMap<Long, Message> messageMap = new HashMap<Long, Message>();
            List messages = this.getMessages(new ArrayList(msgIds));
            for (Message msg : messages) {
                messageMap.put(new Long(msg.getMessageID()), msg);
            }
            ArrayList<PersistenceManager.MessageChannelPair> returnList = new ArrayList<PersistenceManager.MessageChannelPair>();
            for (Holder holder : holders) {
                Message msg = (Message)messageMap.get(new Long(holder.messageId));
                if (msg == null) {
                    throw new IllegalStateException("Cannot find message " + holder.messageId);
                }
                PersistenceManager.MessageChannelPair pair = new PersistenceManager.MessageChannelPair(msg, holder.channelId);
                returnList.add(pair);
            }
            arrayList = returnList;
        }
        catch (Exception e) {
            try {
                wrap.exceptionOccurred();
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                this.closeConnection(conn);
                wrap.end();
                throw throwable;
            }
        }
        this.closeResultSet(rs);
        this.closeStatement(ps);
        this.closeConnection(conn);
        wrap.end();
        return arrayList;
    }

    private synchronized long getOrdering() {
        long order = System.currentTimeMillis();
        order <<= 15;
        this.orderCount = this.orderCount == Short.MAX_VALUE ? (short)0 : (short)(this.orderCount + 1);
        return order |= (long)this.orderCount;
    }

    private void orderReferences(List references) {
        Collections.sort(references, MessageOrderComparator.instance);
    }

    private static class MessageOrderComparator
    implements Comparator {
        static MessageOrderComparator instance = new MessageOrderComparator();

        private MessageOrderComparator() {
        }

        public int compare(Object o1, Object o2) {
            MessageReference ref2;
            MessageReference ref1;
            if (o1 instanceof MessageReference) {
                ref1 = (MessageReference)o1;
                ref2 = (MessageReference)o2;
            } else {
                ref1 = ((ChannelRefPair)o1).ref;
                ref2 = ((ChannelRefPair)o2).ref;
            }
            long id1 = ref1.getMessage().getMessageID();
            long id2 = ref2.getMessage().getMessageID();
            return id1 < id2 ? -1 : (id1 == id2 ? 0 : 1);
        }
    }

    private class TransactionCallback
    implements TxCallback {
        private Transaction tx;
        private List refsToAdd;
        private List refsToRemove;

        private TransactionCallback(Transaction tx) {
            this.tx = tx;
            this.refsToAdd = new ArrayList();
            this.refsToRemove = new ArrayList();
        }

        private void addReferenceToAdd(long channelId, MessageReference ref) {
            this.refsToAdd.add(new ChannelRefPair(channelId, ref));
        }

        private void addReferenceToRemove(long channelId, MessageReference ref) {
            this.refsToRemove.add(new ChannelRefPair(channelId, ref));
        }

        public void afterCommit(boolean onePhase) {
        }

        public void afterPrepare() {
        }

        public void afterRollback(boolean onePhase) {
        }

        public void beforeCommit(boolean onePhase) throws Exception {
            if (onePhase) {
                JDBCPersistenceManager.this.handleBeforeCommit1PC(this.refsToAdd, this.refsToRemove, this.tx);
            } else {
                JDBCPersistenceManager.this.handleBeforeCommit2PC(this.refsToRemove, this.tx);
            }
        }

        public void beforePrepare() throws Exception {
            JDBCPersistenceManager.this.handleBeforePrepare(this.refsToAdd, this.refsToRemove, this.tx);
        }

        public void beforeRollback(boolean onePhase) throws Exception {
            if (!onePhase) {
                JDBCPersistenceManager.this.handleBeforeRollback(this.refsToAdd, this.tx);
            }
        }
    }

    private static class ChannelRefPair {
        private long channelID;
        private MessageReference ref;

        private ChannelRefPair(long channelID, MessageReference ref) {
            this.channelID = channelID;
            this.ref = ref;
        }
    }
}

