/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.ejb.mdb;

import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.notify.ejb.entity.SyslogDuplicationInfoLocal;
import com.clustercontrol.notify.ejb.entity.SyslogDuplicationInfoPK;
import com.clustercontrol.notify.ejb.entity.SyslogDuplicationInfoUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SyslogDuplicationBean
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 8122939314944655588L;
    protected static Log m_log = LogFactory.getLog(SyslogDuplicationBean.class);
    private MessageDrivenContext messageContext = null;
    private static int TIME_LEFT = 3600000;
    private static int REMOVE_INTERVAL = 3600000;
    private static long REMOVE_TIME = new Date().getTime();

    public void setMessageDrivenContext(MessageDrivenContext messageContext) throws EJBException {
        this.messageContext = messageContext;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
        this.messageContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        m_log.debug((Object)("Message Driven Bean got message " + message));
        if (message instanceof ObjectMessage) {
            block17: {
                ObjectMessage msg = (ObjectMessage)message;
                try {
                    Serializable objMsg = msg.getObject();
                    if (objMsg instanceof OutputNotifyGroupInfo) {
                        OutputNotifyGroupInfo outputInfo = (OutputNotifyGroupInfo)objMsg;
                        if (!this.duplicationCheck(outputInfo)) break block17;
                        SendQueue queue = null;
                        try {
                            queue = new SendQueue("queue/clustercontrolNotifyControl");
                            queue.put((Serializable)outputInfo);
                            break block17;
                        }
                        catch (NamingException e) {
                            m_log.warn((Object)("notifyAction() : catch NamingExcepiton" + e.getMessage()), (Throwable)e);
                            break block17;
                        }
                        finally {
                            if (queue != null) {
                                try {
                                    queue.terminate();
                                }
                                catch (JMSException e) {
                                    m_log.warn((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                    }
                    m_log.warn((Object)("onMessage(): ObjectMessage is not an expected instance. " + objMsg.toString()));
                }
                catch (JMSException e) {
                    m_log.error((Object)("onMessage():" + e.getMessage()), (Throwable)e);
                }
                catch (EJBException e) {
                    m_log.error((Object)("onMessage():" + e.getMessage()), (Throwable)e);
                }
            }
            this.removeOldRecode();
        }
    }

    private boolean duplicationCheck(OutputNotifyGroupInfo info) {
        boolean ret = true;
        SyslogDuplicationInfoLocal duplicationInfo = null;
        try {
            try {
                duplicationInfo = SyslogDuplicationInfoUtil.getLocalHome().findByPrimaryKey(new SyslogDuplicationInfoPK(info.getMonitorId(), info.getFacilityId(), new Timestamp(info.getGenerationDate().getTime()), info.getMessageOrg()));
            }
            catch (FinderException e) {
                m_log.debug((Object)"duplicationCheck : catch FinderException ");
                duplicationInfo = null;
            }
            if (duplicationInfo != null) {
                if (duplicationInfo.getMultiId().equals(info.getMultiId())) {
                    duplicationInfo.setCount(duplicationInfo.getCount() + 1);
                } else {
                    m_log.debug((Object)"dulicationCheck : duplication !! ");
                    ret = false;
                    if (duplicationInfo.getCount() > 0) {
                        duplicationInfo.setCount(duplicationInfo.getCount() - 1);
                    } else {
                        duplicationInfo.remove();
                    }
                }
            } else {
                m_log.debug((Object)"duplicationCheck() : create new");
                SyslogDuplicationInfoUtil.getLocalHome().create(info.getMonitorId(), info.getFacilityId(), new Timestamp(info.getGenerationDate().getTime()), info.getMessageOrg(), info.getMultiId(), 0);
            }
        }
        catch (NamingException e) {
            m_log.error((Object)"duplicationCheck : catch NamingException ", (Throwable)e);
        }
        catch (EJBException e) {
            m_log.error((Object)"duplicationCheck : catch EJBException ", (Throwable)e);
        }
        catch (RemoveException e) {
            m_log.error((Object)"duplicationCheck : catch RemoveException ", (Throwable)e);
        }
        catch (CreateException e) {
            m_log.error((Object)"duplicationCheck : catch CreateException ", (Throwable)e);
        }
        return ret;
    }

    private void removeOldRecode() {
        Date nowDate = new Date();
        if (nowDate.getTime() > REMOVE_TIME) {
            try {
                long timeLeft = nowDate.getTime() - (long)TIME_LEFT;
                Collection ct = SyslogDuplicationInfoUtil.getLocalHome().findOldRecode(new Timestamp(timeLeft));
                m_log.debug((Object)("removeOldRecode() : \u30ec\u30b3\u30fc\u30c9\u306e\u4ef6\u6570 \uff1a " + ct.size()));
                Iterator itr = ct.iterator();
                while (itr.hasNext()) {
                    ((SyslogDuplicationInfoLocal)itr.next()).remove();
                }
                m_log.info((Object)"removeOldRecode() : \u524a\u9664\u3057\u307e\u3057\u305f");
            }
            catch (FinderException e) {
                m_log.error((Object)"duplicationCheck : catch FinderException ", (Throwable)e);
            }
            catch (NamingException e) {
                m_log.error((Object)"duplicationCheck : catch NamingException ", (Throwable)e);
            }
            catch (EJBException e) {
                m_log.error((Object)"duplicationCheck : catch EJBException ", (Throwable)e);
            }
            catch (RemoveException e) {
                m_log.error((Object)"duplicationCheck : catch RemoveException ", (Throwable)e);
            }
            REMOVE_TIME += (long)REMOVE_INTERVAL;
        } else {
            m_log.debug((Object)"removeOldRecode() : \u524a\u9664\u6642\u523b\u306b\u306a\u3063\u3066\u3044\u306a\u3044\u306e\u3067\u4f55\u3082\u3057\u307e\u305b\u3093");
        }
    }

    static {
        Properties properties = new Properties();
        String etcdir = System.getProperty("hinemos.manager.etc.dir");
        String propertyFile = etcdir + File.separator + "hinemos.properties";
        try {
            properties.load(new FileInputStream(propertyFile));
            TIME_LEFT = 1000 * Integer.parseInt(properties.getProperty("monitor.syslog.duplication.time.left"));
            REMOVE_INTERVAL = 1000 * Integer.parseInt(properties.getProperty("monitor.syslog.duplication.remove.interval"));
            REMOVE_TIME += (long)REMOVE_INTERVAL;
        }
        catch (Exception e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

