/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.client.RemotingConnectionImpl;
import org.jboss.ws.core.client.SOAPRemotingConnection;
import org.jboss.ws.core.soap.SOAPMessageImpl;

public class SOAPConnectionImpl
extends SOAPConnection {
    private static Logger log = Logger.getLogger(SOAPConnectionImpl.class);
    private RemotingConnectionImpl remotingConnection = new SOAPRemotingConnection();

    public SOAPMessage call(SOAPMessage reqMessage, Object endpoint) throws SOAPException {
        if (reqMessage == null) {
            throw new IllegalArgumentException("Given SOAPMessage cannot be null");
        }
        MessageAbstraction resMessage = this.callInternal(reqMessage, endpoint, false);
        return (SOAPMessage)resMessage;
    }

    public SOAPMessage get(Object endpoint) throws SOAPException {
        MessageAbstraction resMessage = this.callInternal(null, endpoint, false);
        return (SOAPMessage)resMessage;
    }

    public SOAPMessage callOneWay(SOAPMessage reqMessage, Object endpoint) throws SOAPException {
        if (reqMessage == null) {
            throw new IllegalArgumentException("Given SOAPMessage cannot be null");
        }
        MessageAbstraction resMessage = this.callInternal((SOAPMessageImpl)reqMessage, endpoint, true);
        return (SOAPMessage)resMessage;
    }

    public void close() throws SOAPException {
        if (this.remotingConnection.isClosed()) {
            throw new SOAPException("SOAPConnection is already closed");
        }
        this.remotingConnection.setClosed(true);
    }

    private MessageAbstraction callInternal(SOAPMessage reqMessage, Object endpoint, boolean oneway) throws SOAPException {
        try {
            MessageAbstraction resMessage = this.remotingConnection.invoke((SOAPMessageImpl)reqMessage, endpoint, oneway);
            return resMessage;
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SOAPException) {
                throw (SOAPException)cause;
            }
            throw new SOAPException((Throwable)ex);
        }
    }
}

