/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.eventing.mgmt;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import javax.xml.bind.JAXBElement;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.jboss.logging.Logger;
import org.jboss.ws.core.soap.SOAPConnectionImpl;
import org.jboss.ws.extensions.eventing.EventingConstants;
import org.jboss.ws.extensions.eventing.jaxws.AttributedURIType;
import org.jboss.ws.extensions.eventing.jaxws.EndpointReferenceType;
import org.jboss.ws.extensions.eventing.mgmt.Filter;
import org.jboss.ws.extensions.eventing.mgmt.NotificationFailure;
import org.jboss.ws.extensions.eventing.mgmt.SubscriptionManagerFactory;
import org.jboss.ws.extensions.eventing.mgmt.SubscriptionManagerMBean;
import org.jboss.wsf.common.DOMWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class Subscription {
    private static final Logger log = Logger.getLogger(Subscription.class);
    private final EndpointReferenceType notifyTo;
    private final EndpointReferenceType endTo;
    private Date expires;
    private final Filter filter;
    private final EndpointReferenceType endpointReference;
    private final URI eventSourceNS;
    private SubscriptionManagerFactory factory = SubscriptionManagerFactory.getInstance();

    public Subscription(URI eventSourceNS, EndpointReferenceType epr, EndpointReferenceType notifyTo, EndpointReferenceType endTo, Date expires, Filter filter) {
        this.eventSourceNS = eventSourceNS;
        this.notifyTo = notifyTo;
        this.endTo = endTo;
        this.expires = expires;
        this.filter = filter;
        this.endpointReference = epr;
    }

    public void notify(Element event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getIdentifier() + " dispatching " + event));
        }
        try {
            String eventXML = DOMWriter.printNode(event, false);
            MessageFactory msgFactory = MessageFactory.newInstance();
            StringBuilder sb = new StringBuilder();
            sb.append("<env:Envelope xmlns:env='http://www.w3.org/2003/05/soap-envelope' ");
            sb.append("xmlns:wse='").append("http://schemas.xmlsoap.org/ws/2004/08/eventing").append("' ");
            sb.append("xmlns:wsa='").append(EventingConstants.NS_ADDRESSING).append("'>");
            sb.append("<env:Header>");
            sb.append("<wsa:Action>").append(this.getNotificationAction()).append("</wsa:Action>");
            sb.append("<wsa:To>").append(this.notifyTo.getAddress().toString()).append("</wsa:To>");
            sb.append("</env:Header>");
            sb.append("<env:Body>");
            sb.append(eventXML);
            sb.append("</env:Body>");
            sb.append("</env:Envelope>");
            SOAPMessage reqMsg = msgFactory.createMessage(null, (InputStream)new ByteArrayInputStream(sb.toString().getBytes()));
            URL epURL = new URL(this.notifyTo.getAddress().getValue());
            new SOAPConnectionImpl().callOneWay(reqMsg, epURL);
        }
        catch (Exception e) {
            SubscriptionManagerMBean manager = this.factory.getSubscriptionManager();
            AttributedURIType address = this.endTo.getAddress();
            NotificationFailure failure = new NotificationFailure(address.getValue(), event, e);
            manager.addNotificationFailure(failure);
            log.error((Object)"Failed to send notification message", (Throwable)e);
        }
    }

    public boolean accepts(Element event) {
        boolean b = true;
        if (this.filter != null) {
            try {
                XObject o = XPathAPI.eval((Node)event, (String)this.filter.getExpression());
                b = o.bool();
            }
            catch (TransformerException e) {
                log.error((Object)"Failed to evalute xpath expression", (Throwable)e);
            }
        }
        return b;
    }

    public void end(String status) {
        if (null == this.endTo) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ending subscription " + this.getIdentifier()));
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<env:Envelope xmlns:env='http://www.w3.org/2003/05/soap-envelope' ");
        sb.append("xmlns:wse='").append("http://schemas.xmlsoap.org/ws/2004/08/eventing").append("' ");
        sb.append("xmlns:wsa='").append(EventingConstants.NS_ADDRESSING).append("'>");
        sb.append("<env:Header>");
        sb.append("<wsa:Action>").append("http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscriptionEnd").append("</wsa:Action>");
        sb.append("<wsa:To>").append(this.endTo.getAddress().toString()).append("</wsa:To>");
        sb.append("</env:Header>");
        sb.append("<env:Body>");
        sb.append("<wse:SubscriptionEnd>");
        sb.append("<wse:SubscriptionManager>");
        sb.append("<wsa:Address>");
        sb.append(this.endpointReference.getAddress().toString());
        sb.append("</wsa:Address>");
        sb.append("<wsa:ReferenceParameters>");
        sb.append("<wse:Identifier>");
        sb.append(this.getIdentifier().toString());
        sb.append("</wse:Identifier>");
        sb.append("</wsa:ReferenceParameters>");
        sb.append("</wse:SubscriptionManager>");
        sb.append("<wse:Status>").append(status).append("</wse:Status>");
        sb.append("<wse:Reason/>");
        sb.append("</wse:SubscriptionEnd>");
        sb.append("</env:Body>");
        sb.append("</env:Envelope>");
        try {
            MessageFactory msgFactory = MessageFactory.newInstance();
            SOAPMessage reqMsg = msgFactory.createMessage(null, (InputStream)new ByteArrayInputStream(sb.toString().getBytes()));
            URL epURL = new URL(this.endTo.getAddress().getValue());
            new SOAPConnectionImpl().callOneWay(reqMsg, epURL);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to send subscription end message to: " + this.endTo + "(" + e.getMessage() + ")"));
        }
    }

    private String getNotificationAction() {
        return this.eventSourceNS.toString() + "/Notification";
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expires.getTime();
    }

    public EndpointReferenceType getNotifyTo() {
        return this.notifyTo;
    }

    public EndpointReferenceType getEndTo() {
        return this.endTo;
    }

    public Date getExpires() {
        return this.expires;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public EndpointReferenceType getEndpointReferenceType() {
        return this.endpointReference;
    }

    public URI getIdentifier() {
        try {
            JAXBElement jaxbElement = (JAXBElement)this.endpointReference.getReferenceParameters().getAny().get(0);
            return new URI((String)jaxbElement.getValue());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }
}

