/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.element;

import java.util.HashMap;
import java.util.LinkedList;
import org.jboss.ws.extensions.security.BinarySecurityTokenValidator;
import org.jboss.ws.extensions.security.KeyResolver;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.UnsupportedSecurityTokenException;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.WSSecurityException;
import org.jboss.ws.extensions.security.element.BinarySecurityToken;
import org.jboss.ws.extensions.security.element.EncryptedKey;
import org.jboss.ws.extensions.security.element.SecurityElement;
import org.jboss.ws.extensions.security.element.SecurityProcess;
import org.jboss.ws.extensions.security.element.SecurityTokenReference;
import org.jboss.ws.extensions.security.element.Signature;
import org.jboss.ws.extensions.security.element.Timestamp;
import org.jboss.ws.extensions.security.element.Token;
import org.jboss.ws.extensions.security.element.UsernameToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityHeader
implements SecurityElement {
    private Document document;
    private Timestamp timestamp;
    private LinkedList<Token> tokens = new LinkedList();
    private HashMap<Object, Token> sharedTokens = new HashMap();
    private LinkedList<SecurityProcess> securityProcesses = new LinkedList();
    private LinkedList<SecurityTokenReference> securityTokenReferences = new LinkedList();

    public SecurityHeader(Document document) {
        this.document = document;
    }

    public SecurityHeader(Element element, SecurityStore store) throws WSSecurityException {
        this.document = element.getOwnerDocument();
        KeyResolver resolver = new KeyResolver(store);
        BinarySecurityTokenValidator validator = new BinarySecurityTokenValidator(store);
        Element child = Util.getFirstChildElement(element);
        while (child != null) {
            String tag = child.getLocalName();
            if (tag.equals("BinarySecurityToken")) {
                BinarySecurityToken token = BinarySecurityToken.createBinarySecurityToken(child);
                validator.validateToken(token);
                resolver.cacheToken(token);
                this.tokens.add(token);
            } else if (tag.equals("UsernameToken")) {
                this.tokens.add(new UsernameToken(child));
            } else if (tag.equals("Timestamp")) {
                this.timestamp = new Timestamp(child);
            } else if (tag.equals("Signature")) {
                this.securityProcesses.add(new Signature(child, resolver));
            } else if (tag.equals("EncryptedKey")) {
                this.securityProcesses.add(new EncryptedKey(child, resolver));
            } else if (tag.equals("ReferenceList")) {
                throw new UnsupportedSecurityTokenException("ReferenceLists outside of encrypted keys (shared secrets) are not supported.");
            }
            child = Util.getNextSiblingElement(child);
        }
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public LinkedList getSecurityTokenReferences() {
        return this.securityTokenReferences;
    }

    public void setSecurityTokenReferences(LinkedList<SecurityTokenReference> securityTokenReferences) {
        this.securityTokenReferences = securityTokenReferences;
    }

    public LinkedList<SecurityProcess> getSecurityProcesses() {
        return this.securityProcesses;
    }

    public void setSecurityProcesses(LinkedList<SecurityProcess> securityProcesses) {
        this.securityProcesses = securityProcesses;
    }

    public LinkedList<Token> getTokens() {
        return this.tokens;
    }

    public void addToken(Token token) {
        this.tokens.addFirst(token);
        Object content = token.getUniqueContent();
        if (content != null) {
            this.sharedTokens.put(content, token);
        }
    }

    public Token getSharedToken(Object uniqueContent) {
        if (uniqueContent == null) {
            return null;
        }
        return this.sharedTokens.get(uniqueContent);
    }

    public void addSecurityProcess(SecurityProcess process) {
        this.securityProcesses.addFirst(process);
    }

    public void addSecurityTokenReference(SecurityTokenReference reference) {
        this.securityTokenReferences.addFirst(reference);
    }

    @Override
    public Element getElement() throws WSSecurityException {
        Element element = this.document.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
        Util.addNamespace(element, "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        Util.addNamespace(element, "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        if (this.timestamp != null) {
            element.appendChild(this.timestamp.getElement());
        }
        for (Token t : this.tokens) {
            element.appendChild(t.getElement());
        }
        for (SecurityTokenReference r : this.securityTokenReferences) {
            element.appendChild(r.getElement());
        }
        for (SecurityProcess p : this.securityProcesses) {
            element.appendChild(p.getElement());
        }
        return element;
    }
}

