/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.ExtendedCacheLoader;
import org.jboss.cache.marshall.RegionManager;

public class ChainingCacheLoader
implements ExtendedCacheLoader {
    private final List cacheLoaders = new ArrayList(2);
    private final List writeCacheLoaders = new ArrayList(2);
    private final List cacheLoaderConfigs = new ArrayList(2);

    public void setConfig(Properties url) {
    }

    public void setCache(TreeCache c) {
    }

    public Set getChildrenNames(Fqn fqn) throws Exception {
        CacheLoader l;
        Set answer = null;
        Iterator i = this.cacheLoaders.iterator();
        while (i.hasNext() && ((answer = (l = (CacheLoader)i.next()).getChildrenNames(fqn)) == null || answer.size() <= 0)) {
        }
        return answer;
    }

    public Map get(Fqn name) throws Exception {
        CacheLoader l;
        Map answer = null;
        Iterator i = this.cacheLoaders.iterator();
        while (i.hasNext() && (answer = (l = (CacheLoader)i.next()).get(name)) == null) {
        }
        return answer;
    }

    public boolean exists(Fqn name) throws Exception {
        CacheLoader l;
        boolean answer = false;
        Iterator i = this.cacheLoaders.iterator();
        while (i.hasNext() && !(answer = (l = (CacheLoader)i.next()).exists(name))) {
        }
        return answer;
    }

    public Object put(Fqn name, Object key, Object value) throws Exception {
        Object answer = null;
        Iterator i = this.writeCacheLoaders.iterator();
        boolean isFirst = true;
        while (i.hasNext()) {
            CacheLoader l = (CacheLoader)i.next();
            Object tAnswer = l.put(name, key, value);
            if (!isFirst) continue;
            answer = tAnswer;
            isFirst = false;
        }
        return answer;
    }

    public void put(Fqn name, Map attributes) throws Exception {
        Iterator i = this.writeCacheLoaders.iterator();
        while (i.hasNext()) {
            CacheLoader l = (CacheLoader)i.next();
            l.put(name, attributes);
        }
    }

    public void put(List modifications) throws Exception {
        Iterator i = this.writeCacheLoaders.iterator();
        while (i.hasNext()) {
            CacheLoader l = (CacheLoader)i.next();
            l.put(modifications);
        }
    }

    public Object remove(Fqn name, Object key) throws Exception {
        Object answer = null;
        Iterator i = this.writeCacheLoaders.iterator();
        boolean isFirst = true;
        while (i.hasNext()) {
            CacheLoader l = (CacheLoader)i.next();
            Object tAnswer = l.remove(name, key);
            if (!isFirst) continue;
            answer = tAnswer;
            isFirst = false;
        }
        return answer;
    }

    public void remove(Fqn name) throws Exception {
        Iterator i = this.writeCacheLoaders.iterator();
        while (i.hasNext()) {
            CacheLoader l = (CacheLoader)i.next();
            l.remove(name);
        }
    }

    public void removeData(Fqn name) throws Exception {
        Iterator i = this.writeCacheLoaders.iterator();
        while (i.hasNext()) {
            CacheLoader l = (CacheLoader)i.next();
            l.removeData(name);
        }
    }

    public void prepare(Object tx, List modifications, boolean one_phase) throws Exception {
        Iterator i = this.writeCacheLoaders.iterator();
        while (i.hasNext()) {
            CacheLoader l = (CacheLoader)i.next();
            l.prepare(tx, modifications, one_phase);
        }
    }

    public void commit(Object tx) throws Exception {
        Iterator i = this.writeCacheLoaders.iterator();
        while (i.hasNext()) {
            CacheLoader l = (CacheLoader)i.next();
            l.commit(tx);
        }
    }

    public void rollback(Object tx) {
        Iterator i = this.writeCacheLoaders.iterator();
        while (i.hasNext()) {
            CacheLoader l = (CacheLoader)i.next();
            l.rollback(tx);
        }
    }

    public byte[] loadEntireState() throws Exception {
        byte[] answer = null;
        Iterator i = this.cacheLoaders.iterator();
        Iterator cfgs = this.cacheLoaderConfigs.iterator();
        while (i.hasNext() && cfgs.hasNext()) {
            CacheLoader l = (CacheLoader)i.next();
            CacheLoaderConfig.IndividualCacheLoaderConfig cfg = (CacheLoaderConfig.IndividualCacheLoaderConfig)cfgs.next();
            if (!cfg.isFetchPersistentState()) continue;
            answer = l.loadEntireState();
            break;
        }
        return answer;
    }

    public void storeEntireState(byte[] state) throws Exception {
        Iterator i = this.writeCacheLoaders.iterator();
        Iterator cfgs = this.cacheLoaderConfigs.iterator();
        while (i.hasNext()) {
            CacheLoader l = (CacheLoader)i.next();
            CacheLoaderConfig.IndividualCacheLoaderConfig cfg = (CacheLoaderConfig.IndividualCacheLoaderConfig)cfgs.next();
            if (!cfg.isFetchPersistentState()) continue;
            l.storeEntireState(state);
            break;
        }
    }

    public void create() throws Exception {
        Iterator it = this.cacheLoaders.iterator();
        Iterator cfgIt = this.cacheLoaderConfigs.iterator();
        while (it.hasNext() && cfgIt.hasNext()) {
            CacheLoader cl = (CacheLoader)it.next();
            CacheLoaderConfig.IndividualCacheLoaderConfig cfg = (CacheLoaderConfig.IndividualCacheLoaderConfig)cfgIt.next();
            cl.create();
        }
    }

    public void start() throws Exception {
        Iterator it = this.cacheLoaders.iterator();
        while (it.hasNext()) {
            ((CacheLoader)it.next()).start();
        }
    }

    public void stop() {
        Iterator it = this.cacheLoaders.iterator();
        while (it.hasNext()) {
            ((CacheLoader)it.next()).stop();
        }
    }

    public void destroy() {
        Iterator it = this.cacheLoaders.iterator();
        while (it.hasNext()) {
            ((CacheLoader)it.next()).destroy();
        }
    }

    public byte[] loadState(Fqn subtree) throws Exception {
        byte[] answer = null;
        Iterator i = this.cacheLoaders.iterator();
        Iterator cfgs = this.cacheLoaderConfigs.iterator();
        while (i.hasNext() && cfgs.hasNext()) {
            CacheLoader l = (CacheLoader)i.next();
            CacheLoaderConfig.IndividualCacheLoaderConfig cfg = (CacheLoaderConfig.IndividualCacheLoaderConfig)cfgs.next();
            if (!cfg.isFetchPersistentState()) continue;
            if (l instanceof ExtendedCacheLoader) {
                answer = ((ExtendedCacheLoader)l).loadState(subtree);
                break;
            }
            throw new Exception("Cache loader " + l + " does not implement ExtendedCacheLoader");
        }
        return answer;
    }

    public void setRegionManager(RegionManager manager) {
    }

    public void storeState(byte[] state, Fqn subtree) throws Exception {
        Iterator i = this.writeCacheLoaders.iterator();
        Iterator cfgs = this.cacheLoaderConfigs.iterator();
        while (i.hasNext()) {
            CacheLoader l = (CacheLoader)i.next();
            CacheLoaderConfig.IndividualCacheLoaderConfig cfg = (CacheLoaderConfig.IndividualCacheLoaderConfig)cfgs.next();
            if (!cfg.isFetchPersistentState()) continue;
            if (l instanceof ExtendedCacheLoader) {
                ((ExtendedCacheLoader)l).storeState(state, subtree);
                break;
            }
            throw new Exception("Cache loader " + l + " does not implement ExtendedCacheLoader");
        }
    }

    public int getSize() {
        return this.cacheLoaders.size();
    }

    public List getCacheLoaders() {
        return Collections.unmodifiableList(this.cacheLoaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheLoader(CacheLoader l, CacheLoaderConfig.IndividualCacheLoaderConfig cfg) {
        ChainingCacheLoader chainingCacheLoader = this;
        synchronized (chainingCacheLoader) {
            this.cacheLoaderConfigs.add(cfg);
            this.cacheLoaders.add(l);
            if (!cfg.isIgnoreModifications()) {
                this.writeCacheLoaders.add(l);
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ChainingCacheLoader{");
        Iterator i = this.cacheLoaders.iterator();
        Iterator c = this.cacheLoaderConfigs.iterator();
        int count = 0;
        while (i.hasNext() && c.hasNext()) {
            CacheLoader loader = (CacheLoader)i.next();
            CacheLoaderConfig.IndividualCacheLoaderConfig cfg = (CacheLoaderConfig.IndividualCacheLoaderConfig)c.next();
            buf.append(++count);
            buf.append(": IgnoreMods? ");
            buf.append(cfg.isIgnoreModifications());
            buf.append(" CLoader: ");
            buf.append(loader);
            buf.append("; ");
        }
        buf.append("}");
        return buf.toString();
    }

    public void purgeIfNecessary() throws Exception {
        Iterator loaders = this.cacheLoaders.iterator();
        Iterator configs = this.cacheLoaderConfigs.iterator();
        while (loaders.hasNext() && configs.hasNext()) {
            CacheLoader myLoader = (CacheLoader)loaders.next();
            CacheLoaderConfig.IndividualCacheLoaderConfig myConfig = (CacheLoaderConfig.IndividualCacheLoaderConfig)configs.next();
            if (myConfig.isIgnoreModifications() || !myConfig.isPurgeOnStartup()) continue;
            myLoader.remove(Fqn.ROOT);
        }
    }
}

