/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.TreeCache;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.marshall.TreeCacheMarshaller140;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.rpc.RpcTreeCache;
import org.jgroups.Address;
import org.jgroups.blocks.MethodCall;
import org.jgroups.stack.IpAddress;

public class MethodDeclarations {
    private static Log log = LogFactory.getLog((Class)MethodDeclarations.class);
    private static Set crud_methods = new HashSet();
    private static Set crud_method_ids = new HashSet();
    private static Set optimisticPutMethods = new HashSet();
    private static Map methods = new HashMap();
    private static Map methodIds = new HashMap();
    public static final Method putDataMethodLocal;
    public static final Method putDataEraseMethodLocal;
    public static final Method putKeyValMethodLocal;
    public static final Method putFailFastKeyValueMethodLocal;
    public static final Method removeNodeMethodLocal;
    public static final Method removeKeyMethodLocal;
    public static final Method removeDataMethodLocal;
    public static final Method evictNodeMethodLocal;
    public static final Method evictVersionedNodeMethodLocal;
    public static final Method prepareMethod;
    public static final Method commitMethod;
    public static final Method rollbackMethod;
    public static final Method replicateMethod;
    public static final Method replicateAllMethod;
    public static final Method addChildMethodLocal;
    public static final Method getKeyValueMethodLocal;
    public static final Method getNodeMethodLocal;
    public static final Method getKeysMethodLocal;
    public static final Method getChildrenNamesMethodLocal;
    public static final Method getDataMapMethodLocal;
    public static final Method existsMethod;
    public static final Method releaseAllLocksMethodLocal;
    public static final Method printMethodLocal;
    public static final Method lockMethodLocal;
    public static final Method optimisticPrepareMethod;
    public static final Method getPartialStateMethod;
    public static final Method enqueueMethodCallMethod;
    public static final Method notifyCallOnInactiveMethod;
    public static final Method clusteredGetMethod;
    public static final Method remoteAssignToBuddyGroupMethod;
    public static final Method remoteRemoveFromBuddyGroupMethod;
    public static final Method remoteAnnounceBuddyPoolNameMethod;
    public static final Method dataGravitationCleanupMethod;
    public static final Method dataGravitationMethod;
    public static final Method putDataVersionedMethodLocal;
    public static final Method putDataEraseVersionedMethodLocal;
    public static final Method putKeyValVersionedMethodLocal;
    public static final Method removeNodeVersionedMethodLocal;
    public static final Method removeKeyVersionedMethodLocal;
    public static final Method removeDataVersionedMethodLocal;
    public static final int putDataMethodLocal_id = 1;
    public static final int putDataEraseMethodLocal_id = 2;
    public static final int putKeyValMethodLocal_id = 3;
    public static final int putFailFastKeyValueMethodLocal_id = 4;
    public static final int removeNodeMethodLocal_id = 5;
    public static final int removeKeyMethodLocal_id = 6;
    public static final int removeDataMethodLocal_id = 7;
    public static final int evictNodeMethodLocal_id = 8;
    public static final int evictVersionedNodeMethodLocal_id = 9;
    public static final int prepareMethod_id = 10;
    public static final int commitMethod_id = 11;
    public static final int rollbackMethod_id = 12;
    public static final int replicateMethod_id = 13;
    public static final int replicateAllMethod_id = 14;
    public static final int addChildMethodLocal_id = 15;
    public static final int existsMethod_id = 16;
    public static final int releaseAllLocksMethodLocal_id = 17;
    public static final int optimisticPrepareMethod_id = 18;
    public static final int getPartialStateMethod_id = 19;
    public static final int enqueueMethodCallMethod_id = 20;
    public static final int notifyCallOnInactiveMethod_id = 21;
    public static final int clusteredGetMethod_id = 22;
    public static final int getChildrenNamesMethodLocal_id = 23;
    public static final int getDataMapMethodLocal_id = 24;
    public static final int getKeysMethodLocal_id = 25;
    public static final int getKeyValueMethodLocal_id = 26;
    public static final int dispatchRpcCallMethod_id = 27;
    public static final int remoteAnnounceBuddyPoolNameMethod_id = 28;
    public static final int remoteAssignToBuddyGroupMethod_id = 29;
    public static final int remoteRemoveFromBuddyGroupMethod_id = 30;
    public static final int getNodeMethodLocal_id = 31;
    public static final int printMethodLocal_id = 32;
    public static final int lockMethodLocal_id = 33;
    public static final int dataGravitationCleanupMethod_id = 34;
    public static final int dataGravitationMethod_id = 35;
    public static final int putDataVersionedMethodLocal_id = 36;
    public static final int putDataEraseVersionedMethodLocal_id = 37;
    public static final int putKeyValVersionedMethodLocal_id = 38;
    public static final int removeNodeVersionedMethodLocal_id = 39;
    public static final int removeKeyVersionedMethodLocal_id = 40;
    public static final int removeDataVersionedMethodLocal_id = 41;

    protected static int lookupMethodId(Method method) {
        Integer methodIdInteger = (Integer)methodIds.get(method);
        int methodId = -1;
        if (methodIdInteger != null) {
            methodId = methodIdInteger;
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Method " + method + " is not registered with " + TreeCacheMarshaller140.class));
        }
        return methodId;
    }

    protected static Method lookupMethod(int id) {
        Method method = (Method)methods.get(new Integer(id));
        if (method == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Method id " + id + " is not registered"));
            }
            throw new RuntimeException("Method id " + id + " is not registered with " + TreeCacheMarshaller140.class);
        }
        return method;
    }

    public static boolean isCrudMethod(Method m) {
        return crud_methods.contains(m);
    }

    public static boolean isCrudMethod(int id) {
        return crud_method_ids.contains(new Integer(id));
    }

    public static Method getVersionedMethod(int methodId) {
        if (MethodDeclarations.isCrudMethod(methodId)) {
            switch (methodId) {
                case 2: {
                    return putDataEraseVersionedMethodLocal;
                }
                case 1: {
                    return putDataVersionedMethodLocal;
                }
                case 3: {
                    return putKeyValVersionedMethodLocal;
                }
                case 7: {
                    return removeDataVersionedMethodLocal;
                }
                case 6: {
                    return removeKeyVersionedMethodLocal;
                }
                case 5: {
                    return removeNodeVersionedMethodLocal;
                }
            }
            throw new RuntimeException("Unrecognised method id " + methodId);
        }
        throw new RuntimeException("Attempting to look up a versioned equivalent of a non-crud method");
    }

    public static boolean isOptimisticPutMethod(Method method) {
        return optimisticPutMethods.contains(method);
    }

    public static Method getUnversionedMethod(int methodId) {
        if (MethodDeclarations.isCrudMethod(methodId)) {
            switch (methodId) {
                case 37: {
                    return putDataEraseMethodLocal;
                }
                case 36: {
                    return putDataMethodLocal;
                }
                case 38: {
                    return putKeyValMethodLocal;
                }
                case 41: {
                    return removeDataMethodLocal;
                }
                case 40: {
                    return removeKeyMethodLocal;
                }
                case 39: {
                    return removeNodeMethodLocal;
                }
            }
            throw new RuntimeException("Unrecognised method id " + methodId);
        }
        throw new RuntimeException("Attempting to look up a versioned equivalent of a non-crud method");
    }

    public static boolean isDataGravitationMethod(int methodId) {
        return methodId == 34 || methodId == 35;
    }

    public static boolean isGetMethod(int methodId) {
        return methodId == 23 || methodId == 24 || methodId == 16 || methodId == 25 || methodId == 26 || methodId == 31;
    }

    static {
        try {
            getDataMapMethodLocal = TreeCache.class.getDeclaredMethod("_getData", Fqn.class);
            existsMethod = TreeCache.class.getDeclaredMethod("exists", Fqn.class);
            putDataMethodLocal = TreeCache.class.getDeclaredMethod("_put", GlobalTransaction.class, Fqn.class, Map.class, Boolean.TYPE);
            putDataEraseMethodLocal = TreeCache.class.getDeclaredMethod("_put", GlobalTransaction.class, Fqn.class, Map.class, Boolean.TYPE, Boolean.TYPE);
            putKeyValMethodLocal = TreeCache.class.getDeclaredMethod("_put", GlobalTransaction.class, Fqn.class, Object.class, Object.class, Boolean.TYPE);
            putFailFastKeyValueMethodLocal = TreeCache.class.getDeclaredMethod("_put", GlobalTransaction.class, Fqn.class, Object.class, Object.class, Boolean.TYPE, Long.TYPE);
            removeNodeMethodLocal = TreeCache.class.getDeclaredMethod("_remove", GlobalTransaction.class, Fqn.class, Boolean.TYPE);
            removeKeyMethodLocal = TreeCache.class.getDeclaredMethod("_remove", GlobalTransaction.class, Fqn.class, Object.class, Boolean.TYPE);
            removeDataMethodLocal = TreeCache.class.getDeclaredMethod("_removeData", GlobalTransaction.class, Fqn.class, Boolean.TYPE);
            evictNodeMethodLocal = TreeCache.class.getDeclaredMethod("_evict", Fqn.class);
            evictVersionedNodeMethodLocal = TreeCache.class.getDeclaredMethod("_evict", Fqn.class, DataVersion.class);
            prepareMethod = TreeCache.class.getDeclaredMethod("prepare", GlobalTransaction.class, List.class, Address.class, Boolean.TYPE);
            commitMethod = TreeCache.class.getDeclaredMethod("commit", GlobalTransaction.class);
            rollbackMethod = TreeCache.class.getDeclaredMethod("rollback", GlobalTransaction.class);
            addChildMethodLocal = TreeCache.class.getDeclaredMethod("_addChild", GlobalTransaction.class, Fqn.class, Object.class, DataNode.class);
            getKeyValueMethodLocal = TreeCache.class.getDeclaredMethod("_get", Fqn.class, Object.class, Boolean.TYPE);
            getNodeMethodLocal = TreeCache.class.getDeclaredMethod("_get", Fqn.class);
            getKeysMethodLocal = TreeCache.class.getDeclaredMethod("_getKeys", Fqn.class);
            getChildrenNamesMethodLocal = TreeCache.class.getDeclaredMethod("_getChildrenNames", Fqn.class);
            replicateMethod = TreeCache.class.getDeclaredMethod("_replicate", MethodCall.class);
            replicateAllMethod = TreeCache.class.getDeclaredMethod("_replicate", List.class);
            releaseAllLocksMethodLocal = TreeCache.class.getDeclaredMethod("_releaseAllLocks", Fqn.class);
            printMethodLocal = TreeCache.class.getDeclaredMethod("_print", Fqn.class);
            lockMethodLocal = TreeCache.class.getDeclaredMethod("_lock", Fqn.class, Integer.TYPE, Boolean.TYPE);
            optimisticPrepareMethod = TreeCache.class.getDeclaredMethod("optimisticPrepare", GlobalTransaction.class, List.class, Map.class, Address.class, Boolean.TYPE);
            getPartialStateMethod = TreeCache.class.getDeclaredMethod("_getState", Fqn.class, Long.TYPE, Boolean.TYPE, Boolean.TYPE);
            clusteredGetMethod = TreeCache.class.getDeclaredMethod("_clusteredGet", MethodCall.class, Boolean.class);
            enqueueMethodCallMethod = TreeCache.class.getDeclaredMethod("_enqueueMethodCall", String.class, MethodCall.class);
            notifyCallOnInactiveMethod = TreeCache.class.getDeclaredMethod("notifyCallForInactiveSubtree", String.class);
            remoteAnnounceBuddyPoolNameMethod = TreeCache.class.getDeclaredMethod("_remoteAnnounceBuddyPoolName", IpAddress.class, String.class);
            remoteRemoveFromBuddyGroupMethod = TreeCache.class.getDeclaredMethod("_remoteRemoveFromBuddyGroup", String.class);
            remoteAssignToBuddyGroupMethod = TreeCache.class.getDeclaredMethod("_remoteAssignToBuddyGroup", BuddyGroup.class, Map.class);
            dataGravitationCleanupMethod = TreeCache.class.getDeclaredMethod("_dataGravitationCleanup", GlobalTransaction.class, Fqn.class, Fqn.class);
            dataGravitationMethod = TreeCache.class.getDeclaredMethod("_gravitateData", Fqn.class, Boolean.TYPE, Boolean.TYPE);
            putDataVersionedMethodLocal = TreeCache.class.getDeclaredMethod("_put", GlobalTransaction.class, Fqn.class, Map.class, Boolean.TYPE, DataVersion.class);
            putDataEraseVersionedMethodLocal = TreeCache.class.getDeclaredMethod("_put", GlobalTransaction.class, Fqn.class, Map.class, Boolean.TYPE, Boolean.TYPE, DataVersion.class);
            putKeyValVersionedMethodLocal = TreeCache.class.getDeclaredMethod("_put", GlobalTransaction.class, Fqn.class, Object.class, Object.class, Boolean.TYPE, DataVersion.class);
            removeNodeVersionedMethodLocal = TreeCache.class.getDeclaredMethod("_remove", GlobalTransaction.class, Fqn.class, Boolean.TYPE, DataVersion.class);
            removeKeyVersionedMethodLocal = TreeCache.class.getDeclaredMethod("_remove", GlobalTransaction.class, Fqn.class, Object.class, Boolean.TYPE, DataVersion.class);
            removeDataVersionedMethodLocal = TreeCache.class.getDeclaredMethod("_removeData", GlobalTransaction.class, Fqn.class, Boolean.TYPE, DataVersion.class);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex.toString());
        }
        methods.put(new Integer(1), putDataMethodLocal);
        methods.put(new Integer(2), putDataEraseMethodLocal);
        methods.put(new Integer(3), putKeyValMethodLocal);
        methods.put(new Integer(4), putFailFastKeyValueMethodLocal);
        methods.put(new Integer(5), removeNodeMethodLocal);
        methods.put(new Integer(6), removeKeyMethodLocal);
        methods.put(new Integer(7), removeDataMethodLocal);
        methods.put(new Integer(8), evictNodeMethodLocal);
        methods.put(new Integer(9), evictVersionedNodeMethodLocal);
        methods.put(new Integer(10), prepareMethod);
        methods.put(new Integer(11), commitMethod);
        methods.put(new Integer(12), rollbackMethod);
        methods.put(new Integer(13), replicateMethod);
        methods.put(new Integer(14), replicateAllMethod);
        methods.put(new Integer(15), addChildMethodLocal);
        methods.put(new Integer(16), existsMethod);
        methods.put(new Integer(17), releaseAllLocksMethodLocal);
        methods.put(new Integer(18), optimisticPrepareMethod);
        methods.put(new Integer(19), getPartialStateMethod);
        methods.put(new Integer(20), enqueueMethodCallMethod);
        methods.put(new Integer(21), notifyCallOnInactiveMethod);
        methods.put(new Integer(22), clusteredGetMethod);
        methods.put(new Integer(23), getChildrenNamesMethodLocal);
        methods.put(new Integer(24), getDataMapMethodLocal);
        methods.put(new Integer(25), getKeysMethodLocal);
        methods.put(new Integer(26), getKeyValueMethodLocal);
        methods.put(new Integer(27), RpcTreeCache.dispatchRpcCallMethod);
        methods.put(new Integer(28), remoteAnnounceBuddyPoolNameMethod);
        methods.put(new Integer(29), remoteAssignToBuddyGroupMethod);
        methods.put(new Integer(30), remoteRemoveFromBuddyGroupMethod);
        methods.put(new Integer(31), getNodeMethodLocal);
        methods.put(new Integer(32), printMethodLocal);
        methods.put(new Integer(33), lockMethodLocal);
        methods.put(new Integer(34), dataGravitationCleanupMethod);
        methods.put(new Integer(35), dataGravitationMethod);
        methods.put(new Integer(36), putDataVersionedMethodLocal);
        methods.put(new Integer(37), putDataEraseVersionedMethodLocal);
        methods.put(new Integer(38), putKeyValVersionedMethodLocal);
        methods.put(new Integer(41), removeDataVersionedMethodLocal);
        methods.put(new Integer(40), removeKeyVersionedMethodLocal);
        methods.put(new Integer(39), removeNodeVersionedMethodLocal);
        Iterator it = methods.keySet().iterator();
        while (it.hasNext()) {
            Object id = it.next();
            Object method = methods.get(id);
            methodIds.put(method, id);
        }
        crud_method_ids.add(new Integer(1));
        crud_method_ids.add(new Integer(2));
        crud_method_ids.add(new Integer(3));
        crud_method_ids.add(new Integer(4));
        crud_method_ids.add(new Integer(5));
        crud_method_ids.add(new Integer(6));
        crud_method_ids.add(new Integer(7));
        crud_method_ids.add(new Integer(34));
        crud_method_ids.add(new Integer(36));
        crud_method_ids.add(new Integer(37));
        crud_method_ids.add(new Integer(38));
        crud_method_ids.add(new Integer(39));
        crud_method_ids.add(new Integer(40));
        crud_method_ids.add(new Integer(41));
        crud_methods.add(putDataMethodLocal);
        crud_methods.add(putDataEraseMethodLocal);
        crud_methods.add(putKeyValMethodLocal);
        crud_methods.add(putFailFastKeyValueMethodLocal);
        crud_methods.add(removeNodeMethodLocal);
        crud_methods.add(removeKeyMethodLocal);
        crud_methods.add(removeDataMethodLocal);
        crud_methods.add(dataGravitationCleanupMethod);
        crud_methods.add(putDataVersionedMethodLocal);
        crud_methods.add(putDataEraseVersionedMethodLocal);
        crud_methods.add(putKeyValVersionedMethodLocal);
        crud_methods.add(removeDataVersionedMethodLocal);
        crud_methods.add(removeNodeVersionedMethodLocal);
        crud_methods.add(removeKeyVersionedMethodLocal);
        optimisticPutMethods.add(putDataEraseMethodLocal);
        optimisticPutMethods.add(putDataMethodLocal);
        optimisticPutMethods.add(putKeyValMethodLocal);
        optimisticPutMethods.add(putDataEraseVersionedMethodLocal);
        optimisticPutMethods.add(putDataVersionedMethodLocal);
        optimisticPutMethods.add(putKeyValVersionedMethodLocal);
    }
}

