/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.dao.cache;

import com.clustercontrol.repository.dao.FacilityTreeDAOImpl;
import com.clustercontrol.repository.ejb.entity.FacilityTreeBean;
import com.clustercontrol.repository.ejb.entity.FacilityTreePK;
import com.clustercontrol.repository.util.RepositoryCacheProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachedFacilityTreeDAOImpl
extends FacilityTreeDAOImpl {
    private static Log m_log = LogFactory.getLog(CachedFacilityTreeDAOImpl.class);
    private Boolean m_isInit = false;
    private static HashMap<ArrayList, Collection> m_findAllCache = null;
    private static long m_findAllCacheHitCount = 0L;
    private static HashMap<String, Collection> m_facilityIdCache = null;
    private static long m_facilityIdCacheHitCount = 0L;
    private static List<HashMap> m_cacheMapList = new ArrayList<HashMap>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Boolean bl = this.m_isInit;
        synchronized (bl) {
            if (this.m_isInit.booleanValue()) {
                return;
            }
            if (RepositoryCacheProperties.getProperties("common.repository.cache.facilitytree.findall") > 0) {
                m_findAllCache = new HashMap();
                m_cacheMapList.add(m_findAllCache);
                m_log.info((Object)"FacilityTreeDAO findAllCache : enable");
            }
            if (RepositoryCacheProperties.getProperties("common.repository.cache.facilitytree.facilityid") > 0) {
                m_facilityIdCache = new HashMap();
                m_cacheMapList.add(m_facilityIdCache);
                m_log.info((Object)"FacilityTreeDAO facilityIdCache : enable");
            }
            this.m_isInit = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearCacheAll() {
        List<HashMap> list = m_cacheMapList;
        synchronized (list) {
            Iterator<HashMap> itr = m_cacheMapList.iterator();
            while (itr.hasNext()) {
                HashMap map;
                HashMap hashMap = map = itr.next();
                synchronized (hashMap) {
                    m_log.debug((Object)("clearCache() clear : " + map.size()));
                    map.clear();
                }
            }
        }
    }

    public void store(FacilityTreeBean ejb) throws EJBException {
        m_log.debug((Object)"store()");
        super.store(ejb);
        CachedFacilityTreeDAOImpl.clearCacheAll();
    }

    public void remove(FacilityTreePK pk) throws RemoveException, EJBException {
        m_log.debug((Object)"remove()");
        super.remove(pk);
        CachedFacilityTreeDAOImpl.clearCacheAll();
    }

    public FacilityTreePK create(FacilityTreeBean ejb) throws CreateException, EJBException {
        m_log.debug((Object)"create()");
        FacilityTreePK pk = super.create(ejb);
        CachedFacilityTreeDAOImpl.clearCacheAll();
        return pk;
    }

    public Collection findAll() throws FinderException {
        return this.findAll(null, null);
    }

    public Collection findAll(String facilityId) throws FinderException {
        return this.findAll(facilityId, null);
    }

    public Collection findAllNode(String facilityId) throws FinderException {
        return this.findAll(facilityId, new Integer(1));
    }

    public Collection findAllScope(String facilityId) throws FinderException {
        return this.findAll(facilityId, new Integer(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findAll(String facilityId, Integer type) throws FinderException {
        if (m_findAllCache == null) {
            return super.findAll(facilityId, type);
        }
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(facilityId);
        key.add(type);
        HashMap<ArrayList, Collection> hashMap = m_findAllCache;
        synchronized (hashMap) {
            if (m_findAllCache.containsKey(key)) {
                if (m_log.isDebugEnabled() && ++m_findAllCacheHitCount % 1000L == 0L) {
                    m_log.debug((Object)("findAll(String facilityId, Integer type) hit : " + m_findAllCacheHitCount));
                }
                return m_findAllCache.get(key);
            }
        }
        Collection ret = super.findAll(facilityId, type);
        HashMap<ArrayList, Collection> hashMap2 = m_findAllCache;
        synchronized (hashMap2) {
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)("findAll(String facilityId, Integer type) put : " + facilityId + ", " + type + "  entry size : " + ret.size() + "  total entry : " + m_findAllCache.size()));
            }
            m_findAllCache.put(key, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findByFacilityId(String facilityId) throws FinderException {
        if (m_facilityIdCache == null) {
            return super.findByFacilityId(facilityId);
        }
        HashMap<String, Collection> hashMap = m_facilityIdCache;
        synchronized (hashMap) {
            if (m_facilityIdCache.containsKey(facilityId)) {
                if (m_log.isDebugEnabled() && ++m_facilityIdCacheHitCount % 1000L == 0L) {
                    m_log.debug((Object)("findByFacilityId(String facilityId) hit : " + m_facilityIdCacheHitCount));
                }
                return m_facilityIdCache.get(facilityId);
            }
        }
        Collection ret = super.findByFacilityId(facilityId);
        HashMap<String, Collection> hashMap2 = m_facilityIdCache;
        synchronized (hashMap2) {
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)("findByFacilityId(String facilityId) put : " + facilityId + "  entry size : " + ret.size() + "  total entry : " + m_facilityIdCache.size()));
            }
            m_facilityIdCache.put(facilityId, ret);
        }
        return ret;
    }
}

