/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.XYDataset;
import org.jfree.util.ObjectUtils;

public class StandardXYURLGenerator
implements XYURLGenerator,
Serializable {
    private String prefix = "index.html";
    private String seriesParameterName = "series";
    private String itemParameterName = "item";

    public StandardXYURLGenerator() {
    }

    public StandardXYURLGenerator(String sPrefix) {
        this.prefix = sPrefix;
    }

    public StandardXYURLGenerator(String prefix, String seriesParameterName, String itemParameterName) {
        this.prefix = prefix;
        this.seriesParameterName = seriesParameterName;
        this.itemParameterName = itemParameterName;
    }

    public String generateURL(XYDataset dataset, int series, int item) {
        String url = this.prefix;
        boolean firstParameter = url.indexOf("?") == -1;
        url = url + (firstParameter ? "?" : "&");
        url = url + this.seriesParameterName + "=" + series + "&" + this.itemParameterName + "=" + item;
        return url;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof StandardXYURLGenerator) {
            StandardXYURLGenerator g = (StandardXYURLGenerator)obj;
            boolean b0 = ObjectUtils.equal((Object)g.prefix, (Object)this.prefix);
            boolean b1 = ObjectUtils.equal((Object)g.seriesParameterName, (Object)this.seriesParameterName);
            boolean b2 = ObjectUtils.equal((Object)g.itemParameterName, (Object)this.itemParameterName);
            return b0 && b1 && b2;
        }
        return false;
    }
}

