/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.marshalling;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.Constants;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.introspection.FieldInfo;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.sunday.marshalling.AbstractAttributeMarshaller;
import org.jboss.xb.binding.sunday.marshalling.MarshallingContext;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;

public class DefaultAttributeMarshaller
extends AbstractAttributeMarshaller {
    public static final DefaultAttributeMarshaller INSTANCE = new DefaultAttributeMarshaller();

    public Object getValue(MarshallingContext ctx) {
        Object owner = ctx.peek();
        SchemaBinding schema = ctx.getSchemaBinding();
        AttributeBinding binding = ctx.getAttributeBinding();
        QName qName = binding.getQName();
        String fieldName = null;
        PropertyMetaData propertyMetaData = binding.getPropertyMetaData();
        if (propertyMetaData != null) {
            fieldName = propertyMetaData.getName();
        }
        if (fieldName == null) {
            fieldName = Util.xmlNameToFieldName(qName.getLocalPart(), schema.isIgnoreLowLine());
        }
        FieldInfo fieldInfo = FieldInfo.getFieldInfo(owner.getClass(), fieldName, binding.getRequired() && !schema.isIgnoreUnresolvedFieldOrClass());
        Object value = null;
        if (fieldInfo != null) {
            value = fieldInfo.getValue(owner);
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String marshalValue(MarshallingContext ctx, Object value) {
        if (value == null) {
            return null;
        }
        AttributeBinding binding = ctx.getAttributeBinding();
        TypeBinding attrType = binding.getType();
        if (attrType.getItemType() != null) {
            List<Object> list;
            TypeBinding itemType = attrType.getItemType();
            if (!"http://www.w3.org/2001/XMLSchema".equals(itemType.getQName().getNamespaceURI())) throw new JBossXBRuntimeException("Marshalling of list types with item types not from http://www.w3.org/2001/XMLSchema is not supported.");
            if (value instanceof List) {
                list = (List<Object>)value;
            } else {
                if (!value.getClass().isArray()) throw new JBossXBRuntimeException("Expected value for list type is an array or " + List.class.getName() + " but got: " + value);
                list = Arrays.asList((Object[])value);
            }
            if (!Constants.QNAME_QNAME.getLocalPart().equals(itemType.getQName().getLocalPart())) return SimpleTypeBindings.marshalList(itemType.getQName().getLocalPart(), list, null);
            String attrLocal = binding.getQName().getLocalPart();
            int listInd = 0;
            while (listInd < list.size()) {
                QName item = (QName)list.get(listInd);
                String itemNs = item.getNamespaceURI();
                if (itemNs != null && itemNs.length() > 0) {
                    String itemPrefix = ctx.getPrefix(itemNs);
                    if (itemPrefix == null) {
                        itemPrefix = item.getPrefix();
                        if (itemPrefix == null || itemPrefix.length() == 0) {
                            itemPrefix = attrLocal + listInd;
                        }
                        ctx.declareNamespace(itemPrefix, itemNs);
                    }
                    if (!itemPrefix.equals(item.getPrefix())) {
                        item = new QName(item.getNamespaceURI(), item.getLocalPart(), itemPrefix);
                        list.set(listInd, item);
                    }
                }
                ++listInd;
            }
            return SimpleTypeBindings.marshalList(itemType.getQName().getLocalPart(), list, null);
        }
        if (attrType.getLexicalPattern() != null && attrType.getBaseType() != null && Constants.QNAME_BOOLEAN.equals(attrType.getBaseType().getQName())) {
            String item = (String)attrType.getLexicalPattern().get(0);
            if (item.indexOf(48) != -1 && item.indexOf(49) != -1) {
                if ((Boolean)value == false) return "0";
                return "1";
            }
            if ((Boolean)value == false) return "false";
            return "true";
        }
        if (!Constants.QNAME_QNAME.equals(attrType.getQName())) return value.toString();
        boolean removePrefix = false;
        String prefix = null;
        String ns = ((QName)value).getNamespaceURI();
        if (ns != null && ns.length() > 0) {
            prefix = ctx.getPrefix(ns);
            if (prefix == null) {
                prefix = ((QName)value).getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    prefix = "ns_" + ((QName)value).getLocalPart();
                }
                ctx.declareNamespace(prefix, ns);
            }
            ctx.getNamespaceContext().addPrefixMapping(prefix, ns);
            removePrefix = true;
        }
        String marshalled = SimpleTypeBindings.marshalQName((QName)value, ctx.getNamespaceContext());
        if (!removePrefix) return marshalled;
        ctx.getNamespaceContext().removePrefixMapping(prefix);
        return marshalled;
    }
}

