/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.annotation;

import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.jboss.aop.annotation.AnnotationProxy;
import org.jboss.aop.annotation.ProxyMapCreator;
import org.jboss.aop.annotation.ast.ASTAnnotation;
import org.jboss.aop.annotation.ast.ASTChar;
import org.jboss.aop.annotation.ast.ASTIdentifier;
import org.jboss.aop.annotation.ast.ASTMemberValueArrayInitializer;
import org.jboss.aop.annotation.ast.ASTMemberValuePair;
import org.jboss.aop.annotation.ast.ASTMemberValuePairs;
import org.jboss.aop.annotation.ast.ASTSingleMemberValue;
import org.jboss.aop.annotation.ast.ASTStart;
import org.jboss.aop.annotation.ast.ASTString;
import org.jboss.aop.annotation.ast.AnnotationParser;
import org.jboss.aop.annotation.ast.AnnotationParserVisitor;
import org.jboss.aop.annotation.ast.Node;
import org.jboss.aop.annotation.ast.SimpleNode;

public class AnnotationCreator
implements AnnotationParserVisitor {
    private Class annotation;
    private Class type;
    public Object typeValue;

    public AnnotationCreator(Class annotation, Class type) {
        this.type = type;
        this.annotation = annotation;
    }

    public Object visit(ASTMemberValuePairs node, Object data) {
        node.childrenAccept(this, data);
        return null;
    }

    public Object visit(ASTMemberValuePair node, Object data) {
        String name = node.getIdentifier().getValue();
        node.getValue().jjtAccept(this, name);
        return data;
    }

    public Object visit(ASTSingleMemberValue node, Object data) {
        node.getValue().jjtAccept(this, "value");
        return data;
    }

    public Object visit(ASTIdentifier node, Object data) {
        try {
            if (this.type.equals(Class.class)) {
                String classname = node.getValue();
                if (classname.endsWith(".class")) {
                    classname = classname.substring(0, classname.indexOf(".class"));
                }
                this.typeValue = classname.equals("void") ? Void.TYPE : (classname.equals("int") ? Integer.TYPE : (classname.equals("byte") ? Byte.TYPE : (classname.equals("long") ? Long.TYPE : (classname.equals("double") ? Double.TYPE : (classname.equals("float") ? Float.TYPE : (classname.equals("char") ? Character.TYPE : (classname.equals("short") ? Short.TYPE : (classname.equals("boolean") ? Boolean.TYPE : Thread.currentThread().getContextClassLoader().loadClass(classname)))))))));
            } else if (this.type.isPrimitive()) {
                if (this.type.equals(Boolean.TYPE)) {
                    this.typeValue = new Boolean(node.getValue());
                } else if (this.type.equals(Short.TYPE)) {
                    this.typeValue = Short.valueOf(node.getValue());
                } else if (this.type.equals(Float.TYPE)) {
                    this.typeValue = Float.valueOf(node.getValue());
                } else if (this.type.equals(Double.TYPE)) {
                    this.typeValue = Double.valueOf(node.getValue());
                } else if (this.type.equals(Long.TYPE)) {
                    this.typeValue = Long.valueOf(node.getValue());
                } else if (this.type.equals(Byte.TYPE)) {
                    this.typeValue = new Byte(node.getValue());
                } else if (this.type.equals(Integer.TYPE)) {
                    this.typeValue = new Integer(node.getValue());
                }
            } else {
                int index = node.getValue().lastIndexOf(46);
                if (index == -1) {
                    throw new RuntimeException("Enum must be fully qualified: " + node.getValue());
                }
                String className = node.getValue().substring(0, index);
                String en = node.getValue().substring(index + 1);
                Class<?> enumClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                if (enumClass.getSuperclass().getName().equals("java.lang.Enum")) {
                    Method valueOf = null;
                    Method[] methods = enumClass.getSuperclass().getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        if (!methods[i].getName().equals("valueOf")) continue;
                        valueOf = methods[i];
                        break;
                    }
                    Object[] args = new Object[]{enumClass, en};
                    this.typeValue = valueOf.invoke(null, args);
                } else {
                    Field field = enumClass.getField(en);
                    this.typeValue = field.get(null);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public Object visit(ASTString node, Object data) {
        if (!this.type.equals(String.class)) {
            throw new RuntimeException(this.annotation.getName() + "." + data + " is not an String");
        }
        this.typeValue = node.getValue();
        return null;
    }

    public Object visit(ASTChar node, Object data) {
        if (!this.type.equals(Character.TYPE)) {
            throw new RuntimeException(this.annotation.getName() + "." + data + " is not an char");
        }
        this.typeValue = new Character(node.getValue());
        return null;
    }

    public Object visit(ASTMemberValueArrayInitializer node, Object data) {
        if (!this.type.isArray()) {
            throw new RuntimeException(this.annotation.getName() + "." + data + " is not an array");
        }
        Class<?> baseType = this.type.getComponentType();
        int size = node.jjtGetNumChildren();
        this.typeValue = Array.newInstance(baseType, size);
        for (int i = 0; i < size; ++i) {
            AnnotationCreator creator = new AnnotationCreator(this.annotation, baseType);
            node.jjtGetChild(i).jjtAccept(creator, null);
            Array.set(this.typeValue, i, creator.typeValue);
        }
        return null;
    }

    public Object visit(ASTAnnotation node, Object data) {
        try {
            Class<?> subAnnotation = Thread.currentThread().getContextClassLoader().loadClass(node.getIdentifier());
            this.typeValue = AnnotationCreator.createAnnotation(node, subAnnotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public Object visit(SimpleNode node, Object data) {
        return null;
    }

    public Object visit(ASTStart node, Object data) {
        return null;
    }

    public static Object createAnnotation(ASTAnnotation node, Class annotation) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (node.jjtGetNumChildren() > 0) {
            Node contained = node.jjtGetChild(0);
            if (contained instanceof ASTSingleMemberValue) {
                Class type = ProxyMapCreator.getMemberType(annotation, "value");
                AnnotationCreator creator = new AnnotationCreator(annotation, type);
                contained.jjtAccept(creator, "value");
                map.put("value", creator.typeValue);
            } else {
                ASTMemberValuePairs pairs = (ASTMemberValuePairs)contained;
                for (int i = 0; i < pairs.jjtGetNumChildren(); ++i) {
                    ASTMemberValuePair member = (ASTMemberValuePair)pairs.jjtGetChild(i);
                    Class type = ProxyMapCreator.getMemberType(annotation, member.getIdentifier().getValue());
                    AnnotationCreator creator = new AnnotationCreator(annotation, type);
                    member.jjtAccept(creator, null);
                    map.put(member.getIdentifier().getValue(), creator.typeValue);
                }
            }
        }
        return AnnotationProxy.createProxy(map, annotation);
    }

    public static Object createAnnotation(String annotationExpr, Class annotation) throws Exception {
        AnnotationParser parser = new AnnotationParser(new StringReader(annotationExpr));
        ASTStart start = parser.Start();
        ASTAnnotation node = (ASTAnnotation)start.jjtGetChild(0);
        return AnnotationCreator.createAnnotation(node, annotation);
    }
}

