/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jboss.reflect.plugins.AnnotationHolder;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class FieldInfoImpl
extends AnnotationHolder
implements FieldInfo {
    private static final long serialVersionUID = 3546084661584539959L;
    protected String name;
    protected Field field;
    protected TypeInfo type;
    protected int modifiers;
    protected ClassInfo declaringClass;
    protected int hash = -1;

    public FieldInfoImpl() {
    }

    public FieldInfoImpl(AnnotationValue[] annotations, String name, TypeInfo type, int modifiers, ClassInfo declaring) {
        super(annotations);
        this.name = name;
        this.type = type;
        this.modifiers = modifiers;
        this.declaringClass = declaring;
        this.calculateHash();
    }

    public void setField(Field field) {
        this.field = field;
    }

    public String getName() {
        return this.name;
    }

    public Field getField() {
        return this.field;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public ClassInfo getDeclaringClass() {
        return this.declaringClass;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof FieldInfoImpl)) {
            return false;
        }
        FieldInfoImpl other = (FieldInfoImpl)obj;
        if (!this.declaringClass.equals(other.declaringClass)) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.hash;
    }

    protected void calculateHash() {
        int result = this.name.hashCode();
        this.hash = result = 29 * result + this.declaringClass.hashCode();
    }
}

