/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.operator;

import com.clustercontrol.bean.PollerProtocolConstant;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorPollingMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorPollingMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorPollingMstPK;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorPollingMstUtil;
import com.clustercontrol.sharedtable.DataTable;
import com.clustercontrol.sharedtable.TableEntry;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Operator {
    private static Log m_log = LogFactory.getLog(Operator.class);
    private String collectMethod;
    private String platformId;
    private String subPlatformId;
    private String itemCode;
    private List<String> variables = new ArrayList<String>();
    private DataTable currentTable;
    private DataTable previousTable;
    private long deviceIndex;
    private String deviceName;
    private static final long COUNTER32_MAX_VALUE = 0xFFFFFFFFL;
    private static final BigInteger COUTNER64_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE).shiftLeft(1).add(BigInteger.valueOf(1L));
    private HashMap<String, CollectorPollingMstData> m_oidMap = new HashMap();

    public abstract double calc() throws CollectedDataNotFoundException, InvalidValueException;

    protected void setDataTable(DataTable currentTable, DataTable previousTable) {
        this.currentTable = currentTable;
        this.previousTable = previousTable;
    }

    protected double getCurrentMibValue(String variable) throws CollectedDataNotFoundException, InvalidValueException {
        return this.getValue(variable, this.getCurrentTable());
    }

    protected double getPreviousMibValue(String variable) throws CollectedDataNotFoundException, InvalidValueException {
        return this.getValue(variable, this.getPreviousTable());
    }

    protected double getCurrentMibValueTotal() throws CollectedDataNotFoundException, InvalidValueException {
        Iterator<String> itr = this.getVariables().iterator();
        double total = 0.0;
        while (itr.hasNext()) {
            String variable = itr.next();
            total += this.getCurrentMibValue(variable);
        }
        return total;
    }

    protected double getPreviousMibValueTotal() throws CollectedDataNotFoundException, InvalidValueException {
        Iterator<String> itr = this.getVariables().iterator();
        double total = 0.0;
        while (itr.hasNext()) {
            String variable = itr.next();
            total += this.getPreviousMibValue(variable);
        }
        return total;
    }

    protected double getDifferenceValue(String variable) throws CollectedDataNotFoundException, InvalidValueException {
        m_log.debug((Object)("getDifferenceValue " + variable));
        CollectorPollingMstData data = this.getCollectorPollingMstData(variable);
        String entryKey = data.getEntryKey();
        String targetIndex = entryKey.substring(entryKey.lastIndexOf(".") + 1);
        m_log.debug((Object)("getValue() targetIndex : " + targetIndex));
        DataTable currentTable = this.getCurrentTable();
        DataTable previousTable = this.getPreviousTable();
        if ("?".equals(targetIndex)) {
            if (this.getCollectMethod().equals("SNMP")) {
                try {
                    String pollingTarget = data.getPollingTarget() + "." + this.getDeviceIndex();
                    return this.getMibValueDiff(data, currentTable, previousTable, PollerProtocolConstant.getEntryKey((String)this.getCollectMethod(), (String)pollingTarget), PollerProtocolConstant.getEntryKey((String)this.getCollectMethod(), (String)pollingTarget));
                }
                catch (InvalidValueException e) {
                    throw e;
                }
                catch (Exception e) {
                    m_log.debug((Object)e.getMessage(), (Throwable)e);
                    throw new CollectedDataNotFoundException();
                }
            }
            if (this.getCollectMethod().equals("WBEM")) {
                CollectorPollingMstData wbemData = this.getCollectorPollingMstData("key");
                String pollingTarget = wbemData.getPollingTarget();
                m_log.debug((Object)("getDifferenceValue() targetKey : " + pollingTarget));
                Set currentEntrys = currentTable.getValueSetStartWith(PollerProtocolConstant.getEntryKey((String)this.getCollectMethod(), (String)pollingTarget));
                Set previousEntrys = previousTable.getValueSetStartWith(PollerProtocolConstant.getEntryKey((String)this.getCollectMethod(), (String)pollingTarget));
                if (currentEntrys == null || previousEntrys == null) {
                    throw new CollectedDataNotFoundException();
                }
                String currentIndex = null;
                for (TableEntry entry : currentEntrys) {
                    if (!((String)entry.getValue()).equals(this.getDeviceName())) continue;
                    currentIndex = entry.getKey().substring(entry.getKey().lastIndexOf("."));
                    break;
                }
                String previousIndex = null;
                for (TableEntry entry : previousEntrys) {
                    if (!((String)entry.getValue()).equals(this.getDeviceName())) continue;
                    previousIndex = entry.getKey().substring(entry.getKey().lastIndexOf("."));
                    break;
                }
                m_log.debug((Object)("getDifferenceValue() currentIndex : " + currentIndex + ", previousIndex : " + previousIndex));
                if (currentIndex == null || previousIndex == null) {
                    throw new CollectedDataNotFoundException();
                }
                pollingTarget = data.getPollingTarget();
                try {
                    return this.getMibValueDiff(data, currentTable, previousTable, PollerProtocolConstant.getEntryKey((String)this.getCollectMethod(), (String)(pollingTarget + currentIndex)), PollerProtocolConstant.getEntryKey((String)this.getCollectMethod(), (String)(pollingTarget + previousIndex)));
                }
                catch (InvalidValueException e) {
                    throw e;
                }
                catch (Exception e) {
                    m_log.debug((Object)e.getMessage(), (Throwable)e);
                    throw new CollectedDataNotFoundException();
                }
            }
            throw new CollectedDataNotFoundException();
        }
        if ("*".equals(targetIndex)) {
            try {
                String pollingTarget = data.getPollingTarget();
                Set entrys = currentTable.getValueSetStartWith(PollerProtocolConstant.getEntryKey((String)this.getCollectMethod(), (String)pollingTarget));
                if (entrys == null) {
                    throw new CollectedDataNotFoundException();
                }
                double total = 0.0;
                Iterator itr = entrys.iterator();
                while (itr.hasNext()) {
                    String tableEntryKey = ((TableEntry)itr.next()).getKey();
                    total += this.getMibValueDiff(data, currentTable, previousTable, tableEntryKey, tableEntryKey);
                }
                return total;
            }
            catch (InvalidValueException e) {
                throw e;
            }
            catch (Exception e) {
                m_log.debug((Object)e.getMessage(), (Throwable)e);
                throw new CollectedDataNotFoundException();
            }
        }
        try {
            return this.getMibValueDiff(data, currentTable, previousTable, PollerProtocolConstant.getEntryKey((String)this.getCollectMethod(), (String)entryKey), PollerProtocolConstant.getEntryKey((String)this.getCollectMethod(), (String)entryKey));
        }
        catch (InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            m_log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CollectedDataNotFoundException();
        }
    }

    protected double getDifferenceValueTotal() throws CollectedDataNotFoundException, InvalidValueException {
        Iterator<String> itr = this.getVariables().iterator();
        double total = 0.0;
        while (itr.hasNext()) {
            String variable = itr.next();
            total += this.getDifferenceValue(variable);
        }
        return total;
    }

    protected double getValue(String variable, DataTable table) throws CollectedDataNotFoundException, InvalidValueException {
        CollectorPollingMstData data = this.getCollectorPollingMstData(variable);
        String entryKey = data.getEntryKey();
        String targetIndex = entryKey.substring(entryKey.lastIndexOf(".") + 1);
        m_log.debug((Object)("getValue() targetIndex : " + targetIndex));
        if ("?".equals(targetIndex)) {
            if (this.getCollectMethod().equals("SNMP")) {
                try {
                    String pollingTarget = data.getPollingTarget() + "." + this.getDeviceIndex();
                    return this.getMibValueDouble(table, data, PollerProtocolConstant.getEntryKey((String)this.getCollectMethod(), (String)pollingTarget));
                }
                catch (InvalidValueException e) {
                    throw e;
                }
                catch (Exception e) {
                    m_log.debug((Object)e.getMessage(), (Throwable)e);
                    throw new CollectedDataNotFoundException();
                }
            }
            if (this.getCollectMethod().equals("WBEM")) {
                CollectorPollingMstData wbemData = this.getCollectorPollingMstData("key");
                String pollingTarget = wbemData.getPollingTarget();
                m_log.debug((Object)("getValue() targetKey : " + pollingTarget));
                Set entrys = table.getValueSetStartWith(PollerProtocolConstant.getEntryKey((String)this.getCollectMethod(), (String)pollingTarget));
                if (entrys == null) {
                    throw new CollectedDataNotFoundException();
                }
                String index = null;
                for (TableEntry entry : entrys) {
                    if (!((String)entry.getValue()).equals(this.getDeviceName())) continue;
                    index = entry.getKey().substring(entry.getKey().lastIndexOf("."));
                    break;
                }
                m_log.debug((Object)("getValue() index : " + index));
                if (index == null) {
                    throw new CollectedDataNotFoundException();
                }
                pollingTarget = data.getPollingTarget();
                try {
                    return this.getMibValueDouble(table, data, PollerProtocolConstant.getEntryKey((String)this.getCollectMethod(), (String)(pollingTarget + index)));
                }
                catch (InvalidValueException e) {
                    throw e;
                }
                catch (Exception e) {
                    m_log.debug((Object)e.getMessage(), (Throwable)e);
                    throw new CollectedDataNotFoundException();
                }
            }
            throw new CollectedDataNotFoundException();
        }
        if ("*".equals(targetIndex)) {
            try {
                String pollingTarget = data.getPollingTarget();
                Set entrys = table.getValueSetStartWith(PollerProtocolConstant.getEntryKey((String)this.getCollectMethod(), (String)pollingTarget));
                if (entrys == null) {
                    throw new CollectedDataNotFoundException();
                }
                double total = 0.0;
                Iterator itr = entrys.iterator();
                while (itr.hasNext()) {
                    String tableEntryKey = ((TableEntry)itr.next()).getKey();
                    total += this.getMibValueDouble(table, data, tableEntryKey);
                }
                return total;
            }
            catch (Exception e) {
                m_log.debug((Object)e.getMessage(), (Throwable)e);
                throw new CollectedDataNotFoundException();
            }
        }
        try {
            return this.getMibValueDouble(table, data, PollerProtocolConstant.getEntryKey((String)this.getCollectMethod(), (String)entryKey));
        }
        catch (InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            m_log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CollectedDataNotFoundException();
        }
    }

    private long getMibValueLong(DataTable table, CollectorPollingMstData data, String entryKey) throws InvalidValueException {
        m_log.debug((Object)("getMibValueLong() entryKey : " + entryKey));
        TableEntry entry = table.getValue(entryKey);
        if (entry == null) {
            return Long.parseLong(data.getFailureValue());
        }
        long value = (Long)entry.getValue();
        return value;
    }

    private double getMibValueDouble(DataTable table, CollectorPollingMstData data, String entryKey) throws InvalidValueException {
        long longValue = this.getMibValueLong(table, data, entryKey);
        return this.convLongToDouble(longValue);
    }

    private double convLongToDouble(long longValue) {
        double ret = longValue;
        if (longValue < 0L) {
            long tmp = longValue - Long.MAX_VALUE;
            ret = 9.223372036854776E18 + (double)tmp;
        }
        return ret;
    }

    private double getMibValueDiff(CollectorPollingMstData data, DataTable currentTable, DataTable previousTable, String currentEntryKey, String previousEntryKey) throws InvalidValueException {
        double ret = 0.0;
        long previousValue = this.getMibValueLong(previousTable, data, previousEntryKey);
        long currentValue = this.getMibValueLong(currentTable, data, currentEntryKey);
        long diff = currentValue - previousValue;
        if (diff >= 0L) {
            ret = diff;
        } else if ("Counter32".equals(data.getValueType()) || "Uint32".equals(data.getValueType())) {
            diff = 0x100000000L + diff;
            ret = this.convLongToDouble(diff);
        } else if ("Counter64".equals(data.getValueType()) || "Uint64".equals(data.getValueType())) {
            ret = COUTNER64_MAX_VALUE.add(BigInteger.valueOf(diff + 1L)).doubleValue();
        }
        return ret;
    }

    private CollectorPollingMstData getCollectorPollingMstData(String variable) {
        CollectorPollingMstData data = this.m_oidMap.get(variable);
        if (data == null) {
            this.registerOidMap(variable);
            data = this.m_oidMap.get(variable);
            if (data == null) {
                throw new IllegalStateException();
            }
        }
        return data;
    }

    private void registerOidMap(String variable) {
        try {
            m_log.debug((Object)(this.getPlatformId() + ", " + this.getItemCode() + ", " + variable));
            CollectorPollingMstLocal bean = CollectorPollingMstUtil.getLocalHome().findByPrimaryKey(new CollectorPollingMstPK(this.getCollectMethod(), this.getPlatformId(), this.getSubPlatformId(), this.getItemCode(), variable));
            CollectorPollingMstData data = new CollectorPollingMstData(bean.getCollectMethod(), bean.getPlatformId(), bean.getSubPlatformId(), bean.getItemCode(), bean.getVariableId(), bean.getEntryKey(), bean.getValueType(), bean.getPollingTarget(), bean.getFailureValue());
            this.m_oidMap.put(variable, data);
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public DataTable getCurrentTable() {
        return this.currentTable;
    }

    public void setCurrentTable(DataTable currentTable) {
        this.currentTable = currentTable;
    }

    public DataTable getPreviousTable() {
        return this.previousTable;
    }

    public void setPreviousTable(DataTable previousTable) {
        this.previousTable = previousTable;
    }

    public String getCollectMethod() {
        return this.collectMethod;
    }

    public void setCollectMethod(String collectMethod) {
        this.collectMethod = collectMethod;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public String getSubPlatformId() {
        return this.subPlatformId;
    }

    public void setSubPlatformId(String subPlatformId) {
        this.subPlatformId = subPlatformId;
    }

    public String getItemCode() {
        return this.itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
        try {
            Collection beans = CollectorPollingMstUtil.getLocalHome().findByCollectMethodAndPlatformIdAndSubPlatformIdAndItemCode(this.getCollectMethod(), this.getPlatformId(), this.getSubPlatformId(), itemCode);
            Iterator itr = beans.iterator();
            this.getVariables().clear();
            while (itr.hasNext()) {
                CollectorPollingMstLocal bean = (CollectorPollingMstLocal)itr.next();
                m_log.debug((Object)("add " + bean.getVariableId()));
                this.getVariables().add(bean.getVariableId());
            }
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public long getDeviceIndex() {
        return this.deviceIndex;
    }

    public void setDeviceIndex(long deviceIndex) {
        this.deviceIndex = deviceIndex;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public void setVariables(List<String> variables) {
        this.variables = variables;
    }

    public class CollectedDataNotFoundException
    extends Exception {
        private static final long serialVersionUID = 6306555743811316089L;
    }

    public class InvalidValueException
    extends Exception {
        private static final long serialVersionUID = -1102457433444726271L;
    }
}

