/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.AbstractJBossManager;
import org.jboss.web.tomcat.service.session.ClusteredSession;

public class JvmRouteValve
extends ValveBase
implements Lifecycle {
    private static final String info = "JvmRouteValve/1.0";
    protected static Logger log_ = Logger.getLogger(JvmRouteValve.class);
    protected LifecycleSupport support = new LifecycleSupport((Lifecycle)this);
    protected AbstractJBossManager manager_;

    public JvmRouteValve(AbstractJBossManager manager) {
        this.manager_ = manager;
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.checkJvmRoute(request, response);
        this.getNext().invoke(request, response);
    }

    public void checkJvmRoute(Request req, Response res) throws IOException, ServletException {
        String oldsessionId = req.getRequestedSessionId();
        HttpSession session = req.getSession(false);
        if (session != null) {
            String sessionId = session.getId();
            String jvmRoute = this.manager_.getJvmRoute();
            if (log_.isDebugEnabled()) {
                log_.debug((Object)("checkJvmRoute(): check if need to re-route based on JvmRoute. Session id: " + sessionId + " jvmRoute: " + jvmRoute));
            }
            if (jvmRoute == null) {
                throw new RuntimeException("JvmRouteValve.checkJvmRoute(): Tomcat JvmRoute is null. Need to assign a value in Tomcat server.xml for load balancing.");
            }
            boolean setCookie = !req.isRequestedSessionIdFromURL();
            this.handleJvmRoute(oldsessionId, sessionId, jvmRoute, (HttpServletResponse)res, setCookie);
        }
    }

    protected void handleJvmRoute(String oldsessionId, String sessionId, String jvmRoute, HttpServletResponse response, boolean setCookie) {
        String base;
        String receivedJvmRoute = null;
        int index = oldsessionId.lastIndexOf(".");
        if (index > 0) {
            receivedJvmRoute = oldsessionId.substring(index + 1, oldsessionId.length());
        }
        String requestedJvmRoute = null;
        index = sessionId.lastIndexOf(".");
        if (index > 0) {
            requestedJvmRoute = sessionId.substring(index + 1, sessionId.length());
        }
        String newId = null;
        if (!jvmRoute.equals(requestedJvmRoute)) {
            if (requestedJvmRoute == null) {
                newId = sessionId + "." + jvmRoute;
            } else {
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)("handleJvmRoute(): We have detected a failover with different jvmRoute. old one: " + requestedJvmRoute + " new one: " + jvmRoute + ". Will reset the session id."));
                }
                base = sessionId.substring(0, index);
                newId = base + "." + jvmRoute;
            }
            this.resetSessionId(sessionId, newId);
        }
        if (!jvmRoute.equals(receivedJvmRoute)) {
            if (log_.isDebugEnabled()) {
                log_.debug((Object)("handleJvmRoute(): We have detected a failover with different jvmRoute. received one: " + receivedJvmRoute + " new one: " + jvmRoute + ". Will resent the session id."));
            }
            base = sessionId.substring(0, index);
            newId = base + "." + jvmRoute;
        }
        if (setCookie && newId != null) {
            this.manager_.setNewSessionCookie(newId, response);
        }
    }

    private void resetSessionId(String oldId, String newId) {
        try {
            ClusteredSession session = (ClusteredSession)this.manager_.findSession(oldId);
            if (session != null) {
                session.resetIdWithRouteInfo(newId);
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)("resetSessionId(): changed catalina session to= [" + newId + "] old one= [" + oldId + "]"));
                }
            } else if (log_.isDebugEnabled()) {
                log_.debug((Object)("resetSessionId(): no session with id " + newId + " found"));
            }
        }
        catch (IOException e) {
            if (log_.isDebugEnabled()) {
                log_.debug((Object)("resetSessionId(): manager_.findSession() unable to find session= [" + oldId + "]"), (Throwable)e);
            }
            throw new RuntimeException("JvmRouteValve.resetSessionId(): cannot find session [" + oldId + "]", e);
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.support.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.support.removeLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.support.findLifecycleListeners();
    }

    public void start() throws LifecycleException {
        this.support.fireLifecycleEvent("start", (Object)this);
    }

    public void stop() throws LifecycleException {
        this.support.fireLifecycleEvent("stop", (Object)this);
    }
}

