/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.SnapshotManager;

public final class SessionReplicationContext {
    private static final ThreadLocal replicationContext = new ThreadLocal();
    private static final SessionReplicationContext EMPTY = new SessionReplicationContext();
    private int webappCount;
    private int activityCount;
    private SnapshotManager soleManager;
    private ClusteredSession soleSession;
    private Map crossCtxSessions;
    private Map expiredSessions;
    private Request outerRequest;
    private Response outerResponse;

    public static void enterWebapp(Request request, Response response, boolean startCacheActivity) {
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        if (ctx == null) {
            ctx = new SessionReplicationContext(request, response);
            replicationContext.set(ctx);
        }
        ++ctx.webappCount;
        if (startCacheActivity) {
            ++ctx.activityCount;
        }
    }

    public static SessionReplicationContext exitWebapp() {
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        if (ctx != null) {
            --ctx.webappCount;
            if (ctx.webappCount < 1) {
                ctx.outerRequest = null;
                ctx.outerResponse = null;
                if (ctx.activityCount < 1) {
                    replicationContext.set(null);
                }
                return ctx;
            }
        }
        return EMPTY;
    }

    public static void bindSession(ClusteredSession session, SnapshotManager manager) {
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        if (ctx != null && ctx.webappCount > 0) {
            ctx.addReplicatableSession(session, manager);
        }
    }

    public static void sessionExpired(ClusteredSession session, String realId, SnapshotManager manager) {
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        if (ctx != null && ctx.webappCount > 0) {
            ctx.addExpiredSession(session, manager);
        }
    }

    public static boolean isSessionBoundAndExpired(String realId, SnapshotManager manager) {
        boolean result = false;
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        if (ctx != null) {
            result = ctx.isSessionExpired(realId, manager);
        }
        return result;
    }

    public static void startCacheActivity() {
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        if (ctx == null) {
            ctx = new SessionReplicationContext();
            replicationContext.set(ctx);
        }
        ++ctx.activityCount;
    }

    public static void finishCacheActivity() {
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        if (ctx != null) {
            --ctx.activityCount;
            if (ctx.activityCount < 1 && ctx.webappCount < 1) {
                replicationContext.set(null);
            }
        }
    }

    public static boolean isLocallyActive() {
        return SessionReplicationContext.getCurrentContext() != null;
    }

    public static Request getOriginalRequest() {
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        return ctx == null ? null : ctx.outerRequest;
    }

    public static Response getOriginalResponse() {
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        return ctx == null ? null : ctx.outerResponse;
    }

    private static SessionReplicationContext getCurrentContext() {
        return (SessionReplicationContext)replicationContext.get();
    }

    private SessionReplicationContext(Request request, Response response) {
        this.outerRequest = request;
        this.outerResponse = response;
    }

    private SessionReplicationContext() {
    }

    public Map getCrossContextSessions() {
        return this.crossCtxSessions;
    }

    public SnapshotManager getSoleSnapshotManager() {
        return this.soleManager;
    }

    public ClusteredSession getSoleSession() {
        return this.soleSession;
    }

    private void addReplicatableSession(ClusteredSession session, SnapshotManager mgr) {
        if (this.crossCtxSessions != null) {
            this.crossCtxSessions.put(session, mgr);
        } else if (this.soleManager == null) {
            this.soleManager = mgr;
            this.soleSession = session;
        } else if (!mgr.equals(this.soleManager)) {
            this.crossCtxSessions = new HashMap();
            this.crossCtxSessions.put(this.soleSession, this.soleManager);
            this.crossCtxSessions.put(session, mgr);
            this.soleManager = null;
            this.soleSession = null;
        } else {
            this.soleSession = session;
        }
    }

    private void addExpiredSession(ClusteredSession session, SnapshotManager manager) {
        boolean store = manager.equals(this.soleManager);
        if (store) {
            this.soleManager = null;
            this.soleSession = null;
        } else if (this.crossCtxSessions != null) {
            boolean bl = store = this.crossCtxSessions.remove(session) != null;
        }
        if (store) {
            if (this.expiredSessions == null) {
                this.expiredSessions = new HashMap();
            }
            this.expiredSessions.put(manager, session.getRealId());
        }
    }

    private boolean isSessionExpired(String realId, SnapshotManager manager) {
        boolean result = false;
        if (this.expiredSessions != null) {
            result = realId.equals(this.expiredSessions.get(manager));
        }
        return result;
    }
}

