/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;

class MethodVerifier15
extends MethodVerifier {
    MethodVerifier15(LookupEnvironment environment) {
        super(environment);
    }

    boolean areMethodsEqual(MethodBinding one, MethodBinding two) {
        MethodBinding sub = this.computeSubstituteMethod(two, one);
        return sub != null && this.doesSubstituteMethodOverride(one, sub) && this.areReturnTypesEqual(one, sub);
    }

    boolean areParametersEqual(MethodBinding one, MethodBinding two) {
        TypeBinding[] oneArgs = one.parameters;
        TypeBinding[] twoArgs = two.parameters;
        if (oneArgs == twoArgs) {
            return true;
        }
        int length = oneArgs.length;
        if (length != twoArgs.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!(this.areTypesEqual(oneArgs[i], twoArgs[i]) || !one.declaringClass.isInterface() && oneArgs[i].leafComponentType().isRawType() && oneArgs[i].dimensions() == twoArgs[i].dimensions() && oneArgs[i].leafComponentType().isEquivalentTo(twoArgs[i].leafComponentType()))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean areReturnTypesEqual(MethodBinding one, MethodBinding substituteTwo) {
        return this.areReturnTypesCompatible(one, substituteTwo);
    }

    boolean areTypesEqual(TypeBinding one, TypeBinding two) {
        if (one == two) {
            return true;
        }
        if (one.isParameterizedType() && two.isParameterizedType()) {
            return one.isEquivalentTo(two) && two.isEquivalentTo(one);
        }
        return false;
    }

    boolean canSkipInheritedMethods() {
        if (this.type.superclass() != null && (this.type.superclass().isAbstract() || this.type.superclass().isParameterizedType())) {
            return false;
        }
        return this.type.superInterfaces() == Binding.NO_SUPERINTERFACES;
    }

    boolean canSkipInheritedMethods(MethodBinding one, MethodBinding two) {
        return two == null || one.declaringClass == two.declaringClass && !one.declaringClass.isParameterizedType();
    }

    void checkConcreteInheritedMethod(MethodBinding concreteMethod, MethodBinding[] abstractMethods) {
        super.checkConcreteInheritedMethod(concreteMethod, abstractMethods);
        int i = 0;
        int l = abstractMethods.length;
        while (i < l) {
            MethodBinding abstractMethod = abstractMethods[i];
            if (concreteMethod.isVarargs() != abstractMethod.isVarargs()) {
                this.problemReporter().varargsConflict(concreteMethod, abstractMethod, this.type);
            }
            MethodBinding originalInherited = abstractMethod.original();
            if (originalInherited.returnType != concreteMethod.returnType) {
                TypeBinding currentReturnType;
                if (abstractMethod.returnType.leafComponentType().isParameterizedType()) {
                    if (concreteMethod.returnType.leafComponentType().isRawType()) {
                        this.problemReporter().unsafeReturnTypeOverride(concreteMethod, originalInherited, this.type);
                    }
                } else if (abstractMethod.hasSubstitutedReturnType() && originalInherited.returnType.leafComponentType().isTypeVariable() && ((TypeVariableBinding)originalInherited.returnType.leafComponentType()).declaringElement == originalInherited && (!(currentReturnType = concreteMethod.returnType.leafComponentType()).isTypeVariable() || ((TypeVariableBinding)currentReturnType).declaringElement != concreteMethod)) {
                    this.problemReporter().unsafeReturnTypeOverride(concreteMethod, originalInherited, this.type);
                }
            }
            if (originalInherited.declaringClass.isInterface() && this.type.superclass.erasure().findSuperTypeWithSameErasure(originalInherited.declaringClass) == null) {
                this.type.addSyntheticBridgeMethod(originalInherited, concreteMethod.original());
            }
            ++i;
        }
    }

    void checkForBridgeMethod(MethodBinding currentMethod, MethodBinding inheritedMethod, MethodBinding[] allInheritedMethods) {
        if (currentMethod.isVarargs() != inheritedMethod.isVarargs()) {
            this.problemReporter(currentMethod).varargsConflict(currentMethod, inheritedMethod, this.type);
        }
        MethodBinding originalInherited = inheritedMethod.original();
        if (originalInherited.returnType != currentMethod.returnType) {
            TypeBinding currentReturnType;
            if (inheritedMethod.returnType.leafComponentType().isParameterizedType()) {
                if (currentMethod.returnType.leafComponentType().isRawType()) {
                    this.problemReporter(currentMethod).unsafeReturnTypeOverride(currentMethod, originalInherited, this.type);
                }
            } else if (inheritedMethod.hasSubstitutedReturnType() && originalInherited.returnType.leafComponentType().isTypeVariable() && ((TypeVariableBinding)originalInherited.returnType.leafComponentType()).declaringElement == originalInherited && (!(currentReturnType = currentMethod.returnType.leafComponentType()).isTypeVariable() || ((TypeVariableBinding)currentReturnType).declaringElement != currentMethod)) {
                this.problemReporter(currentMethod).unsafeReturnTypeOverride(currentMethod, originalInherited, this.type);
            }
        }
        if (this.type.addSyntheticBridgeMethod(originalInherited, currentMethod.original()) != null) {
            int i = 0;
            int l = allInheritedMethods.length;
            while (i < l) {
                MethodBinding compareMethod;
                MethodBinding substitute;
                MethodBinding otherInheritedMethod = allInheritedMethods[i];
                MethodBinding otherOriginal = otherInheritedMethod.original();
                if (otherOriginal != originalInherited && otherOriginal != otherInheritedMethod && (substitute = this.computeSubstituteMethod(otherInheritedMethod, compareMethod = inheritedMethod instanceof ParameterizedGenericMethodBinding ? ((ParameterizedGenericMethodBinding)inheritedMethod).originalMethod : inheritedMethod)) != null && !this.doesSubstituteMethodOverride(compareMethod, substitute) && this.detectInheritedNameClash(originalInherited, otherOriginal)) {
                    return;
                }
                ++i;
            }
        }
    }

    void checkForInheritedNameClash(MethodBinding inheritedMethod, MethodBinding otherInheritedMethod) {
        if (inheritedMethod.declaringClass.isInterface() || inheritedMethod.isStatic()) {
            return;
        }
        this.detectInheritedNameClash(inheritedMethod, otherInheritedMethod);
    }

    void checkForNameClash(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (currentMethod.declaringClass.isInterface() || currentMethod.isStatic()) {
            return;
        }
        if (!this.detectNameClash(currentMethod, inheritedMethod)) {
            TypeBinding[] currentParams = currentMethod.parameters;
            int length = currentParams.length;
            TypeBinding[] inheritedParams = inheritedMethod.parameters;
            if (length != inheritedParams.length) {
                return;
            }
            int i = 0;
            while (i < length) {
                if (!(currentParams[i] == inheritedParams[i] || currentParams[i].isBaseType() == inheritedParams[i].isBaseType() && inheritedParams[i].isCompatibleWith(currentParams[i]))) {
                    return;
                }
                ++i;
            }
            ReferenceBinding[] interfacesToVisit = null;
            int nextPosition = 0;
            ReferenceBinding superType = inheritedMethod.declaringClass;
            ReferenceBinding[] itsInterfaces = superType.superInterfaces();
            if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
                nextPosition = itsInterfaces.length;
                interfacesToVisit = itsInterfaces;
            }
            superType = superType.superclass();
            while (superType != null && superType.isValidBinding()) {
                MethodBinding[] methods = superType.getMethods(currentMethod.selector);
                int m = 0;
                int n = methods.length;
                while (m < n) {
                    MethodBinding substitute = this.computeSubstituteMethod(methods[m], currentMethod);
                    if (substitute != null && !this.doesSubstituteMethodOverride(currentMethod, substitute) && this.detectNameClash(currentMethod, substitute)) {
                        return;
                    }
                    ++m;
                }
                itsInterfaces = superType.superInterfaces();
                if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
                    if (interfacesToVisit == null) {
                        interfacesToVisit = itsInterfaces;
                        nextPosition = interfacesToVisit.length;
                    } else {
                        int itsLength = itsInterfaces.length;
                        if (nextPosition + itsLength >= interfacesToVisit.length) {
                            ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                            interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                            System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                        }
                        int a = 0;
                        while (a < itsLength) {
                            block25: {
                                ReferenceBinding next = itsInterfaces[a];
                                int b = 0;
                                while (b < nextPosition) {
                                    if (next != interfacesToVisit[b]) {
                                        ++b;
                                        continue;
                                    }
                                    break block25;
                                }
                                interfacesToVisit[nextPosition++] = next;
                            }
                            ++a;
                        }
                    }
                }
                superType = superType.superclass();
            }
            int i2 = 0;
            while (i2 < nextPosition) {
                superType = interfacesToVisit[i2];
                if (superType.isValidBinding()) {
                    MethodBinding[] methods = superType.getMethods(currentMethod.selector);
                    int m = 0;
                    int n = methods.length;
                    while (m < n) {
                        MethodBinding substitute = this.computeSubstituteMethod(methods[m], currentMethod);
                        if (substitute != null && !this.doesSubstituteMethodOverride(currentMethod, substitute) && this.detectNameClash(currentMethod, substitute)) {
                            return;
                        }
                        ++m;
                    }
                    itsInterfaces = superType.superInterfaces();
                    if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
                        int itsLength = itsInterfaces.length;
                        if (nextPosition + itsLength >= interfacesToVisit.length) {
                            ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                            interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                            System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                        }
                        int a = 0;
                        while (a < itsLength) {
                            block26: {
                                ReferenceBinding next = itsInterfaces[a];
                                int b = 0;
                                while (b < nextPosition) {
                                    if (next != interfacesToVisit[b]) {
                                        ++b;
                                        continue;
                                    }
                                    break block26;
                                }
                                interfacesToVisit[nextPosition++] = next;
                            }
                            ++a;
                        }
                    }
                }
                ++i2;
            }
        }
    }

    void checkInheritedMethods(MethodBinding[] methods, int length) {
        int count = length;
        int i = 0;
        int l = length - 1;
        block0: while (i < l) {
            MethodBinding method = methods[i++];
            int j = i;
            while (j <= l) {
                if (method.declaringClass == methods[j].declaringClass && this.areMethodsEqual(method, methods[j])) {
                    this.problemReporter().duplicateInheritedMethods(this.type, method, methods[j]);
                    --count;
                    methods[i - 1] = null;
                    continue block0;
                }
                ++j;
            }
        }
        if (count < length) {
            if (count == 1) {
                return;
            }
            MethodBinding[] newMethods = new MethodBinding[count];
            int i2 = length;
            while (--i2 >= 0) {
                if (methods[i2] == null) continue;
                newMethods[--count] = methods[i2];
            }
            methods = newMethods;
            length = newMethods.length;
        }
        super.checkInheritedMethods(methods, length);
    }

    boolean checkInheritedReturnTypes(MethodBinding[] methods, int length) {
        if (methods[0].declaringClass.isClass()) {
            return super.checkInheritedReturnTypes(methods, length);
        }
        int i = 0;
        int l = length - 1;
        while (i < l) {
            MethodBinding method = methods[i++];
            int j = i;
            while (j <= l) {
                if (!this.areReturnTypesEqual(method, methods[j])) {
                    if (this.type.isInterface()) {
                        int m = length;
                        while (--m >= 0) {
                            if (methods[m].declaringClass.id != 1) continue;
                            return false;
                        }
                    }
                    this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(this.type, methods, length);
                    return false;
                }
                ++j;
            }
        }
        return true;
    }

    void checkMethods() {
        boolean mustImplementAbstractMethods = this.mustImplementAbstractMethods();
        boolean skipInheritedMethods = mustImplementAbstractMethods && this.canSkipInheritedMethods();
        char[][] methodSelectors = this.inheritedMethods.keyTable;
        int s = methodSelectors.length;
        while (--s >= 0) {
            int j;
            int i;
            MethodBinding[] current;
            if (methodSelectors[s] == null || (current = (MethodBinding[])this.currentMethods.get(methodSelectors[s])) == null && skipInheritedMethods) continue;
            MethodBinding[] inherited = (MethodBinding[])this.inheritedMethods.valueTable[s];
            if (inherited.length == 1 && current == null) {
                if (!mustImplementAbstractMethods || !inherited[0].isAbstract()) continue;
                this.checkAbstractMethod(inherited[0]);
                continue;
            }
            int index = -1;
            MethodBinding[] matchingInherited = new MethodBinding[inherited.length];
            byte[] foundMatch = new byte[inherited.length];
            if (current != null) {
                i = 0;
                int length1 = current.length;
                while (i < length1) {
                    MethodBinding currentMethod = current[i];
                    j = 0;
                    int length2 = inherited.length;
                    while (j < length2) {
                        MethodBinding inheritedMethod = this.computeSubstituteMethod(inherited[j], currentMethod);
                        if (inheritedMethod != null) {
                            if (foundMatch[j] == 0 && this.doesSubstituteMethodOverride(currentMethod, inheritedMethod)) {
                                matchingInherited[++index] = inheritedMethod;
                                foundMatch[j] = 1;
                            } else {
                                this.checkForNameClash(currentMethod, inheritedMethod);
                            }
                        }
                        ++j;
                    }
                    if (index >= 0) {
                        this.checkAgainstInheritedMethods(currentMethod, matchingInherited, index + 1, inherited);
                        while (index >= 0) {
                            matchingInherited[index--] = null;
                        }
                    }
                    ++i;
                }
            }
            i = 0;
            int length = inherited.length;
            while (i < length) {
                if (foundMatch[i] != 1) {
                    MethodBinding inheritedMethod = inherited[i];
                    matchingInherited[++index] = inheritedMethod;
                    j = i + 1;
                    while (j < length) {
                        MethodBinding otherInheritedMethod = inherited[j];
                        if (foundMatch[j] != 1 && !this.canSkipInheritedMethods(inheritedMethod, otherInheritedMethod) && (otherInheritedMethod = this.computeSubstituteMethod(otherInheritedMethod, inheritedMethod)) != null) {
                            if (this.doesSubstituteMethodOverride(inheritedMethod, otherInheritedMethod)) {
                                matchingInherited[++index] = otherInheritedMethod;
                                foundMatch[j] = 1;
                            } else {
                                this.checkForInheritedNameClash(inheritedMethod, otherInheritedMethod);
                            }
                        }
                        ++j;
                    }
                    if (index != -1) {
                        if (index > 0) {
                            this.checkInheritedMethods(matchingInherited, index + 1);
                        } else if (mustImplementAbstractMethods && index == 0 && matchingInherited[0].isAbstract()) {
                            this.checkAbstractMethod(matchingInherited[0]);
                        }
                        while (index >= 0) {
                            matchingInherited[index--] = null;
                        }
                    }
                }
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void checkTypeVariableMethods() {
        methodSelectors = this.inheritedMethods.keyTable;
        s = methodSelectors.length;
        block0: while (--s >= 0) {
            if (methodSelectors[s] == null || (inherited = (MethodBinding[])this.inheritedMethods.valueTable[s]).length == 1) continue;
            index = -1;
            matchingInherited = new MethodBinding[inherited.length];
            i = 0;
            length = inherited.length;
            ** GOTO lbl33
            {
                matchingInherited[index--] = null;
                do {
                    if (index >= 0) continue block1;
                    inheritedMethod = inherited[i];
                    if (inheritedMethod != null) {
                        matchingInherited[++index] = inheritedMethod;
                        j = i + 1;
                        while (j < length) {
                            otherInheritedMethod = inherited[j];
                            if (!this.canSkipInheritedMethods(inheritedMethod, otherInheritedMethod) && (otherInheritedMethod = this.computeSubstituteMethod(otherInheritedMethod, inheritedMethod)) != null && this.doesSubstituteMethodOverride(inheritedMethod, otherInheritedMethod)) {
                                matchingInherited[++index] = otherInheritedMethod;
                                inherited[j] = null;
                            }
                            ++j;
                        }
                    }
                    if (index > 0) {
                        first = matchingInherited[0];
                        count = index + 1;
                        while (--count > 0 && this.areReturnTypesEqual(first, matchingInherited[count])) {
                        }
                        if (count > 0) {
                            this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(this.type, matchingInherited, index + 1);
                            continue block0;
                        }
                    }
                    ++i;
lbl33:
                    // 2 sources

                } while (i < length);
            }
        }
    }

    MethodBinding computeSubstituteMethod(MethodBinding inheritedMethod, MethodBinding currentMethod) {
        TypeVariableBinding[] inheritedTypeVariables;
        if (inheritedMethod == null) {
            return null;
        }
        if (currentMethod.parameters.length != inheritedMethod.parameters.length) {
            return null;
        }
        if (currentMethod.declaringClass instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)currentMethod.declaringClass).resolveTypesFor(currentMethod);
        }
        if (inheritedMethod.declaringClass instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)inheritedMethod.declaringClass).resolveTypesFor(inheritedMethod);
        }
        if ((inheritedTypeVariables = inheritedMethod.typeVariables) == Binding.NO_TYPE_VARIABLES) {
            return inheritedMethod;
        }
        int inheritedLength = inheritedTypeVariables.length;
        TypeVariableBinding[] typeVariables = currentMethod.typeVariables;
        int length = typeVariables.length;
        if (length > 0 && inheritedLength != length) {
            return inheritedMethod;
        }
        TypeBinding[] arguments = new TypeBinding[inheritedLength];
        if (inheritedLength <= length) {
            System.arraycopy(typeVariables, 0, arguments, 0, inheritedLength);
        } else {
            System.arraycopy(typeVariables, 0, arguments, 0, length);
            int i = length;
            while (i < inheritedLength) {
                arguments[i] = inheritedTypeVariables[i].upperBound();
                ++i;
            }
        }
        ParameterizedGenericMethodBinding substitute = this.environment.createParameterizedGenericMethod(inheritedMethod, arguments);
        int i = 0;
        while (i < inheritedLength) {
            block21: {
                TypeBinding argument;
                TypeVariableBinding inheritedTypeVariable;
                block18: {
                    TypeVariableBinding typeVariable;
                    block20: {
                        block19: {
                            inheritedTypeVariable = inheritedTypeVariables[i];
                            argument = arguments[i];
                            if (!(argument instanceof TypeVariableBinding)) break block18;
                            typeVariable = (TypeVariableBinding)argument;
                            if (typeVariable.firstBound != inheritedTypeVariable.firstBound) break block19;
                            if (typeVariable.firstBound != null) break block20;
                            break block21;
                        }
                        if (typeVariable.firstBound != null && inheritedTypeVariable.firstBound != null && typeVariable.firstBound.isClass() != inheritedTypeVariable.firstBound.isClass()) {
                            return inheritedMethod;
                        }
                    }
                    if (Scope.substitute((Substitution)substitute, inheritedTypeVariable.superclass) != typeVariable.superclass) {
                        return inheritedMethod;
                    }
                    int interfaceLength = inheritedTypeVariable.superInterfaces.length;
                    ReferenceBinding[] interfaces = typeVariable.superInterfaces;
                    if (interfaceLength != interfaces.length) {
                        return inheritedMethod;
                    }
                    int j = 0;
                    while (j < interfaceLength) {
                        block17: {
                            TypeBinding superType = Scope.substitute((Substitution)substitute, inheritedTypeVariable.superInterfaces[j]);
                            int k = 0;
                            while (k < interfaceLength) {
                                if (superType != interfaces[k]) {
                                    ++k;
                                    continue;
                                }
                                break block17;
                            }
                            return inheritedMethod;
                        }
                        ++j;
                    }
                    break block21;
                }
                if (inheritedTypeVariable.boundCheck(substitute, argument) != 0) {
                    return inheritedMethod;
                }
            }
            ++i;
        }
        return substitute;
    }

    boolean detectInheritedNameClash(MethodBinding inherited, MethodBinding otherInherited) {
        if (!inherited.areParameterErasuresEqual(otherInherited) || inherited.returnType.erasure() != otherInherited.returnType.erasure()) {
            return false;
        }
        this.problemReporter().inheritedMethodsHaveNameClash(this.type, inherited, otherInherited);
        return true;
    }

    boolean detectNameClash(MethodBinding current, MethodBinding inherited) {
        MethodBinding original = inherited.original();
        if (!current.areParameterErasuresEqual(original) || current.returnType.erasure() != original.returnType.erasure()) {
            return false;
        }
        this.problemReporter(current).methodNameClash(current, original);
        return true;
    }

    public boolean doesMethodOverride(MethodBinding method, MethodBinding inheritedMethod) {
        MethodBinding substitute = this.computeSubstituteMethod(inheritedMethod, method);
        return substitute != null && this.doesSubstituteMethodOverride(method, substitute);
    }

    boolean doesSubstituteMethodOverride(MethodBinding method, MethodBinding substituteMethod) {
        if (this.doTypeVariablesClash(method, substituteMethod)) {
            return false;
        }
        if (this.areParametersEqual(method, substituteMethod)) {
            return true;
        }
        if (method.declaringClass == substituteMethod.declaringClass) {
            return false;
        }
        TypeBinding[] params = method.parameters;
        int length = params.length;
        TypeBinding[] inheritedParams = substituteMethod.parameters;
        if (length != inheritedParams.length) {
            return false;
        }
        if (method.typeVariables != Binding.NO_TYPE_VARIABLES || !substituteMethod.hasSubstitutedParameters()) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (inheritedParams[i].kind() == 4100 ? params[i] != ((TypeVariableBinding)inheritedParams[i]).upperBound() : params[i] != inheritedParams[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean doTypeVariablesClash(MethodBinding one, MethodBinding substituteTwo) {
        return one.typeVariables != Binding.NO_TYPE_VARIABLES && !(substituteTwo instanceof ParameterizedGenericMethodBinding);
    }

    boolean isInterfaceMethodImplemented(MethodBinding inheritedMethod, MethodBinding existingMethod, ReferenceBinding superType) {
        if (inheritedMethod.original() != inheritedMethod && existingMethod.declaringClass.isInterface()) {
            return false;
        }
        return (inheritedMethod = this.computeSubstituteMethod(inheritedMethod, existingMethod)) != null && inheritedMethod.returnType == existingMethod.returnType && super.isInterfaceMethodImplemented(inheritedMethod, existingMethod, superType);
    }

    SimpleSet findSuperinterfaceCollisions(ReferenceBinding superclass, ReferenceBinding[] superInterfaces) {
        ReferenceBinding[] interfacesToVisit = null;
        int nextPosition = 0;
        ReferenceBinding[] itsInterfaces = superInterfaces;
        if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
            nextPosition = itsInterfaces.length;
            interfacesToVisit = itsInterfaces;
        }
        boolean isInconsistent = this.type.isHierarchyInconsistent();
        ReferenceBinding superType = superclass;
        while (superType != null && superType.isValidBinding()) {
            isInconsistent |= superType.isHierarchyInconsistent();
            itsInterfaces = superType.superInterfaces();
            if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
                if (interfacesToVisit == null) {
                    interfacesToVisit = itsInterfaces;
                    nextPosition = interfacesToVisit.length;
                } else {
                    int itsLength = itsInterfaces.length;
                    if (nextPosition + itsLength >= interfacesToVisit.length) {
                        ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                    }
                    int a = 0;
                    while (a < itsLength) {
                        block22: {
                            ReferenceBinding next = itsInterfaces[a];
                            int b = 0;
                            while (b < nextPosition) {
                                if (next != interfacesToVisit[b]) {
                                    ++b;
                                    continue;
                                }
                                break block22;
                            }
                            interfacesToVisit[nextPosition++] = next;
                        }
                        ++a;
                    }
                }
            }
            superType = superType.superclass();
        }
        int i = 0;
        while (i < nextPosition) {
            superType = interfacesToVisit[i];
            if (superType.isValidBinding()) {
                isInconsistent |= superType.isHierarchyInconsistent();
                itsInterfaces = superType.superInterfaces();
                if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
                    int itsLength = itsInterfaces.length;
                    if (nextPosition + itsLength >= interfacesToVisit.length) {
                        ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                    }
                    int a = 0;
                    while (a < itsLength) {
                        block23: {
                            ReferenceBinding next = itsInterfaces[a];
                            int b = 0;
                            while (b < nextPosition) {
                                if (next != interfacesToVisit[b]) {
                                    ++b;
                                    continue;
                                }
                                break block23;
                            }
                            interfacesToVisit[nextPosition++] = next;
                        }
                        ++a;
                    }
                }
            }
            ++i;
        }
        if (!isInconsistent) {
            return null;
        }
        SimpleSet copy = null;
        int i2 = 0;
        while (i2 < nextPosition) {
            ReferenceBinding current = interfacesToVisit[i2];
            if (current.isValidBinding()) {
                TypeBinding erasure = current.erasure();
                int j = i2 + 1;
                while (j < nextPosition) {
                    ReferenceBinding next = interfacesToVisit[j];
                    if (next.isValidBinding() && next.erasure() == erasure) {
                        if (copy == null) {
                            copy = new SimpleSet(nextPosition);
                        }
                        copy.add(interfacesToVisit[i2]);
                        copy.add(interfacesToVisit[j]);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        return copy;
    }

    boolean reportIncompatibleReturnTypeError(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (currentMethod.typeVariables == Binding.NO_TYPE_VARIABLES && inheritedMethod.original().typeVariables != Binding.NO_TYPE_VARIABLES && currentMethod.returnType.erasure().findSuperTypeWithSameErasure(inheritedMethod.returnType.erasure()) != null) {
            this.problemReporter(currentMethod).unsafeReturnTypeOverride(currentMethod, inheritedMethod, this.type);
            return false;
        }
        return super.reportIncompatibleReturnTypeError(currentMethod, inheritedMethod);
    }

    void verify(SourceTypeBinding someType) {
        if (someType.isAnnotationType()) {
            someType.detectAnnotationCycle();
        }
        super.verify(someType);
        int i = someType.typeVariables.length;
        while (--i >= 0) {
            TypeVariableBinding var = someType.typeVariables[i];
            if (var.superInterfaces == Binding.NO_SUPERINTERFACES || var.superInterfaces.length == 1 && var.superclass.id == 1) continue;
            this.currentMethods = new HashtableOfObject(0);
            ReferenceBinding superclass = var.superclass();
            if (superclass.kind() == 4100) {
                superclass = (ReferenceBinding)superclass.erasure();
            }
            ReferenceBinding[] itsInterfaces = var.superInterfaces();
            ReferenceBinding[] superInterfaces = new ReferenceBinding[itsInterfaces.length];
            int j = itsInterfaces.length;
            while (--j >= 0) {
                ReferenceBinding referenceBinding = superInterfaces[j] = itsInterfaces[j].kind() == 4100 ? (ReferenceBinding)itsInterfaces[j].erasure() : itsInterfaces[j];
            }
            this.computeInheritedMethods(superclass, superInterfaces);
            this.checkTypeVariableMethods();
        }
    }
}

