/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.maintenance.factory;

import com.clustercontrol.bean.Schedule;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;
import com.clustercontrol.quartzmanager.util.QuartzUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;

public class SelectSchedule {
    protected static Log m_log = LogFactory.getLog(SelectSchedule.class);

    public ArrayList getSchedule(String maintenanceId) throws NamingException, SchedulerException {
        ArrayList info = new ArrayList();
        QuartzManager manager = QuartzUtil.getQuartzManager();
        try {
            JobDetail job = null;
            try {
                job = manager.getJobDetail(maintenanceId, "MAINTENANCE");
            }
            catch (RemoteException e) {
                // empty catch block
            }
            info = this.createScheduleArrayList(job);
        }
        catch (NamingException e1) {
            e1.printStackTrace();
        }
        catch (SchedulerException e1) {
            e1.printStackTrace();
        }
        return info;
    }

    public ArrayList getScheduleList() throws NamingException, SchedulerException {
        m_log.debug((Object)"getScheduleList()");
        ArrayList<ArrayList> list = new ArrayList<ArrayList>();
        QuartzManager manager = QuartzUtil.getQuartzManager();
        String[] jobs = null;
        try {
            jobs = manager.getJobs("MAINTENANCE");
        }
        catch (RemoteException e) {
            // empty catch block
        }
        for (int i = 0; i < jobs.length; ++i) {
            JobDetail job = null;
            try {
                job = manager.getJobDetail(jobs[i], "MAINTENANCE");
            }
            catch (RemoteException e) {
                // empty catch block
            }
            ArrayList info = this.createScheduleArrayList(job);
            list.add(info);
        }
        return list;
    }

    private ArrayList createScheduleArrayList(JobDetail jobDetail) {
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.add(jobDetail.getName());
        ret.add(jobDetail.getDescription());
        Object[] jdArgs = (Object[])jobDetail.getJobDataMap().get((Object)"args");
        ret.add((String)jdArgs[0]);
        String jobName = (String)jobDetail.getJobDataMap().get((Object)"maintenanceName");
        ret.add(jobName);
        if (jdArgs.length > 1) {
            ret.add((String)jdArgs[1]);
        } else {
            ret.add("");
        }
        Schedule schedule = (Schedule)jobDetail.getJobDataMap().get((Object)"schedule");
        ret.add(schedule);
        Integer valid = (Integer)jobDetail.getJobDataMap().get((Object)"valid");
        ret.add(valid);
        String createUser = (String)jobDetail.getJobDataMap().get((Object)"createUser");
        ret.add(createUser);
        Date createDate = (Date)jobDetail.getJobDataMap().get((Object)"createDate");
        ret.add(createDate);
        String upadteUser = (String)jobDetail.getJobDataMap().get((Object)"updateUser");
        ret.add(upadteUser);
        Date upadteDate = (Date)jobDetail.getJobDataMap().get((Object)"updateDate");
        ret.add(upadteDate);
        return ret;
    }
}

