/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.vm.factory;

import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.vm.bean.NodeOperationCommandConstant;
import com.clustercontrol.vm.bean.NodeOperationStatusConstant;
import com.clustercontrol.vm.bean.NodeOperationTypeId;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailData;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailLocal;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailPK;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailUtil;
import com.clustercontrol.vm.util.CreateSessionId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OperationRun {
    protected static Log m_log = LogFactory.getLog(OperationRun.class);

    public String createSession(String commandId, String facilityId, Locale locale) throws CreateException, FinderException, NamingException {
        m_log.debug((Object)("createSession() : start commandId = " + commandId + ", facilityId = " + facilityId));
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
        String sessionId = null;
        sessionId = CreateSessionId.getNewSessionId();
        m_log.debug((Object)("createSession() : sessionId = " + sessionId));
        ArrayList nodeIdList = null;
        Short typeId = NodeOperationCommandConstant.COMMANDIDS.get(commandId);
        if (typeId == null) {
            m_log.error((Object)("typeId is null. commandId=" + commandId));
        }
        if (typeId.equals(NodeOperationTypeId.GUEST)) {
            nodeIdList = repository.getExecTargetFacilityIdList(facilityId);
            m_log.debug((Object)"createSession() : This command is guest command");
        } else {
            nodeIdList = repository.getExecTargetFacilityIdList(facilityId);
            m_log.debug((Object)"createSession() : This command is host command");
        }
        if (nodeIdList instanceof ArrayList) {
            for (int i = 0; i < nodeIdList.size(); ++i) {
                ArrayList<String> Attribute = new ArrayList<String>();
                Attribute.add("cn");
                Attribute.add("ccVirtualizationNodeType");
                HashMap map = repository.getNodeDetail((String)nodeIdList.get(i), Attribute);
                VmOperationDetailUtil.getLocalHome().create(sessionId, (String)nodeIdList.get(i), (String)map.get("cn"), (String)map.get("ccVirtualizationNodeType"), commandId, NodeOperationStatusConstant.READY, null, null, null, null, null);
            }
        }
        m_log.debug((Object)("createSession() : end commandId = " + commandId + ", facilityId = " + facilityId));
        return sessionId;
    }

    public void run(String sessionId) throws FinderException, NamingException, JMSException {
        m_log.debug((Object)("run() : start sessionId=" + sessionId));
        this.startNode(sessionId);
        m_log.debug((Object)("run() : end sessionId=" + sessionId));
    }

    protected void startNode(String sessionId) throws FinderException, NamingException, JMSException {
        m_log.debug((Object)("startNode() : start sessionId =" + sessionId));
        Collection collection = VmOperationDetailUtil.getLocalHome().findBySessionId(sessionId);
        if (collection != null && collection.size() > 0) {
            SendQueue send = null;
            try {
                send = new SendQueue("queue/clustercontrolVmControlExecute");
            }
            catch (NamingException e) {
                m_log.debug((Object)("startNode() : \u5b9f\u884c\u6307\u793a\u30ad\u30e5\u30fc\u751f\u6210 : " + e.getMessage()), (Throwable)e);
                throw e;
            }
            catch (JMSException e) {
                m_log.debug((Object)("startNode() : \u5b9f\u884c\u6307\u793a\u30ad\u30e5\u30fc\u751f\u6210 : " + e.getMessage()), (Throwable)e);
                throw e;
            }
            for (VmOperationDetailLocal local : collection) {
                VmOperationDetailData data = new VmOperationDetailData(local.getSessionId(), local.getFacilityId(), local.getScopeText(), local.getNodeType(), local.getCommandId(), local.getStatus(), local.getStartDate(), local.getEndStatus(), local.getEndDate(), local.getEndValue(), local.getMessage());
                try {
                    send.put((Serializable)data);
                }
                catch (JMSException e) {
                    m_log.debug((Object)("startNode() : \u5b9f\u884c\u6307\u793a\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()), (Throwable)e);
                }
            }
            try {
                send.terminate();
            }
            catch (JMSException e) {
                m_log.debug((Object)("startNode() : \u5b9f\u884c\u6307\u793a\u30ad\u30e5\u30fc\u5f8c\u51e6\u7406\u30a8\u30e9\u30fc : " + e.getMessage()), (Throwable)e);
            }
        }
        m_log.debug((Object)("startNode() : end sessionId =" + sessionId));
    }

    public void endNode(VmOperationDetailData data) throws FinderException, NamingException {
        m_log.debug((Object)("endNode() : start sessionId = " + data.getSessionId() + ",status=" + data.getStatus()));
        VmOperationDetailLocal local = VmOperationDetailUtil.getLocalHome().findByPrimaryKey(new VmOperationDetailPK(data.getSessionId(), data.getFacilityId()));
        if (local.getStatus() != null) {
            if (data.getStatus().equals(NodeOperationStatusConstant.RUNNING) && local.getStatus().equals(NodeOperationStatusConstant.READY)) {
                local.setStatus(data.getStatus());
                local.setStartDate(data.getStartDate());
            } else if (local.getStatus().equals(NodeOperationStatusConstant.RUNNING)) {
                local.setStatus(data.getStatus());
                local.setEndStatus(data.getEndStatus());
                local.setEndDate(data.getEndDate());
                local.setEndValue(data.getEndValue());
                local.setMessage(data.getMessage());
            } else {
                m_log.warn((Object)("endNode() : sessionId = " + data.getSessionId() + ", local status to " + local.getStatus()));
                this.testPrintVmOperationDetail(local);
            }
            m_log.debug((Object)("endNode() : sessionId = " + data.getSessionId() + ", status to " + data.getStatus() + ", endStatus to " + data.getEndStatus()));
        } else {
            m_log.info((Object)("endNode() : sessionId = " + data.getSessionId() + ", status is null"));
        }
        m_log.debug((Object)("endNode() : end sessionId = " + data.getSessionId() + ",status=" + data.getStatus()));
    }

    private void testPrintVmOperationDetail(VmOperationDetailLocal local) {
        m_log.info((Object)(".getSessionId :" + local.getSessionId()));
        m_log.info((Object)(".getFacilityId :" + local.getFacilityId()));
        m_log.info((Object)(".getScopeText :" + local.getScopeText()));
        m_log.info((Object)(".getTypeId :" + local.getNodeType()));
        m_log.info((Object)(".getCommandId :" + local.getCommandId()));
        m_log.info((Object)(".getStatus :" + local.getStatus()));
        m_log.info((Object)(".getStartDate :" + local.getStartDate()));
        m_log.info((Object)(".getStartDate :" + local.getEndStatus()));
        m_log.info((Object)(".getEndDate :" + local.getEndDate()));
        m_log.info((Object)(".getEndValue :" + local.getEndValue()));
        m_log.info((Object)(".getMessage :" + local.getMessage()));
    }
}

