/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.jdbc.ResultSetWrapper;

public class ColumnNameCache {
    private final Map columnNameToIndexCache;

    public ColumnNameCache(int columnCount) {
        this.columnNameToIndexCache = new HashMap(columnCount);
    }

    public int getIndexForColumnName(String columnName, ResultSetWrapper rs) throws SQLException {
        Integer cached = (Integer)this.columnNameToIndexCache.get(columnName);
        if (cached != null) {
            return cached;
        }
        int index = rs.getTarget().findColumn(columnName);
        this.columnNameToIndexCache.put(columnName, new Integer(index));
        return index;
    }
}

