/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.EJBMethodPermission;
import org.jboss.ejb.Container;
import org.jboss.ejb.plugins.JaccAuthorizationInterceptor;
import org.jboss.ejb.plugins.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.AssemblyDescriptorMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.security.SimplePrincipal;

public class ExtendedJaccAuthorizationInterceptor
extends JaccAuthorizationInterceptor {
    protected Map<String, Set<String>> deploymentRoleMap = null;

    public void setContainer(Container container) {
        super.setContainer(container);
        if (container != null) {
            BeanMetaData beanMetaData = container.getBeanMetaData();
            ApplicationMetaData applicationMetaData = beanMetaData.getApplicationMetaData();
            AssemblyDescriptorMetaData assemblyDescriptor = applicationMetaData.getAssemblyDescriptor();
            this.deploymentRoleMap = assemblyDescriptor.getPrincipalVersusRolesMap();
        }
    }

    protected void checkSecurityAssociation(Invocation mi) throws Exception {
        Method m = mi.getMethod();
        if (m == null) {
            return;
        }
        String iface = mi.getType().toInterfaceString();
        EJBMethodPermission methodPerm = new EJBMethodPermission(this.ejbName, iface, m);
        if (SecurityActions.peekRunAsIdentity(1) == null && this.deploymentRoleMap != null && this.deploymentRoleMap.size() > 0) {
            Principal[] principals = null;
            Principal principal = mi.getPrincipal();
            if (principal != null) {
                Set<String> roles = this.deploymentRoleMap.get(principal.getName());
                if (roles != null) {
                    ArrayList<SimplePrincipal> al = new ArrayList<SimplePrincipal>();
                    for (String rolename : roles) {
                        al.add(new SimplePrincipal(rolename));
                    }
                    principals = new Principal[al.size()];
                    al.toArray(principals);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Principal=" + principal.getName() + "::roles=" + principals));
                    }
                }
                this.checkPolicy(principals, methodPerm, SecurityActions.getContextSubject());
                return;
            }
        }
        super.checkSecurityAssociation(mi);
    }
}

