/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss42;

import javax.annotation.security.RolesAllowed;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.dom4j.Element;
import org.jboss.annotation.security.SecurityDomain;
import org.jboss.ejb3.Ejb3ModuleMBean;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanProxyCreationException;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.SecurityHandler;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;

public class SecurityHandlerEJB3
implements SecurityHandler {
    public void addSecurityDomain(Element jbossWeb, Deployment dep) {
        String securityDomain = null;
        ObjectName deployedObject = (ObjectName)dep.getProperty("org.jboss.ws.ejb3.deployed.object");
        Ejb3ModuleMBean ejb3Module = this.getEJB3Module(deployedObject);
        for (Object manager : ejb3Module.getContainers().values()) {
            StatelessContainer container;
            SecurityDomain anSecurityDomain;
            if (!(manager instanceof StatelessContainer) || (anSecurityDomain = (SecurityDomain)(container = (StatelessContainer)manager).resolveAnnotation(SecurityDomain.class)) == null) continue;
            if (securityDomain != null && !securityDomain.equals(anSecurityDomain.value())) {
                throw new IllegalStateException("Multiple security domains not supported");
            }
            securityDomain = anSecurityDomain.value();
        }
        if (securityDomain != null) {
            if (!securityDomain.startsWith("java:/jaas/")) {
                securityDomain = "java:/jaas/" + securityDomain;
            }
            jbossWeb.addElement("security-domain").addText(securityDomain);
        }
    }

    public void addSecurityRoles(Element webApp, Deployment dep) {
        ObjectName deployedObject = (ObjectName)dep.getProperty("org.jboss.ws.ejb3.deployed.object");
        Ejb3ModuleMBean ejb3Module = this.getEJB3Module(deployedObject);
        for (Object manager : ejb3Module.getContainers().values()) {
            StatelessContainer container;
            RolesAllowed anRolesAllowed;
            if (!(manager instanceof StatelessContainer) || (anRolesAllowed = (RolesAllowed)(container = (StatelessContainer)manager).resolveAnnotation(RolesAllowed.class)) == null) continue;
            for (String role : anRolesAllowed.value()) {
                webApp.addElement("security-role").addElement("role-name").addText(role);
            }
        }
    }

    private Ejb3ModuleMBean getEJB3Module(ObjectName objectName) {
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            Ejb3ModuleMBean ejb3Module = (Ejb3ModuleMBean)MBeanProxy.get(Ejb3ModuleMBean.class, (ObjectName)objectName, (MBeanServer)server);
            if (ejb3Module == null) {
                throw new WSFDeploymentException("Cannot obtain EJB3 module: " + objectName);
            }
            return ejb3Module;
        }
        catch (MBeanProxyCreationException ex) {
            throw new WSFDeploymentException("Cannot obtain proxy to EJB3 module");
        }
    }
}

